/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.EmbeddedTextContextMenuContent$1;
import com.sun.javafx.scene.control.EmbeddedTextContextMenuContent$2;
import com.sun.javafx.scene.control.EmbeddedTextContextMenuContent$MenuItemContainer;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.collections.ObservableMap;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.TextAreaSkin;
import javafx.scene.control.skin.TextFieldSkin;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.stage.Window;

public class EmbeddedTextContextMenuContent
extends StackPane {
    private ContextMenu contextMenu;
    private StackPane pointer;
    private HBox menuBox;

    public EmbeddedTextContextMenuContent(ContextMenu contextMenu) {
        this.contextMenu = contextMenu;
        this.menuBox = new HBox();
        this.pointer = new StackPane();
        this.pointer.getStyleClass().add("pointer");
        this.updateMenuItemContainer();
        this.getChildren().addAll((Node[])new Node[]{this.pointer, this.menuBox});
        this.contextMenu.ownerNodeProperty().addListener(object -> {
            if (this.contextMenu.getOwnerNode() instanceof TextArea) {
                object = (TextAreaSkin)((TextArea)this.contextMenu.getOwnerNode()).getSkin();
                ((TextArea)((SkinBase)((Object)object)).getSkinnable()).getProperties().addListener(new EmbeddedTextContextMenuContent$1(this));
                return;
            }
            if (this.contextMenu.getOwnerNode() instanceof TextField) {
                object = (TextFieldSkin)((TextField)this.contextMenu.getOwnerNode()).getSkin();
                ((TextField)((SkinBase)((Object)object)).getSkinnable()).getProperties().addListener(new EmbeddedTextContextMenuContent$2(this));
            }
        });
        this.contextMenu.getItems().addListener(listChangeListener$Change -> this.updateMenuItemContainer());
    }

    private void updateMenuItemContainer() {
        this.menuBox.getChildren().clear();
        for (MenuItem menuItem : this.contextMenu.getItems()) {
            EmbeddedTextContextMenuContent$MenuItemContainer embeddedTextContextMenuContent$MenuItemContainer = new EmbeddedTextContextMenuContent$MenuItemContainer(this, menuItem);
            embeddedTextContextMenuContent$MenuItemContainer.visibleProperty().bind(menuItem.visibleProperty());
            this.menuBox.getChildren().add(embeddedTextContextMenuContent$MenuItemContainer);
        }
    }

    private void hideAllMenus(MenuItem menuItem) {
        Menu menu;
        ((Window)this.contextMenu).hide();
        while ((menu = menuItem.getParentMenu()) != null) {
            menu.hide();
            menuItem = menu;
        }
        if (menu == null && menuItem.getParentPopup() != null) {
            ((Window)menuItem.getParentPopup()).hide();
        }
    }

    @Override
    protected double computePrefHeight(double d2) {
        EmbeddedTextContextMenuContent embeddedTextContextMenuContent = this;
        double d3 = embeddedTextContextMenuContent.snapSizeY(((Node)embeddedTextContextMenuContent.pointer).prefHeight(d2));
        EmbeddedTextContextMenuContent embeddedTextContextMenuContent2 = this;
        double d4 = embeddedTextContextMenuContent2.snapSizeY(((Node)embeddedTextContextMenuContent2.menuBox).prefHeight(d2));
        return this.snappedTopInset() + d3 + d4 + this.snappedBottomInset();
    }

    @Override
    protected double computePrefWidth(double d2) {
        EmbeddedTextContextMenuContent embeddedTextContextMenuContent = this;
        double d3 = embeddedTextContextMenuContent.snapSizeX(((Node)embeddedTextContextMenuContent.menuBox).prefWidth(d2));
        return this.snappedLeftInset() + d3 + this.snappedRightInset();
    }

    @Override
    protected void layoutChildren() {
        double d2 = this.snappedLeftInset();
        double d3 = this.snappedRightInset();
        double d4 = this.snappedTopInset();
        double d5 = this.getWidth() - (d2 + d3);
        EmbeddedTextContextMenuContent embeddedTextContextMenuContent = this;
        double d6 = embeddedTextContextMenuContent.snapSizeX(Utils.boundedSize(((Node)embeddedTextContextMenuContent.pointer).prefWidth(-1.0), ((Node)this.pointer).minWidth(-1.0), ((Node)this.pointer).maxWidth(-1.0)));
        EmbeddedTextContextMenuContent embeddedTextContextMenuContent2 = this;
        double d7 = embeddedTextContextMenuContent2.snapSizeY(Utils.boundedSize(((Node)embeddedTextContextMenuContent2.pointer).prefWidth(-1.0), ((Node)this.pointer).minWidth(-1.0), ((Node)this.pointer).maxWidth(-1.0)));
        EmbeddedTextContextMenuContent embeddedTextContextMenuContent3 = this;
        double d8 = embeddedTextContextMenuContent3.snapSizeX(Utils.boundedSize(((Node)embeddedTextContextMenuContent3.menuBox).prefWidth(-1.0), ((Node)this.menuBox).minWidth(-1.0), ((Node)this.menuBox).maxWidth(-1.0)));
        EmbeddedTextContextMenuContent embeddedTextContextMenuContent4 = this;
        double d9 = embeddedTextContextMenuContent4.snapSizeY(Utils.boundedSize(((Node)embeddedTextContextMenuContent4.menuBox).prefWidth(-1.0), ((Node)this.menuBox).minWidth(-1.0), ((Node)this.menuBox).maxWidth(-1.0)));
        double d10 = 0.0;
        double d11 = 0.0;
        ObservableMap<Object, Object> observableMap = null;
        if (this.contextMenu.getOwnerNode() instanceof TextArea) {
            observableMap = ((TextArea)this.contextMenu.getOwnerNode()).getProperties();
        } else if (this.contextMenu.getOwnerNode() instanceof TextField) {
            observableMap = ((TextField)this.contextMenu.getOwnerNode()).getProperties();
        }
        if (observableMap != null) {
            if (observableMap.containsKey("CONTEXT_MENU_SCENE_X")) {
                d10 = Double.valueOf(observableMap.get("CONTEXT_MENU_SCENE_X").toString());
                observableMap.remove("CONTEXT_MENU_SCENE_X");
            }
            if (observableMap.containsKey("CONTEXT_MENU_SCREEN_X")) {
                d11 = Double.valueOf(observableMap.get("CONTEXT_MENU_SCREEN_X").toString());
                observableMap.remove("CONTEXT_MENU_SCREEN_X");
            }
        }
        double d12 = d10 == 0.0 ? d5 / 2.0 : d11 - d10 - this.contextMenu.getX() + d10;
        ((Node)this.pointer).resize(d6, d7);
        EmbeddedTextContextMenuContent embeddedTextContextMenuContent5 = this;
        embeddedTextContextMenuContent5.positionInArea(embeddedTextContextMenuContent5.pointer, d12, d4, d6, d7, 0.0, HPos.CENTER, VPos.CENTER);
        ((Node)this.menuBox).resize(d8, d9);
        EmbeddedTextContextMenuContent embeddedTextContextMenuContent6 = this;
        embeddedTextContextMenuContent6.positionInArea(embeddedTextContextMenuContent6.menuBox, d2, d4 + d7, d8, d9, 0.0, HPos.CENTER, VPos.CENTER);
    }
}

