/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;

public final class LambdaMultiplePropertyChangeListenerHandler {
    private static final Consumer EMPTY_CONSUMER = object -> {};
    private final Map<ObservableValue<?>, Consumer<ObservableValue<?>>> propertyReferenceMap = new HashMap();
    private final ChangeListener<Object> propertyChangedListener = (observableValue, object, object2) -> this.propertyReferenceMap.getOrDefault(observableValue, EMPTY_CONSUMER).accept(observableValue);
    private final WeakChangeListener<Object> weakPropertyChangedListener = new WeakChangeListener<Object>(this.propertyChangedListener);
    private final Map<Observable, Consumer<Observable>> observableReferenceMap = new HashMap<Observable, Consumer<Observable>>();
    private final InvalidationListener invalidationListener = observable -> this.observableReferenceMap.getOrDefault(observable, EMPTY_CONSUMER).accept(observable);
    private final WeakInvalidationListener weakInvalidationListener = new WeakInvalidationListener(this.invalidationListener);
    private final Map<ObservableList<?>, Consumer<ListChangeListener$Change<?>>> observableListReferenceMap = new IdentityHashMap();
    private final ListChangeListener<Object> listChangeListener = listChangeListener$Change -> this.observableListReferenceMap.getOrDefault(listChangeListener$Change.getList(), EMPTY_CONSUMER).accept(listChangeListener$Change);
    private final WeakListChangeListener<Object> weakListChangeListener = new WeakListChangeListener<Object>(this.listChangeListener);

    public final void registerChangeListener(ObservableValue<?> observableValue, Consumer<ObservableValue<?>> consumer) {
        if (observableValue == null || consumer == null) {
            return;
        }
        if (!this.propertyReferenceMap.containsKey(observableValue)) {
            observableValue.addListener(this.weakPropertyChangedListener);
        }
        this.propertyReferenceMap.merge(observableValue, consumer, Consumer::andThen);
    }

    public final Consumer<ObservableValue<?>> unregisterChangeListeners(ObservableValue<?> observableValue) {
        if (observableValue == null) {
            return null;
        }
        observableValue.removeListener(this.weakPropertyChangedListener);
        return this.propertyReferenceMap.remove(observableValue);
    }

    public final void registerInvalidationListener(Observable observable, Consumer<Observable> consumer) {
        if (observable == null || consumer == null) {
            return;
        }
        if (!this.observableReferenceMap.containsKey(observable)) {
            observable.addListener(this.weakInvalidationListener);
        }
        this.observableReferenceMap.merge(observable, consumer, Consumer::andThen);
    }

    public final Consumer<Observable> unregisterInvalidationListeners(Observable observable) {
        if (observable == null) {
            return null;
        }
        observable.removeListener(this.weakInvalidationListener);
        return this.observableReferenceMap.remove(observable);
    }

    public final void registerListChangeListener(ObservableList<?> observableList, Consumer<ListChangeListener$Change<?>> consumer) {
        if (observableList == null || consumer == null) {
            return;
        }
        if (!this.observableListReferenceMap.containsKey(observableList)) {
            observableList.addListener(this.weakListChangeListener);
        }
        this.observableListReferenceMap.merge(observableList, consumer, Consumer::andThen);
    }

    public final Consumer<ListChangeListener$Change<?>> unregisterListChangeListeners(ObservableList<?> observableList) {
        if (observableList == null) {
            return null;
        }
        observableList.removeListener(this.weakListChangeListener);
        return this.observableListReferenceMap.remove(observableList);
    }

    public final void dispose() {
        for (ObservableValue<?> observable : this.propertyReferenceMap.keySet()) {
            observable.removeListener(this.weakPropertyChangedListener);
        }
        this.propertyReferenceMap.clear();
        for (Observable observable : this.observableReferenceMap.keySet()) {
            observable.removeListener(this.weakInvalidationListener);
        }
        this.observableReferenceMap.clear();
        for (ObservableList observableList : this.observableListReferenceMap.keySet()) {
            observableList.removeListener(this.weakListChangeListener);
        }
        this.observableListReferenceMap.clear();
    }
}

