/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.ConstrainedColumnResize$ResizeMode;
import java.util.BitSet;
import java.util.List;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.TableColumnBase;
import javafx.scene.layout.Region;

public class ResizeHelper {
    private static final int SMALL_DELTA = 32;
    private static final double EPSILON = 1.0E-6;
    private final ResizeFeaturesBase rf;
    private final double target;
    private final List<? extends TableColumnBase<?, ?>> columns;
    private final int count;
    private final ConstrainedColumnResize$ResizeMode mode;
    private final double[] size;
    private final double[] min;
    private final double[] pref;
    private final double[] max;
    private final BitSet skip;
    private final Region snap;

    public ResizeHelper(ResizeFeaturesBase resizeFeaturesBase, double d2, List<? extends TableColumnBase<?, ?>> list, ConstrainedColumnResize$ResizeMode constrainedColumnResize$ResizeMode) {
        this.rf = resizeFeaturesBase;
        this.snap = resizeFeaturesBase.getTableControl().isSnapToPixel() ? resizeFeaturesBase.getTableControl() : null;
        this.columns = list;
        this.mode = constrainedColumnResize$ResizeMode;
        this.target = this.snap(d2);
        this.count = list.size();
        this.size = new double[this.count];
        this.min = new double[this.count];
        this.pref = new double[this.count];
        this.max = new double[this.count];
        this.skip = new BitSet(this.count);
        for (int i2 = 0; i2 < this.count; ++i2) {
            TableColumnBase<?, ?> tableColumnBase = list.get(i2);
            this.size[i2] = tableColumnBase.getWidth();
            if (tableColumnBase.isResizable()) {
                double d3 = tableColumnBase.getMinWidth();
                double d4 = tableColumnBase.getMaxWidth();
                this.min[i2] = d3;
                this.max[i2] = d4;
                this.pref[i2] = ResizeHelper.clip(tableColumnBase.getPrefWidth(), d3, d4);
                continue;
            }
            this.skip.set(i2, true);
        }
    }

    public void resizeToContentWidth() {
        boolean bl2;
        block0: do {
            int n2;
            bl2 = false;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i2 = 0; i2 < this.count; ++i2) {
                d2 += this.size[i2];
                d3 += this.min[i2];
            }
            if (d3 >= this.target) {
                return;
            }
            double d4 = this.target - this.snap(d2);
            if (ResizeHelper.isZero(d4)) {
                return;
            }
            double d5 = 0.0;
            for (n2 = 0; n2 < this.count; ++n2) {
                if (this.skip.get(n2)) continue;
                d5 += this.pref[n2];
            }
            if (ResizeHelper.isZero(d5)) {
                return;
            }
            if (Math.abs(d4) < 32.0) {
                this.distributeSmallDelta(d4);
                return;
            }
            for (n2 = 0; n2 < this.count; ++n2) {
                double d6;
                if (this.skip.get(n2)) continue;
                double d7 = this.size[n2] + d4 * this.pref[n2] / d5;
                if (d6 < this.min[n2]) {
                    d7 = this.min[n2];
                    this.skip.set(n2, true);
                    bl2 = true;
                } else if (d7 > this.max[n2]) {
                    d7 = this.max[n2];
                    this.skip.set(n2, true);
                    bl2 = true;
                }
                this.size[n2] = d7;
                if (!bl2) continue;
                this.resetSizeChanges();
                continue block0;
            }
        } while (bl2);
    }

    public boolean applySizes() {
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.count; ++i2) {
            TableColumnBase<?, ?> tableColumnBase = this.columns.get(i2);
            if (tableColumnBase.isResizable()) {
                d2 = this.snap(d2 + this.size[i2]);
                double d4 = d2 - d3;
                this.rf.setColumnWidth(tableColumnBase, d4);
            } else {
                d2 += this.size[i2];
            }
            d3 = d2;
        }
        return d2 > this.target;
    }

    protected static double clip(double d2, double d3, double d4) {
        if (d2 < d3) {
            return d3;
        }
        if (d2 > d4) {
            return d4;
        }
        return d2;
    }

    public boolean resizeColumn(TableColumnBase<?, ?> tableColumnBase) {
        boolean bl2;
        double d2 = this.rf.getDelta();
        while (tableColumnBase.getColumns().size() > 0) {
            tableColumnBase = (TableColumnBase)tableColumnBase.getColumns().get(tableColumnBase.getColumns().size() - 1);
        }
        if (!tableColumnBase.isResizable()) {
            return false;
        }
        int n2 = this.columns.indexOf(tableColumnBase);
        double d3 = this.getAllowedDelta(n2, bl2 = d2 > 0.0);
        if (ResizeHelper.isZero(d3)) {
            return false;
        }
        int n3 = this.markOppositeColumns(n2);
        if (n3 == 0) {
            return false;
        }
        double d4 = this.computeAllowedDelta(!bl2);
        if (ResizeHelper.isZero(d4)) {
            return false;
        }
        d3 = Math.min(Math.abs(d2), Math.min(d3, d4));
        if (!bl2) {
            d3 = -d3;
        }
        if (this.isCornerCase(d3, n2)) {
            return false;
        }
        return this.distributeDelta(n2, d3);
    }

    protected boolean isCornerCase(double d2, int n2) {
        int n3;
        return (n2 = n2 == this.count - 2 ? 1 : 0) != 0 && d2 > 0.0 && this.size[n3 = this.count - 1] <= this.min[n3];
    }

    protected double getAllowedDelta(int n2, boolean bl2) {
        if (bl2) {
            return Math.abs(this.max[n2] - this.size[n2]);
        }
        return Math.abs(this.min[n2] - this.size[n2]);
    }

    protected int markOppositeColumns(int n2) {
        switch (this.mode) {
            case AUTO_RESIZE_NEXT_COLUMN: {
                this.setSkip(0, n2 + 1);
                this.setSkip(n2 + 2, this.columns.size());
                break;
            }
            case AUTO_RESIZE_FLEX_HEAD: 
            case AUTO_RESIZE_FLEX_TAIL: 
            case AUTO_RESIZE_SUBSEQUENT_COLUMNS: {
                this.setSkip(0, n2 + 1);
                break;
            }
            case AUTO_RESIZE_LAST_COLUMN: {
                this.setSkip(0, Math.max(n2 + 1, this.columns.size() - 1));
                break;
            }
            default: {
                int n3 = n2;
                this.setSkip(n3, n3 + 1);
            }
        }
        return this.count - this.skip.cardinality();
    }

    protected void setSkip(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.count) {
            return;
        }
        n3 = Math.min(this.count, n3);
        if (n2 < n3) {
            this.skip.set(n2, n3);
        }
    }

    protected double computeAllowedDelta(boolean bl2) {
        double d2 = 0.0;
        int n2 = 0;
        while ((n2 = this.skip.nextClearBit(n2)) < this.count) {
            d2 = bl2 ? (d2 += this.max[n2] - this.size[n2]) : (d2 += this.size[n2] - this.min[n2]);
            ++n2;
        }
        return d2;
    }

    protected boolean distributeDelta(int n2, double d2) {
        int n3 = this.count - this.skip.cardinality();
        switch (n3) {
            case 0: {
                return false;
            }
            case 1: {
                n3 = this.skip.nextClearBit(0);
                int n4 = n2;
                this.size[n4] = this.size[n4] + d2;
                int n5 = n3;
                this.size[n5] = this.size[n5] - d2;
                return true;
            }
        }
        int n6 = n2;
        this.size[n6] = this.size[n6] + d2;
        double d3 = switch (this.mode) {
            case ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_FLEX_HEAD -> this.distributeDeltaFlexHead(-d2);
            case ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_FLEX_TAIL -> this.distributeDeltaFlexTail(-d2);
            default -> {
                if (Math.abs(d2) < 32.0) {
                    this.distributeSmallDelta(-d2);
                } else {
                    this.distributeDeltaRemainingColumns(-d2);
                }
                yield 0.0;
            }
        };
        int n7 = n2;
        this.size[n7] = this.size[n7] + d3;
        return true;
    }

    protected double distributeDeltaFlexHead(double d2) {
        int n2;
        if (d2 < 0.0) {
            for (n2 = 0; !(n2 >= this.count || !this.skip.get(n2) && this.size[n2] > this.pref[n2] && ResizeHelper.isZero(d2 = this.resize(n2, d2))); ++n2) {
            }
        } else {
            for (n2 = 0; !(n2 >= this.count || !this.skip.get(n2) && this.size[n2] < this.pref[n2] && ResizeHelper.isZero(d2 = this.resize(n2, d2))); ++n2) {
            }
        }
        for (n2 = 0; n2 < this.count && (this.skip.get(n2) || !ResizeHelper.isZero(d2 = this.resize(n2, d2))); ++n2) {
        }
        return d2;
    }

    protected double distributeDeltaFlexTail(double d2) {
        int n2;
        if (d2 < 0.0) {
            for (n2 = this.count - 1; !(n2 < 0 || !this.skip.get(n2) && this.size[n2] > this.pref[n2] && ResizeHelper.isZero(d2 = this.resize(n2, d2))); --n2) {
            }
        } else {
            for (n2 = this.count - 1; !(n2 < 0 || !this.skip.get(n2) && this.size[n2] < this.pref[n2] && ResizeHelper.isZero(d2 = this.resize(n2, d2))); --n2) {
            }
        }
        for (n2 = this.count - 1; n2 >= 0 && (this.skip.get(n2) || !ResizeHelper.isZero(d2 = this.resize(n2, d2))); --n2) {
        }
        return d2;
    }

    protected double resize(int n2, double d2) {
        double d3;
        double d4 = this.size[n2] + d2;
        if (d3 < this.min[n2]) {
            d2 = d4 - this.min[n2];
            d4 = this.min[n2];
        } else if (d4 > this.max[n2]) {
            d2 = d4 - this.max[n2];
            d4 = this.max[n2];
        } else {
            d2 = 0.0;
        }
        this.size[n2] = d4;
        return d2;
    }

    protected void distributeDeltaRemainingColumns(double d2) {
        boolean bl2;
        block0: do {
            int n2;
            double d3 = 0.0;
            for (n2 = 0; n2 < this.count; ++n2) {
                if (this.skip.get(n2)) continue;
                d3 += this.pref[n2];
            }
            if (ResizeHelper.isZero(d3)) {
                return;
            }
            bl2 = false;
            for (n2 = 0; n2 < this.count; ++n2) {
                double d4;
                if (this.skip.get(n2)) continue;
                double d5 = this.size[n2] + d2 * this.pref[n2] / d3;
                if (d4 < this.min[n2]) {
                    d5 = this.min[n2];
                    this.skip.set(n2, true);
                    bl2 = true;
                    d2 -= d5 - this.size[n2];
                } else if (d5 > this.max[n2]) {
                    d5 = this.max[n2];
                    this.skip.set(n2, true);
                    bl2 = true;
                    d2 -= d5 - this.size[n2];
                }
                this.size[n2] = d5;
                if (!bl2) continue;
                this.resetSizeChanges();
                continue block0;
            }
        } while (bl2);
    }

    protected void distributeSmallDelta(double d2) {
        if (d2 < 0.0) {
            while (d2 < 0.0) {
                double d3 = Math.max(-1.0, d2);
                double d4 = this.shrinkSmall(d3);
                if (Double.isNaN(d4)) {
                    return;
                }
                d2 -= d3 - d4;
            }
        } else {
            while (d2 > 0.0) {
                double d5 = Math.min(1.0, d2);
                double d6 = this.expandSmall(d5);
                if (Double.isNaN(d6)) {
                    return;
                }
                d2 -= d5 - d6;
            }
        }
    }

    protected double shrinkSmall(double d2) {
        double d3;
        double d4 = Double.NEGATIVE_INFINITY;
        int n2 = -1;
        for (int i2 = 0; i2 < this.count; ++i2) {
            double d5;
            if (this.skip.get(i2)) continue;
            double d6 = this.size[i2] - this.pref[i2];
            if (!(d5 > d4)) continue;
            d4 = d6;
            n2 = i2;
        }
        if (n2 < 0) {
            return Double.NaN;
        }
        double d7 = 0.0;
        double d8 = this.size[n2] + d2;
        if (d3 < this.min[n2]) {
            d7 = d8 - this.min[n2];
            d8 = this.min[n2];
            this.skip.set(n2);
        }
        this.size[n2] = d8;
        return d7;
    }

    protected double expandSmall(double d2) {
        double d3;
        double d4 = Double.NEGATIVE_INFINITY;
        int n2 = -1;
        for (int i2 = 0; i2 < this.count; ++i2) {
            double d5;
            if (this.skip.get(i2)) continue;
            double d6 = this.pref[i2] - this.size[i2];
            if (!(d5 > d4)) continue;
            d4 = d6;
            n2 = i2;
        }
        if (n2 < 0) {
            return Double.NaN;
        }
        double d7 = 0.0;
        double d8 = this.size[n2] + d2;
        if (d3 > this.max[n2]) {
            d7 = d8 - this.max[n2];
            d8 = this.max[n2];
            this.skip.set(n2);
        }
        this.size[n2] = d8;
        return d7;
    }

    protected void resetSizeChanges() {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (this.skip.get(i2)) continue;
            this.size[i2] = this.columns.get(i2).getWidth();
        }
    }

    protected double sumSizes() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.count; ++i2) {
            d2 += this.size[i2];
        }
        return d2;
    }

    protected static boolean isZero(double d2) {
        return Math.abs(d2) < 1.0E-6;
    }

    protected double snap(double d2) {
        if (this.snap == null) {
            return d2;
        }
        return this.snap.snapSpaceX(d2);
    }
}

