/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;

public abstract class SelectedItemsReadOnlyObservableList<E>
extends ObservableListBase<E> {
    private final ObservableList<Integer> selectedIndices;
    private final Supplier<Integer> modelSizeSupplier;
    private final List<WeakReference<E>> itemsRefList;

    public SelectedItemsReadOnlyObservableList(ObservableList<Integer> observableList, Supplier<Integer> supplier) {
        this.modelSizeSupplier = supplier;
        this.selectedIndices = observableList;
        this.itemsRefList = new ArrayList<WeakReference<E>>();
        observableList.addListener((ListChangeListener$Change<? super E> listChangeListener$Change) -> {
            int n2 = 0;
            this.beginChange();
            while (listChangeListener$Change.next()) {
                if (listChangeListener$Change.wasReplaced()) {
                    List<E> list;
                    List<E> list2 = this.getRemovedElements(listChangeListener$Change, n2);
                    if (list2.equals(list = this.getAddedElements(listChangeListener$Change))) continue;
                    this.nextReplace(listChangeListener$Change.getFrom(), listChangeListener$Change.getTo(), list2);
                    continue;
                }
                if (listChangeListener$Change.wasAdded()) {
                    this.nextAdd(listChangeListener$Change.getFrom(), listChangeListener$Change.getTo());
                    continue;
                }
                if (listChangeListener$Change.wasRemoved()) {
                    int n3 = listChangeListener$Change.getRemovedSize();
                    if (n3 == 1) {
                        this.nextRemove(listChangeListener$Change.getFrom(), this.getRemovedModelItem(n2 + listChangeListener$Change.getFrom()));
                    } else {
                        this.nextRemove(listChangeListener$Change.getFrom(), this.getRemovedElements(listChangeListener$Change, n2));
                    }
                    n2 += n3;
                    continue;
                }
                if (listChangeListener$Change.wasPermutated()) {
                    int[] nArray = new int[this.size()];
                    for (int i2 = 0; i2 < this.size(); ++i2) {
                        nArray[i2] = listChangeListener$Change.getPermutation(i2);
                    }
                    this.nextPermutation(listChangeListener$Change.getFrom(), listChangeListener$Change.getTo(), nArray);
                    continue;
                }
                if (!listChangeListener$Change.wasUpdated()) continue;
                for (int i3 = listChangeListener$Change.getFrom(); i3 < listChangeListener$Change.getTo(); ++i3) {
                    this.nextUpdate(i3);
                }
            }
            this.itemsRefList.clear();
            Iterator iterator = observableList.iterator();
            while (iterator.hasNext()) {
                int n4 = (Integer)iterator.next();
                this.itemsRefList.add(new WeakReference<E>(this.getModelItem(n4)));
            }
            this.endChange();
        });
    }

    protected abstract E getModelItem(int var1);

    @Override
    public E get(int n2) {
        n2 = (Integer)this.selectedIndices.get(n2);
        return this.getModelItem(n2);
    }

    @Override
    public int size() {
        return this.selectedIndices.size();
    }

    private E _getModelItem(int n2) {
        if (n2 >= this.modelSizeSupplier.get()) {
            return this.getRemovedModelItem(n2);
        }
        return this.getModelItem(n2);
    }

    private E getRemovedModelItem(int n2) {
        if (n2 < 0 || n2 >= this.itemsRefList.size()) {
            return null;
        }
        return (E)this.itemsRefList.get(n2).get();
    }

    private List<E> getRemovedElements(ListChangeListener$Change<? extends Integer> listChangeListener$Change, int n2) {
        int n3;
        ArrayList<E> arrayList = new ArrayList<E>(listChangeListener$Change.getRemovedSize());
        int n4 = n3 + listChangeListener$Change.getRemovedSize();
        for (int i2 = n3 = listChangeListener$Change.getFrom(); i2 < n4; ++i2) {
            arrayList.add(this.getRemovedModelItem(i2 + n2));
        }
        return arrayList;
    }

    private List<E> getAddedElements(ListChangeListener$Change<? extends Integer> object) {
        ArrayList<E> arrayList = new ArrayList<E>(((ListChangeListener$Change)object).getAddedSize());
        object = ((ListChangeListener$Change)object).getAddedSubList().iterator();
        while (object.hasNext()) {
            int n2 = (Integer)object.next();
            arrayList.add(this._getModelItem(n2));
        }
        return arrayList;
    }
}

