/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.scene.control.TableColumnBase;

public abstract class TableColumnComparatorBase<S, T>
implements Comparator<S> {
    private final List<? extends TableColumnBase> columns;

    public TableColumnComparatorBase(TableColumnBase<S, T> ... tableColumnBaseArray) {
        this(Arrays.asList(tableColumnBaseArray));
    }

    public TableColumnComparatorBase(List<? extends TableColumnBase> list) {
        this.columns = new ArrayList<TableColumnBase>(list);
    }

    public List<? extends TableColumnBase> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    @Override
    public int compare(S s2, S s3) {
        for (TableColumnBase tableColumnBase : this.columns) {
            Object t2;
            Object t3;
            int n2;
            if (!this.isSortable(tableColumnBase) || (n2 = this.doCompare(tableColumnBase, t3 = tableColumnBase.getCellData(s2), t2 = tableColumnBase.getCellData(s3))) == 0) continue;
            return n2;
        }
        return 0;
    }

    public int hashCode() {
        int n2 = 413 + (this.columns != null ? this.columns.hashCode() : 0);
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (TableColumnComparatorBase)object;
        return this.columns == ((TableColumnComparatorBase)object).columns || this.columns != null && this.columns.equals(((TableColumnComparatorBase)object).columns);
    }

    public String toString() {
        return "TableColumnComparatorBase [ columns: " + String.valueOf(this.getColumns()) + "] ";
    }

    public abstract boolean isSortable(TableColumnBase<S, T> var1);

    public abstract int doCompare(TableColumnBase<S, T> var1, T var2, T var3);
}

