/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.InputMap$Mapping;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.Node;

public abstract class BehaviorBase<N extends Node> {
    private final N node;
    private final List<InputMap$Mapping<?>> installedDefaultMappings;
    private final List<Runnable> childInputMapDisposalHandlers;

    public BehaviorBase(N n2) {
        this.node = n2;
        this.installedDefaultMappings = new ArrayList();
        this.childInputMapDisposalHandlers = new ArrayList<Runnable>();
    }

    public abstract InputMap<N> getInputMap();

    public final N getNode() {
        return this.node;
    }

    public void dispose() {
        for (InputMap$Mapping<?> object : this.installedDefaultMappings) {
            this.getInputMap().getMappings().remove(object);
        }
        for (Runnable runnable : this.childInputMapDisposalHandlers) {
            runnable.run();
        }
    }

    protected void addDefaultMapping(List<InputMap$Mapping<?>> list) {
        BehaviorBase behaviorBase = this;
        List<InputMap$Mapping<?>> list2 = list;
        behaviorBase.addDefaultMapping(behaviorBase.getInputMap(), list2.toArray(new InputMap$Mapping[list2.size()]));
    }

    protected void addDefaultMapping(InputMap$Mapping<?> ... inputMap$MappingArray) {
        BehaviorBase behaviorBase = this;
        behaviorBase.addDefaultMapping(behaviorBase.getInputMap(), inputMap$MappingArray);
    }

    protected void addDefaultMapping(InputMap<N> inputMap, InputMap$Mapping<?> ... inputMap$MappingArray) {
        ArrayList arrayList = new ArrayList(inputMap.getMappings());
        for (InputMap$Mapping<?> inputMap$Mapping : inputMap$MappingArray) {
            if (arrayList.contains(inputMap$Mapping)) continue;
            inputMap.getMappings().add(inputMap$Mapping);
            this.installedDefaultMappings.add(inputMap$Mapping);
        }
    }

    protected <T extends Node> void addDefaultChildMap(InputMap<T> inputMap, InputMap<T> inputMap2) {
        inputMap.getChildInputMaps().add(inputMap2);
        this.childInputMapDisposalHandlers.add(() -> inputMap.getChildInputMaps().remove(inputMap2));
    }

    protected InputMap<N> createInputMap() {
        return new InputMap<N>(this.node);
    }

    protected void removeMapping(Object object) {
        InputMap<N> inputMap = this.getInputMap();
        inputMap.lookupMapping(object).ifPresent(inputMap$Mapping -> {
            inputMap.getMappings().remove(inputMap$Mapping);
            this.installedDefaultMappings.remove(inputMap$Mapping);
        });
    }

    void rtl(Node node, Runnable runnable, Runnable runnable2) {
        switch (node.getEffectiveNodeOrientation()) {
            case RIGHT_TO_LEFT: {
                runnable.run();
                return;
            }
        }
        runnable2.run();
    }

    <T> void rtl(Node node, T t2, Consumer<T> consumer, Consumer<T> consumer2) {
        switch (node.getEffectiveNodeOrientation()) {
            case RIGHT_TO_LEFT: {
                consumer.accept(t2);
                return;
            }
        }
        consumer2.accept(t2);
    }

    boolean isRTL(Node node) {
        switch (node.getEffectiveNodeOrientation()) {
            case RIGHT_TO_LEFT: {
                return true;
            }
        }
        return false;
    }
}

