/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusComboBehavior;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.InputMap$KeyMapping;
import com.sun.javafx.scene.control.inputmap.InputMap$Mapping;
import com.sun.javafx.scene.control.inputmap.InputMap$MouseMapping;
import com.sun.javafx.scene.control.inputmap.KeyBinding;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.DatePicker;
import javafx.scene.control.PopupControl;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class ComboBoxBaseBehavior<T>
extends BehaviorBase<ComboBoxBase<T>> {
    private final InputMap<ComboBoxBase<T>> inputMap;
    private InvalidationListener focusListener = this::focusChanged;
    private TwoLevelFocusComboBehavior tlFocus;
    private boolean keyDown;
    private boolean showPopupOnMouseRelease = true;
    private boolean mouseInsideButton = false;

    public ComboBoxBaseBehavior(ComboBoxBase<T> comboBoxBase) {
        super(comboBoxBase);
        this.inputMap = this.createInputMap();
        Object object = keyEvent -> {
            this.showPopupOnMouseRelease = true;
            if (((ComboBoxBase)this.getNode()).isShowing()) {
                this.hide();
                return;
            }
            this.show();
        };
        ComboBoxBaseBehavior comboBoxBaseBehavior = this;
        InputMap$Mapping[] inputMap$MappingArray = new InputMap$Mapping[13];
        inputMap$MappingArray[0] = new InputMap$KeyMapping(KeyCode.F4, KeyEvent.KEY_RELEASED, (EventHandler<KeyEvent>)object);
        inputMap$MappingArray[1] = new InputMap$KeyMapping(new KeyBinding(KeyCode.UP).alt(), (EventHandler<KeyEvent>)object);
        inputMap$MappingArray[2] = new InputMap$KeyMapping(new KeyBinding(KeyCode.DOWN).alt(), (EventHandler<KeyEvent>)object);
        inputMap$MappingArray[3] = new InputMap$KeyMapping(KeyCode.SPACE, KeyEvent.KEY_PRESSED, this::keyPressed);
        inputMap$MappingArray[4] = new InputMap$KeyMapping(KeyCode.SPACE, KeyEvent.KEY_RELEASED, this::keyReleased);
        object = new InputMap$KeyMapping(KeyCode.ENTER, KeyEvent.KEY_PRESSED, this::keyPressed);
        inputMap$MappingArray[5] = object;
        InputMap$KeyMapping inputMap$KeyMapping = new InputMap$KeyMapping(KeyCode.ENTER, KeyEvent.KEY_RELEASED, this::keyReleased);
        inputMap$MappingArray[6] = inputMap$KeyMapping;
        inputMap$MappingArray[7] = new InputMap$KeyMapping(KeyCode.ESCAPE, KeyEvent.KEY_PRESSED, this::cancelEdit);
        inputMap$MappingArray[8] = new InputMap$KeyMapping(KeyCode.F10, KeyEvent.KEY_PRESSED, this::forwardToParent);
        inputMap$MappingArray[9] = new InputMap$MouseMapping(MouseEvent.MOUSE_PRESSED, this::mousePressed);
        inputMap$MappingArray[10] = new InputMap$MouseMapping(MouseEvent.MOUSE_RELEASED, this::mouseReleased);
        inputMap$MappingArray[11] = new InputMap$MouseMapping(MouseEvent.MOUSE_ENTERED, this::mouseEntered);
        inputMap$MappingArray[12] = new InputMap$MouseMapping(MouseEvent.MOUSE_EXITED, this::mouseExited);
        comboBoxBaseBehavior.addDefaultMapping(comboBoxBaseBehavior.inputMap, inputMap$MappingArray);
        ((InputMap$Mapping)object).setAutoConsume(false);
        inputMap$KeyMapping.setAutoConsume(false);
        comboBoxBase.focusedProperty().addListener(this.focusListener);
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusComboBehavior(comboBoxBase);
        }
    }

    @Override
    public void dispose() {
        if (this.tlFocus != null) {
            ((TwoLevelFocusBehavior)this.tlFocus).dispose();
        }
        ((ComboBoxBase)this.getNode()).focusedProperty().removeListener(this.focusListener);
        super.dispose();
    }

    @Override
    public InputMap<ComboBoxBase<T>> getInputMap() {
        return this.inputMap;
    }

    protected void focusChanged(Observable object) {
        object = (ComboBoxBase)this.getNode();
        if (this.keyDown && !((Node)object).isFocused()) {
            this.keyDown = false;
            ((ComboBoxBase)object).disarm();
        }
    }

    private void keyPressed(KeyEvent keyEvent) {
        this.showPopupOnMouseRelease = true;
        if (Utils.isTwoLevelFocus()) {
            this.show();
            if (this.tlFocus != null) {
                this.tlFocus.setExternalFocus(false);
                return;
            }
        } else if (!((ComboBoxBase)this.getNode()).isPressed() && !((ComboBoxBase)this.getNode()).isArmed()) {
            this.keyDown = true;
            ((ComboBoxBase)this.getNode()).arm();
        }
    }

    private void keyReleased(KeyEvent keyEvent) {
        this.showPopupOnMouseRelease = true;
        if (!Utils.isTwoLevelFocus() && this.keyDown) {
            this.keyDown = false;
            if (((ComboBoxBase)this.getNode()).isArmed()) {
                ((ComboBoxBase)this.getNode()).disarm();
            }
        }
    }

    private void forwardToParent(KeyEvent keyEvent) {
        if (((ComboBoxBase)this.getNode()).getParent() != null) {
            ((ComboBoxBase)this.getNode()).getParent().fireEvent(keyEvent);
        }
    }

    private void cancelEdit(KeyEvent keyEvent) {
        ComboBoxBase comboBoxBase = (ComboBoxBase)this.getNode();
        TextField textField = null;
        if (comboBoxBase instanceof DatePicker) {
            v0 = ((DatePicker)comboBoxBase).getEditor();
        } else if (comboBoxBase instanceof ComboBox) {
            v0 = textField = comboBoxBase.isEditable() ? ((ComboBox)comboBoxBase).getEditor() : null;
        }
        if (textField != null && textField.getTextFormatter() != null) {
            textField.cancelEdit();
            return;
        }
        this.forwardToParent(keyEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.arm(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.disarm();
        if (this.showPopupOnMouseRelease) {
            this.show();
            return;
        }
        this.showPopupOnMouseRelease = true;
        this.hide();
    }

    public void mouseEntered(MouseEvent object) {
        boolean bl2;
        if (!((ComboBoxBase)this.getNode()).isEditable()) {
            v0 = this;
            bl2 = true;
        } else {
            object = ((Event)object).getTarget();
            v0 = this;
            bl2 = object instanceof Node && "arrow-button".equals(((Node)object).getId());
        }
        v0.mouseInsideButton = bl2;
        this.arm();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseInsideButton = false;
        this.disarm();
    }

    private void arm(MouseEvent mouseEvent) {
        boolean bl2;
        boolean bl3 = bl2 = mouseEvent.getButton() == MouseButton.PRIMARY && !mouseEvent.isMiddleButtonDown() && !mouseEvent.isSecondaryButtonDown() && !mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && !mouseEvent.isAltDown() && !mouseEvent.isMetaDown();
        if (!((ComboBoxBase)this.getNode()).isArmed() && bl2) {
            ((ComboBoxBase)this.getNode()).arm();
        }
    }

    public void show() {
        if (!((ComboBoxBase)this.getNode()).isShowing()) {
            if (((ComboBoxBase)this.getNode()).isFocusTraversable()) {
                ((ComboBoxBase)this.getNode()).requestFocus();
            }
            ((ComboBoxBase)this.getNode()).show();
        }
    }

    public void hide() {
        if (((ComboBoxBase)this.getNode()).isShowing()) {
            ((ComboBoxBase)this.getNode()).hide();
        }
    }

    public void onAutoHide(PopupControl popupControl) {
        this.hide();
        this.showPopupOnMouseRelease = !this.mouseInsideButton || !this.showPopupOnMouseRelease;
    }

    public void arm() {
        if (((ComboBoxBase)this.getNode()).isPressed()) {
            ((ComboBoxBase)this.getNode()).arm();
        }
    }

    public void disarm() {
        if (!this.keyDown && ((ComboBoxBase)this.getNode()).isArmed()) {
            ((ComboBoxBase)this.getNode()).disarm();
        }
    }
}

