/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.InputMap$KeyMapping;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class SliderBehavior
extends BehaviorBase<Slider> {
    private final InputMap<Slider> sliderInputMap = this.createInputMap();
    private TwoLevelFocusBehavior tlFocus;

    public SliderBehavior(Slider slider) {
        super(slider);
        SliderBehavior sliderBehavior = this;
        sliderBehavior.addDefaultMapping(sliderBehavior.sliderInputMap, new InputMap$KeyMapping(KeyCode.HOME, KeyEvent.KEY_RELEASED, keyEvent -> this.home()), new InputMap$KeyMapping(KeyCode.END, KeyEvent.KEY_RELEASED, keyEvent -> this.end()));
        InputMap<Slider> inputMap = new InputMap<Slider>(slider);
        inputMap.setInterceptor(event -> slider.getOrientation() != Orientation.HORIZONTAL);
        inputMap.getMappings().addAll(new InputMap$KeyMapping(KeyCode.LEFT, keyEvent -> this.rtl(slider, this::incrementValue, this::decrementValue)), new InputMap$KeyMapping(KeyCode.KP_LEFT, keyEvent -> this.rtl(slider, this::incrementValue, this::decrementValue)), new InputMap$KeyMapping(KeyCode.RIGHT, keyEvent -> this.rtl(slider, this::decrementValue, this::incrementValue)), new InputMap$KeyMapping(KeyCode.KP_RIGHT, keyEvent -> this.rtl(slider, this::decrementValue, this::incrementValue)));
        SliderBehavior sliderBehavior2 = this;
        sliderBehavior2.addDefaultChildMap(sliderBehavior2.sliderInputMap, inputMap);
        inputMap = new InputMap<Slider>(slider);
        inputMap.setInterceptor(event -> slider.getOrientation() != Orientation.VERTICAL);
        inputMap.getMappings().addAll(new InputMap$KeyMapping(KeyCode.DOWN, keyEvent -> this.decrementValue()), new InputMap$KeyMapping(KeyCode.KP_DOWN, keyEvent -> this.decrementValue()), new InputMap$KeyMapping(KeyCode.UP, keyEvent -> this.incrementValue()), new InputMap$KeyMapping(KeyCode.KP_UP, keyEvent -> this.incrementValue()));
        SliderBehavior sliderBehavior3 = this;
        sliderBehavior3.addDefaultChildMap(sliderBehavior3.sliderInputMap, inputMap);
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusBehavior(slider);
        }
    }

    @Override
    public void dispose() {
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
        super.dispose();
    }

    @Override
    public InputMap<Slider> getInputMap() {
        return this.sliderInputMap;
    }

    public void trackPress(MouseEvent object, double d2) {
        object = (Slider)this.getNode();
        ((Node)object).requestFocus();
        if (((Slider)object).getOrientation().equals((Object)Orientation.HORIZONTAL)) {
            ((Slider)object).adjustValue(d2 * (((Slider)object).getMax() - ((Slider)object).getMin()) + ((Slider)object).getMin());
            return;
        }
        ((Slider)object).adjustValue((1.0 - d2) * (((Slider)object).getMax() - ((Slider)object).getMin()) + ((Slider)object).getMin());
    }

    public void thumbPressed(MouseEvent object, double d2) {
        object = (Slider)this.getNode();
        ((Node)object).requestFocus();
        ((Slider)object).setValueChanging(true);
    }

    public void thumbDragged(MouseEvent object, double d2) {
        object = (Slider)this.getNode();
        ((Slider)object).setValue(com.sun.javafx.util.Utils.clamp(((Slider)object).getMin(), d2 * (((Slider)object).getMax() - ((Slider)object).getMin()) + ((Slider)object).getMin(), ((Slider)object).getMax()));
    }

    public void thumbReleased(MouseEvent object) {
        object = (Slider)this.getNode();
        ((Slider)object).setValueChanging(false);
        Object object2 = object;
        ((Slider)object2).adjustValue(((Slider)object2).getValue());
    }

    void home() {
        Slider slider = (Slider)this.getNode();
        slider.adjustValue(slider.getMin());
    }

    void decrementValue() {
        Slider slider = (Slider)this.getNode();
        if (slider.isSnapToTicks()) {
            Slider slider2 = slider;
            slider2.adjustValue(slider2.getValue() - this.computeIncrement());
            return;
        }
        slider.decrement();
    }

    void end() {
        Slider slider = (Slider)this.getNode();
        slider.adjustValue(slider.getMax());
    }

    void incrementValue() {
        Slider slider = (Slider)this.getNode();
        if (slider.isSnapToTicks()) {
            Slider slider2 = slider;
            slider2.adjustValue(slider2.getValue() + this.computeIncrement());
            return;
        }
        slider.increment();
    }

    double computeIncrement() {
        Slider slider = (Slider)this.getNode();
        double d2 = slider.getMinorTickCount() != 0 ? slider.getMajorTickUnit() / (double)(Math.max(slider.getMinorTickCount(), 0) + 1) : slider.getMajorTickUnit();
        if (slider.getBlockIncrement() > 0.0 && slider.getBlockIncrement() < d2) {
            return d2;
        }
        return slider.getBlockIncrement();
    }
}

