/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.input.MouseButton;

public abstract class TableCellBehaviorBase<S, T, TC extends TableColumnBase<S, ?>, C extends IndexedCell<T>>
extends CellBehaviorBase<C> {
    public TableCellBehaviorBase(C c2) {
        super(c2);
    }

    protected abstract TableColumnBase<S, T> getTableColumn();

    protected abstract int getItemCount();

    @Override
    protected abstract TableSelectionModel<S> getSelectionModel();

    protected abstract TableFocusModel<S, TC> getFocusModel();

    protected abstract TablePositionBase getFocusedCell();

    protected abstract boolean isTableRowSelected();

    protected abstract int getVisibleLeafIndex(TableColumnBase<S, T> var1);

    protected abstract void focus(int var1, TableColumnBase<S, T> var2);

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected void doSelect(double d2, double d3, MouseButton object, int n2, boolean bl2, boolean bl3) {
        void var6_7;
        void var8_9;
        void var7_8;
        IndexedCell indexedCell = (IndexedCell)this.getNode();
        if (!indexedCell.contains(d2, d3)) {
            return;
        }
        Control control = this.getCellContainer();
        if (control == null) {
            return;
        }
        int n3 = this.getItemCount();
        if (indexedCell.getIndex() >= n3) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = this.getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        boolean bl4 = this.isSelected();
        int n4 = indexedCell.getIndex();
        int n5 = this.getColumn();
        TableColumnBase<S, T> tableColumnBase = this.getTableColumn();
        FocusModel focusModel = this.getFocusModel();
        if (focusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase = this.getFocusedCell();
        if (this.handleDisclosureNode(d2, d3)) {
            return;
        }
        if (var7_8 != false) {
            if (!TableCellBehaviorBase.hasNonDefaultAnchor(control)) {
                TableCellBehaviorBase.setAnchor(control, tablePositionBase, false);
            }
        } else {
            TableCellBehaviorBase.removeAnchor(control);
        }
        if (object != MouseButton.PRIMARY) {
            if (object != MouseButton.SECONDARY) return;
            if (bl4) return;
        }
        if (multipleSelectionModel.getSelectionMode() != SelectionMode.SINGLE) {
            if (var8_9 != false) {
                if (bl4) {
                    ((TableSelectionModel)multipleSelectionModel).clearSelection(n4, tableColumnBase);
                    ((TableFocusModel)focusModel).focus(n4, tableColumnBase);
                    return;
                }
                ((TableSelectionModel)multipleSelectionModel).select(n4, tableColumnBase);
                return;
            }
            if (var7_8 != false) {
                Object object2 = TableCellBehaviorBase.getAnchor(control, tablePositionBase);
                int n6 = ((TablePositionBase)object2).getRow();
                boolean bl5 = n6 < n4;
                multipleSelectionModel.clearSelection();
                int n7 = Math.min(n6, n4);
                n6 = Math.max(n6, n4);
                TableColumnBase<S, T> tableColumnBase2 = ((TablePositionBase)object2).getColumn() < n5 ? ((TablePositionBase)object2).getTableColumn() : tableColumnBase;
                Object object3 = object2 = ((TablePositionBase)object2).getColumn() >= n5 ? ((TablePositionBase)object2).getTableColumn() : tableColumnBase;
                if (bl5) {
                    ((TableSelectionModel)multipleSelectionModel).selectRange(n7, tableColumnBase2, n6, object2);
                    return;
                }
                ((TableSelectionModel)multipleSelectionModel).selectRange(n6, tableColumnBase2, n7, object2);
                return;
            }
        }
        this.simpleSelect((MouseButton)((Object)object), (int)var6_7, (boolean)var8_9);
    }

    @Override
    protected void simpleSelect(MouseButton mouseButton, int n2, boolean bl2) {
        boolean bl3;
        MultipleSelectionModel multipleSelectionModel = this.getSelectionModel();
        if (multipleSelectionModel == null) {
            bl3 = false;
        } else {
            TableColumnBase<S, T> tableColumnBase;
            int n3 = ((IndexedCell)this.getNode()).getIndex();
            bl3 = ((TableSelectionModel)multipleSelectionModel).isSelected(n3, tableColumnBase = this.getTableColumn());
            if (bl3 && bl2) {
                ((TableSelectionModel)multipleSelectionModel).clearSelection(n3, tableColumnBase);
                ((TableFocusModel)this.getFocusModel()).focus(n3, tableColumnBase);
                bl3 = false;
            } else {
                ((TableSelectionModel)multipleSelectionModel).clearAndSelect(n3, tableColumnBase);
            }
        }
        this.handleClicks(mouseButton, n2, bl3);
    }

    private int getColumn() {
        if (((TableSelectionModel)this.getSelectionModel()).isCellSelectionEnabled()) {
            TableColumnBase<S, T> tableColumnBase = this.getTableColumn();
            return this.getVisibleLeafIndex(tableColumnBase);
        }
        return -1;
    }

    @Override
    protected boolean isSelected() {
        Object object = this.getSelectionModel();
        if (object == null) {
            return false;
        }
        if (((TableSelectionModel)object).isCellSelectionEnabled()) {
            object = (IndexedCell)this.getNode();
            return ((Cell)object).isSelected();
        }
        return this.isTableRowSelected();
    }
}

