/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import javafx.collections.ObservableList;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public abstract class TableRowBehaviorBase<T extends Cell>
extends CellBehaviorBase<T> {
    public TableRowBehaviorBase(T t2) {
        super(t2);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isClickPositionValid(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        super.mousePressed(mouseEvent);
    }

    @Override
    protected abstract TableSelectionModel<?> getSelectionModel();

    protected abstract TablePositionBase<?> getFocusedCell();

    protected abstract ObservableList getVisibleLeafColumns();

    @Override
    protected void doSelect(double d2, double d3, MouseButton mouseButton, int n2, boolean bl2, boolean bl3) {
        Control control = this.getCellContainer();
        if (control == null) {
            return;
        }
        if (this.handleDisclosureNode(d2, d3)) {
            return;
        }
        MultipleSelectionModel multipleSelectionModel = this.getSelectionModel();
        if (multipleSelectionModel == null || ((TableSelectionModel)multipleSelectionModel).isCellSelectionEnabled()) {
            return;
        }
        int n3 = this.getIndex();
        boolean bl4 = multipleSelectionModel.isSelected(n3);
        if (n2 == 1) {
            if (!this.isClickPositionValid(d2, d3)) {
                return;
            }
            if (bl4 && bl3) {
                multipleSelectionModel.clearSelection(n3);
                return;
            }
            if (bl3) {
                multipleSelectionModel.select(this.getIndex());
                return;
            }
            if (bl2) {
                TablePositionBase<?> tablePositionBase = TableRowBehaviorBase.getAnchor(control, this.getFocusedCell());
                int n4 = tablePositionBase.getRow();
                this.selectRows(n4, n3);
                return;
            }
            this.simpleSelect(mouseButton, n2, bl3);
            return;
        }
        this.simpleSelect(mouseButton, n2, bl3);
    }

    @Override
    protected boolean isClickPositionValid(double d2, double d3) {
        ObservableList observableList = this.getVisibleLeafColumns();
        double d4 = 0.0;
        for (int i2 = 0; i2 < observableList.size(); ++i2) {
            d4 += ((TableColumnBase)observableList.get(i2)).getWidth();
        }
        return d2 > d4;
    }
}

