/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.TableViewBehaviorBase;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.scene.control.TableView$TableViewSelectionModel;

public class TableViewBehavior<T>
extends TableViewBehaviorBase<TableView<T>, T, TableColumn<T, ?>> {
    private final ChangeListener<TableView$TableViewSelectionModel<T>> selectionModelListener = (observableValue, tableView$TableViewSelectionModel, tableView$TableViewSelectionModel2) -> {
        if (tableView$TableViewSelectionModel != null) {
            tableView$TableViewSelectionModel.getSelectedCells().removeListener(this.weakSelectedCellsListener);
        }
        if (tableView$TableViewSelectionModel2 != null) {
            tableView$TableViewSelectionModel2.getSelectedCells().addListener(this.weakSelectedCellsListener);
        }
    };
    private final WeakChangeListener<TableView$TableViewSelectionModel<T>> weakSelectionModelListener = new WeakChangeListener<TableView$TableViewSelectionModel<TableView$TableViewSelectionModel<T>>>(this.selectionModelListener);
    private TwoLevelFocusBehavior tlFocus;

    public TableViewBehavior(TableView<T> tableView) {
        super(tableView);
        tableView.selectionModelProperty().addListener(this.weakSelectionModelListener);
        TableView$TableViewSelectionModel<T> tableView$TableViewSelectionModel3 = tableView.getSelectionModel();
        if (tableView$TableViewSelectionModel3 != null) {
            tableView$TableViewSelectionModel3.getSelectedCells().addListener(this.weakSelectedCellsListener);
        }
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusBehavior(tableView);
        }
    }

    @Override
    public void dispose() {
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
            this.tlFocus = null;
        }
        super.dispose();
    }

    @Override
    protected int getItemCount() {
        if (((TableView)this.getNode()).getItems() == null) {
            return 0;
        }
        return ((TableView)this.getNode()).getItems().size();
    }

    @Override
    protected TableFocusModel getFocusModel() {
        return ((TableView)this.getNode()).getFocusModel();
    }

    @Override
    protected TableSelectionModel<T> getSelectionModel() {
        return ((TableView)this.getNode()).getSelectionModel();
    }

    @Override
    protected ObservableList<TablePosition> getSelectedCells() {
        TableView$TableViewSelectionModel tableView$TableViewSelectionModel = ((TableView)this.getNode()).getSelectionModel();
        if (tableView$TableViewSelectionModel == null) {
            return FXCollections.emptyObservableList();
        }
        return tableView$TableViewSelectionModel.getSelectedCells();
    }

    @Override
    protected TablePositionBase getFocusedCell() {
        return ((TableView)this.getNode()).getFocusModel().getFocusedCell();
    }

    @Override
    protected int getVisibleLeafIndex(TableColumnBase tableColumnBase) {
        return ((TableView)this.getNode()).getVisibleLeafIndex((TableColumn)tableColumnBase);
    }

    @Override
    protected TableColumn<T, ?> getVisibleLeafColumn(int n2) {
        return ((TableView)this.getNode()).getVisibleLeafColumn(n2);
    }

    @Override
    protected boolean isControlEditable() {
        return ((TableView)this.getNode()).isEditable();
    }

    @Override
    protected void editCell(int n2, TableColumnBase tableColumnBase) {
        ((TableView)this.getNode()).edit(n2, (TableColumn)tableColumnBase);
    }

    @Override
    protected ObservableList<TableColumn<T, ?>> getVisibleLeafColumns() {
        return ((TableView)this.getNode()).getVisibleLeafColumns();
    }

    @Override
    protected TablePositionBase<TableColumn<T, ?>> getTablePosition(int n2, TableColumnBase<T, ?> tableColumnBase) {
        return new TablePosition((TableView)this.getNode(), n2, (TableColumn)tableColumnBase);
    }

    @Override
    protected void selectAllToFocus(boolean bl2) {
        if (((TableView)this.getNode()).getEditingCell() != null) {
            return;
        }
        super.selectAllToFocus(bl2);
    }
}

