/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.SizeLimitedList;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.FocusTraversalInputMap;
import com.sun.javafx.scene.control.behavior.TableCellBehaviorBase;
import com.sun.javafx.scene.control.behavior.TreeTableCellBehavior;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.InputMap$KeyMapping;
import com.sun.javafx.scene.control.inputmap.InputMap$Mapping;
import com.sun.javafx.scene.control.inputmap.InputMap$MouseMapping;
import com.sun.javafx.scene.control.inputmap.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public abstract class TableViewBehaviorBase<C extends Control, T, TC extends TableColumnBase<T, ?>>
extends BehaviorBase<C> {
    private final InputMap<C> tableViewInputMap;
    protected boolean isShortcutDown = false;
    protected boolean isShiftDown = false;
    private boolean selectionPathDeviated = false;
    protected boolean selectionChanging = false;
    private final EventHandler<KeyEvent> keyEventListener = keyEvent -> {
        if (!keyEvent.isConsumed()) {
            this.isShiftDown = ((Event)keyEvent).getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isShiftDown();
            this.isShortcutDown = ((Event)keyEvent).getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isShortcutDown();
        }
    };
    private final SizeLimitedList<TablePositionBase> selectionHistory = new SizeLimitedList(50);
    protected final ListChangeListener<TablePositionBase> selectedCellsListener = listChangeListener$Change -> {
        block0: while (listChangeListener$Change.next()) {
            if (listChangeListener$Change.wasReplaced()) {
                if (TreeTableCellBehavior.hasDefaultAnchor((Control)this.getNode())) {
                    TreeTableCellBehavior.removeAnchor((Control)this.getNode());
                }
                if (this.selectionHistory.size() > 0) {
                    this.resetSelectionHistory();
                }
            }
            if (!listChangeListener$Change.wasAdded()) continue;
            TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
            if (tableSelectionModel == null) {
                return;
            }
            TablePositionBase tablePositionBase = this.getAnchor();
            boolean bl2 = tableSelectionModel.isCellSelectionEnabled();
            int n2 = listChangeListener$Change.getAddedSize();
            List list = listChangeListener$Change.getAddedSubList();
            for (TablePositionBase tablePositionBase2 : list) {
                if (this.selectionHistory.contains(tablePositionBase2)) continue;
                this.selectionHistory.add(tablePositionBase2);
            }
            if (n2 > 0 && !this.hasAnchor()) {
                TablePositionBase tablePositionBase3 = (TablePositionBase)list.get(n2 - 1);
                this.setAnchor(tablePositionBase3);
            }
            if (tablePositionBase == null || !bl2 || this.selectionPathDeviated) continue;
            for (int i2 = 0; i2 < n2; ++i2) {
                TablePositionBase tablePositionBase2;
                tablePositionBase2 = (TablePositionBase)list.get(i2);
                if (tablePositionBase.getRow() == -1 || tablePositionBase2.getRow() == tablePositionBase.getRow() || tablePositionBase2.getColumn() == tablePositionBase.getColumn()) continue;
                this.setSelectionPathDeviated(true);
                continue block0;
            }
        }
    };
    protected final WeakListChangeListener<TablePositionBase> weakSelectedCellsListener = new WeakListChangeListener<TablePositionBase>(this.selectedCellsListener);
    private Callback<Boolean, Integer> onScrollPageUp;
    private Callback<Boolean, Integer> onScrollPageDown;
    private Runnable onFocusPreviousRow;
    private Runnable onFocusNextRow;
    private Runnable onSelectPreviousRow;
    private Runnable onSelectNextRow;
    private Runnable onMoveToFirstCell;
    private Runnable onMoveToLastCell;
    private Runnable onSelectRightCell;
    private Runnable onSelectLeftCell;
    private Runnable onFocusRightCell;
    private Runnable onFocusLeftCell;

    public TableViewBehaviorBase(C c2) {
        super(c2);
        this.tableViewInputMap = this.createInputMap();
        TableViewBehaviorBase tableViewBehaviorBase = this;
        InputMap$Mapping[] inputMap$MappingArray = new InputMap$Mapping[60];
        inputMap$MappingArray[0] = new InputMap$KeyMapping(KeyCode.TAB, FocusTraversalInputMap::traverseNext);
        inputMap$MappingArray[1] = new InputMap$KeyMapping(new KeyBinding(KeyCode.TAB).shift(), FocusTraversalInputMap::traversePrevious);
        inputMap$MappingArray[2] = new InputMap$KeyMapping(KeyCode.HOME, keyEvent -> this.selectFirstRow());
        inputMap$MappingArray[3] = new InputMap$KeyMapping(KeyCode.END, keyEvent -> this.selectLastRow());
        inputMap$MappingArray[4] = new InputMap$KeyMapping(KeyCode.PAGE_UP, keyEvent -> this.scrollUp());
        inputMap$MappingArray[5] = new InputMap$KeyMapping(KeyCode.PAGE_DOWN, keyEvent -> this.scrollDown());
        inputMap$MappingArray[6] = new InputMap$KeyMapping(KeyCode.LEFT, keyEvent -> {
            if (this.isRTL()) {
                this.selectRightCell();
                return;
            }
            this.selectLeftCell();
        });
        inputMap$MappingArray[7] = new InputMap$KeyMapping(KeyCode.KP_LEFT, keyEvent -> {
            if (this.isRTL()) {
                this.selectRightCell();
                return;
            }
            this.selectLeftCell();
        });
        inputMap$MappingArray[8] = new InputMap$KeyMapping(KeyCode.RIGHT, keyEvent -> {
            if (this.isRTL()) {
                this.selectLeftCell();
                return;
            }
            this.selectRightCell();
        });
        inputMap$MappingArray[9] = new InputMap$KeyMapping(KeyCode.KP_RIGHT, keyEvent -> {
            if (this.isRTL()) {
                this.selectLeftCell();
                return;
            }
            this.selectRightCell();
        });
        inputMap$MappingArray[10] = new InputMap$KeyMapping(KeyCode.UP, keyEvent -> this.selectPreviousRow());
        inputMap$MappingArray[11] = new InputMap$KeyMapping(KeyCode.KP_UP, keyEvent -> this.selectPreviousRow());
        inputMap$MappingArray[12] = new InputMap$KeyMapping(KeyCode.DOWN, keyEvent -> this.selectNextRow());
        inputMap$MappingArray[13] = new InputMap$KeyMapping(KeyCode.KP_DOWN, keyEvent -> this.selectNextRow());
        inputMap$MappingArray[14] = new InputMap$KeyMapping(KeyCode.LEFT, keyEvent -> {
            if (this.isRTL()) {
                this.focusTraverseRight();
                return;
            }
            this.focusTraverseLeft();
        });
        inputMap$MappingArray[15] = new InputMap$KeyMapping(KeyCode.KP_LEFT, keyEvent -> {
            if (this.isRTL()) {
                this.focusTraverseRight();
                return;
            }
            this.focusTraverseLeft();
        });
        inputMap$MappingArray[16] = new InputMap$KeyMapping(KeyCode.RIGHT, keyEvent -> {
            if (this.isRTL()) {
                this.focusTraverseLeft();
                return;
            }
            this.focusTraverseRight();
        });
        inputMap$MappingArray[17] = new InputMap$KeyMapping(KeyCode.KP_RIGHT, keyEvent -> {
            if (this.isRTL()) {
                this.focusTraverseLeft();
                return;
            }
            this.focusTraverseRight();
        });
        inputMap$MappingArray[18] = new InputMap$KeyMapping(KeyCode.UP, FocusTraversalInputMap::traverseUp);
        inputMap$MappingArray[19] = new InputMap$KeyMapping(KeyCode.KP_UP, FocusTraversalInputMap::traverseUp);
        inputMap$MappingArray[20] = new InputMap$KeyMapping(KeyCode.DOWN, FocusTraversalInputMap::traverseDown);
        inputMap$MappingArray[21] = new InputMap$KeyMapping(KeyCode.KP_DOWN, FocusTraversalInputMap::traverseDown);
        inputMap$MappingArray[22] = new InputMap$KeyMapping(new KeyBinding(KeyCode.HOME).shift(), keyEvent -> this.selectAllToFirstRow());
        inputMap$MappingArray[23] = new InputMap$KeyMapping(new KeyBinding(KeyCode.END).shift(), keyEvent -> this.selectAllToLastRow());
        inputMap$MappingArray[24] = new InputMap$KeyMapping(new KeyBinding(KeyCode.PAGE_UP).shift(), keyEvent -> this.selectAllPageUp());
        inputMap$MappingArray[25] = new InputMap$KeyMapping(new KeyBinding(KeyCode.PAGE_DOWN).shift(), keyEvent -> this.selectAllPageDown());
        inputMap$MappingArray[26] = new InputMap$KeyMapping(new KeyBinding(KeyCode.UP).shift(), keyEvent -> this.alsoSelectPrevious());
        inputMap$MappingArray[27] = new InputMap$KeyMapping(new KeyBinding(KeyCode.KP_UP).shift(), keyEvent -> this.alsoSelectPrevious());
        inputMap$MappingArray[28] = new InputMap$KeyMapping(new KeyBinding(KeyCode.DOWN).shift(), keyEvent -> this.alsoSelectNext());
        inputMap$MappingArray[29] = new InputMap$KeyMapping(new KeyBinding(KeyCode.KP_DOWN).shift(), keyEvent -> this.alsoSelectNext());
        inputMap$MappingArray[30] = new InputMap$KeyMapping(new KeyBinding(KeyCode.SPACE).shift(), keyEvent -> this.selectAllToFocus(false));
        inputMap$MappingArray[31] = new InputMap$KeyMapping(new KeyBinding(KeyCode.SPACE).shortcut().shift(), keyEvent -> this.selectAllToFocus(true));
        inputMap$MappingArray[32] = new InputMap$KeyMapping(new KeyBinding(KeyCode.LEFT).shift(), keyEvent -> {
            if (this.isRTL()) {
                this.alsoSelectRightCell();
                return;
            }
            this.alsoSelectLeftCell();
        });
        inputMap$MappingArray[33] = new InputMap$KeyMapping(new KeyBinding(KeyCode.KP_LEFT).shift(), keyEvent -> {
            if (this.isRTL()) {
                this.alsoSelectRightCell();
                return;
            }
            this.alsoSelectLeftCell();
        });
        inputMap$MappingArray[34] = new InputMap$KeyMapping(new KeyBinding(KeyCode.RIGHT).shift(), keyEvent -> {
            if (this.isRTL()) {
                this.alsoSelectLeftCell();
                return;
            }
            this.alsoSelectRightCell();
        });
        inputMap$MappingArray[35] = new InputMap$KeyMapping(new KeyBinding(KeyCode.KP_RIGHT).shift(), keyEvent -> {
            if (this.isRTL()) {
                this.alsoSelectLeftCell();
                return;
            }
            this.alsoSelectRightCell();
        });
        inputMap$MappingArray[36] = new InputMap$KeyMapping(new KeyBinding(KeyCode.UP).shortcut(), keyEvent -> this.focusPreviousRow());
        inputMap$MappingArray[37] = new InputMap$KeyMapping(new KeyBinding(KeyCode.DOWN).shortcut(), keyEvent -> this.focusNextRow());
        inputMap$MappingArray[38] = new InputMap$KeyMapping(new KeyBinding(KeyCode.RIGHT).shortcut(), keyEvent -> {
            if (this.isRTL()) {
                this.focusLeftCell();
                return;
            }
            this.focusRightCell();
        });
        inputMap$MappingArray[39] = new InputMap$KeyMapping(new KeyBinding(KeyCode.KP_RIGHT).shortcut(), keyEvent -> {
            if (this.isRTL()) {
                this.focusLeftCell();
                return;
            }
            this.focusRightCell();
        });
        inputMap$MappingArray[40] = new InputMap$KeyMapping(new KeyBinding(KeyCode.LEFT).shortcut(), keyEvent -> {
            if (this.isRTL()) {
                this.focusRightCell();
                return;
            }
            this.focusLeftCell();
        });
        inputMap$MappingArray[41] = new InputMap$KeyMapping(new KeyBinding(KeyCode.KP_LEFT).shortcut(), keyEvent -> {
            if (this.isRTL()) {
                this.focusRightCell();
                return;
            }
            this.focusLeftCell();
        });
        inputMap$MappingArray[42] = new InputMap$KeyMapping(new KeyBinding(KeyCode.A).shortcut(), keyEvent -> this.selectAll());
        inputMap$MappingArray[43] = new InputMap$KeyMapping(new KeyBinding(KeyCode.HOME).shortcut(), keyEvent -> this.focusFirstRow());
        inputMap$MappingArray[44] = new InputMap$KeyMapping(new KeyBinding(KeyCode.END).shortcut(), keyEvent -> this.focusLastRow());
        inputMap$MappingArray[45] = new InputMap$KeyMapping(new KeyBinding(KeyCode.PAGE_UP).shortcut(), keyEvent -> this.focusPageUp());
        inputMap$MappingArray[46] = new InputMap$KeyMapping(new KeyBinding(KeyCode.PAGE_DOWN).shortcut(), keyEvent -> this.focusPageDown());
        inputMap$MappingArray[47] = new InputMap$KeyMapping(new KeyBinding(KeyCode.UP).shortcut().shift(), keyEvent -> this.discontinuousSelectPreviousRow());
        inputMap$MappingArray[48] = new InputMap$KeyMapping(new KeyBinding(KeyCode.DOWN).shortcut().shift(), keyEvent -> this.discontinuousSelectNextRow());
        inputMap$MappingArray[49] = new InputMap$KeyMapping(new KeyBinding(KeyCode.LEFT).shortcut().shift(), keyEvent -> {
            if (this.isRTL()) {
                this.discontinuousSelectNextColumn();
                return;
            }
            this.discontinuousSelectPreviousColumn();
        });
        inputMap$MappingArray[50] = new InputMap$KeyMapping(new KeyBinding(KeyCode.RIGHT).shortcut().shift(), keyEvent -> {
            if (this.isRTL()) {
                this.discontinuousSelectPreviousColumn();
                return;
            }
            this.discontinuousSelectNextColumn();
        });
        inputMap$MappingArray[51] = new InputMap$KeyMapping(new KeyBinding(KeyCode.PAGE_UP).shortcut().shift(), keyEvent -> this.discontinuousSelectPageUp());
        inputMap$MappingArray[52] = new InputMap$KeyMapping(new KeyBinding(KeyCode.PAGE_DOWN).shortcut().shift(), keyEvent -> this.discontinuousSelectPageDown());
        inputMap$MappingArray[53] = new InputMap$KeyMapping(new KeyBinding(KeyCode.HOME).shortcut().shift(), keyEvent -> this.discontinuousSelectAllToFirstRow());
        inputMap$MappingArray[54] = new InputMap$KeyMapping(new KeyBinding(KeyCode.END).shortcut().shift(), keyEvent -> this.discontinuousSelectAllToLastRow());
        InputMap<C> inputMap = new InputMap$KeyMapping(KeyCode.ENTER, this::activate);
        inputMap$MappingArray[55] = inputMap;
        inputMap$MappingArray[56] = new InputMap$KeyMapping(KeyCode.SPACE, this::activate);
        inputMap$MappingArray[57] = new InputMap$KeyMapping(KeyCode.F2, this::activate);
        InputMap$KeyMapping inputMap$KeyMapping = new InputMap$KeyMapping(KeyCode.ESCAPE, this::cancelEdit);
        inputMap$MappingArray[58] = inputMap$KeyMapping;
        inputMap$MappingArray[59] = new InputMap$MouseMapping(MouseEvent.MOUSE_PRESSED, this::mousePressed);
        tableViewBehaviorBase.addDefaultMapping(tableViewBehaviorBase.tableViewInputMap, inputMap$MappingArray);
        ((InputMap$Mapping)((Object)inputMap)).setAutoConsume(false);
        inputMap$KeyMapping.setAutoConsume(false);
        inputMap = new InputMap<C>(c2);
        inputMap.setInterceptor(event -> !PlatformUtil.isMac());
        this.addDefaultMapping(inputMap, new InputMap$KeyMapping(new KeyBinding(KeyCode.SPACE).shortcut().ctrl(), keyEvent -> this.toggleFocusOwnerSelection()));
        TableViewBehaviorBase tableViewBehaviorBase2 = this;
        tableViewBehaviorBase2.addDefaultChildMap(tableViewBehaviorBase2.tableViewInputMap, inputMap);
        inputMap = new InputMap<C>(c2);
        inputMap.setInterceptor(event -> PlatformUtil.isMac());
        this.addDefaultMapping(inputMap, new InputMap$KeyMapping(new KeyBinding(KeyCode.SPACE).ctrl(), keyEvent -> this.toggleFocusOwnerSelection()));
        TableViewBehaviorBase tableViewBehaviorBase3 = this;
        tableViewBehaviorBase3.addDefaultChildMap(tableViewBehaviorBase3.tableViewInputMap, inputMap);
        ((Node)c2).addEventFilter(KeyEvent.ANY, this.keyEventListener);
    }

    @Override
    public InputMap<C> getInputMap() {
        return this.tableViewInputMap;
    }

    protected void setAnchor(TablePositionBase tablePositionBase) {
        TableCellBehaviorBase.setAnchor((Control)this.getNode(), tablePositionBase, false);
        this.resetSelectionHistory();
    }

    protected TablePositionBase getAnchor() {
        return TableCellBehaviorBase.getAnchor((Control)this.getNode(), this.getFocusedCell());
    }

    protected boolean hasAnchor() {
        return TableCellBehaviorBase.hasNonDefaultAnchor((Control)this.getNode());
    }

    protected abstract int getItemCount();

    protected abstract TableFocusModel getFocusModel();

    protected abstract TableSelectionModel<T> getSelectionModel();

    protected abstract ObservableList<? extends TablePositionBase> getSelectedCells();

    protected abstract TablePositionBase getFocusedCell();

    protected abstract int getVisibleLeafIndex(TableColumnBase var1);

    protected abstract TableColumnBase getVisibleLeafColumn(int var1);

    protected abstract boolean isControlEditable();

    protected abstract void editCell(int var1, TableColumnBase var2);

    protected abstract ObservableList<? extends TableColumnBase> getVisibleLeafColumns();

    protected abstract TablePositionBase<TC> getTablePosition(int var1, TableColumnBase<T, ?> var2);

    protected void setAnchor(int n2, TableColumnBase tableColumnBase) {
        this.setAnchor(n2 == -1 && tableColumnBase == null ? null : this.getTablePosition(n2, tableColumnBase));
    }

    public void setOnScrollPageUp(Callback<Boolean, Integer> callback) {
        this.onScrollPageUp = callback;
    }

    public void setOnScrollPageDown(Callback<Boolean, Integer> callback) {
        this.onScrollPageDown = callback;
    }

    public void setOnFocusPreviousRow(Runnable runnable) {
        this.onFocusPreviousRow = runnable;
    }

    public void setOnFocusNextRow(Runnable runnable) {
        this.onFocusNextRow = runnable;
    }

    public void setOnSelectPreviousRow(Runnable runnable) {
        this.onSelectPreviousRow = runnable;
    }

    public void setOnSelectNextRow(Runnable runnable) {
        this.onSelectNextRow = runnable;
    }

    public void setOnMoveToFirstCell(Runnable runnable) {
        this.onMoveToFirstCell = runnable;
    }

    public void setOnMoveToLastCell(Runnable runnable) {
        this.onMoveToLastCell = runnable;
    }

    public void setOnSelectRightCell(Runnable runnable) {
        this.onSelectRightCell = runnable;
    }

    public void setOnSelectLeftCell(Runnable runnable) {
        this.onSelectLeftCell = runnable;
    }

    public void setOnFocusRightCell(Runnable runnable) {
        this.onFocusRightCell = runnable;
    }

    public void setOnFocusLeftCell(Runnable runnable) {
        this.onFocusLeftCell = runnable;
    }

    @Override
    public void dispose() {
        this.onScrollPageUp = null;
        this.onScrollPageDown = null;
        this.onFocusPreviousRow = null;
        this.onFocusNextRow = null;
        this.onSelectPreviousRow = null;
        this.onSelectNextRow = null;
        this.onMoveToFirstCell = null;
        this.onMoveToLastCell = null;
        this.onSelectRightCell = null;
        this.onSelectLeftCell = null;
        this.onFocusRightCell = null;
        this.onFocusLeftCell = null;
        super.dispose();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!((Control)this.getNode()).isFocused() && ((Control)this.getNode()).isFocusTraversable()) {
            ((Control)this.getNode()).requestFocus();
        }
    }

    protected boolean isRTL() {
        return ((Control)this.getNode()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
    }

    private void setSelectionPathDeviated(boolean bl2) {
        this.selectionPathDeviated = bl2;
    }

    private void resetSelectionHistory() {
        this.setSelectionPathDeviated(false);
        this.selectionHistory.clear();
        this.selectionHistory.add(this.getAnchor());
    }

    protected void scrollUp() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null || this.getSelectedCells().isEmpty()) {
            return;
        }
        TablePositionBase tablePositionBase = (TablePositionBase)this.getSelectedCells().get(0);
        int n2 = -1;
        if (this.onScrollPageUp != null) {
            n2 = this.onScrollPageUp.call(Boolean.FALSE);
        }
        if (n2 == -1) {
            return;
        }
        tableSelectionModel.clearAndSelect(n2, (TableColumnBase<T, ?>)tablePositionBase.getTableColumn());
    }

    protected void scrollDown() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null || this.getSelectedCells().isEmpty()) {
            return;
        }
        TablePositionBase tablePositionBase = (TablePositionBase)this.getSelectedCells().get(0);
        int n2 = -1;
        if (this.onScrollPageDown != null) {
            n2 = this.onScrollPageDown.call(Boolean.FALSE);
        }
        if (n2 == -1) {
            return;
        }
        tableSelectionModel.clearAndSelect(n2, (TableColumnBase<T, ?>)tablePositionBase.getTableColumn());
    }

    protected void focusFirstRow() {
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        Object TC = this.getFocusedCell() == null ? null : (Object)this.getFocusedCell().getTableColumn();
        tableFocusModel.focus(0, TC);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    protected void focusLastRow() {
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        Object TC = this.getFocusedCell() == null ? null : (Object)this.getFocusedCell().getTableColumn();
        tableFocusModel.focus(this.getItemCount() - 1, TC);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    protected void focusPreviousRow() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        if (tableSelectionModel.isCellSelectionEnabled()) {
            tableFocusModel.focusAboveCell();
        } else {
            tableFocusModel.focusPrevious();
        }
        if (!this.isShortcutDown || this.getAnchor() == null) {
            this.setAnchor(tableFocusModel.getFocusedIndex(), null);
        }
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    protected void focusNextRow() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        if (tableSelectionModel.isCellSelectionEnabled()) {
            tableFocusModel.focusBelowCell();
        } else {
            tableFocusModel.focusNext();
        }
        if (!this.isShortcutDown || this.getAnchor() == null) {
            this.setAnchor(tableFocusModel.getFocusedIndex(), null);
        }
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    protected void focusLeftCell() {
        Object object = this.getSelectionModel();
        if (object == null) {
            return;
        }
        object = this.getFocusModel();
        if (object == null) {
            return;
        }
        ((TableFocusModel)object).focusLeftCell();
        if (this.onFocusLeftCell != null) {
            this.onFocusLeftCell.run();
        }
    }

    protected void focusRightCell() {
        Object object = this.getSelectionModel();
        if (object == null) {
            return;
        }
        object = this.getFocusModel();
        if (object == null) {
            return;
        }
        ((TableFocusModel)object).focusRightCell();
        if (this.onFocusRightCell != null) {
            this.onFocusRightCell.run();
        }
    }

    protected void focusPageUp() {
        int n2 = this.onScrollPageUp.call(Boolean.TRUE);
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        Object TC = this.getFocusedCell() == null ? null : (Object)this.getFocusedCell().getTableColumn();
        tableFocusModel.focus(n2, TC);
    }

    protected void focusPageDown() {
        int n2 = this.onScrollPageDown.call(Boolean.TRUE);
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        Object TC = this.getFocusedCell() == null ? null : (Object)this.getFocusedCell().getTableColumn();
        tableFocusModel.focus(n2, TC);
    }

    protected void clearSelection() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        ((SelectionModel)tableSelectionModel).clearSelection();
    }

    protected void clearSelectionOutsideRange(int n2, int n3, TableColumnBase<T, ?> tableColumnBase) {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        int n4 = Math.min(n2, n3);
        n2 = Math.max(n2, n3);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(((MultipleSelectionModel)tableSelectionModel).getSelectedIndices());
        this.selectionChanging = true;
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            int n5 = (Integer)arrayList.get(i2);
            if (n5 >= n4 && n5 <= n2) continue;
            tableSelectionModel.clearSelection(n5, tableColumnBase);
        }
        this.selectionChanging = false;
    }

    protected void alsoSelectPrevious() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        if (tableSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            this.selectPreviousRow();
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        if (tableSelectionModel.isCellSelectionEnabled()) {
            this.updateCellVerticalSelection(-1, () -> this.getSelectionModel().selectAboveCell());
        } else if (this.isShiftDown && this.hasAnchor()) {
            this.updateRowSelection(-1);
        } else {
            ((SelectionModel)tableSelectionModel).selectPrevious();
        }
        this.onSelectPreviousRow.run();
    }

    protected void alsoSelectNext() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        if (tableSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            this.selectNextRow();
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        if (tableSelectionModel.isCellSelectionEnabled()) {
            this.updateCellVerticalSelection(1, () -> this.getSelectionModel().selectBelowCell());
        } else if (this.isShiftDown && this.hasAnchor()) {
            this.updateRowSelection(1);
        } else {
            ((SelectionModel)tableSelectionModel).selectNext();
        }
        this.onSelectNextRow.run();
    }

    protected void alsoSelectLeftCell() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null || !tableSelectionModel.isCellSelectionEnabled()) {
            return;
        }
        this.updateCellHorizontalSelection(-1, () -> this.getSelectionModel().selectLeftCell());
        this.onSelectLeftCell.run();
    }

    protected void alsoSelectRightCell() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null || !tableSelectionModel.isCellSelectionEnabled()) {
            return;
        }
        this.updateCellHorizontalSelection(1, () -> this.getSelectionModel().selectRightCell());
        this.onSelectRightCell.run();
    }

    protected void updateRowSelection(int n2) {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null || tableSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        Object object = this.getFocusModel();
        if (object == null) {
            return;
        }
        n2 = ((FocusModel)object).getFocusedIndex() + n2;
        object = this.getAnchor();
        if (!this.hasAnchor()) {
            TableViewBehaviorBase tableViewBehaviorBase = this;
            tableViewBehaviorBase.setAnchor(tableViewBehaviorBase.getFocusedCell());
        }
        if (((MultipleSelectionModel)tableSelectionModel).getSelectedIndices().size() > 1) {
            this.clearSelectionOutsideRange(((TablePositionBase)object).getRow(), n2, null);
        }
        if (((TablePositionBase)object).getRow() > n2) {
            tableSelectionModel.selectRange(((TablePositionBase)object).getRow(), n2 - 1);
            return;
        }
        tableSelectionModel.selectRange(((TablePositionBase)object).getRow(), n2 + 1);
    }

    protected void updateCellVerticalSelection(int n2, Runnable runnable) {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null || tableSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase = this.getFocusedCell();
        int n3 = tablePositionBase.getRow();
        if (this.isShiftDown && tableSelectionModel.isSelected(n3 + n2, (TableColumnBase<T, ?>)tablePositionBase.getTableColumn())) {
            n2 = n3 + n2;
            boolean bl2 = false;
            if (this.selectionHistory.size() >= 2) {
                TablePositionBase tablePositionBase3 = this.selectionHistory.get(1);
                bl2 = tablePositionBase3.getRow() == n2 && tablePositionBase3.getColumn() == tablePositionBase.getColumn();
            }
            int n4 = this.selectionPathDeviated && !bl2 ? n2 : n3;
            this.selectionHistory.removeIf(tablePositionBase2 -> tablePositionBase2.getRow() == n4 && tablePositionBase2.getColumn() == tablePositionBase.getColumn());
            tableSelectionModel.clearSelection(n4, (TableColumnBase<T, ?>)tablePositionBase.getTableColumn());
            tableFocusModel.focus(n2, tablePositionBase.getTableColumn());
            return;
        }
        if (this.isShiftDown && this.getAnchor() != null && !this.selectionPathDeviated) {
            n2 = tableFocusModel.getFocusedIndex() + n2;
            n2 = Math.max(Math.min(this.getItemCount() - 1, n2), 0);
            int n5 = Math.min(this.getAnchor().getRow(), n2);
            int n6 = Math.max(this.getAnchor().getRow(), n2);
            if (((MultipleSelectionModel)tableSelectionModel).getSelectedIndices().size() > 1) {
                this.clearSelectionOutsideRange(n5, n6, (TableColumnBase<T, ?>)tablePositionBase.getTableColumn());
            }
            while (n5 <= n6) {
                if (!tableSelectionModel.isSelected(n5, (TableColumnBase<T, ?>)tablePositionBase.getTableColumn())) {
                    tableSelectionModel.select(n5, (TableColumnBase<T, ?>)tablePositionBase.getTableColumn());
                }
                ++n5;
            }
            tableFocusModel.focus(n2, tablePositionBase.getTableColumn());
            return;
        }
        n2 = tableFocusModel.getFocusedIndex();
        if (!tableSelectionModel.isSelected(n2, (TableColumnBase<T, ?>)tablePositionBase.getTableColumn())) {
            tableSelectionModel.select(n2, (TableColumnBase<T, ?>)tablePositionBase.getTableColumn());
        }
        runnable.run();
    }

    protected void updateCellHorizontalSelection(int n2, Runnable runnable) {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null || tableSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase2 = this.getFocusedCell();
        if (tablePositionBase2 == null || tablePositionBase2.getTableColumn() == null) {
            return;
        }
        int n3 = 0;
        TableColumnBase tableColumnBase = this.getColumn((TableColumnBase)tablePositionBase2.getTableColumn(), n2);
        if (tableColumnBase == null) {
            tableColumnBase = tablePositionBase2.getTableColumn();
            n3 = 1;
        }
        int n4 = tablePositionBase2.getRow();
        if (this.isShiftDown && tableSelectionModel.isSelected(n4, tableColumnBase)) {
            if (n3 != 0) {
                return;
            }
            boolean bl2 = false;
            if (this.selectionHistory.size() >= 2) {
                TablePositionBase tablePositionBase3 = this.selectionHistory.get(1);
                bl2 = tablePositionBase3.getRow() == n4 && tablePositionBase3.getTableColumn().equals(tableColumnBase);
            }
            Object object = this.selectionPathDeviated && !bl2 ? tableColumnBase : tablePositionBase2.getTableColumn();
            this.selectionHistory.removeIf(tablePositionBase -> tablePositionBase.getRow() == n4 && tablePositionBase.getTableColumn().equals(object));
            tableSelectionModel.clearSelection(n4, (TableColumnBase<T, ?>)object);
            tableFocusModel.focus(n4, tableColumnBase);
            return;
        }
        if (this.isShiftDown && this.getAnchor() != null && !this.selectionPathDeviated) {
            int n5 = this.getAnchor().getColumn();
            n2 = this.getVisibleLeafIndex((TableColumnBase)tablePositionBase2.getTableColumn()) + n2;
            n2 = Math.max(Math.min(this.getVisibleLeafColumns().size() - 1, n2), 0);
            n3 = Math.min(n5, n2);
            n5 = Math.max(n5, n2);
            while (n3 <= n5) {
                tableSelectionModel.select(tablePositionBase2.getRow(), this.getColumn(n3));
                ++n3;
            }
            tableFocusModel.focus(tablePositionBase2.getRow(), this.getColumn(n2));
            return;
        }
        runnable.run();
    }

    protected TableColumnBase getColumn(int n2) {
        return this.getVisibleLeafColumn(n2);
    }

    protected TableColumnBase getColumn(TableColumnBase tableColumnBase, int n2) {
        TableViewBehaviorBase tableViewBehaviorBase = this;
        return tableViewBehaviorBase.getVisibleLeafColumn(tableViewBehaviorBase.getVisibleLeafIndex(tableColumnBase) + n2);
    }

    protected void selectFirstRow() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        ObservableList<TablePositionBase> observableList = this.getSelectedCells();
        observableList = observableList.size() == 0 ? null : ((TablePositionBase)observableList.get(0)).getTableColumn();
        tableSelectionModel.clearAndSelect(0, (TableColumnBase<T, ?>)((Object)observableList));
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    protected void selectLastRow() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        ObservableList<TablePositionBase> observableList = this.getSelectedCells();
        observableList = observableList.size() == 0 ? null : ((TablePositionBase)observableList.get(0)).getTableColumn();
        tableSelectionModel.clearAndSelect(this.getItemCount() - 1, (TableColumnBase<T, ?>)((Object)observableList));
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    protected void selectPreviousRow() {
        this.selectCell(-1, 0);
        if (this.onSelectPreviousRow != null) {
            this.onSelectPreviousRow.run();
        }
    }

    protected void selectNextRow() {
        this.selectCell(1, 0);
        if (this.onSelectNextRow != null) {
            this.onSelectNextRow.run();
        }
    }

    protected void selectLeftCell() {
        this.selectCell(0, -1);
        if (this.onSelectLeftCell != null) {
            this.onSelectLeftCell.run();
        }
    }

    protected void selectRightCell() {
        this.selectCell(0, 1);
        if (this.onSelectRightCell != null) {
            this.onSelectRightCell.run();
        }
    }

    protected void selectCell(int n2, int n3) {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        Object object = this.getFocusModel();
        if (object == null) {
            return;
        }
        object = this.getFocusedCell();
        int n4 = ((TablePositionBase)object).getRow();
        int n5 = this.getVisibleLeafIndex((TableColumnBase)((TablePositionBase)object).getTableColumn());
        if (n2 > 0 && n4 >= this.getItemCount() - 1) {
            return;
        }
        if (n3 < 0 && n5 <= 0) {
            return;
        }
        if (n3 > 0 && n5 >= this.getVisibleLeafColumns().size() - 1) {
            return;
        }
        if (n3 > 0 && n5 == -1) {
            return;
        }
        Object object2 = ((TablePositionBase)object).getTableColumn();
        object2 = this.getColumn((TableColumnBase)object2, n3);
        n2 = n4 <= 0 && n2 <= 0 ? 0 : ((TablePositionBase)object).getRow() + n2;
        tableSelectionModel.clearAndSelect(n2, (TableColumnBase<T, ?>)object2);
        this.setAnchor(n2, (TableColumnBase)object2);
    }

    protected void cancelEdit(KeyEvent keyEvent) {
        if (this.isControlEditable()) {
            this.editCell(-1, null);
            keyEvent.consume();
        }
    }

    protected void activate(KeyEvent keyEvent) {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        Object object = this.getFocusModel();
        if (object == null) {
            return;
        }
        object = this.getFocusedCell();
        Object TC = ((TablePositionBase)object).getTableColumn();
        tableSelectionModel.select(((TablePositionBase)object).getRow(), (TableColumnBase<T, ?>)TC);
        this.setAnchor((TablePositionBase)object);
        if (TC == null) {
            return;
        }
        boolean bl2 = this.isControlEditable() && ((TableColumnBase)TC).isEditable();
        if (bl2 && ((TablePositionBase)object).getRow() >= 0) {
            this.editCell(((TablePositionBase)object).getRow(), (TableColumnBase)TC);
            keyEvent.consume();
        }
    }

    protected void selectAllToFocus(boolean bl2) {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        Object object = this.getFocusModel();
        if (object == null) {
            return;
        }
        object = this.getFocusedCell();
        int n2 = ((TablePositionBase)object).getRow();
        TablePositionBase tablePositionBase = this.getAnchor();
        int n3 = tablePositionBase.getRow();
        ((SelectionModel)tableSelectionModel).clearSelection();
        if (!tableSelectionModel.isCellSelectionEnabled()) {
            int n4 = n3;
            n2 = n3 > n2 ? n2 - 1 : n2 + 1;
            tableSelectionModel.selectRange(n4, n2);
        } else {
            tableSelectionModel.selectRange(tablePositionBase.getRow(), (TableColumnBase<T, ?>)tablePositionBase.getTableColumn(), ((TablePositionBase)object).getRow(), (TableColumnBase<T, ?>)((TablePositionBase)object).getTableColumn());
        }
        this.setAnchor((TablePositionBase)(bl2 ? object : tablePositionBase));
    }

    protected void selectAll() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        ((MultipleSelectionModel)tableSelectionModel).selectAll();
    }

    protected void selectAllToFirstRow() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        boolean bl2 = tableSelectionModel.getSelectionMode() == SelectionMode.SINGLE;
        TablePositionBase tablePositionBase = this.getFocusedCell();
        Object TC = this.getFocusedCell().getTableColumn();
        int n2 = tablePositionBase.getRow();
        if (this.isShiftDown) {
            n2 = this.getAnchor() == null ? n2 : this.getAnchor().getRow();
        }
        ((SelectionModel)tableSelectionModel).clearSelection();
        if (!tableSelectionModel.isCellSelectionEnabled()) {
            if (bl2) {
                ((SelectionModel)tableSelectionModel).select(0);
            } else {
                tableSelectionModel.selectRange(n2, -1);
            }
            tableFocusModel.focus(0);
        } else {
            if (bl2) {
                tableSelectionModel.select(0, (TableColumnBase<T, ?>)TC);
            } else {
                tableSelectionModel.selectRange(n2, (TableColumnBase<T, ?>)TC, -1, (TableColumnBase<T, ?>)TC);
            }
            tableFocusModel.focus(0, TC);
        }
        if (this.isShiftDown) {
            this.setAnchor(n2, (TableColumnBase)TC);
        }
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    protected void selectAllToLastRow() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        int n2 = this.getItemCount();
        TablePositionBase tablePositionBase = this.getFocusedCell();
        Object TC = this.getFocusedCell().getTableColumn();
        int n3 = tablePositionBase.getRow();
        if (this.isShiftDown) {
            n3 = this.getAnchor() == null ? n3 : this.getAnchor().getRow();
        }
        ((SelectionModel)tableSelectionModel).clearSelection();
        if (!tableSelectionModel.isCellSelectionEnabled()) {
            tableSelectionModel.selectRange(n3, n2);
        } else {
            tableSelectionModel.selectRange(n3, (TableColumnBase<T, ?>)TC, n2 - 1, (TableColumnBase<T, ?>)TC);
        }
        if (this.isShiftDown) {
            this.setAnchor(n3, (TableColumnBase)TC);
        }
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    protected void selectAllPageUp() {
        TableColumnBase tableColumnBase;
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        int n2 = tableFocusModel.getFocusedIndex();
        TableColumnBase tableColumnBase2 = tableColumnBase = tableSelectionModel.isCellSelectionEnabled() ? (TableColumnBase)this.getFocusedCell().getTableColumn() : null;
        if (this.isShiftDown) {
            n2 = this.getAnchor() == null ? n2 : this.getAnchor().getRow();
            this.setAnchor(n2, tableColumnBase);
        }
        int n3 = this.onScrollPageUp.call(Boolean.FALSE);
        this.selectionChanging = true;
        if (tableSelectionModel.getSelectionMode() == null || tableSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            if (tableSelectionModel.isCellSelectionEnabled()) {
                tableSelectionModel.select(n3, tableColumnBase);
            } else {
                ((SelectionModel)tableSelectionModel).select(n3);
            }
        } else {
            ((SelectionModel)tableSelectionModel).clearSelection();
            if (tableSelectionModel.isCellSelectionEnabled()) {
                tableSelectionModel.selectRange(n2, tableColumnBase, n3, tableColumnBase);
            } else {
                int n4 = n2 < n3 ? 1 : -1;
                tableSelectionModel.selectRange(n2, n3 + n4);
            }
        }
        this.selectionChanging = false;
    }

    protected void selectAllPageDown() {
        TableColumnBase tableColumnBase;
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        int n2 = tableFocusModel.getFocusedIndex();
        TableColumnBase tableColumnBase2 = tableColumnBase = tableSelectionModel.isCellSelectionEnabled() ? (TableColumnBase)this.getFocusedCell().getTableColumn() : null;
        if (this.isShiftDown) {
            n2 = this.getAnchor() == null ? n2 : this.getAnchor().getRow();
            this.setAnchor(n2, tableColumnBase);
        }
        int n3 = this.onScrollPageDown.call(Boolean.FALSE);
        this.selectionChanging = true;
        if (tableSelectionModel.getSelectionMode() == null || tableSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            if (tableSelectionModel.isCellSelectionEnabled()) {
                tableSelectionModel.select(n3, tableColumnBase);
            } else {
                ((SelectionModel)tableSelectionModel).select(n3);
            }
        } else {
            ((SelectionModel)tableSelectionModel).clearSelection();
            if (tableSelectionModel.isCellSelectionEnabled()) {
                tableSelectionModel.selectRange(n2, tableColumnBase, n3, tableColumnBase);
            } else {
                int n4 = n2 < n3 ? 1 : -1;
                tableSelectionModel.selectRange(n2, n3 + n4);
            }
        }
        this.selectionChanging = false;
    }

    protected void toggleFocusOwnerSelection() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase = this.getFocusedCell();
        if (tableSelectionModel.isSelected(tablePositionBase.getRow(), (TableColumnBase<T, ?>)tablePositionBase.getTableColumn())) {
            tableSelectionModel.clearSelection(tablePositionBase.getRow(), (TableColumnBase<T, ?>)tablePositionBase.getTableColumn());
            tableFocusModel.focus(tablePositionBase.getRow(), tablePositionBase.getTableColumn());
        } else {
            tableSelectionModel.select(tablePositionBase.getRow(), (TableColumnBase<T, ?>)tablePositionBase.getTableColumn());
        }
        this.setAnchor(tablePositionBase.getRow(), (TableColumnBase)tablePositionBase.getTableColumn());
    }

    protected void discontinuousSelectPreviousRow() {
        TableColumnBase<?, ?> tableColumnBase;
        TableSelectionModel tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        if (tableSelectionModel.getSelectionMode() != SelectionMode.MULTIPLE) {
            this.selectPreviousRow();
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        int n2 = tableFocusModel.getFocusedIndex();
        int n3 = n2 - 1;
        if (n3 < 0) {
            return;
        }
        int n4 = n2;
        TableColumnBase<?, ?> tableColumnBase2 = tableColumnBase = tableSelectionModel.isCellSelectionEnabled() ? (TableColumnBase<?, ?>)this.getFocusedCell().getTableColumn() : null;
        if (this.isShiftDown) {
            int n5 = n4 = this.getAnchor() == null ? n2 : this.getAnchor().getRow();
        }
        if (!tableSelectionModel.isCellSelectionEnabled()) {
            tableSelectionModel.selectRange(n3, n4 + 1);
            tableFocusModel.focus(n3);
        } else {
            for (n2 = n3; n2 < n4 + 1; ++n2) {
                tableSelectionModel.select(n2, tableColumnBase);
            }
            tableFocusModel.focus(n3, tableColumnBase);
        }
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    protected void discontinuousSelectNextRow() {
        TableColumnBase<?, ?> tableColumnBase;
        TableSelectionModel tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        if (tableSelectionModel.getSelectionMode() != SelectionMode.MULTIPLE) {
            this.selectNextRow();
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        int n2 = tableFocusModel.getFocusedIndex();
        int n3 = n2 + 1;
        if (n3 >= this.getItemCount()) {
            return;
        }
        int n4 = n2;
        TableColumnBase<?, ?> tableColumnBase2 = tableColumnBase = tableSelectionModel.isCellSelectionEnabled() ? (TableColumnBase<?, ?>)this.getFocusedCell().getTableColumn() : null;
        if (this.isShiftDown) {
            int n5 = n4 = this.getAnchor() == null ? n2 : this.getAnchor().getRow();
        }
        if (!tableSelectionModel.isCellSelectionEnabled()) {
            tableSelectionModel.selectRange(n4, n3 + 1);
            tableFocusModel.focus(n3);
        } else {
            for (n2 = n4; n2 < n3 + 1; ++n2) {
                tableSelectionModel.select(n2, tableColumnBase);
            }
            tableFocusModel.focus(n3, tableColumnBase);
        }
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    protected void discontinuousSelectPreviousColumn() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null || !tableSelectionModel.isCellSelectionEnabled()) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TableViewBehaviorBase tableViewBehaviorBase = this;
        TableColumnBase tableColumnBase = tableViewBehaviorBase.getColumn((TableColumnBase)tableViewBehaviorBase.getFocusedCell().getTableColumn(), -1);
        tableSelectionModel.select(tableFocusModel.getFocusedIndex(), tableColumnBase);
    }

    protected void discontinuousSelectNextColumn() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null || !tableSelectionModel.isCellSelectionEnabled()) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TableViewBehaviorBase tableViewBehaviorBase = this;
        TableColumnBase tableColumnBase = tableViewBehaviorBase.getColumn((TableColumnBase)tableViewBehaviorBase.getFocusedCell().getTableColumn(), 1);
        tableSelectionModel.select(tableFocusModel.getFocusedIndex(), tableColumnBase);
    }

    protected void discontinuousSelectPageUp() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        int n2 = this.hasAnchor() ? this.getAnchor().getRow() : tableFocusModel.getFocusedIndex();
        int n3 = this.onScrollPageUp.call(Boolean.FALSE);
        if (!tableSelectionModel.isCellSelectionEnabled()) {
            tableSelectionModel.selectRange(n2, n3 - 1);
        }
    }

    protected void discontinuousSelectPageDown() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        int n2 = this.hasAnchor() ? this.getAnchor().getRow() : tableFocusModel.getFocusedIndex();
        int n3 = this.onScrollPageDown.call(Boolean.FALSE);
        if (!tableSelectionModel.isCellSelectionEnabled()) {
            tableSelectionModel.selectRange(n2, n3 + 1);
        }
    }

    protected void discontinuousSelectAllToFirstRow() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        int n2 = tableFocusModel.getFocusedIndex();
        if (!tableSelectionModel.isCellSelectionEnabled()) {
            tableSelectionModel.selectRange(0, n2);
            tableFocusModel.focus(0);
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                tableSelectionModel.select(i2, (TableColumnBase<T, ?>)this.getFocusedCell().getTableColumn());
            }
            tableFocusModel.focus(0, this.getFocusedCell().getTableColumn());
        }
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    protected void discontinuousSelectAllToLastRow() {
        TableSelectionModel<T> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        TableFocusModel tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        int n2 = tableFocusModel.getFocusedIndex() + 1;
        if (!tableSelectionModel.isCellSelectionEnabled()) {
            tableSelectionModel.selectRange(n2, this.getItemCount());
        } else {
            while (n2 < this.getItemCount()) {
                tableSelectionModel.select(n2, (TableColumnBase<T, ?>)this.getFocusedCell().getTableColumn());
                ++n2;
            }
        }
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private EventHandler<KeyEvent> focusTraverseLeft() {
        return FocusTraversalInputMap::traverseLeft;
    }

    private EventHandler<KeyEvent> focusTraverseRight() {
        return FocusTraversalInputMap::traverseRight;
    }
}

