/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.FocusTraversalInputMap;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior$1;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior$ContextMenuItem;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.InputMap$KeyMapping;
import com.sun.javafx.scene.control.inputmap.InputMap$Mapping;
import com.sun.javafx.scene.control.inputmap.InputMap$MouseMapping;
import com.sun.javafx.scene.control.inputmap.KeyBinding;
import com.sun.javafx.scene.control.inputmap.KeyBinding$OptionalBoolean;
import com.sun.javafx.scene.control.skin.FXVK;
import java.text.Bidi;
import java.util.function.Predicate;
import javafx.application.ConditionalFeature;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.skin.TextInputControlSkin;
import javafx.scene.control.skin.TextInputControlSkin$Direction;
import javafx.scene.control.skin.TextInputControlSkin$TextUnit;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public abstract class TextInputControlBehavior<T extends TextInputControl>
extends BehaviorBase<T> {
    static final boolean SHOW_HANDLES = Properties.IS_TOUCH_SUPPORTED;
    public static final String DISABLE_FORWARD_TO_PARENT = "TextInputControlBehavior.disableForwardToParent";
    final T textInputControl;
    protected ContextMenu contextMenu;
    private InvalidationListener textListener = observable -> this.invalidateBidi();
    private final InputMap<T> inputMap;
    private Bidi bidi = null;
    private Boolean mixed = null;
    private Boolean rtlText = null;
    private boolean editing = false;
    private final MenuItem undoMI = new TextInputControlBehavior$ContextMenuItem("Undo", actionEvent -> this.undo());
    private final MenuItem redoMI = new TextInputControlBehavior$ContextMenuItem("Redo", actionEvent -> this.redo());
    private final MenuItem cutMI = new TextInputControlBehavior$ContextMenuItem("Cut", actionEvent -> this.cut());
    private final MenuItem copyMI = new TextInputControlBehavior$ContextMenuItem("Copy", actionEvent -> ((TextInputControl)this.getNode()).copy());
    private final MenuItem pasteMI = new TextInputControlBehavior$ContextMenuItem("Paste", actionEvent -> this.paste());
    private final MenuItem deleteMI = new TextInputControlBehavior$ContextMenuItem("DeleteSelection", actionEvent -> this.deleteSelection());
    private final MenuItem selectWordMI = new TextInputControlBehavior$ContextMenuItem("SelectWord", actionEvent -> this.selectWord());
    private final MenuItem selectAllMI = new TextInputControlBehavior$ContextMenuItem("SelectAll", actionEvent -> this.selectAll());
    private final MenuItem separatorMI = new SeparatorMenuItem();

    public TextInputControlBehavior(T t2) {
        super(t2);
        this.textInputControl = t2;
        this.inputMap = this.createInputMap();
        InputMap<T> inputMap = keyEvent -> !t2.isEditable();
        Predicate<KeyEvent> predicate = keyEvent -> !PlatformUtil.isWindows();
        Predicate<KeyEvent> predicate2 = keyEvent -> !PlatformUtil.isLinux();
        TextInputControlBehavior textInputControlBehavior = this;
        InputMap$Mapping[] inputMap$MappingArray = new InputMap$Mapping[40];
        inputMap$MappingArray[0] = this.keyMapping(KeyCode.RIGHT, (KeyEvent keyEvent) -> this.nextCharacterVisually(true));
        inputMap$MappingArray[1] = this.keyMapping(KeyCode.LEFT, (KeyEvent keyEvent) -> this.nextCharacterVisually(false));
        inputMap$MappingArray[2] = this.keyMapping(KeyCode.UP, (KeyEvent keyEvent) -> t2.home());
        inputMap$MappingArray[3] = this.keyMapping(KeyCode.HOME, (KeyEvent keyEvent) -> t2.home());
        inputMap$MappingArray[4] = this.keyMapping(KeyCode.DOWN, (KeyEvent keyEvent) -> t2.end());
        inputMap$MappingArray[5] = this.keyMapping(KeyCode.END, (KeyEvent keyEvent) -> t2.end());
        InputMap$KeyMapping inputMap$KeyMapping = this.keyMapping(KeyCode.ENTER, this::fire);
        inputMap$MappingArray[6] = inputMap$KeyMapping;
        inputMap$MappingArray[7] = this.keyMapping(new KeyBinding(KeyCode.HOME).shortcut(), (KeyEvent keyEvent) -> t2.home());
        inputMap$MappingArray[8] = this.keyMapping(new KeyBinding(KeyCode.END).shortcut(), (KeyEvent keyEvent) -> t2.end());
        inputMap$MappingArray[9] = this.keyMapping(new KeyBinding(KeyCode.BACK_SPACE), keyEvent -> this.deletePreviousChar(), (Predicate<KeyEvent>)((Object)inputMap));
        inputMap$MappingArray[10] = this.keyMapping(new KeyBinding(KeyCode.BACK_SPACE).shift(), keyEvent -> this.deletePreviousChar(), (Predicate<KeyEvent>)((Object)inputMap));
        inputMap$MappingArray[11] = this.keyMapping(new KeyBinding(KeyCode.DELETE), keyEvent -> this.deleteNextChar(), (Predicate<KeyEvent>)((Object)inputMap));
        inputMap$MappingArray[12] = this.keyMapping(new KeyBinding(KeyCode.X).shortcut(), keyEvent -> this.cut(), (Predicate<KeyEvent>)((Object)inputMap));
        inputMap$MappingArray[13] = this.keyMapping(new KeyBinding(KeyCode.CUT), keyEvent -> this.cut(), (Predicate<KeyEvent>)((Object)inputMap));
        inputMap$MappingArray[14] = this.keyMapping(new KeyBinding(KeyCode.C).shortcut(), (KeyEvent keyEvent) -> t2.copy());
        inputMap$MappingArray[15] = this.keyMapping(new KeyBinding(KeyCode.INSERT).shortcut(), (KeyEvent keyEvent) -> t2.copy());
        inputMap$MappingArray[16] = this.keyMapping(KeyCode.COPY, (KeyEvent keyEvent) -> t2.copy());
        inputMap$MappingArray[17] = this.keyMapping(new KeyBinding(KeyCode.V).shortcut(), keyEvent -> this.paste(), (Predicate<KeyEvent>)((Object)inputMap));
        inputMap$MappingArray[18] = this.keyMapping(new KeyBinding(KeyCode.PASTE), keyEvent -> this.paste(), (Predicate<KeyEvent>)((Object)inputMap));
        inputMap$MappingArray[19] = this.keyMapping(new KeyBinding(KeyCode.INSERT).shift(), keyEvent -> this.paste(), (Predicate<KeyEvent>)((Object)inputMap));
        inputMap$MappingArray[20] = this.keyMapping(new KeyBinding(KeyCode.RIGHT).shift(), (KeyEvent keyEvent) -> this.selectRight());
        inputMap$MappingArray[21] = this.keyMapping(new KeyBinding(KeyCode.LEFT).shift(), (KeyEvent keyEvent) -> this.selectLeft());
        inputMap$MappingArray[22] = this.keyMapping(new KeyBinding(KeyCode.UP).shift(), (KeyEvent keyEvent) -> this.selectHome());
        inputMap$MappingArray[23] = this.keyMapping(new KeyBinding(KeyCode.DOWN).shift(), (KeyEvent keyEvent) -> this.selectEnd());
        inputMap$MappingArray[24] = this.keyMapping(new KeyBinding(KeyCode.HOME).shortcut().shift(), (KeyEvent keyEvent) -> this.selectHome());
        inputMap$MappingArray[25] = this.keyMapping(new KeyBinding(KeyCode.END).shortcut().shift(), (KeyEvent keyEvent) -> this.selectEnd());
        inputMap$MappingArray[26] = this.keyMapping(new KeyBinding(KeyCode.A).shortcut(), (KeyEvent keyEvent) -> t2.selectAll());
        inputMap$MappingArray[27] = new InputMap$KeyMapping(new KeyBinding(KeyCode.TAB), FocusTraversalInputMap::traverseNext);
        inputMap$MappingArray[28] = new InputMap$KeyMapping(new KeyBinding(KeyCode.TAB).shift(), FocusTraversalInputMap::traversePrevious);
        inputMap$MappingArray[29] = new InputMap$KeyMapping(new KeyBinding(KeyCode.TAB).ctrl(), FocusTraversalInputMap::traverseNext);
        inputMap$MappingArray[30] = new InputMap$KeyMapping(new KeyBinding(KeyCode.TAB).ctrl().shift(), FocusTraversalInputMap::traversePrevious);
        inputMap = new InputMap$KeyMapping(KeyCode.ESCAPE, this::cancelEdit);
        inputMap$MappingArray[31] = inputMap;
        inputMap$MappingArray[32] = this.keyMapping(new KeyBinding(KeyCode.Z).shortcut(), (KeyEvent keyEvent) -> this.undo());
        inputMap$MappingArray[33] = this.keyMapping(new KeyBinding(null, KeyEvent.KEY_TYPED).alt(KeyBinding$OptionalBoolean.ANY).shift(KeyBinding$OptionalBoolean.ANY).ctrl(KeyBinding$OptionalBoolean.ANY).meta(KeyBinding$OptionalBoolean.ANY), this::defaultKeyTyped);
        InputMap$KeyMapping inputMap$KeyMapping2 = this.keyMapping(new KeyBinding(null, KeyEvent.KEY_PRESSED).shift(KeyBinding$OptionalBoolean.ANY), (KeyEvent keyEvent) -> {
            if (!keyEvent.getCode().isFunctionKey()) {
                keyEvent.consume();
            }
        });
        inputMap$MappingArray[34] = inputMap$KeyMapping2;
        inputMap$MappingArray[35] = new InputMap$KeyMapping(new KeyBinding(KeyCode.DIGIT9).ctrl().shift(), keyEvent -> FXVK.toggleUseVK(this.textInputControl), keyEvent -> !PlatformImpl.isSupported(ConditionalFeature.VIRTUAL_KEYBOARD));
        inputMap$MappingArray[36] = new InputMap$MouseMapping(MouseEvent.MOUSE_PRESSED, this::mousePressed);
        inputMap$MappingArray[37] = new InputMap$MouseMapping(MouseEvent.MOUSE_DRAGGED, this::mouseDragged);
        inputMap$MappingArray[38] = new InputMap$MouseMapping(MouseEvent.MOUSE_RELEASED, this::mouseReleased);
        inputMap$MappingArray[39] = new TextInputControlBehavior$1(this, ContextMenuEvent.CONTEXT_MENU_REQUESTED, this::contextMenuRequested);
        textInputControlBehavior.addDefaultMapping(textInputControlBehavior.inputMap, inputMap$MappingArray);
        ((InputMap$Mapping)((Object)inputMap)).setAutoConsume(false);
        inputMap$KeyMapping.setAutoConsume(false);
        inputMap$KeyMapping2.setAutoConsume(false);
        inputMap = new InputMap<T>(t2);
        inputMap.setInterceptor(event -> !PlatformUtil.isMac());
        inputMap.getMappings().addAll(this.keyMapping(new KeyBinding(KeyCode.HOME).shift(), (KeyEvent keyEvent) -> this.selectHomeExtend()), this.keyMapping(new KeyBinding(KeyCode.END).shift(), (KeyEvent keyEvent) -> this.selectEndExtend()), this.keyMapping(new KeyBinding(KeyCode.LEFT).shortcut(), (KeyEvent keyEvent) -> t2.home()), this.keyMapping(new KeyBinding(KeyCode.RIGHT).shortcut(), (KeyEvent keyEvent) -> t2.end()), this.keyMapping(new KeyBinding(KeyCode.LEFT).alt(), (KeyEvent keyEvent) -> this.leftWord()), this.keyMapping(new KeyBinding(KeyCode.RIGHT).alt(), (KeyEvent keyEvent) -> this.rightWord()), this.keyMapping(new KeyBinding(KeyCode.DELETE).alt(), (KeyEvent keyEvent) -> this.deleteNextWord()), this.keyMapping(new KeyBinding(KeyCode.BACK_SPACE).alt(), (KeyEvent keyEvent) -> this.deletePreviousWord()), this.keyMapping(new KeyBinding(KeyCode.BACK_SPACE).shortcut(), (KeyEvent keyEvent) -> this.deleteFromLineStart()), this.keyMapping(new KeyBinding(KeyCode.Z).shortcut().shift(), (KeyEvent keyEvent) -> this.redo()), this.keyMapping(new KeyBinding(KeyCode.LEFT).shortcut().shift(), (KeyEvent keyEvent) -> this.selectHomeExtend()), this.keyMapping(new KeyBinding(KeyCode.RIGHT).shortcut().shift(), (KeyEvent keyEvent) -> this.selectEndExtend()), this.keyMapping(new KeyBinding(KeyCode.LEFT).shift().alt(), (KeyEvent keyEvent) -> this.selectLeftWord()), this.keyMapping(new KeyBinding(KeyCode.RIGHT).shift().alt(), (KeyEvent keyEvent) -> this.selectRightWord()));
        TextInputControlBehavior textInputControlBehavior2 = this;
        textInputControlBehavior2.addDefaultChildMap(textInputControlBehavior2.inputMap, inputMap);
        inputMap = new InputMap<T>(t2);
        inputMap.setInterceptor(event -> PlatformUtil.isMac());
        inputMap.getMappings().addAll(this.keyMapping(new KeyBinding(KeyCode.HOME).shift(), (KeyEvent keyEvent) -> this.selectHome()), this.keyMapping(new KeyBinding(KeyCode.END).shift(), (KeyEvent keyEvent) -> this.selectEnd()), this.keyMapping(new KeyBinding(KeyCode.LEFT).ctrl(), (KeyEvent keyEvent) -> this.leftWord()), this.keyMapping(new KeyBinding(KeyCode.RIGHT).ctrl(), (KeyEvent keyEvent) -> this.rightWord()), this.keyMapping(new KeyBinding(KeyCode.H).ctrl(), (KeyEvent keyEvent) -> this.deletePreviousChar()), this.keyMapping(new KeyBinding(KeyCode.DELETE).ctrl(), (KeyEvent keyEvent) -> this.deleteNextWord()), this.keyMapping(new KeyBinding(KeyCode.BACK_SPACE).ctrl(), (KeyEvent keyEvent) -> this.deletePreviousWord()), this.keyMapping(new KeyBinding(KeyCode.BACK_SLASH).ctrl(), (KeyEvent keyEvent) -> t2.deselect()), this.keyMapping(new KeyBinding(KeyCode.Y).ctrl(), keyEvent -> this.redo(), predicate), this.keyMapping(new KeyBinding(KeyCode.Z).ctrl().shift(), keyEvent -> this.redo(), predicate2), this.keyMapping(new KeyBinding(KeyCode.LEFT).ctrl().shift(), (KeyEvent keyEvent) -> this.selectLeftWord()), this.keyMapping(new KeyBinding(KeyCode.RIGHT).ctrl().shift(), (KeyEvent keyEvent) -> this.selectRightWord()));
        TextInputControlBehavior textInputControlBehavior3 = this;
        textInputControlBehavior3.addDefaultChildMap(textInputControlBehavior3.inputMap, inputMap);
        TextInputControlBehavior textInputControlBehavior4 = this;
        textInputControlBehavior4.addKeyPadMappings(textInputControlBehavior4.inputMap);
        ((TextInputControl)this.textInputControl).textProperty().addListener(this.textListener);
        this.contextMenu = new ContextMenu();
    }

    @Override
    public InputMap<T> getInputMap() {
        return this.inputMap;
    }

    protected void addKeyPadMappings(InputMap<T> inputMap) {
        InputMap<TextInputControl> inputMap2 = new InputMap<TextInputControl>((TextInputControl)this.getNode());
        for (Object e2 : inputMap.getMappings()) {
            InputMap$KeyMapping inputMap$KeyMapping;
            KeyBinding keyBinding;
            if (!(e2 instanceof InputMap$KeyMapping) || (keyBinding = (KeyBinding)((InputMap$Mapping)(inputMap$KeyMapping = (InputMap$KeyMapping)e2)).getMappingKey()).getCode() == null) continue;
            KeyCode keyCode = null;
            switch (keyBinding.getCode()) {
                case LEFT: {
                    keyCode = KeyCode.KP_LEFT;
                    break;
                }
                case RIGHT: {
                    keyCode = KeyCode.KP_RIGHT;
                    break;
                }
                case UP: {
                    keyCode = KeyCode.KP_UP;
                    break;
                }
                case DOWN: {
                    keyCode = KeyCode.KP_DOWN;
                }
            }
            if (keyCode == null) continue;
            keyBinding = new KeyBinding(keyCode).shift(keyBinding.getShift()).ctrl(keyBinding.getCtrl()).alt(keyBinding.getAlt()).meta(keyBinding.getMeta());
            inputMap2.getMappings().add(new InputMap$KeyMapping(keyBinding, inputMap$KeyMapping.getEventHandler()));
        }
        if (inputMap == ((BehaviorBase)this).getInputMap()) {
            for (InputMap$Mapping inputMap$Mapping : inputMap2.getMappings()) {
                this.addDefaultMapping(inputMap, inputMap$Mapping);
            }
        } else {
            for (Object e3 : inputMap2.getMappings()) {
                inputMap.getMappings().add((InputMap$KeyMapping)e3);
            }
        }
        inputMap2.dispose();
        for (Object e4 : inputMap.getChildInputMaps()) {
            this.addKeyPadMappings((InputMap)e4);
        }
    }

    protected InputMap$KeyMapping keyMapping(KeyCode keyCode, EventHandler<KeyEvent> eventHandler) {
        return this.keyMapping(new KeyBinding(keyCode), eventHandler);
    }

    protected InputMap$KeyMapping keyMapping(KeyBinding keyBinding, EventHandler<KeyEvent> eventHandler) {
        return this.keyMapping(keyBinding, eventHandler, null);
    }

    protected InputMap$KeyMapping keyMapping(KeyBinding keyBinding, EventHandler<KeyEvent> eventHandler, Predicate<KeyEvent> predicate) {
        return new InputMap$KeyMapping(keyBinding, keyEvent -> {
            this.setCaretAnimating(false);
            eventHandler.handle((KeyEvent)keyEvent);
            this.setCaretAnimating(true);
        }, predicate);
    }

    @Override
    public void dispose() {
        ((TextInputControl)this.textInputControl).textProperty().removeListener(this.textListener);
        super.dispose();
    }

    protected abstract void deleteChar(boolean var1);

    protected abstract void replaceText(int var1, int var2, String var3);

    protected abstract void setCaretAnimating(boolean var1);

    protected abstract void deleteFromLineStart();

    protected abstract void mousePressed(MouseEvent var1);

    protected abstract void mouseDragged(MouseEvent var1);

    protected abstract void mouseReleased(MouseEvent var1);

    protected abstract void contextMenuRequested(ContextMenuEvent var1);

    private void defaultKeyTyped(KeyEvent object) {
        TextInputControl textInputControl = (TextInputControl)this.getNode();
        if (!textInputControl.isEditable() || textInputControl.isDisabled()) {
            return;
        }
        String string = ((KeyEvent)object).getCharacter();
        if (string.length() == 0) {
            return;
        }
        if ((((KeyEvent)object).isControlDown() || ((KeyEvent)object).isAltDown() || PlatformUtil.isMac() && ((KeyEvent)object).isMetaDown()) && (!((KeyEvent)object).isControlDown() && !PlatformUtil.isMac() || !((KeyEvent)object).isAltDown())) {
            return;
        }
        this.setEditing(true);
        if (string.charAt(0) > '\u001f' && string.charAt(0) != '\u007f' && !((KeyEvent)object).isMetaDown()) {
            object = textInputControl.getSelection();
            int n2 = ((IndexRange)object).getStart();
            int n3 = ((IndexRange)object).getEnd();
            this.replaceText(n2, n3, string);
        }
        this.setEditing(false);
    }

    Bidi getRawBidi() {
        return this.bidi;
    }

    private void invalidateBidi() {
        this.bidi = null;
        this.mixed = null;
        this.rtlText = null;
    }

    private Bidi getBidi() {
        if (this.bidi == null) {
            this.bidi = new Bidi(((TextInputControl)this.textInputControl).textProperty().getValueSafe(), ((Node)this.textInputControl).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? 1 : 0);
        }
        return this.bidi;
    }

    protected boolean isMixed() {
        if (this.mixed == null) {
            this.mixed = this.getBidi().isMixed();
        }
        return this.mixed;
    }

    protected boolean isRTLText() {
        if (this.rtlText == null) {
            Bidi bidi = this.getBidi();
            this.rtlText = bidi.isRightToLeft() || this.isMixed() && ((Node)this.textInputControl).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
        }
        return this.rtlText;
    }

    private void nextCharacterVisually(boolean bl2) {
        if (this.isMixed()) {
            TextInputControlSkin textInputControlSkin = (TextInputControlSkin)((Control)this.textInputControl).getSkin();
            textInputControlSkin.moveCaret(TextInputControlSkin$TextUnit.CHARACTER, bl2 ? TextInputControlSkin$Direction.RIGHT : TextInputControlSkin$Direction.LEFT, false);
            return;
        }
        if (bl2 != this.isRTLText()) {
            ((TextInputControl)this.textInputControl).forward();
            return;
        }
        ((TextInputControl)this.textInputControl).backward();
    }

    private void selectLeft() {
        if (this.isRTLText()) {
            ((TextInputControl)this.textInputControl).selectForward();
            return;
        }
        ((TextInputControl)this.textInputControl).selectBackward();
    }

    private void selectRight() {
        if (this.isRTLText()) {
            ((TextInputControl)this.textInputControl).selectBackward();
            return;
        }
        ((TextInputControl)this.textInputControl).selectForward();
    }

    private void deletePreviousChar() {
        this.setEditing(true);
        this.deleteChar(true);
        this.setEditing(false);
    }

    private void deleteNextChar() {
        this.setEditing(true);
        this.deleteChar(false);
        this.setEditing(false);
    }

    protected void deletePreviousWord() {
        this.setEditing(true);
        TextInputControl textInputControl = (TextInputControl)this.getNode();
        int n2 = textInputControl.getCaretPosition();
        if (n2 > 0) {
            textInputControl.previousWord();
            int n3 = textInputControl.getCaretPosition();
            this.replaceText(n3, n2, "");
        }
        this.setEditing(false);
    }

    protected void deleteNextWord() {
        this.setEditing(true);
        TextInputControl textInputControl = (TextInputControl)this.getNode();
        int n2 = textInputControl.getCaretPosition();
        if (n2 < textInputControl.getLength()) {
            this.nextWord();
            int n3 = textInputControl.getCaretPosition();
            this.replaceText(n2, n3, "");
        }
        this.setEditing(false);
    }

    public void deleteSelection() {
        this.setEditing(true);
        Object object = (TextInputControl)this.getNode();
        object = ((TextInputControl)object).getSelection();
        if (((IndexRange)object).getLength() > 0) {
            this.deleteChar(false);
        }
        this.setEditing(false);
    }

    public void cut() {
        this.setEditing(true);
        ((TextInputControl)this.getNode()).cut();
        this.setEditing(false);
    }

    public void paste() {
        this.setEditing(true);
        ((TextInputControl)this.getNode()).paste();
        this.setEditing(false);
    }

    public void undo() {
        this.setEditing(true);
        ((TextInputControl)this.getNode()).undo();
        this.setEditing(false);
    }

    public void redo() {
        this.setEditing(true);
        ((TextInputControl)this.getNode()).redo();
        this.setEditing(false);
    }

    protected void selectPreviousWord() {
        ((TextInputControl)this.getNode()).selectPreviousWord();
    }

    public void selectNextWord() {
        TextInputControl textInputControl = (TextInputControl)this.getNode();
        if (PlatformUtil.isMac() || PlatformUtil.isLinux()) {
            textInputControl.selectEndOfNextWord();
            return;
        }
        textInputControl.selectNextWord();
    }

    private void selectLeftWord() {
        if (this.isRTLText()) {
            this.selectNextWord();
            return;
        }
        this.selectPreviousWord();
    }

    private void selectRightWord() {
        if (this.isRTLText()) {
            this.selectPreviousWord();
            return;
        }
        this.selectNextWord();
    }

    protected void selectWord() {
        TextInputControl textInputControl = (TextInputControl)this.getNode();
        textInputControl.previousWord();
        if (PlatformUtil.isWindows()) {
            textInputControl.selectNextWord();
        } else {
            textInputControl.selectEndOfNextWord();
        }
        if (SHOW_HANDLES && this.contextMenu.isShowing()) {
            this.populateContextMenu();
        }
    }

    protected void selectAll() {
        ((TextInputControl)this.getNode()).selectAll();
        if (SHOW_HANDLES && this.contextMenu.isShowing()) {
            this.populateContextMenu();
        }
    }

    protected void previousWord() {
        ((TextInputControl)this.getNode()).previousWord();
    }

    protected void nextWord() {
        TextInputControl textInputControl = (TextInputControl)this.getNode();
        if (PlatformUtil.isMac() || PlatformUtil.isLinux()) {
            textInputControl.endOfNextWord();
            return;
        }
        textInputControl.nextWord();
    }

    private void leftWord() {
        if (this.isRTLText()) {
            this.nextWord();
            return;
        }
        this.previousWord();
    }

    private void rightWord() {
        if (this.isRTLText()) {
            this.previousWord();
            return;
        }
        this.nextWord();
    }

    protected void fire(KeyEvent keyEvent) {
    }

    protected void cancelEdit(KeyEvent keyEvent) {
    }

    protected void selectHome() {
        ((TextInputControl)this.getNode()).selectHome();
    }

    protected void selectEnd() {
        ((TextInputControl)this.getNode()).selectEnd();
    }

    protected void selectHomeExtend() {
        ((TextInputControl)this.getNode()).extendSelection(0);
    }

    protected void selectEndExtend() {
        TextInputControl textInputControl = (TextInputControl)this.getNode();
        textInputControl.extendSelection(textInputControl.getLength());
    }

    protected void setEditing(boolean bl2) {
        this.editing = bl2;
    }

    public boolean isEditing() {
        return this.editing;
    }

    protected void populateContextMenu() {
        TextInputControl textInputControl = (TextInputControl)this.getNode();
        boolean bl2 = textInputControl.isEditable();
        boolean bl3 = textInputControl.getLength() > 0;
        boolean bl4 = textInputControl.getSelection().getLength() > 0;
        boolean bl5 = textInputControl.getSelection().getLength() == textInputControl.getLength();
        boolean bl6 = textInputControl instanceof PasswordField;
        ObservableList<MenuItem> observableList = this.contextMenu.getItems();
        if (SHOW_HANDLES) {
            observableList.clear();
            if (!bl6 && bl4) {
                if (bl2) {
                    observableList.add(this.cutMI);
                }
                observableList.add(this.copyMI);
            }
            if (bl2 && Clipboard.getSystemClipboard().hasString()) {
                observableList.add(this.pasteMI);
            }
            if (bl3 && !bl5) {
                if (!bl4 && !(textInputControl instanceof PasswordField)) {
                    observableList.add(this.selectWordMI);
                }
                observableList.add(this.selectAllMI);
            }
            this.selectWordMI.getProperties().put("refreshMenu", Boolean.TRUE);
            this.selectAllMI.getProperties().put("refreshMenu", Boolean.TRUE);
            return;
        }
        if (bl2) {
            observableList.setAll((MenuItem[])new MenuItem[]{this.undoMI, this.redoMI, this.cutMI, this.copyMI, this.pasteMI, this.deleteMI, this.separatorMI, this.selectAllMI});
        } else {
            observableList.setAll((MenuItem[])new MenuItem[]{this.copyMI, this.separatorMI, this.selectAllMI});
        }
        this.undoMI.setDisable(!((TextInputControl)this.getNode()).isUndoable());
        this.redoMI.setDisable(!((TextInputControl)this.getNode()).isRedoable());
        this.cutMI.setDisable(bl6 || !bl4);
        this.copyMI.setDisable(bl6 || !bl4);
        this.pasteMI.setDisable(!Clipboard.getSystemClipboard().hasString());
        this.deleteMI.setDisable(!bl4);
    }
}

