/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.WebColorField;
import com.sun.javafx.scene.control.skin.InputFieldSkin;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.regex.Pattern;
import javafx.beans.InvalidationListener;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.paint.Color;

public class WebColorFieldSkin
extends InputFieldSkin {
    private static final String HEX_DIGIT = "[A-Fa-f0-9]";
    private static final Pattern PATTERN = Pattern.compile("#?[A-Fa-f0-9]{6}");
    private static final Pattern PARTIAL_PATTERN = Pattern.compile("#?[A-Fa-f0-9]{0,6}");
    private InvalidationListener integerFieldValueListener = observable -> this.updateText();

    public WebColorFieldSkin(WebColorField webColorField) {
        super(webColorField);
        webColorField.valueProperty().addListener(this.integerFieldValueListener);
        this.getTextField().setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
    }

    @Override
    public WebColorField getSkinnable() {
        return (WebColorField)this.control;
    }

    @Override
    public Node getNode() {
        return this.getTextField();
    }

    @Override
    public void dispose() {
        ((WebColorField)this.control).valueProperty().removeListener(this.integerFieldValueListener);
        super.dispose();
    }

    @Override
    protected boolean accept(String string) {
        return PARTIAL_PATTERN.matcher(string).matches();
    }

    @Override
    protected void updateText() {
        Color color = ((WebColorField)this.control).getValue();
        if (color == null) {
            color = Color.BLACK;
        }
        this.getTextField().setText(Utils.formatHexString(color));
    }

    @Override
    protected void updateValue() {
        String string;
        Object object = ((WebColorField)this.control).getValue();
        String string2 = string = this.getTextField().getText() == null ? "" : this.getTextField().getText().trim();
        if (PATTERN.matcher(string).matches()) {
            Color color = string.charAt(0) == '#' ? Color.web(string) : Color.web("#" + string);
            if (!color.equals(object)) {
                ((WebColorField)this.control).setValue(color);
                return;
            }
            object = Utils.formatHexString(color);
            if (!((String)object).equals(string)) {
                this.getTextField().setText((String)object);
            }
        }
    }
}

