/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.input;

import com.sun.javafx.scene.CameraHelper;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.SceneUtils;
import com.sun.javafx.scene.SubSceneHelper;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.SubScene;
import javafx.scene.input.PickResult;
import javafx.scene.input.TransferMode;

public class InputEventUtils {
    private static final List<TransferMode> TM_ANY = List.of(TransferMode.COPY, TransferMode.MOVE, TransferMode.LINK);
    private static final List<TransferMode> TM_COPY_OR_MOVE = List.of(TransferMode.COPY, TransferMode.MOVE);

    public static Point3D recomputeCoordinates(PickResult object, Object object2) {
        boolean bl2;
        Point3D point3D = ((PickResult)object).getIntersectedPoint();
        if (point3D == null) {
            return new Point3D(Double.NaN, Double.NaN, Double.NaN);
        }
        object = ((PickResult)object).getIntersectedNode();
        object2 = object2 instanceof Node ? (Node)object2 : null;
        SubScene subScene = object == null ? null : NodeHelper.getSubScene((Node)object);
        SubScene subScene2 = object2 == null ? null : NodeHelper.getSubScene((Node)object2);
        boolean bl3 = bl2 = subScene != subScene2;
        if (object != null) {
            point3D = ((Node)object).localToScene(point3D);
            if (bl2 && subScene != null) {
                point3D = SceneUtils.subSceneToScene(subScene, point3D);
            }
        }
        if (object2 != null) {
            if (bl2 && subScene2 != null) {
                object = CameraHelper.project(SceneHelper.getEffectiveCamera(((Node)object2).getScene()), point3D);
                point3D = (object = SceneUtils.sceneToSubScenePlane(subScene2, (Point2D)object)) == null ? null : CameraHelper.pickProjectPlane(SubSceneHelper.getEffectiveCamera(subScene2), ((Point2D)object).getX(), ((Point2D)object).getY());
            }
            if (point3D != null) {
                point3D = ((Node)object2).sceneToLocal(point3D);
            }
            if (point3D == null) {
                point3D = new Point3D(Double.NaN, Double.NaN, Double.NaN);
            }
        }
        return point3D;
    }

    public static List<TransferMode> safeTransferModes(TransferMode[] transferModeArray) {
        if (transferModeArray == TransferMode.ANY) {
            return TM_ANY;
        }
        if (transferModeArray == TransferMode.COPY_OR_MOVE) {
            return TM_COPY_OR_MOVE;
        }
        return Arrays.asList(transferModeArray);
    }
}

