/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.ParsedValueImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.ParsedValue;
import javafx.css.Size;
import javafx.css.StyleConverter;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;

public class BorderStyleConverter
extends StyleConverter<ParsedValue[], BorderStrokeStyle> {
    public static final ParsedValueImpl<ParsedValue[], Number[]> NONE = new ParsedValueImpl(null, null);
    public static final ParsedValueImpl<ParsedValue[], Number[]> HIDDEN = new ParsedValueImpl(null, null);
    public static final ParsedValueImpl<ParsedValue[], Number[]> DOTTED = new ParsedValueImpl(null, null);
    public static final ParsedValueImpl<ParsedValue[], Number[]> DASHED = new ParsedValueImpl(null, null);
    public static final ParsedValueImpl<ParsedValue[], Number[]> SOLID = new ParsedValueImpl(null, null);
    private static final BorderStyleConverter BORDER_STYLE_CONVERTER = new BorderStyleConverter();

    public static BorderStyleConverter getInstance() {
        return BORDER_STYLE_CONVERTER;
    }

    private BorderStyleConverter() {
    }

    @Override
    public BorderStrokeStyle convert(ParsedValue<ParsedValue[], BorderStrokeStyle> object, Font font) {
        double d2;
        List<Double> list;
        boolean bl2;
        object = object.getValue();
        ParsedValue parsedValue = object[0];
        boolean bl3 = bl2 = object[1] == null && object[2] == null && object[3] == null && object[4] == null && object[5] == null;
        if (NONE == parsedValue) {
            return BorderStrokeStyle.NONE;
        }
        if (DOTTED == parsedValue && bl2) {
            return BorderStrokeStyle.DOTTED;
        }
        if (DASHED == parsedValue && bl2) {
            return BorderStrokeStyle.DASHED;
        }
        if (SOLID == parsedValue && bl2) {
            return BorderStrokeStyle.SOLID;
        }
        Object object2 = (ParsedValue[])object[0].getValue();
        if (object2 == null) {
            list = DOTTED == parsedValue ? BorderStrokeStyle.DOTTED.getDashArray() : (DASHED == parsedValue ? BorderStrokeStyle.DASHED.getDashArray() : (SOLID == parsedValue ? BorderStrokeStyle.SOLID.getDashArray() : Collections.emptyList()));
        } else {
            list = new ArrayList<Double>(((ParsedValue[])object2).length);
            for (int i2 = 0; i2 < ((ParsedValue[])object2).length; ++i2) {
                Size size = (Size)object2[i2].convert(font);
                list.add(size.pixels(font));
            }
        }
        double d3 = object[1] != null ? (Double)object[1].convert(font) : 0.0;
        object2 = object[2] != null ? (StrokeType)((Object)object[2].convert(font)) : StrokeType.INSIDE;
        StrokeLineJoin strokeLineJoin = object[3] != null ? (StrokeLineJoin)((Object)object[3].convert(font)) : StrokeLineJoin.MITER;
        double d4 = d2 = object[4] != null ? (Double)object[4].convert(font) : 10.0;
        object = object[5] != null ? (StrokeLineCap)((Object)object[5].convert(font)) : (DOTTED == parsedValue ? StrokeLineCap.ROUND : StrokeLineCap.BUTT);
        object = new BorderStrokeStyle((StrokeType)((Object)object2), strokeLineJoin, (StrokeLineCap)((Object)object), d2, d3, list);
        if (BorderStrokeStyle.SOLID.equals(object)) {
            return BorderStrokeStyle.SOLID;
        }
        return object;
    }

    public String toString() {
        return "BorderStyleConverter";
    }
}

