/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalEngine;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;

final class TabOrderHelper {
    TabOrderHelper() {
    }

    private static Node findPreviousFocusableInList(List<Node> list, int n2) {
        while (n2 >= 0) {
            Node node = list.get(n2);
            if (!TabOrderHelper.isDisabledOrInvisible(node)) {
                ParentTraversalEngine parentTraversalEngine;
                ParentTraversalEngine parentTraversalEngine2 = parentTraversalEngine = node instanceof Parent ? ParentHelper.getTraversalEngine((Parent)node) : null;
                if (node instanceof Parent) {
                    if (parentTraversalEngine != null && parentTraversalEngine.canTraverse()) {
                        var4_4 = parentTraversalEngine.selectLast();
                        if (var4_4 != null) {
                            return var4_4;
                        }
                    } else {
                        var4_4 = ((Parent)node).getChildrenUnmodifiable();
                        if (var4_4.size() > 0) {
                            ObservableList<Node> observableList = var4_4;
                            var4_4 = TabOrderHelper.findPreviousFocusableInList((List<Node>)observableList, observableList.size() - 1);
                            if (var4_4 != null) {
                                return var4_4;
                            }
                        }
                    }
                }
                if (parentTraversalEngine != null ? parentTraversalEngine.isParentTraversable() : node.isFocusTraversable()) {
                    return node;
                }
            }
            --n2;
        }
        return null;
    }

    private static boolean isDisabledOrInvisible(Node node) {
        return node.isDisabled() || !NodeHelper.isTreeVisible(node);
    }

    public static Node findPreviousFocusablePeer(Node object, Parent parent) {
        List<Node> list = object;
        Object object2 = TabOrderHelper.findPeers((Node)((Object)list));
        if (object2 == null) {
            object = ((Parent)object).getChildrenUnmodifiable();
            return TabOrderHelper.findPreviousFocusableInList(object, object.size() - 1);
        }
        int n2 = object2.indexOf(list);
        Object object3 = TabOrderHelper.findPreviousFocusableInList(object2, n2 - 1);
        while (object3 == null && ((Node)((Object)list)).getParent() != parent) {
            object2 = ((Node)((Object)list)).getParent();
            if (object2 != null) {
                list = ParentHelper.getTraversalEngine((Parent)object2);
                if (list != null ? ((ParentTraversalEngine)((Object)list)).isParentTraversable() : ((Node)object2).isFocusTraversable()) {
                    object3 = object2;
                } else {
                    list = TabOrderHelper.findPeers((Node)object2);
                    if (list != null) {
                        int n3 = list.indexOf(object2);
                        object3 = TabOrderHelper.findPreviousFocusableInList(list, n3 - 1);
                    }
                }
            }
            list = object2;
        }
        return object3;
    }

    private static List<Node> findPeers(Node node) {
        ObservableList<Node> observableList = null;
        if ((node = node.getParent()) != null) {
            observableList = ((Parent)node).getChildrenUnmodifiable();
        }
        return observableList;
    }

    private static Node findNextFocusableInList(List<Node> list, int n2) {
        while (n2 < list.size()) {
            Object object = list.get(n2);
            if (!TabOrderHelper.isDisabledOrInvisible((Node)object)) {
                ParentTraversalEngine parentTraversalEngine;
                ParentTraversalEngine parentTraversalEngine2 = parentTraversalEngine = object instanceof Parent ? ParentHelper.getTraversalEngine((Parent)object) : null;
                if (parentTraversalEngine2 != null ? parentTraversalEngine.isParentTraversable() : ((Node)object).isFocusTraversable()) {
                    return object;
                }
                if (object instanceof Parent && (parentTraversalEngine != null && parentTraversalEngine.canTraverse() ? (object = parentTraversalEngine.selectFirst()) != null : (object = ((Parent)object).getChildrenUnmodifiable()).size() > 0 && (object = TabOrderHelper.findNextFocusableInList((List<Node>)object, 0)) != null)) {
                    return object;
                }
            }
            ++n2;
        }
        return null;
    }

    public static Node findNextFocusablePeer(Node list, Parent parent, boolean bl2) {
        Object object = list;
        Node node = null;
        if (bl2 && list instanceof Parent) {
            node = TabOrderHelper.findNextFocusableInList(((Parent)((Object)list)).getChildrenUnmodifiable(), 0);
        }
        if (node == null) {
            list = TabOrderHelper.findPeers(object);
            if (list == null) {
                return null;
            }
            int n2 = list.indexOf(object);
            node = TabOrderHelper.findNextFocusableInList(list, n2 + 1);
        }
        while (node == null && ((Node)object).getParent() != parent) {
            if ((object = ((Node)object).getParent()) == null || (list = TabOrderHelper.findPeers((Node)object)) == null) continue;
            int n3 = list.indexOf(object);
            node = TabOrderHelper.findNextFocusableInList(list, n3 + 1);
        }
        return node;
    }

    public static Node getFirstTargetNode(Parent object) {
        if (object == null || TabOrderHelper.isDisabledOrInvisible((Node)object)) {
            return null;
        }
        Object object2 = ParentHelper.getTraversalEngine((Parent)object);
        if (object2 != null && ((TraversalEngine)object2).canTraverse() && (object2 = ((TraversalEngine)object2).selectFirst()) != null) {
            return object2;
        }
        object2 = ((Parent)object).getChildrenUnmodifiable();
        object = object2.iterator();
        while (object.hasNext()) {
            ParentTraversalEngine parentTraversalEngine;
            object2 = (Node)object.next();
            if (TabOrderHelper.isDisabledOrInvisible((Node)object2)) continue;
            ParentTraversalEngine parentTraversalEngine2 = parentTraversalEngine = object2 instanceof Parent ? ParentHelper.getTraversalEngine((Parent)object2) : null;
            if (parentTraversalEngine2 != null ? parentTraversalEngine.isParentTraversable() : ((Node)object2).isFocusTraversable()) {
                return object2;
            }
            if (!(object2 instanceof Parent) || (object2 = TabOrderHelper.getFirstTargetNode((Parent)object2)) == null) continue;
            return object2;
        }
        return null;
    }

    public static Node getLastTargetNode(Parent parent) {
        if (parent == null || TabOrderHelper.isDisabledOrInvisible(parent)) {
            return null;
        }
        Object object = ParentHelper.getTraversalEngine(parent);
        if (object != null && ((TraversalEngine)object).canTraverse() && (object = ((TraversalEngine)object).selectLast()) != null) {
            return object;
        }
        object = parent.getChildrenUnmodifiable();
        for (int i2 = object.size() - 1; i2 >= 0; --i2) {
            Object object2;
            Node node = (Node)object.get(i2);
            if (TabOrderHelper.isDisabledOrInvisible(node)) continue;
            if (node instanceof Parent && (object2 = TabOrderHelper.getLastTargetNode((Parent)node)) != null) {
                return object2;
            }
            Object object3 = object2 = node instanceof Parent ? ParentHelper.getTraversalEngine((Parent)node) : null;
            if (!(object3 != null ? ((ParentTraversalEngine)object2).isParentTraversable() : node.isFocusTraversable())) continue;
            return node;
        }
        return null;
    }
}

