/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.ContainerTabOrder;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.Hueristic2D;
import com.sun.javafx.scene.traversal.TraversalContext;
import com.sun.javafx.scene.traversal.TraversalEngine$EngineContext;
import com.sun.javafx.scene.traversal.TraversalEngine$TempEngineContext;
import com.sun.javafx.scene.traversal.TraverseListener;
import java.util.ArrayList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;

public abstract class TraversalEngine {
    static final Algorithm DEFAULT_ALGORITHM = PlatformImpl.isContextual2DNavigation() ? new Hueristic2D() : new ContainerTabOrder();
    private final TraversalContext context = new TraversalEngine$EngineContext(this);
    private final TraversalEngine$TempEngineContext tempEngineContext = new TraversalEngine$TempEngineContext(this);
    protected final Algorithm algorithm;
    private final Bounds initialBounds = new BoundingBox(0.0, 0.0, 1.0, 1.0);
    private final ArrayList<TraverseListener> listeners = new ArrayList();

    protected TraversalEngine(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    protected TraversalEngine() {
        this.algorithm = null;
    }

    public final void addTraverseListener(TraverseListener traverseListener) {
        this.listeners.add(traverseListener);
    }

    final void notifyTraversedTo(Node node) {
        for (TraverseListener traverseListener : this.listeners) {
            traverseListener.onTraverse(node, this.getLayoutBounds(node, this.getRoot()));
        }
    }

    public final Node select(Node node, Direction direction) {
        return this.algorithm.select(node, direction, this.context);
    }

    public final Node selectFirst() {
        return this.algorithm.selectFirst(this.context);
    }

    public final Node selectLast() {
        return this.algorithm.selectLast(this.context);
    }

    protected abstract Parent getRoot();

    public final boolean canTraverse() {
        return this.algorithm != null;
    }

    private Bounds getLayoutBounds(Node object, Parent parent) {
        if (object != null) {
            if (parent == null) {
                Node node = object;
                object = node.localToScene(node.getLayoutBounds());
            } else {
                Object object2 = object;
                object = parent.sceneToLocal(((Node)object2).localToScene(((Node)object2).getLayoutBounds()));
            }
        } else {
            object = this.initialBounds;
        }
        return object;
    }
}

