/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGAmbientLight;
import com.sun.javafx.sg.prism.NGDirectionalLight;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGPhongMaterial;
import com.sun.javafx.sg.prism.NGPointLight;
import com.sun.javafx.sg.prism.NGSpotLight;
import com.sun.javafx.sg.prism.NGTriangleMesh;
import com.sun.javafx.util.Utils;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Material;
import com.sun.prism.MeshView;
import com.sun.prism.PrinterGraphics;
import com.sun.prism.ResourceFactory;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.geometry.Point3D;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;

public abstract class NGShape3D
extends NGNode {
    private NGPhongMaterial material;
    private DrawMode drawMode;
    private CullFace cullFace;
    private boolean materialDirty = false;
    private boolean drawModeDirty = false;
    NGTriangleMesh mesh;
    private MeshView meshView;

    public void setMaterial(NGPhongMaterial nGPhongMaterial) {
        this.material = nGPhongMaterial;
        this.materialDirty = true;
        this.visualsChanged();
    }

    public void setDrawMode(Object object) {
        this.drawMode = (DrawMode)((Object)object);
        this.drawModeDirty = true;
        this.visualsChanged();
    }

    public void setCullFace(Object object) {
        this.cullFace = (CullFace)((Object)object);
        this.visualsChanged();
    }

    void invalidate() {
        this.meshView = null;
        this.visualsChanged();
    }

    private void renderMeshView(Graphics graphics) {
        graphics.setup3DRendering();
        GraphicsResource graphicsResource = graphics.getResourceFactory();
        if (graphicsResource == null || graphicsResource.isDisposed()) {
            return;
        }
        if (this.meshView != null && !this.meshView.isValid()) {
            this.meshView.dispose();
            this.meshView = null;
        }
        if (this.meshView == null && this.mesh != null) {
            this.meshView = graphicsResource.createMeshView(this.mesh.createMesh((ResourceFactory)graphicsResource));
            NGShape3D nGShape3D = this;
            nGShape3D.drawModeDirty = true;
            nGShape3D.materialDirty = true;
        }
        if (this.meshView == null || !this.mesh.validate()) {
            return;
        }
        graphicsResource = this.material.createMaterial((ResourceFactory)graphicsResource);
        if (this.materialDirty) {
            this.meshView.setMaterial((Material)graphicsResource);
            this.materialDirty = false;
        }
        int n2 = this.cullFace.ordinal();
        if (this.cullFace.ordinal() != MeshView.CULL_NONE && graphics.getTransformNoClone().getDeterminant() < 0.0) {
            n2 = n2 == MeshView.CULL_BACK ? MeshView.CULL_FRONT : MeshView.CULL_BACK;
        }
        this.meshView.setCullingMode(n2);
        if (this.drawModeDirty) {
            this.meshView.setWireframe(this.drawMode == DrawMode.LINE);
            this.drawModeDirty = false;
        }
        this.setupLights(graphics);
        this.meshView.render(graphics);
    }

    private void setupLights(Graphics graphics) {
        int n2 = 0;
        NGLightBase[] nGLightBaseArray = graphics.getLights();
        if (this.noLights(nGLightBaseArray)) {
            this.setDefaultLight(graphics);
            ++n2;
        } else {
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            for (NGLightBase nGLightBase : nGLightBaseArray) {
                if (nGLightBase == null) break;
                if (!nGLightBase.affects(this)) continue;
                float f5 = nGLightBase.getColor().getRed();
                float f6 = nGLightBase.getColor().getGreen();
                float f7 = nGLightBase.getColor().getBlue();
                if (f5 == 0.0f && f6 == 0.0f && f7 == 0.0f) continue;
                if (nGLightBase instanceof NGAmbientLight) {
                    f2 += f5;
                    f4 += f6;
                    f3 += f7;
                    continue;
                }
                if (nGLightBase instanceof NGSpotLight) {
                    nGLightBase = (NGSpotLight)nGLightBase;
                    this.addSpotLight((NGSpotLight)nGLightBase, n2++, f5, f6, f7);
                    continue;
                }
                if (nGLightBase instanceof NGPointLight) {
                    nGLightBase = (NGPointLight)nGLightBase;
                    this.addPointLight((NGPointLight)nGLightBase, n2++, f5, f6, f7);
                    continue;
                }
                if (!(nGLightBase instanceof NGDirectionalLight)) continue;
                nGLightBase = (NGDirectionalLight)nGLightBase;
                this.addDirectionalLight((NGDirectionalLight)nGLightBase, n2++, f5, f6, f7);
            }
            f2 = Utils.clamp(0.0f, f2, 1.0f);
            f4 = Utils.clamp(0.0f, f4, 1.0f);
            f3 = Utils.clamp(0.0f, f3, 1.0f);
            this.meshView.setAmbientLight(f2, f4, f3);
        }
        while (n2 < 3) {
            this.resetLight(n2++);
        }
    }

    private boolean noLights(NGLightBase[] nGLightBaseArray) {
        return nGLightBaseArray == null || nGLightBaseArray[0] == null;
    }

    private void setDefaultLight(Graphics object) {
        this.meshView.setAmbientLight(0.0f, 0.0f, 0.0f);
        object = object.getCameraNoClone().getPositionInWorld(null);
        Point3D point3D = NGPointLight.getSimulatedDirection();
        this.meshView.setLight(0, (float)((Vec3d)object).x, (float)((Vec3d)object).y, (float)((Vec3d)object).z, 1.0f, 1.0f, 1.0f, 1.0f, NGPointLight.getDefaultCa(), NGPointLight.getDefaultLa(), NGPointLight.getDefaultQa(), 1.0f, NGPointLight.getDefaultMaxRange(), (float)point3D.getX(), (float)point3D.getY(), (float)point3D.getZ(), NGPointLight.getSimulatedInnerAngle(), NGPointLight.getSimulatedOuterAngle(), NGPointLight.getSimulatedFalloff());
    }

    private void addPointLight(NGPointLight nGPointLight, int n2, float f2, float f3, float f4) {
        Affine3D affine3D = nGPointLight.getWorldTransform();
        Point3D point3D = NGPointLight.getSimulatedDirection();
        this.meshView.setLight(n2, (float)((BaseTransform)affine3D).getMxt(), (float)((BaseTransform)affine3D).getMyt(), (float)((BaseTransform)affine3D).getMzt(), f2, f3, f4, 1.0f, nGPointLight.getCa(), nGPointLight.getLa(), nGPointLight.getQa(), 1.0f, nGPointLight.getMaxRange(), (float)point3D.getX(), (float)point3D.getY(), (float)point3D.getZ(), NGPointLight.getSimulatedInnerAngle(), NGPointLight.getSimulatedOuterAngle(), NGPointLight.getSimulatedFalloff());
    }

    private void addSpotLight(NGSpotLight nGSpotLight, int n2, float f2, float f3, float f4) {
        Affine3D affine3D = nGSpotLight.getWorldTransform();
        Point3D point3D = nGSpotLight.getDirection().normalize();
        this.meshView.setLight(n2, (float)((BaseTransform)affine3D).getMxt(), (float)((BaseTransform)affine3D).getMyt(), (float)((BaseTransform)affine3D).getMzt(), f2, f3, f4, 1.0f, nGSpotLight.getCa(), nGSpotLight.getLa(), nGSpotLight.getQa(), 1.0f, nGSpotLight.getMaxRange(), (float)point3D.getX(), (float)point3D.getY(), (float)point3D.getZ(), nGSpotLight.getInnerAngle(), nGSpotLight.getOuterAngle(), nGSpotLight.getFalloff());
    }

    private void addDirectionalLight(NGDirectionalLight object, int n2, float f2, float f3, float f4) {
        object = ((NGDirectionalLight)object).getDirection().normalize();
        this.meshView.setLight(n2, 0.0f, 0.0f, 0.0f, f2, f3, f4, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, Float.POSITIVE_INFINITY, (float)((Point3D)object).getX(), (float)((Point3D)object).getY(), (float)((Point3D)object).getZ(), 0.0f, 0.0f, 0.0f);
    }

    private void resetLight(int n2) {
        this.meshView.setLight(n2, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);
    }

    public void setMesh(NGTriangleMesh nGTriangleMesh) {
        this.mesh = nGTriangleMesh;
        this.meshView = null;
        this.visualsChanged();
    }

    @Override
    protected void renderContent(Graphics graphics) {
        if (!Platform.isSupported(ConditionalFeature.SCENE3D) || this.material == null || graphics instanceof PrinterGraphics) {
            return;
        }
        this.renderMeshView(graphics);
    }

    @Override
    boolean isShape3D() {
        return true;
    }

    @Override
    protected boolean hasOverlappingContents() {
        return false;
    }

    @Override
    public void release() {
    }
}

