/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NodeEffectInput$RenderType;
import com.sun.prism.Graphics;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.Effect$AccelType;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrRenderInfo;

public final class NodeEffectInput
extends Effect {
    private NGNode node;
    private NodeEffectInput$RenderType renderType;
    private BaseBounds tempBounds = new RectBounds();
    private ImageData cachedIdentityImageData;
    private ImageData cachedTransformedImageData;
    private BaseTransform cachedTransform;

    public NodeEffectInput(NGNode nGNode) {
        this(nGNode, NodeEffectInput$RenderType.EFFECT_CONTENT);
    }

    public NodeEffectInput(NGNode nGNode, NodeEffectInput$RenderType nodeEffectInput$RenderType) {
        this.node = nGNode;
        this.renderType = nodeEffectInput$RenderType;
    }

    public final NGNode getNode() {
        return this.node;
    }

    public final void setNode(NGNode nGNode) {
        if (this.node != nGNode) {
            this.node = nGNode;
            this.flush();
        }
    }

    static boolean contains(ImageData object, Rectangle rectangle) {
        object = ((ImageData)object).getUntransformedBounds();
        return ((Rectangle)object).contains(rectangle);
    }

    @Override
    public final BaseBounds getBounds(BaseTransform baseTransform, Effect effect) {
        baseTransform = baseTransform == null ? BaseTransform.IDENTITY_TRANSFORM : baseTransform;
        this.tempBounds = this.node.getContentBounds(this.tempBounds, baseTransform);
        return this.tempBounds.copy();
    }

    @Override
    public final ImageData filter(FilterContext object, BaseTransform baseTransform, Rectangle rectangle, Object object2, Effect effect) {
        if (object2 instanceof PrRenderInfo && (object2 = ((PrRenderInfo)object2).getGraphics()) != null) {
            this.render((Graphics)object2, baseTransform);
            return null;
        }
        object2 = NodeEffectInput.getImageBoundsForNode(this.node, this.renderType, baseTransform, rectangle);
        if (baseTransform.isIdentity()) {
            if (this.cachedIdentityImageData != null && NodeEffectInput.contains(this.cachedIdentityImageData, (Rectangle)object2) && this.cachedIdentityImageData.validate((FilterContext)object)) {
                this.cachedIdentityImageData.addref();
                return this.cachedIdentityImageData;
            }
        } else if (this.cachedTransformedImageData != null && NodeEffectInput.contains(this.cachedTransformedImageData, (Rectangle)object2) && this.cachedTransformedImageData.validate((FilterContext)object) && this.cachedTransform.equals(baseTransform)) {
            this.cachedTransformedImageData.addref();
            return this.cachedTransformedImageData;
        }
        object = NodeEffectInput.getImageDataForBoundedNode((FilterContext)object, this.node, this.renderType, baseTransform, (Rectangle)object2);
        if (baseTransform.isIdentity()) {
            this.flushIdentityImage();
            this.cachedIdentityImageData = object;
            this.cachedIdentityImageData.addref();
        } else {
            this.flushTransformedImage();
            this.cachedTransform = baseTransform.copy();
            this.cachedTransformedImageData = object;
            this.cachedTransformedImageData.addref();
        }
        return object;
    }

    @Override
    public final Effect$AccelType getAccelType(FilterContext filterContext) {
        return Effect$AccelType.INTRINSIC;
    }

    public final void flushIdentityImage() {
        if (this.cachedIdentityImageData != null) {
            this.cachedIdentityImageData.unref();
            this.cachedIdentityImageData = null;
        }
    }

    public final void flushTransformedImage() {
        if (this.cachedTransformedImageData != null) {
            this.cachedTransformedImageData.unref();
            this.cachedTransformedImageData = null;
        }
        this.cachedTransform = null;
    }

    public final void flush() {
        this.flushIdentityImage();
        this.flushTransformedImage();
    }

    public final void render(Graphics graphics, BaseTransform baseTransform) {
        BaseTransform baseTransform2 = null;
        if (!baseTransform.isIdentity()) {
            baseTransform2 = graphics.getTransformNoClone().copy();
            graphics.transform(baseTransform);
        }
        this.node.renderContent(graphics);
        if (baseTransform2 != null) {
            graphics.setTransform(baseTransform2);
        }
    }

    static ImageData getImageDataForNode(FilterContext filterContext, NGNode nGNode, boolean bl2, BaseTransform baseTransform, Rectangle rectangle) {
        NodeEffectInput$RenderType nodeEffectInput$RenderType = bl2 ? NodeEffectInput$RenderType.EFFECT_CONTENT : NodeEffectInput$RenderType.FULL_CONTENT;
        rectangle = NodeEffectInput.getImageBoundsForNode(nGNode, nodeEffectInput$RenderType, baseTransform, rectangle);
        return NodeEffectInput.getImageDataForBoundedNode(filterContext, nGNode, nodeEffectInput$RenderType, baseTransform, rectangle);
    }

    static Rectangle getImageBoundsForNode(NGNode object, NodeEffectInput$RenderType nodeEffectInput$RenderType, BaseTransform baseTransform, Rectangle rectangle) {
        BaseBounds baseBounds = new RectBounds();
        switch (nodeEffectInput$RenderType) {
            case EFFECT_CONTENT: {
                baseBounds = ((NGNode)object).getContentBounds(baseBounds, baseTransform);
                break;
            }
            case FULL_CONTENT: {
                baseBounds = ((NGNode)object).getCompleteBounds(baseBounds, baseTransform);
                break;
            }
            case CLIPPED_CONTENT: {
                baseBounds = ((NGNode)object).getClippedBounds(baseBounds, baseTransform);
            }
        }
        object = new Rectangle(baseBounds);
        if (rectangle != null) {
            ((Rectangle)object).intersectWith(rectangle);
        }
        return object;
    }

    private static ImageData getImageDataForBoundedNode(FilterContext filterContext, NGNode nGNode, NodeEffectInput$RenderType nodeEffectInput$RenderType, BaseTransform baseTransform, Rectangle rectangle) {
        PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage(filterContext, rectangle.width, rectangle.height);
        if (prDrawable != null) {
            Graphics graphics = prDrawable.createGraphics();
            graphics.translate(-rectangle.x, -rectangle.y);
            if (baseTransform != null) {
                graphics.transform(baseTransform);
            }
            switch (nodeEffectInput$RenderType) {
                case EFFECT_CONTENT: {
                    nGNode.renderContent(graphics);
                    break;
                }
                case FULL_CONTENT: {
                    nGNode.render(graphics);
                    break;
                }
                case CLIPPED_CONTENT: {
                    nGNode.renderForClip(graphics);
                }
            }
        }
        return new ImageData(filterContext, prDrawable, rectangle);
    }

    @Override
    public final boolean reducesOpaquePixels() {
        return false;
    }

    @Override
    public final DirtyRegionContainer getDirtyRegions(Effect effect, DirtyRegionPool dirtyRegionPool) {
        return null;
    }
}

