/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.text.PrismTextLayout;
import com.sun.javafx.text.ScriptMapper;
import com.sun.javafx.text.TextRun;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Bidi;

public abstract class GlyphLayout {
    public static final int CANONICAL_SUBSTITUTION = 0x40000000;
    public static final int LAYOUT_LEFT_TO_RIGHT = 1;
    public static final int LAYOUT_RIGHT_TO_LEFT = 2;
    public static final int LAYOUT_NO_START_CONTEXT = 4;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 8;
    public static final int HINTING = 16;
    private static Method isIdeographicMethod = null;
    private static GlyphLayout reusableGL;
    private static boolean inUse;

    protected TextRun addTextRun(PrismTextLayout prismTextLayout, char[] object, int n2, int n3, PGFont pGFont, TextSpan textSpan, byte by2) {
        object = new TextRun(n2, n3, by2, true, 0, textSpan, 0, false);
        prismTextLayout.addTextRun((TextRun)object);
        return object;
    }

    private TextRun addTextRun(PrismTextLayout prismTextLayout, char[] object, int n2, int n3, PGFont pGFont, TextSpan textSpan, byte by2, boolean bl2) {
        if (bl2 || (by2 & 1) != 0) {
            return this.addTextRun(prismTextLayout, (char[])object, n2, n3, pGFont, textSpan, by2);
        }
        object = new TextRun(n2, n3, by2, false, 0, textSpan, 0, false);
        prismTextLayout.addTextRun((TextRun)object);
        return object;
    }

    public int breakRuns(PrismTextLayout prismTextLayout, char[] cArray, int n2) {
        int n3;
        int n4;
        int n5 = cArray.length;
        int n6 = 0;
        int n7 = 0;
        boolean bl2 = true;
        int n8 = 1;
        if ((n2 & 2) != 0) {
            bl2 = (n2 & 0x10) != 0;
            n8 = (n2 & 8) != 0 ? 1 : 0;
        }
        TextRun textRun = null;
        Bidi bidi = null;
        byte by2 = 0;
        int n9 = n5;
        int n10 = 0;
        int n11 = 0;
        TextSpan textSpan = null;
        int n12 = n5;
        PGFont pGFont = null;
        TextSpan[] textSpanArray = prismTextLayout.getTextSpans();
        if (textSpanArray != null) {
            if (textSpanArray.length > 0) {
                textSpan = textSpanArray[0];
                n12 = textSpan.getText().length();
                pGFont = (PGFont)textSpan.getFont();
                if (pGFont == null) {
                    n2 |= 0x20;
                }
            }
        } else {
            pGFont = prismTextLayout.getFont();
        }
        if (pGFont != null) {
            FontResource fontResource = pGFont.getFontResource();
            n4 = pGFont.getFeatures();
            int n13 = n7 = (n4 & (n3 = fontResource.getFeatures())) != 0 ? 1 : 0;
        }
        if (n8 != 0 && n5 > 0) {
            int n14 = prismTextLayout.getDirection();
            bidi = new Bidi(cArray, 0, null, 0, n5, n14);
            by2 = (byte)bidi.getLevelAt(bidi.getRunStart(0));
            n9 = bidi.getRunLimit(0);
            if ((by2 & 1) != 0) {
                n2 |= 0x18;
            }
        }
        int n15 = 0;
        n4 = 0;
        while (n4 < n5) {
            int n16;
            n8 = n3 = cArray[n4];
            boolean bl3 = n3 == 9 || n3 == 10 || n3 == 13;
            int n17 = 0;
            if (Character.isHighSurrogate((char)n3) && n4 + 1 < n12 && Character.isLowSurrogate(cArray[n4 + 1])) {
                n8 = Character.toCodePoint((char)n3, cArray[++n4]);
                n17 = 1;
            }
            boolean bl4 = false;
            if (pGFont != null) {
                FontResource fontResource = pGFont.getFontResource();
                n16 = fontResource.getGlyphMapper().charToGlyph(n8);
                bl4 = fontResource.isColorGlyph(n16);
            }
            if ((bl3 || bl4) && n4 - n17 != n15) {
                textRun = this.addTextRun(prismTextLayout, cArray, n15, n4 - n17 - n15, pGFont, textSpan, by2, n6 != 0);
                if (n6 != 0) {
                    n2 |= 0x10;
                    n6 = 0;
                }
                n15 = n4 - n17;
            }
            boolean bl5 = n4 >= n12 && n4 < n5;
            int n18 = n16 = n4 >= n9 && n4 < n5 ? 1 : 0;
            if (!bl3 && !bl4) {
                n17 = n6;
                if (bl2) {
                    if (GlyphLayout.isIdeographic(n8)) {
                        n2 |= 0x40;
                    }
                    ScriptMapper.getScript(n8);
                    if (n6 == 0) {
                        int n19 = n6 = n7 != 0 || ScriptMapper.isComplexCharCode(n8) ? 1 : 0;
                    }
                }
                if ((bl5 || n16 != 0) && n15 != n4) {
                    textRun = this.addTextRun(prismTextLayout, cArray, n15, n4 - n15, pGFont, textSpan, by2, n17 != 0);
                    if (n6 != 0) {
                        n2 |= 0x10;
                        n6 = 0;
                    }
                    n15 = n4;
                }
                ++n4;
            }
            if (bl5) {
                textSpan = textSpanArray[++n11];
                n12 += textSpan.getText().length();
                pGFont = (PGFont)textSpan.getFont();
                if (pGFont == null) {
                    n2 |= 0x20;
                } else {
                    FontResource fontResource = pGFont.getFontResource();
                    n7 = pGFont.getFeatures();
                    int n20 = n7 = (n7 & (n8 = fontResource.getFeatures())) != 0 ? 1 : 0;
                }
            }
            if (n16 != 0) {
                Bidi bidi2 = bidi;
                by2 = (byte)bidi2.getLevelAt(bidi2.getRunStart(++n10));
                n9 = bidi.getRunLimit(n10);
                if ((by2 & 1) != 0) {
                    n2 |= 0x18;
                }
            }
            if (bl3) {
                if (n3 == 13 && ++n4 < n12 && cArray[n4] == '\n') {
                    ++n4;
                }
                textRun = new TextRun(n15, n4 - n15, by2, false, 0, textSpan, 0, false);
                if (n3 == 9) {
                    textRun.setTab();
                    n2 |= 4;
                } else {
                    textRun.setLinebreak();
                }
                prismTextLayout.addTextRun(textRun);
                n15 = n4;
            }
            if (!bl4) continue;
            textRun = new TextRun(n15, ++n4 - n15, by2, false, 0, textSpan, 0, false);
            prismTextLayout.addTextRun(textRun);
            n15 = n4;
        }
        if (n15 < n5) {
            this.addTextRun(prismTextLayout, cArray, n15, n5 - n15, pGFont, textSpan, by2, n6 != 0);
            if (n6 != 0) {
                n2 |= 0x10;
            }
        } else if (textRun == null || textRun.isLinebreak()) {
            textRun = new TextRun(n15, 0, 0, false, 0, textSpan, 0, false);
            prismTextLayout.addTextRun(textRun);
        }
        if (bidi != null && !bidi.baseIsLeftToRight()) {
            n2 |= 0x100;
        }
        return n2 |= 2;
    }

    public abstract void layout(TextRun var1, PGFont var2, FontStrike var3, char[] var4);

    protected int getInitialSlot(FontResource fontResource) {
        if (PrismFontFactory.isJreFont(fontResource)) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("Avoiding JRE Font: " + fontResource.getFullName());
            }
            return 1;
        }
        return 0;
    }

    private static GlyphLayout newInstance() {
        PrismFontFactory prismFontFactory = PrismFontFactory.getFontFactory();
        return prismFontFactory.createGlyphLayout();
    }

    public static GlyphLayout getInstance() {
        if (inUse) {
            return GlyphLayout.newInstance();
        }
        Class<GlyphLayout> clazz = GlyphLayout.class;
        synchronized (GlyphLayout.class) {
            if (inUse) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return GlyphLayout.newInstance();
            }
            inUse = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return reusableGL;
        }
    }

    public void dispose() {
        if (this == reusableGL) {
            inUse = false;
        }
    }

    private static boolean isIdeographic(int n2) {
        if (isIdeographicMethod != null) {
            try {
                return (Boolean)isIdeographicMethod.invoke(null, n2);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                return false;
            }
        }
        return false;
    }

    static {
        try {
            isIdeographicMethod = Character.class.getMethod("isIdeographic", Integer.TYPE);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            isIdeographicMethod = null;
        }
        reusableGL = GlyphLayout.newInstance();
    }
}

