/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.embed.EmbeddedSceneDSInterface;
import com.sun.javafx.embed.EmbeddedSceneDTInterface;
import com.sun.javafx.embed.HostDragStartListener;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.EmbeddedSceneDS;
import com.sun.javafx.tk.quantum.EmbeddedSceneDT;
import com.sun.javafx.tk.quantum.EmbeddedSceneDnD$1;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.scene.input.TransferMode;

final class EmbeddedSceneDnD {
    private final GlassSceneDnDEventHandler dndHandler;
    private HostDragStartListener dragStartListener;
    private EmbeddedSceneDSInterface fxDragSource;
    private EmbeddedSceneDTInterface fxDropTarget;
    private Thread hostThread;

    public EmbeddedSceneDnD(GlassScene glassScene) {
        this.dndHandler = new GlassSceneDnDEventHandler(glassScene);
    }

    private void startDrag() {
        assert (Platform.isFxApplicationThread());
        assert (this.fxDragSource != null);
        this.dragStartListener.dragStarted(this.fxDragSource, TransferMode.COPY);
    }

    private void setHostThread() {
        if (this.hostThread == null) {
            this.hostThread = Thread.currentThread();
        }
    }

    public final boolean isHostThread() {
        return Thread.currentThread() == this.hostThread;
    }

    public final void onDragSourceReleased(EmbeddedSceneDSInterface embeddedSceneDSInterface) {
        assert (this.fxDragSource == embeddedSceneDSInterface);
        this.fxDragSource = null;
        Toolkit.getToolkit().exitNestedEventLoop(this, null);
    }

    public final void onDropTargetReleased(EmbeddedSceneDTInterface embeddedSceneDTInterface) {
        this.fxDropTarget = null;
    }

    final <T> T executeOnFXThread(Callable<T> callable) {
        if (Platform.isFxApplicationThread()) {
            try {
                return callable.call();
            }
            catch (Exception exception) {
                return null;
            }
        }
        AtomicReference atomicReference = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                atomicReference.set(callable.call());
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (Exception exception) {}
        return (T)atomicReference.get();
    }

    public final TKClipboard createDragboard(boolean bl2) {
        assert (Platform.isFxApplicationThread());
        assert (this.fxDragSource == null);
        assert (bl2);
        EmbeddedSceneDnD$1 embeddedSceneDnD$1 = new EmbeddedSceneDnD$1(this, "DND-Embedded");
        this.fxDragSource = new EmbeddedSceneDS(this, embeddedSceneDnD$1, this.dndHandler);
        return QuantumClipboard.getDragboardInstance(embeddedSceneDnD$1, bl2);
    }

    public final void setDragStartListener(HostDragStartListener hostDragStartListener) {
        this.setHostThread();
        this.dragStartListener = hostDragStartListener;
    }

    public final EmbeddedSceneDTInterface createDropTarget() {
        this.setHostThread();
        EmbeddedSceneDnD embeddedSceneDnD = this;
        return embeddedSceneDnD.executeOnFXThread(() -> {
            assert (this.fxDropTarget == null);
            EmbeddedSceneDnD embeddedSceneDnD = this;
            this.fxDropTarget = new EmbeddedSceneDT(embeddedSceneDnD, embeddedSceneDnD.dndHandler);
            return this.fxDropTarget;
        });
    }
}

