/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.Toolkit;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.Settings;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import com.sun.scenario.animation.AnimationPulse;
import java.util.Map;

public final class PrimaryTimer
extends AbstractPrimaryTimer {
    private static final Object PRIMARY_TIMER_KEY = new StringBuilder("PrimaryTimerKey");

    private PrimaryTimer() {
    }

    public static synchronized PrimaryTimer getInstance() {
        Map<Object, Object> map = Toolkit.getToolkit().getContextMap();
        PrimaryTimer primaryTimer = (PrimaryTimer)map.get(PRIMARY_TIMER_KEY);
        if (primaryTimer == null) {
            primaryTimer = new PrimaryTimer();
            map.put(PRIMARY_TIMER_KEY, primaryTimer);
            if (Settings.getBoolean("com.sun.scenario.animation.AnimationMBean.enabled", false)) {
                AnimationPulse.getDefaultBean().setEnabled(true);
            }
        }
        return primaryTimer;
    }

    @Override
    protected final int getPulseDuration(int n2) {
        int n3 = n2 / 60;
        if (Settings.get("javafx.animation.framerate") != null) {
            int n4 = Settings.getInt("javafx.animation.framerate", 60);
            if (n4 > 0) {
                n3 = n2 / n4;
            }
        } else if (Settings.get("javafx.animation.pulse") != null) {
            int n5 = Settings.getInt("javafx.animation.pulse", 60);
            if (n5 > 0) {
                n3 = n2 / n5;
            }
        } else {
            int n6 = Toolkit.getToolkit().getRefreshRate();
            if (n6 > 0) {
                n3 = n2 / n6;
            }
        }
        return n3;
    }

    @Override
    protected final void postUpdateAnimationRunnable(DelayedRunnable delayedRunnable) {
        Toolkit.getToolkit().setAnimationRunnable(delayedRunnable);
    }

    @Override
    protected final void recordStart(long l2) {
        AnimationPulse.getDefaultBean().recordStart(l2);
    }

    @Override
    protected final void recordEnd() {
        AnimationPulse.getDefaultBean().recordEnd();
    }

    @Override
    protected final void recordAnimationEnd() {
        AnimationPulse.getDefaultBean().recordAnimationEnd();
    }
}

