/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.quantum.PrismImageLoader2$PrismLoadListener;
import com.sun.prism.Image;
import com.sun.prism.impl.PrismSettings;
import java.io.InputStream;

class PrismImageLoader2
implements ImageLoader {
    private static PlatformLogger imageioLogger = null;
    private Image[] images;
    private int[] delayTimes;
    private int loopCount;
    private double width;
    private double height;
    private float pixelScale;
    private Exception exception;

    public PrismImageLoader2(String string, double d2, double d3, boolean bl2, float f2, boolean bl3) {
        this.loadAll(string, d2, d3, bl2, f2, bl3);
    }

    public PrismImageLoader2(InputStream inputStream, double d2, double d3, boolean bl2, boolean bl3) {
        this.loadAll(inputStream, d2, d3, bl2, bl3);
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public int getFrameCount() {
        if (this.images == null) {
            return 0;
        }
        return this.images.length;
    }

    @Override
    public PlatformImage getFrame(int n2) {
        if (this.images == null) {
            return null;
        }
        return this.images[n2];
    }

    @Override
    public int getFrameDelay(int n2) {
        if (this.images == null) {
            return 0;
        }
        return this.delayTimes[n2];
    }

    @Override
    public int getLoopCount() {
        if (this.images == null) {
            return 0;
        }
        return this.loopCount;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    private void loadAll(String imageFrameArray, double d2, double d3, boolean bl2, float f2, boolean bl3) {
        PrismImageLoader2$PrismLoadListener prismImageLoader2$PrismLoadListener = new PrismImageLoader2$PrismLoadListener(this);
        try {
            imageFrameArray = ImageStorage.getInstance().loadAll((String)imageFrameArray, (ImageLoadListener)prismImageLoader2$PrismLoadListener, d2, d3, bl2, f2, bl3);
            this.convertAll(imageFrameArray);
            return;
        }
        catch (ImageStorageException imageStorageException) {
            this.handleException(imageStorageException);
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    private void loadAll(InputStream imageFrameArray, double d2, double d3, boolean bl2, boolean bl3) {
        PrismImageLoader2$PrismLoadListener prismImageLoader2$PrismLoadListener = new PrismImageLoader2$PrismLoadListener(this);
        try {
            imageFrameArray = ImageStorage.getInstance().loadAll((InputStream)imageFrameArray, (ImageLoadListener)prismImageLoader2$PrismLoadListener, d2, d3, bl2, 1.0f, bl3);
            this.convertAll(imageFrameArray);
            return;
        }
        catch (ImageStorageException imageStorageException) {
            this.handleException(imageStorageException);
            return;
        }
        catch (Exception exception) {
            this.handleException(exception);
            return;
        }
    }

    private void handleException(ImageStorageException imageStorageException) {
        Throwable throwable = imageStorageException.getCause();
        if (throwable instanceof Exception) {
            this.handleException((Exception)throwable);
            return;
        }
        this.handleException((Exception)imageStorageException);
    }

    private void handleException(Exception exception) {
        if (PrismSettings.verbose) {
            exception.printStackTrace(System.err);
        }
        this.exception = exception;
    }

    private void convertAll(ImageFrame[] imageFrameArray) {
        int n2 = imageFrameArray.length;
        this.images = new Image[n2];
        this.delayTimes = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ImageFrame imageFrame = imageFrameArray[i2];
            this.images[i2] = Image.convertImageFrame(imageFrame);
            Object object = imageFrame.getMetadata();
            if (object != null) {
                Integer n3 = ((ImageMetadata)object).delayTime;
                if (n3 != null) {
                    this.delayTimes[i2] = n3;
                }
                if ((object = ((ImageMetadata)object).loopCount) != null) {
                    this.loopCount = (Integer)object;
                }
            }
            if (i2 != 0) continue;
            this.width = imageFrame.getWidth();
            this.height = imageFrame.getHeight();
        }
    }

    private static synchronized PlatformLogger getImageioLogger() {
        if (imageioLogger == null) {
            imageioLogger = PlatformLogger.getLogger("javafx.scene.image");
        }
        return imageioLogger;
    }
}

