/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PermissionHelper;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.PixelUtils;
import com.sun.javafx.tk.quantum.QuantumClipboard$1;
import com.sun.prism.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.input.DataFormat;
import javafx.scene.input.TransferMode;
import javafx.util.Pair;

final class QuantumClipboard
implements TKClipboard {
    private ClipboardAssistance systemAssistant;
    private AccessControlContext accessContext = null;
    private boolean isCaching;
    private List<Pair<DataFormat, Object>> dataCache;
    private Set<TransferMode> transferModesCache;
    private javafx.scene.image.Image dragImage = null;
    private double dragOffsetX = 0.0;
    private double dragOffsetY = 0.0;
    private static ClipboardAssistance currentDragboard;
    private static final Pattern findTagIMG;

    private QuantumClipboard() {
    }

    @Override
    public final void setSecurityContext(AccessControlContext accessControlContext) {
        if (this.accessContext != null) {
            throw new RuntimeException("Clipboard security context has been already set!");
        }
        this.accessContext = accessControlContext;
    }

    private AccessControlContext getAccessControlContext() {
        if (this.accessContext == null) {
            throw new RuntimeException("Clipboard security context has not been set!");
        }
        return this.accessContext;
    }

    public static QuantumClipboard getClipboardInstance(ClipboardAssistance clipboardAssistance) {
        QuantumClipboard quantumClipboard = new QuantumClipboard();
        new QuantumClipboard().systemAssistant = clipboardAssistance;
        quantumClipboard.isCaching = false;
        return quantumClipboard;
    }

    static ClipboardAssistance getCurrentDragboard() {
        return currentDragboard;
    }

    static void releaseCurrentDragboard() {
        currentDragboard = null;
    }

    public static QuantumClipboard getDragboardInstance(ClipboardAssistance clipboardAssistance, boolean bl2) {
        QuantumClipboard quantumClipboard = new QuantumClipboard();
        new QuantumClipboard().systemAssistant = clipboardAssistance;
        quantumClipboard.isCaching = true;
        if (bl2) {
            currentDragboard = clipboardAssistance;
        }
        return quantumClipboard;
    }

    public static int transferModesToClipboardActions(Set<TransferMode> set) {
        int n2 = 0;
        block5: for (TransferMode transferMode : set) {
            switch (transferMode) {
                case COPY: {
                    n2 |= 1;
                    continue block5;
                }
                case MOVE: {
                    n2 |= 2;
                    continue block5;
                }
                case LINK: {
                    n2 |= 0x40000000;
                    continue block5;
                }
            }
            throw new IllegalArgumentException("unsupported TransferMode " + String.valueOf(set));
        }
        return n2;
    }

    public final void setSupportedTransferMode(Set<TransferMode> set) {
        if (this.isCaching) {
            this.transferModesCache = set;
        }
        int n2 = QuantumClipboard.transferModesToClipboardActions(set);
        this.systemAssistant.setSupportedActions(n2);
    }

    public static Set<TransferMode> clipboardActionsToTransferModes(int n2) {
        EnumSet<TransferMode> enumSet = EnumSet.noneOf(TransferMode.class);
        if ((n2 & 1) != 0) {
            enumSet.add(TransferMode.COPY);
        }
        if ((n2 & 2) != 0) {
            enumSet.add(TransferMode.MOVE);
        }
        if ((n2 & 0x40000000) != 0) {
            enumSet.add(TransferMode.LINK);
        }
        return enumSet;
    }

    @Override
    public final Set<TransferMode> getTransferModes() {
        if (this.transferModesCache != null) {
            return EnumSet.copyOf(this.transferModesCache);
        }
        Object object = currentDragboard != null ? currentDragboard : this.systemAssistant;
        object = QuantumClipboard.clipboardActionsToTransferModes(((ClipboardAssistance)object).getSupportedSourceActions());
        return object;
    }

    @Override
    public final void setDragView(javafx.scene.image.Image image) {
        this.dragImage = image;
    }

    @Override
    public final void setDragViewOffsetX(double d2) {
        this.dragOffsetX = d2;
    }

    @Override
    public final void setDragViewOffsetY(double d2) {
        this.dragOffsetY = d2;
    }

    @Override
    public final javafx.scene.image.Image getDragView() {
        return this.dragImage;
    }

    @Override
    public final double getDragViewOffsetX() {
        return this.dragOffsetX;
    }

    @Override
    public final double getDragViewOffsetY() {
        return this.dragOffsetY;
    }

    public final void close() {
        this.systemAssistant.close();
    }

    public final void flush() {
        if (this.isCaching) {
            QuantumClipboard quantumClipboard = this;
            quantumClipboard.putContentToPeer(quantumClipboard.dataCache.toArray(new Pair[0]));
        }
        this.clearCache();
        this.clearDragView();
        this.systemAssistant.flush();
    }

    @Override
    public final Object getContent(DataFormat object3) {
        ClipboardAssistance clipboardAssistance;
        if (this.dataCache != null) {
            for (Pair<DataFormat, Object> pair : this.dataCache) {
                if (pair.getKey() != object3) continue;
                return pair.getValue();
            }
            return null;
        }
        ClipboardAssistance clipboardAssistance2 = clipboardAssistance = currentDragboard != null ? currentDragboard : this.systemAssistant;
        if (object3 == DataFormat.IMAGE) {
            return this.readImage();
        }
        if (object3 == DataFormat.URL) {
            return clipboardAssistance.getData("text/uri-list");
        }
        if (object3 == DataFormat.FILES) {
            Object object = clipboardAssistance.getData("application/x-java-file-list");
            if (object == null) {
                return Collections.emptyList();
            }
            String[] stringArray = (String[])object;
            ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                arrayList.add(new File(stringArray[i2]));
            }
            return arrayList;
        }
        for (String string : ((DataFormat)object3).getIdentifiers()) {
            Object object = clipboardAssistance.getData(string);
            if (object instanceof ByteBuffer) {
                try {
                    ByteBuffer byteBuffer = (ByteBuffer)object;
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteBuffer.array());
                    QuantumClipboard$1 quantumClipboard$1 = new QuantumClipboard$1(this, byteArrayInputStream);
                    object = quantumClipboard$1.readObject();
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private static javafx.scene.image.Image convertObjectToImage(Object object) {
        if (object instanceof javafx.scene.image.Image) {
            return (javafx.scene.image.Image)object;
        }
        if (object instanceof ByteBuffer) {
            object = (ByteBuffer)object;
            try {
                ((ByteBuffer)object).rewind();
                int n2 = ((ByteBuffer)object).getInt();
                int n3 = ((ByteBuffer)object).getInt();
                object = Application.GetApplication().createPixels(n2, n3, ((ByteBuffer)object).slice());
            }
            catch (Exception exception) {
                return null;
            }
        } else if (object instanceof Pixels) {
            object = (Pixels)object;
        } else {
            return null;
        }
        object = PixelUtils.pixelsToImage((Pixels)object);
        ImageLoader imageLoader = Toolkit.getToolkit().loadPlatformImage(object);
        return Toolkit.getImageAccessor().fromPlatformImage(imageLoader);
    }

    private javafx.scene.image.Image readImage() {
        Object object = currentDragboard != null ? currentDragboard : this.systemAssistant;
        Object object2 = ((ClipboardAssistance)object).getData("application/x-java-rawimage");
        if (object2 == null) {
            if ((object = ((ClipboardAssistance)object).getData("text/html")) != null && (object = this.parseIMG(object)) != null) {
                try {
                    object2 = System.getSecurityManager();
                    if (object2 != null) {
                        AccessControlContext accessControlContext = this.getAccessControlContext();
                        Object object3 = new URL((String)object);
                        Object object4 = ((URL)object3).getProtocol();
                        if (((String)object4).equalsIgnoreCase("jar")) {
                            object4 = ((URL)object3).getFile();
                            object3 = new URL((String)object4);
                            object4 = ((URL)object3).getProtocol();
                        }
                        if (((String)object4).equalsIgnoreCase("file")) {
                            object4 = new FilePermission(((URL)object3).getFile(), "read");
                            ((SecurityManager)object2).checkPermission((Permission)object4, accessControlContext);
                        } else if (((String)object4).equalsIgnoreCase("ftp") || ((String)object4).equalsIgnoreCase("http") || ((String)object4).equalsIgnoreCase("https")) {
                            int n2 = ((URL)object3).getPort();
                            object3 = n2 == -1 ? ((URL)object3).getHost() : ((URL)object3).getHost() + ":" + n2;
                            object3 = new SocketPermission((String)object3, "connect");
                            ((SecurityManager)object2).checkPermission((Permission)object3, accessControlContext);
                        } else {
                            PermissionHelper.checkClipboardPermission(accessControlContext);
                        }
                    }
                    return new javafx.scene.image.Image((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
                catch (SecurityException securityException) {
                    return null;
                }
            }
            return null;
        }
        return QuantumClipboard.convertObjectToImage(object2);
    }

    private String parseIMG(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof String)) {
            return null;
        }
        object = (String)object;
        if (((Matcher)(object = findTagIMG.matcher((CharSequence)object))).find()) {
            return ((Matcher)object).group(1);
        }
        return null;
    }

    private boolean placeImage(javafx.scene.image.Image object) {
        if (object == null) {
            return false;
        }
        String string = ((javafx.scene.image.Image)object).getUrl();
        if (string == null || PixelUtils.supportedFormatType(string)) {
            object = (Image)Toolkit.getImageAccessor().getPlatformImage((javafx.scene.image.Image)object);
            if ((object = PixelUtils.imageToPixels((Image)object)) != null) {
                this.systemAssistant.setData("application/x-java-rawimage", object);
                return true;
            }
            return false;
        }
        this.systemAssistant.setData("text/uri-list", string);
        return true;
    }

    @Override
    public final Set<DataFormat> getContentTypes() {
        HashSet<DataFormat> hashSet = new HashSet<DataFormat>();
        if (this.dataCache != null) {
            for (Pair<DataFormat, Object> pair : this.dataCache) {
                hashSet.add(pair.getKey());
            }
            return hashSet;
        }
        ClipboardAssistance clipboardAssistance = currentDragboard != null ? currentDragboard : this.systemAssistant;
        String[] stringArray = clipboardAssistance.getMimeTypes();
        if (stringArray == null) {
            return hashSet;
        }
        for (String string : stringArray) {
            if (string.equalsIgnoreCase("application/x-java-rawimage")) {
                hashSet.add(DataFormat.IMAGE);
                continue;
            }
            if (string.equalsIgnoreCase("text/uri-list")) {
                hashSet.add(DataFormat.URL);
                continue;
            }
            if (string.equalsIgnoreCase("application/x-java-file-list")) {
                hashSet.add(DataFormat.FILES);
                continue;
            }
            if (string.equalsIgnoreCase("text/html")) {
                hashSet.add(DataFormat.HTML);
                try {
                    if (this.parseIMG(clipboardAssistance.getData("text/html")) == null) continue;
                    hashSet.add(DataFormat.IMAGE);
                }
                catch (Exception exception) {}
                continue;
            }
            DataFormat dataFormat = DataFormat.lookupMimeType(string);
            if (dataFormat == null) {
                dataFormat = new DataFormat(string);
            }
            hashSet.add(dataFormat);
        }
        return hashSet;
    }

    @Override
    public final boolean hasContent(DataFormat dataFormat) {
        if (this.dataCache != null) {
            for (Pair<DataFormat, Object> pair : this.dataCache) {
                if (pair.getKey() != dataFormat) continue;
                return true;
            }
            return false;
        }
        ClipboardAssistance clipboardAssistance = currentDragboard != null ? currentDragboard : this.systemAssistant;
        String[] stringArray = clipboardAssistance.getMimeTypes();
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (dataFormat == DataFormat.IMAGE && string.equalsIgnoreCase("application/x-java-rawimage")) {
                return true;
            }
            if (dataFormat == DataFormat.URL && string.equalsIgnoreCase("text/uri-list")) {
                return true;
            }
            if (dataFormat == DataFormat.IMAGE && string.equalsIgnoreCase("text/html") && this.parseIMG(clipboardAssistance.getData("text/html")) != null) {
                return true;
            }
            if (dataFormat == DataFormat.FILES && string.equalsIgnoreCase("application/x-java-file-list")) {
                return true;
            }
            DataFormat object = DataFormat.lookupMimeType(string);
            if (object == null || !object.equals(dataFormat)) continue;
            return true;
        }
        return false;
    }

    private static ByteBuffer prepareImage(javafx.scene.image.Image image) {
        Object object = image.getPixelReader();
        int n2 = (int)image.getWidth();
        int n3 = (int)image.getHeight();
        byte[] byArray = new byte[n2 * n3 << 2];
        object.getPixels(0, 0, n2, n3, WritablePixelFormat.getByteBgraInstance(), byArray, 0, n2 << 2);
        object = ByteBuffer.allocate(8 + (n2 * n3 << 2));
        ((ByteBuffer)object).putInt(n2);
        ((ByteBuffer)object).putInt(n3);
        ((ByteBuffer)object).put(byArray);
        return object;
    }

    private static ByteBuffer prepareOffset(double d2, double d3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.rewind();
        byteBuffer.putInt((int)d2);
        byteBuffer.putInt((int)d3);
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    private boolean putContentToPeer(Pair<DataFormat, Object> ... object) {
        this.systemAssistant.emptyCache();
        boolean bl2 = false;
        for (Object n3 : object) {
            Object object2;
            Object object3 = (DataFormat)((Pair)n3).getKey();
            Object v2 = ((Pair)n3).getValue();
            if (object3 == DataFormat.IMAGE) {
                bl2 = this.placeImage(QuantumClipboard.convertObjectToImage(v2));
                continue;
            }
            if (object3 == DataFormat.URL) {
                this.systemAssistant.setData("text/uri-list", v2);
                bl2 = true;
                continue;
            }
            if (object3 == DataFormat.RTF) {
                this.systemAssistant.setData("text/rtf", v2);
                bl2 = true;
                continue;
            }
            if (object3 == DataFormat.FILES) {
                object2 = (List)v2;
                if (object2.size() == 0) continue;
                String[] stringArray = new String[object2.size()];
                boolean bl3 = false;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object3 = (File)iterator.next();
                    stringArray[++var5_13] = ((File)object3).getAbsolutePath();
                }
                this.systemAssistant.setData("application/x-java-file-list", stringArray);
                bl2 = true;
                continue;
            }
            if (v2 instanceof Serializable) {
                if (object3 != DataFormat.PLAIN_TEXT && object3 != DataFormat.HTML || !(v2 instanceof String)) {
                    try {
                        object2 = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object2);
                        objectOutputStream.writeObject(v2);
                        objectOutputStream.close();
                        ByteBuffer byteBuffer = ByteBuffer.wrap(((ByteArrayOutputStream)object2).toByteArray());
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("Could not serialize the data", iOException);
                    }
                }
            } else if (v2 instanceof InputStream) {
                object2 = new ByteArrayOutputStream();
                try (InputStream inputStream = (InputStream)v2;){
                    int n2;
                    int n4 = inputStream.read();
                    while (n2 != -1) {
                        ((ByteArrayOutputStream)object2).write(n2);
                        n2 = inputStream.read();
                    }
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Could not serialize the data", iOException);
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(((ByteArrayOutputStream)object2).toByteArray());
            } else if (!(v2 instanceof ByteBuffer)) {
                throw new IllegalArgumentException("Only serializable objects or ByteBuffer can be used as data with data format " + String.valueOf(object3));
            }
            for (String string : ((DataFormat)object3).getIdentifiers()) {
                void var5_19;
                this.systemAssistant.setData(string, var5_19);
                bl2 = true;
            }
        }
        if (this.dragImage != null) {
            ByteBuffer byteBuffer = QuantumClipboard.prepareImage(this.dragImage);
            ByteBuffer byteBuffer2 = QuantumClipboard.prepareOffset(this.dragOffsetX, this.dragOffsetY);
            this.systemAssistant.setData("application/x-java-drag-image", byteBuffer);
            this.systemAssistant.setData("application/x-java-drag-image-offset", byteBuffer2);
        }
        return bl2;
    }

    @Override
    public final boolean putContent(Pair<DataFormat, Object> ... pairArray) {
        Object object;
        int n2;
        Pair<DataFormat, Object>[] pairArray2 = pairArray;
        int n3 = pairArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            Object object2 = pairArray2[n2];
            object = ((Pair)object2).getKey();
            object2 = ((Pair)object2).getValue();
            if (object == null) {
                throw new NullPointerException("Clipboard.putContent: null data format");
            }
            if (object2 != null) continue;
            throw new NullPointerException("Clipboard.putContent: null data");
        }
        boolean bl2 = false;
        if (this.isCaching) {
            if (this.dataCache == null) {
                this.dataCache = new ArrayList<Pair<DataFormat, Object>>(pairArray.length);
            }
            Pair<DataFormat, Object>[] pairArray3 = pairArray;
            n2 = pairArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                object = pairArray3[i2];
                this.dataCache.add((Pair<DataFormat, Object>)object);
                bl2 = true;
            }
        } else {
            bl2 = this.putContentToPeer(pairArray);
            this.systemAssistant.flush();
        }
        return bl2;
    }

    private void clearCache() {
        this.dataCache = null;
        this.transferModesCache = null;
    }

    private void clearDragView() {
        this.dragImage = null;
        QuantumClipboard quantumClipboard = this;
        quantumClipboard.dragOffsetY = 0.0;
        quantumClipboard.dragOffsetX = 0.0;
    }

    static {
        findTagIMG = Pattern.compile("IMG\\s+SRC=\\\"([^\\\"]+)\\\"", 34);
    }
}

