/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.CommonDialogs$ExtensionFilter;
import com.sun.glass.ui.CommonDialogs$FileChooserResult;
import com.sun.glass.ui.EventLoop;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.font.PrismFontLoader;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.runtime.async.AbstractRemoteResource;
import com.sun.javafx.runtime.async.AsyncOperationListener;
import com.sun.javafx.scene.input.DragboardHelper;
import com.sun.javafx.scene.text.TextLayoutFactory;
import com.sun.javafx.text.PrismTextLayoutFactory;
import com.sun.javafx.tk.CompletionListener;
import com.sun.javafx.tk.FileChooserType;
import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.ImageLoader;
import com.sun.javafx.tk.PlatformImage;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.ScreenConfigurationAccessor;
import com.sun.javafx.tk.TKClipboard;
import com.sun.javafx.tk.TKDragGestureListener;
import com.sun.javafx.tk.TKDragSourceListener;
import com.sun.javafx.tk.TKDropTargetListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKScreenConfigurationListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.TKSystemMenu;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.Toolkit$ImageRenderingContext;
import com.sun.javafx.tk.Toolkit$Task;
import com.sun.javafx.tk.quantum.CursorUtils;
import com.sun.javafx.tk.quantum.EmbeddedStage;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.GlassSystemMenu;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.PaintRenderJob;
import com.sun.javafx.tk.quantum.PathIteratorHelper;
import com.sun.javafx.tk.quantum.PathIteratorHelper$Struct;
import com.sun.javafx.tk.quantum.PerformanceTrackerImpl;
import com.sun.javafx.tk.quantum.PrimaryTimer;
import com.sun.javafx.tk.quantum.PrismImageLoader2;
import com.sun.javafx.tk.quantum.PrismImageLoader2$AsyncImageLoader;
import com.sun.javafx.tk.quantum.QuantumClipboard;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.javafx.tk.quantum.QuantumToolkit$1;
import com.sun.javafx.tk.quantum.QuantumToolkit$2;
import com.sun.javafx.tk.quantum.QuantumToolkit$3;
import com.sun.javafx.tk.quantum.QuantumToolkit$4;
import com.sun.javafx.tk.quantum.QuantumToolkit$5;
import com.sun.javafx.tk.quantum.QuantumToolkit$PulseTask;
import com.sun.javafx.tk.quantum.QuantumToolkit$QuantumImage;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.BasicStroke;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.PixelFormat;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.paint.Stop;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.animation.AbstractPrimaryTimer;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrImage;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javafx.application.ConditionalFeature;
import javafx.event.Event;
import javafx.geometry.Dimension2D;
import javafx.scene.image.Image;
import javafx.scene.image.PixelBuffer;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.stage.FileChooser$ExtensionFilter;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public final class QuantumToolkit
extends Toolkit {
    public static final boolean verbose = AccessController.doPrivileged(() -> Boolean.getBoolean("quantum.verbose"));
    public static final boolean pulseDebug = AccessController.doPrivileged(() -> Boolean.getBoolean("quantum.pulse"));
    private static final boolean multithreaded = AccessController.doPrivileged(() -> {
        String string = System.getProperty("quantum.multithreaded");
        if (string == null) {
            return Boolean.TRUE;
        }
        boolean bl2 = Boolean.parseBoolean(string);
        if (verbose) {
            System.out.println(bl2 ? "Multi-Threading Enabled" : "Multi-Threading Disabled");
        }
        return bl2;
    });
    private static boolean debug = AccessController.doPrivileged(() -> Boolean.getBoolean("quantum.debug"));
    private static Integer pulseHZ = AccessController.doPrivileged(() -> Integer.getInteger("javafx.animation.pulse"));
    static final boolean liveResize = AccessController.doPrivileged(() -> {
        boolean bl2 = "swt".equals(System.getProperty("glass.platform"));
        String string = (PlatformUtil.isMac() || PlatformUtil.isWindows()) && !bl2 ? "true" : "false";
        return "true".equals(System.getProperty("javafx.live.resize", string));
    });
    static final boolean drawInPaint = AccessController.doPrivileged(() -> {
        boolean bl2 = "swt".equals(System.getProperty("glass.platform"));
        String string = PlatformUtil.isMac() && bl2 ? "true" : "false";
        return "true".equals(System.getProperty("javafx.draw.in.paint", string));
    });
    private static boolean singleThreaded = AccessController.doPrivileged(() -> {
        Boolean bl2 = Boolean.getBoolean("quantum.singlethreaded");
        if (bl2.booleanValue()) {
            System.out.println("Warning: Single GUI Threadiong is enabled, FPS should be slower");
        }
        return bl2;
    });
    private static boolean noRenderJobs = AccessController.doPrivileged(() -> {
        Boolean bl2 = Boolean.getBoolean("quantum.norenderjobs");
        if (bl2.booleanValue()) {
            System.out.println("Warning: Quantum will not submit render jobs, nothing should draw");
        }
        return bl2;
    });
    private AtomicBoolean toolkitRunning = new AtomicBoolean(false);
    private QuantumToolkit$PulseTask animationRunning = new QuantumToolkit$PulseTask(this, false);
    private QuantumToolkit$PulseTask nextPulseRequested = new QuantumToolkit$PulseTask(this, false);
    private AtomicBoolean pulseRunning = new AtomicBoolean(false);
    private int inPulse = 0;
    private CountDownLatch launchLatch = new CountDownLatch(1);
    final int PULSE_INTERVAL = (int)(TimeUnit.SECONDS.toMillis(1L) / (long)((Toolkit)this).getRefreshRate());
    final int FULLSPEED_INTERVAL = 1;
    boolean nativeSystemVsync = false;
    private long firstPauseRequestTime = 0L;
    private boolean pauseRequested = false;
    private static final long PAUSE_THRESHOLD_DURATION = 250L;
    private float _maxPixelScale;
    private Runnable pulseRunnable;
    private Runnable userRunnable;
    private Runnable timerRunnable;
    private Timer pulseTimer = null;
    private Thread shutdownHook = null;
    private PaintCollector collector;
    private QuantumRenderer renderer;
    private GraphicsPipeline pipeline;
    private ClassLoader ccl;
    private HashMap<Object, EventLoop> eventLoopMap = null;
    private final PerformanceTracker perfTracker = new PerformanceTrackerImpl();
    private static ScreenConfigurationAccessor screenAccessor = new QuantumToolkit$3();
    private Map<Object, Object> contextMap = Collections.synchronizedMap(new HashMap());
    private DelayedRunnable animationRunnable;
    static BasicStroke tmpStroke = new BasicStroke();
    private QuantumClipboard clipboard;
    private GlassSystemMenu systemMenu = new GlassSystemMenu();

    @Override
    public final boolean init() {
        this.renderer = QuantumRenderer.getInstance();
        this.collector = PaintCollector.createInstance(this);
        this.pipeline = GraphicsPipeline.getPipeline();
        this.shutdownHook = new QuantumToolkit$1(this, "Glass/Prism Shutdown Hook");
        AccessController.doPrivileged(() -> {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            return null;
        });
        return true;
    }

    @Override
    public final void startup(Runnable object) {
        this.ccl = Thread.currentThread().getContextClassLoader();
        try {
            this.userRunnable = object;
            Application.run(() -> this.runToolkit());
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        try {
            this.launchLatch.await();
            return;
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            interruptedException.printStackTrace();
            return;
        }
    }

    private void assertToolkitRunning() {
    }

    final boolean shouldWaitForRenderingToComplete() {
        return !multithreaded;
    }

    private static void initSceneGraph() {
        Screen.getPrimary();
    }

    final void runToolkit() {
        Object object = Thread.currentThread();
        if (!this.toolkitRunning.getAndSet(true)) {
            ((Thread)object).setName("JavaFX Application Thread");
            ((Thread)object).setContextClassLoader(this.ccl);
            QuantumToolkit.setFxUserThread((Thread)object);
            QuantumToolkit.assignScreensAdapters();
            this.renderer.createResourceFactory();
            this.pulseRunnable = () -> this.pulseFromQueue();
            this.timerRunnable = () -> {
                try {
                    this.postPulse();
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    throwable.printStackTrace(System.err);
                    return;
                }
            };
            this.pulseTimer = Application.GetApplication().createTimer(this.timerRunnable);
            Application.GetApplication().setEventHandler(new QuantumToolkit$2(this));
        }
        QuantumToolkit.initSceneGraph();
        this.launchLatch.countDown();
        try {
            Application.invokeAndWait(this.userRunnable);
            this.userRunnable = null;
            if (((Toolkit)this).getPrimaryTimer().isFullspeed()) {
                this.pulseTimer.start(1);
            } else {
                boolean bl2 = this.nativeSystemVsync = com.sun.glass.ui.Screen.getVideoRefreshPeriod() != 0.0;
                if (this.nativeSystemVsync) {
                    this.pulseTimer.start();
                } else {
                    this.pulseTimer.start(this.PULSE_INTERVAL);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            object = throwable;
            throwable.printStackTrace(System.err);
            return;
        }
        finally {
            if (PrismSettings.verbose) {
                System.err.println(" vsync: " + PrismSettings.isVsyncEnabled + " vpipe: " + this.pipeline.isVsyncSupported());
            }
            PerformanceTracker.logEvent("Toolkit.startup - finished");
        }
    }

    public static <T> T runWithoutRenderLock(Supplier<T> supplier) {
        boolean bl2 = ViewPainter.renderLock.isHeldByCurrentThread();
        try {
            if (bl2) {
                ViewPainter.renderLock.unlock();
            }
            supplier = supplier.get();
            return (T)supplier;
        }
        finally {
            if (bl2) {
                ViewPainter.renderLock.lock();
            }
        }
    }

    public static <T> T runWithRenderLock(Supplier<T> supplier) {
        ViewPainter.renderLock.lock();
        try {
            supplier = supplier.get();
            return (T)supplier;
        }
        finally {
            ViewPainter.renderLock.unlock();
        }
    }

    public static void runInRenderThreadAndWait(Runnable runnable) {
        try {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            QuantumRenderer.getInstance().execute(() -> {
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    runnable = throwable;
                    throwable.printStackTrace();
                }
                countDownLatch.countDown();
            });
            countDownLatch.await();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    final boolean hasNativeSystemVsync() {
        return this.nativeSystemVsync;
    }

    final boolean isVsyncEnabled() {
        return PrismSettings.isVsyncEnabled && this.pipeline.isVsyncSupported();
    }

    @Override
    public final void checkFxUserThread() {
        super.checkFxUserThread();
        this.renderer.checkRendererIdle();
    }

    protected static Thread getFxUserThread() {
        return Toolkit.getFxUserThread();
    }

    @Override
    public final Future addRenderJob(RenderJob object) {
        if (noRenderJobs) {
            CompletionListener completionListener = ((RenderJob)object).getCompletionListener();
            if (object instanceof PaintRenderJob) {
                ((PaintRenderJob)object).getScene().setPainting(false);
            }
            if (completionListener != null) {
                try {
                    completionListener.done((RenderJob)object);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throwable.printStackTrace();
                }
            }
            return null;
        }
        if (singleThreaded) {
            ((RenderJob)object).run();
            return null;
        }
        return this.renderer.submitRenderJob((RenderJob)object);
    }

    final void postPulse() {
        if (this.toolkitRunning.get() && (this.animationRunning.get() || this.nextPulseRequested.get()) && !this.setPulseRunning()) {
            Application.invokeLater(this.pulseRunnable);
            if (debug) {
                System.err.println("QT.postPulse@(" + System.nanoTime() + "): " + this.pulseString());
                return;
            }
        } else {
            if (!(this.animationRunning.get() || this.nextPulseRequested.get() || this.pulseRunning.get())) {
                this.pauseTimer();
                return;
            }
            if (debug) {
                System.err.println("QT.postPulse#(" + System.nanoTime() + "): DROP : " + this.pulseString());
            }
        }
    }

    private synchronized void pauseTimer() {
        if (!this.pauseRequested) {
            this.pauseRequested = true;
            this.firstPauseRequestTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.firstPauseRequestTime >= 250L) {
            this.pulseTimer.pause();
            if (debug) {
                System.err.println("QT.pauseTimer#(" + System.nanoTime() + "): Pausing Timer : " + this.pulseString());
                return;
            }
        } else if (debug) {
            System.err.println("QT.pauseTimer#(" + System.nanoTime() + "): Pause Timer : DROP : " + this.pulseString());
        }
    }

    private synchronized void resumeTimer() {
        this.pauseRequested = false;
        this.pulseTimer.resume();
    }

    private String pulseString() {
        return (this.toolkitRunning.get() ? "T" : "t") + (this.animationRunning.get() ? "A" : "a") + (this.pulseRunning.get() ? "P" : "p") + (this.nextPulseRequested.get() ? "N" : "n");
    }

    private boolean setPulseRunning() {
        return this.pulseRunning.getAndSet(true);
    }

    private void endPulseRunning() {
        this.pulseRunning.set(false);
        if (debug) {
            System.err.println("QT.endPulse: " + System.nanoTime());
        }
    }

    final void pulseFromQueue() {
        try {
            this.pulse();
            return;
        }
        finally {
            this.endPulseRunning();
        }
    }

    protected final void pulse() {
        this.pulse(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void pulse(boolean bl2) {
        block7: {
            try {
                ++this.inPulse;
                if (PulseLogger.PULSE_LOGGING_ENABLED) {
                    PulseLogger.pulseStart();
                }
                if (this.toolkitRunning.get()) break block7;
                --this.inPulse;
                if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
            }
            catch (Throwable throwable) {
                --this.inPulse;
                if (!PulseLogger.PULSE_LOGGING_ENABLED) throw throwable;
                PulseLogger.pulseEnd();
                throw throwable;
            }
            PulseLogger.pulseEnd();
            return;
        }
        this.nextPulseRequested.set(false);
        if (this.animationRunnable != null) {
            this.animationRunning.set(true);
            this.animationRunnable.run();
        } else {
            this.animationRunning.set(false);
        }
        this.firePulse();
        if (bl2) {
            this.collector.renderAll();
        }
        --this.inPulse;
        if (!PulseLogger.PULSE_LOGGING_ENABLED) return;
        PulseLogger.pulseEnd();
    }

    final void vsyncHint() {
        if (this.isVsyncEnabled()) {
            if (debug) {
                System.err.println("QT.vsyncHint: postPulse: " + System.nanoTime());
            }
            this.postPulse();
        }
    }

    @Override
    public final TKStage createTKStage(Window object, boolean bl2, StageStyle stageStyle, boolean bl3, Modality modality, TKStage tKStage, boolean bl4, AccessControlContext accessControlContext) {
        this.assertToolkitRunning();
        object = new WindowStage((Window)object, bl2, stageStyle, modality, tKStage);
        ((GlassStage)object).setSecurityContext(accessControlContext);
        if (bl3) {
            ((WindowStage)object).setIsPrimary();
        }
        ((WindowStage)object).setRTL(bl4);
        ((WindowStage)object).init(this.systemMenu);
        return object;
    }

    @Override
    public final boolean canStartNestedEventLoop() {
        ((Toolkit)this).checkFxUserThread();
        return this.inPulse == 0;
    }

    @Override
    public final Object enterNestedEventLoop(Object object) {
        ((Toolkit)this).checkFxUserThread();
        if (object == null) {
            throw new NullPointerException();
        }
        if (!((Toolkit)this).canStartNestedEventLoop()) {
            throw new IllegalStateException("Cannot enter nested loop during animation or layout processing");
        }
        if (this.eventLoopMap == null) {
            this.eventLoopMap = new HashMap();
        }
        if (this.eventLoopMap.containsKey(object)) {
            throw new IllegalArgumentException("Key already associated with a running event loop: " + String.valueOf(object));
        }
        EventLoop eventLoop = Application.GetApplication().createEventLoop();
        this.eventLoopMap.put(object, eventLoop);
        object = eventLoop.enter();
        if (!((Toolkit)this).isNestedLoopRunning()) {
            this.notifyLastNestedLoopExited();
        }
        return object;
    }

    @Override
    public final void exitNestedEventLoop(Object object, Object object2) {
        ((Toolkit)this).checkFxUserThread();
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.eventLoopMap == null || !this.eventLoopMap.containsKey(object)) {
            throw new IllegalArgumentException("Key not associated with a running event loop: " + String.valueOf(object));
        }
        EventLoop eventLoop = this.eventLoopMap.get(object);
        this.eventLoopMap.remove(object);
        eventLoop.leave(object2);
    }

    @Override
    public final void exitAllNestedEventLoops() {
        ((Toolkit)this).checkFxUserThread();
        for (EventLoop eventLoop : this.eventLoopMap.values()) {
            eventLoop.leave(null);
        }
        this.eventLoopMap.clear();
        this.eventLoopMap = null;
    }

    @Override
    public final TKStage createTKPopupStage(Window object, StageStyle stageStyle, TKStage tKStage, AccessControlContext accessControlContext) {
        this.assertToolkitRunning();
        boolean bl2 = tKStage instanceof WindowStage ? ((WindowStage)tKStage).isSecurityDialog() : false;
        object = new WindowStage((Window)object, bl2, stageStyle, null, tKStage);
        ((GlassStage)object).setSecurityContext(accessControlContext);
        ((WindowStage)object).setIsPopup();
        ((WindowStage)object).init(this.systemMenu);
        return object;
    }

    @Override
    public final TKStage createTKEmbeddedStage(HostInterface object, AccessControlContext accessControlContext) {
        this.assertToolkitRunning();
        object = new EmbeddedStage((HostInterface)object);
        ((GlassStage)object).setSecurityContext(accessControlContext);
        return object;
    }

    @Override
    public final ScreenConfigurationAccessor setScreenConfigurationListener(TKScreenConfigurationListener tKScreenConfigurationListener) {
        com.sun.glass.ui.Screen.setEventHandler(new QuantumToolkit$4(this, tKScreenConfigurationListener));
        return screenAccessor;
    }

    private static void assignScreensAdapters() {
        GraphicsPipeline graphicsPipeline = GraphicsPipeline.getPipeline();
        for (com.sun.glass.ui.Screen screen : com.sun.glass.ui.Screen.getScreens()) {
            screen.setAdapterOrdinal(graphicsPipeline.getAdapterOrdinal(screen));
        }
    }

    private static void notifyScreenListener(TKScreenConfigurationListener tKScreenConfigurationListener) {
        QuantumToolkit.assignScreensAdapters();
        tKScreenConfigurationListener.screenConfigurationChanged();
    }

    @Override
    public final Object getPrimaryScreen() {
        return com.sun.glass.ui.Screen.getMainScreen();
    }

    @Override
    public final List<?> getScreens() {
        return com.sun.glass.ui.Screen.getScreens();
    }

    @Override
    public final ScreenConfigurationAccessor getScreenConfigurationAccessor() {
        return screenAccessor;
    }

    @Override
    public final PerformanceTracker getPerformanceTracker() {
        return this.perfTracker;
    }

    @Override
    public final PerformanceTracker createPerformanceTracker() {
        return new PerformanceTrackerImpl();
    }

    private float getMaxRenderScale() {
        if (this._maxPixelScale == 0.0f) {
            for (Object obj : ((Toolkit)this).getScreens()) {
                this._maxPixelScale = Math.max(this._maxPixelScale, ((com.sun.glass.ui.Screen)obj).getRecommendedOutputScaleX());
                this._maxPixelScale = Math.max(this._maxPixelScale, ((com.sun.glass.ui.Screen)obj).getRecommendedOutputScaleY());
            }
        }
        return this._maxPixelScale;
    }

    @Override
    public final ImageLoader loadImage(String string, double d2, double d3, boolean bl2, boolean bl3) {
        return new PrismImageLoader2(string, d2, d3, bl2, this.getMaxRenderScale(), bl3);
    }

    @Override
    public final ImageLoader loadImage(InputStream inputStream, double d2, double d3, boolean bl2, boolean bl3) {
        return new PrismImageLoader2(inputStream, d2, d3, bl2, bl3);
    }

    public final AbstractRemoteResource<? extends ImageLoader> loadImageAsync(AsyncOperationListener asyncOperationListener, String string, double d2, double d3, boolean bl2, boolean bl3) {
        return new PrismImageLoader2$AsyncImageLoader(asyncOperationListener, string, d2, d3, bl2, bl3);
    }

    @Override
    public final void defer(Runnable runnable) {
        if (!this.toolkitRunning.get()) {
            return;
        }
        Application.invokeLater(runnable);
    }

    @Override
    public final void exit() {
        ((Toolkit)this).checkFxUserThread();
        this.pulseTimer.stop();
        PaintCollector.getInstance().waitForRenderingToComplete();
        this.notifyShutdownHooks();
        QuantumToolkit.runWithRenderLock(() -> {
            Application application = Application.GetApplication();
            application.terminate();
            return null;
        });
        this.dispose();
        super.exit();
    }

    public final void dispose() {
        if (this.toolkitRunning.compareAndSet(true, false)) {
            this.pulseTimer.stop();
            this.renderer.stopRenderer();
            try {
                AccessController.doPrivileged(() -> {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                    return null;
                });
                return;
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    @Override
    public final boolean isForwardTraversalKey(KeyEvent keyEvent) {
        return keyEvent.getCode() == KeyCode.TAB && ((Event)keyEvent).getEventType() == KeyEvent.KEY_PRESSED && !keyEvent.isShiftDown();
    }

    @Override
    public final boolean isBackwardTraversalKey(KeyEvent keyEvent) {
        return keyEvent.getCode() == KeyCode.TAB && ((Event)keyEvent).getEventType() == KeyEvent.KEY_PRESSED && keyEvent.isShiftDown();
    }

    @Override
    public final Map<Object, Object> getContextMap() {
        return this.contextMap;
    }

    @Override
    public final int getRefreshRate() {
        if (pulseHZ == null) {
            return 60;
        }
        return pulseHZ;
    }

    @Override
    public final void setAnimationRunnable(DelayedRunnable delayedRunnable) {
        if (delayedRunnable != null) {
            this.animationRunning.set(true);
        }
        this.animationRunnable = delayedRunnable;
    }

    @Override
    public final void requestNextPulse() {
        this.nextPulseRequested.set(true);
    }

    @Override
    public final void waitFor(Toolkit$Task toolkit$Task) {
        if (toolkit$Task.isFinished()) {
            return;
        }
    }

    @Override
    protected final Object createColorPaint(Color color) {
        return new com.sun.prism.paint.Color((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getOpacity());
    }

    private com.sun.prism.paint.Color toPrismColor(Color color) {
        return (com.sun.prism.paint.Color)Toolkit.getPaintAccessor().getPlatformPaint(color);
    }

    private List<Stop> convertStops(List<javafx.scene.paint.Stop> object) {
        ArrayList<Stop> arrayList = new ArrayList<Stop>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            javafx.scene.paint.Stop stop = (javafx.scene.paint.Stop)object.next();
            arrayList.add(new Stop(this.toPrismColor(stop.getColor()), (float)stop.getOffset()));
        }
        return arrayList;
    }

    @Override
    protected final Object createLinearGradientPaint(javafx.scene.paint.LinearGradient linearGradient) {
        int n2 = 2;
        Object object = linearGradient.getCycleMethod();
        if (object == CycleMethod.NO_CYCLE) {
            n2 = 0;
        } else if (object == CycleMethod.REFLECT) {
            n2 = 1;
        }
        object = this.convertStops(linearGradient.getStops());
        return new LinearGradient((float)linearGradient.getStartX(), (float)linearGradient.getStartY(), (float)linearGradient.getEndX(), (float)linearGradient.getEndY(), null, linearGradient.isProportional(), n2, (List<Stop>)object);
    }

    @Override
    protected final Object createRadialGradientPaint(javafx.scene.paint.RadialGradient radialGradient) {
        float f2 = (float)radialGradient.getCenterX();
        float f3 = (float)radialGradient.getCenterY();
        float f4 = (float)radialGradient.getFocusAngle();
        float f5 = (float)radialGradient.getFocusDistance();
        int n2 = radialGradient.getCycleMethod() == CycleMethod.NO_CYCLE ? 0 : (radialGradient.getCycleMethod() == CycleMethod.REFLECT ? 1 : 2);
        List<Stop> list = this.convertStops(radialGradient.getStops());
        return new RadialGradient(f2, f3, f4, f5, (float)radialGradient.getRadius(), null, radialGradient.isProportional(), n2, list);
    }

    @Override
    protected final Object createImagePatternPaint(ImagePattern imagePattern) {
        if (imagePattern.getImage() == null) {
            return com.sun.prism.paint.Color.TRANSPARENT;
        }
        return new com.sun.prism.paint.ImagePattern((com.sun.prism.Image)Toolkit.getImageAccessor().getPlatformImage(imagePattern.getImage()), (float)imagePattern.getX(), (float)imagePattern.getY(), (float)imagePattern.getWidth(), (float)imagePattern.getHeight(), imagePattern.isProportional(), Toolkit.getPaintAccessor().isMutable(imagePattern));
    }

    private void initStroke(StrokeType strokeType, double d2, StrokeLineCap strokeLineCap, StrokeLineJoin strokeLineJoin, float f2, float[] fArray, float f3) {
        int n2 = strokeType == StrokeType.CENTERED ? 0 : (strokeType == StrokeType.INSIDE ? 1 : 2);
        int n3 = strokeLineCap == StrokeLineCap.BUTT ? 0 : (strokeLineCap == StrokeLineCap.SQUARE ? 2 : 1);
        int n4 = strokeLineJoin == StrokeLineJoin.BEVEL ? 2 : (strokeLineJoin == StrokeLineJoin.MITER ? 0 : 1);
        tmpStroke.set(n2, (float)d2, n3, n4, f2);
        if (fArray != null && fArray.length > 0) {
            tmpStroke.set(fArray, f3);
            return;
        }
        tmpStroke.set((float[])null, 0.0f);
    }

    @Override
    public final void accumulateStrokeBounds(Shape shape, float[] fArray, StrokeType strokeType, double d2, StrokeLineCap strokeLineCap, StrokeLineJoin strokeLineJoin, float f2, BaseTransform baseTransform) {
        this.initStroke(strokeType, d2, strokeLineCap, strokeLineJoin, f2, null, 0.0f);
        if (baseTransform.isTranslateOrIdentity()) {
            tmpStroke.accumulateShapeBounds(fArray, shape, baseTransform);
            return;
        }
        Shape.accumulate(fArray, tmpStroke.createStrokedShape(shape), baseTransform);
    }

    @Override
    public final boolean strokeContains(Shape shape, double d2, double d3, StrokeType strokeType, double d4, StrokeLineCap strokeLineCap, StrokeLineJoin strokeLineJoin, float f2) {
        this.initStroke(strokeType, d4, strokeLineCap, strokeLineJoin, f2, null, 0.0f);
        return tmpStroke.createStrokedShape(shape).contains((float)d2, (float)d3);
    }

    @Override
    public final Shape createStrokedShape(Shape shape, StrokeType strokeType, double d2, StrokeLineCap strokeLineCap, StrokeLineJoin strokeLineJoin, float f2, float[] fArray, float f3) {
        this.initStroke(strokeType, d2, strokeLineCap, strokeLineJoin, f2, fArray, f3);
        return tmpStroke.createStrokedShape(shape);
    }

    @Override
    public final Dimension2D getBestCursorSize(int n2, int n3) {
        return CursorUtils.getBestCursorSize(n2, n3);
    }

    @Override
    public final int getMaximumCursorColors() {
        return 2;
    }

    @Override
    public final int getKeyCodeForChar(String string) {
        if (string.length() == 1) {
            return com.sun.glass.events.KeyEvent.getKeyCodeForChar(string.charAt(0));
        }
        return 0;
    }

    @Override
    public final PathElement[] convertShapeToFXPath(Object object) {
        if (object == null) {
            return new PathElement[0];
        }
        ArrayList<MoveTo> arrayList = new ArrayList<MoveTo>();
        object = (Shape)object;
        object = ((Shape)object).getPathIterator(null);
        object = new PathIteratorHelper((PathIterator)object);
        PathIteratorHelper$Struct pathIteratorHelper$Struct = new PathIteratorHelper$Struct();
        while (!((PathIteratorHelper)object).isDone()) {
            PathElement pathElement;
            ((PathIteratorHelper)object).getWindingRule();
            int n2 = ((PathIteratorHelper)object).currentSegment(pathIteratorHelper$Struct);
            if (n2 == 0) {
                pathElement = new MoveTo(pathIteratorHelper$Struct.f0, pathIteratorHelper$Struct.f1);
            } else if (n2 == 1) {
                pathElement = new LineTo(pathIteratorHelper$Struct.f0, pathIteratorHelper$Struct.f1);
            } else if (n2 == 2) {
                pathElement = new QuadCurveTo(pathIteratorHelper$Struct.f0, pathIteratorHelper$Struct.f1, pathIteratorHelper$Struct.f2, pathIteratorHelper$Struct.f3);
            } else if (n2 == 3) {
                pathElement = new CubicCurveTo(pathIteratorHelper$Struct.f0, pathIteratorHelper$Struct.f1, pathIteratorHelper$Struct.f2, pathIteratorHelper$Struct.f3, pathIteratorHelper$Struct.f4, pathIteratorHelper$Struct.f5);
            } else if (n2 == 4) {
                pathElement = new ClosePath();
            } else {
                throw new IllegalStateException("Invalid element type: " + n2);
            }
            ((PathIteratorHelper)object).next();
            arrayList.add((MoveTo)pathElement);
        }
        ArrayList<MoveTo> arrayList2 = arrayList;
        return arrayList2.toArray(new PathElement[arrayList2.size()]);
    }

    @Override
    public final Filterable toFilterable(Image image) {
        return PrImage.create((com.sun.prism.Image)Toolkit.getImageAccessor().getPlatformImage(image));
    }

    @Override
    public final FilterContext getFilterContext(Object object) {
        if (object == null || !(object instanceof com.sun.glass.ui.Screen)) {
            return PrFilterContext.getDefaultInstance();
        }
        object = (com.sun.glass.ui.Screen)object;
        return PrFilterContext.getInstance((com.sun.glass.ui.Screen)object);
    }

    @Override
    public final AbstractPrimaryTimer getPrimaryTimer() {
        return PrimaryTimer.getInstance();
    }

    @Override
    public final FontLoader getFontLoader() {
        return PrismFontLoader.getInstance();
    }

    @Override
    public final TextLayoutFactory getTextLayoutFactory() {
        return PrismTextLayoutFactory.getFactory();
    }

    @Override
    public final Object createSVGPathObject(SVGPath sVGPath) {
        int n2 = sVGPath.getFillRule() == FillRule.NON_ZERO ? 1 : 0;
        Path2D path2D = new Path2D(n2);
        path2D.appendSVGPath(sVGPath.getContent());
        return path2D;
    }

    @Override
    public final Path2D createSVGPath2D(SVGPath sVGPath) {
        int n2 = sVGPath.getFillRule() == FillRule.NON_ZERO ? 1 : 0;
        Path2D path2D = new Path2D(n2);
        path2D.appendSVGPath(sVGPath.getContent());
        return path2D;
    }

    @Override
    public final boolean imageContains(Object object, float f2, float f3) {
        if (object == null) {
            return false;
        }
        object = (com.sun.prism.Image)object;
        int n2 = (int)f2 + ((com.sun.prism.Image)object).getMinX();
        int n3 = (int)f3 + ((com.sun.prism.Image)object).getMinY();
        if (((com.sun.prism.Image)object).isOpaque()) {
            return true;
        }
        if (((com.sun.prism.Image)object).getPixelFormat() == PixelFormat.INT_ARGB_PRE) {
            IntBuffer intBuffer = (IntBuffer)((com.sun.prism.Image)object).getPixelBuffer();
            int n4 = n2 + n3 * ((com.sun.prism.Image)object).getRowLength();
            if (n4 >= intBuffer.limit()) {
                return false;
            }
            return (intBuffer.get(n4) & 0xFF000000) != 0;
        }
        if (((com.sun.prism.Image)object).getPixelFormat() == PixelFormat.BYTE_BGRA_PRE) {
            ByteBuffer byteBuffer = (ByteBuffer)((com.sun.prism.Image)object).getPixelBuffer();
            int n5 = n2 * ((com.sun.prism.Image)object).getBytesPerPixelUnit() + n3 * ((com.sun.prism.Image)object).getScanlineStride() + 3;
            if (n5 >= byteBuffer.limit()) {
                return false;
            }
            return (byteBuffer.get(n5) & 0xFF) != 0;
        }
        if (((com.sun.prism.Image)object).getPixelFormat() == PixelFormat.BYTE_ALPHA) {
            ByteBuffer byteBuffer = (ByteBuffer)((com.sun.prism.Image)object).getPixelBuffer();
            int n6 = n2 * ((com.sun.prism.Image)object).getBytesPerPixelUnit() + n3 * ((com.sun.prism.Image)object).getScanlineStride();
            if (n6 >= byteBuffer.limit()) {
                return false;
            }
            return (byteBuffer.get(n6) & 0xFF) != 0;
        }
        return true;
    }

    @Override
    public final boolean isNestedLoopRunning() {
        return Application.isNestedLoopRunning();
    }

    @Override
    public final boolean isSupported(ConditionalFeature conditionalFeature) {
        switch (conditionalFeature) {
            case SCENE3D: {
                return GraphicsPipeline.getPipeline().is3DSupported();
            }
            case EFFECT: {
                return GraphicsPipeline.getPipeline().isEffectSupported();
            }
            case SHAPE_CLIP: {
                return true;
            }
            case INPUT_METHOD: {
                return Application.GetApplication().supportsInputMethods();
            }
            case TRANSPARENT_WINDOW: {
                return Application.GetApplication().supportsTransparentWindows();
            }
            case UNIFIED_WINDOW: {
                return Application.GetApplication().supportsUnifiedWindows();
            }
            case TWO_LEVEL_FOCUS: {
                return Application.GetApplication().hasTwoLevelFocus();
            }
            case VIRTUAL_KEYBOARD: {
                return Application.GetApplication().hasVirtualKeyboard();
            }
            case INPUT_TOUCH: {
                return Application.GetApplication().hasTouch();
            }
            case INPUT_MULTITOUCH: {
                return Application.GetApplication().hasMultiTouch();
            }
            case INPUT_POINTER: {
                return Application.GetApplication().hasPointer();
            }
        }
        return false;
    }

    @Override
    public final boolean isMSAASupported() {
        return GraphicsPipeline.getPipeline().isMSAASupported();
    }

    private int toGlassKeyCode(KeyCode keyCode) {
        switch (keyCode) {
            case CAPS: {
                return 20;
            }
            case NUM_LOCK: {
                return 144;
            }
        }
        return 0;
    }

    @Override
    public final Optional<Boolean> isKeyLocked(KeyCode keyCode) {
        return Application.GetApplication().isKeyLocked(this.toGlassKeyCode(keyCode));
    }

    static TransferMode clipboardActionToTransferMode(int n2) {
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: 
            case 0x40000001: {
                return TransferMode.COPY;
            }
            case 2: 
            case 0x40000002: {
                return TransferMode.MOVE;
            }
            case 0x40000000: {
                return TransferMode.LINK;
            }
            case 0x4FFFFFFF: {
                return TransferMode.COPY;
            }
        }
        return null;
    }

    @Override
    public final TKClipboard getSystemClipboard() {
        if (this.clipboard == null) {
            this.clipboard = QuantumClipboard.getClipboardInstance(new ClipboardAssistance("SYSTEM"));
        }
        return this.clipboard;
    }

    @Override
    public final TKSystemMenu getSystemMenu() {
        return this.systemMenu;
    }

    @Override
    public final TKClipboard getNamedClipboard(String string) {
        return null;
    }

    @Override
    public final void startDrag(TKScene object, Set<TransferMode> set, TKDragSourceListener tKDragSourceListener, Dragboard dragboard) {
        if (dragboard == null) {
            throw new IllegalArgumentException("dragboard should not be null");
        }
        object = (GlassScene)object;
        ((GlassScene)object).setTKDragSourceListener(tKDragSourceListener);
        object = (QuantumClipboard)DragboardHelper.getPeer(dragboard);
        ((QuantumClipboard)object).setSupportedTransferMode(set);
        ((QuantumClipboard)object).flush();
        ((QuantumClipboard)object).close();
    }

    @Override
    public final void enableDrop(TKScene tKScene, TKDropTargetListener tKDropTargetListener) {
        assert (tKScene instanceof GlassScene);
        tKScene = (GlassScene)tKScene;
        ((GlassScene)tKScene).setTKDropTargetListener(tKDropTargetListener);
    }

    @Override
    public final void registerDragGestureListener(TKScene tKScene, Set<TransferMode> set, TKDragGestureListener tKDragGestureListener) {
        assert (tKScene instanceof GlassScene);
        tKScene = (GlassScene)tKScene;
        ((GlassScene)tKScene).setTKDragGestureListener(tKDragGestureListener);
    }

    @Override
    public final void installInputMethodRequests(TKScene tKScene, InputMethodRequests inputMethodRequests) {
        assert (tKScene instanceof GlassScene);
        tKScene = (GlassScene)tKScene;
        ((GlassScene)tKScene).setInputMethodRequests(inputMethodRequests);
    }

    @Override
    public final ImageLoader loadPlatformImage(Object object) {
        if (object instanceof QuantumToolkit$QuantumImage) {
            return (QuantumToolkit$QuantumImage)object;
        }
        if (object instanceof com.sun.prism.Image) {
            return new QuantumToolkit$QuantumImage((com.sun.prism.Image)object);
        }
        if (object instanceof PixelBuffer) {
            return new QuantumToolkit$QuantumImage((PixelBuffer)object);
        }
        throw new UnsupportedOperationException("unsupported class for loadPlatformImage");
    }

    @Override
    public final PlatformImage createPlatformImage(int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 * n3 << 2);
        return com.sun.prism.Image.fromByteBgraPreData(byteBuffer, n2, n3);
    }

    @Override
    public final Object renderToImage(Toolkit$ImageRenderingContext object) {
        Object object2 = ((Toolkit$ImageRenderingContext)object).platformImage;
        Toolkit$ImageRenderingContext toolkit$ImageRenderingContext = object;
        object = ((Toolkit$ImageRenderingContext)object).platformPaint instanceof Paint ? (Paint)((Toolkit$ImageRenderingContext)object).platformPaint : null;
        object = new RenderJob(new QuantumToolkit$5(this, (Paint)object, toolkit$ImageRenderingContext));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ((RenderJob)object).setCompletionListener(renderJob -> countDownLatch.countDown());
        ((Toolkit)this).addRenderJob((RenderJob)object);
        while (true) {
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                object = interruptedException;
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
        object = toolkit$ImageRenderingContext.platformImage;
        toolkit$ImageRenderingContext.platformImage = object2;
        return object;
    }

    @Override
    public final CommonDialogs$FileChooserResult showFileChooser(TKStage object, String string, File file, String string2, FileChooserType fileChooserType, List<FileChooser$ExtensionFilter> list, FileChooser$ExtensionFilter fileChooser$ExtensionFilter) {
        WindowStage windowStage = null;
        try {
            windowStage = this.blockOwnerStage((TKStage)object);
            object = CommonDialogs.showFileChooser(object instanceof WindowStage ? ((WindowStage)object).getPlatformWindow() : null, file, string2, string, fileChooserType == FileChooserType.SAVE ? 1 : 0, fileChooserType == FileChooserType.OPEN_MULTIPLE, QuantumToolkit.convertExtensionFilters(list), list.indexOf(fileChooser$ExtensionFilter));
            return object;
        }
        finally {
            if (windowStage != null) {
                windowStage.setEnabled(true);
            }
        }
    }

    @Override
    public final File showDirectoryChooser(TKStage object, String string, File file) {
        WindowStage windowStage = null;
        try {
            windowStage = this.blockOwnerStage((TKStage)object);
            object = CommonDialogs.showFolderChooser(object instanceof WindowStage ? ((WindowStage)object).getPlatformWindow() : null, file, string);
            return object;
        }
        finally {
            if (windowStage != null) {
                windowStage.setEnabled(true);
            }
        }
    }

    private WindowStage blockOwnerStage(TKStage tKStage) {
        if (tKStage instanceof WindowStage && (tKStage = ((WindowStage)tKStage).getOwner()) instanceof WindowStage) {
            tKStage = (WindowStage)tKStage;
            ((WindowStage)tKStage).setEnabled(false);
            return tKStage;
        }
        return null;
    }

    private static List<CommonDialogs$ExtensionFilter> convertExtensionFilters(List<FileChooser$ExtensionFilter> object) {
        CommonDialogs$ExtensionFilter[] commonDialogs$ExtensionFilterArray = new CommonDialogs$ExtensionFilter[object.size()];
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            FileChooser$ExtensionFilter fileChooser$ExtensionFilter = (FileChooser$ExtensionFilter)object.next();
            commonDialogs$ExtensionFilterArray[n2++] = new CommonDialogs$ExtensionFilter(fileChooser$ExtensionFilter.getDescription(), fileChooser$ExtensionFilter.getExtensions());
        }
        return Arrays.asList(commonDialogs$ExtensionFilterArray);
    }

    @Override
    public final long getMultiClickTime() {
        return View.getMultiClickTime();
    }

    @Override
    public final int getMultiClickMaxX() {
        return View.getMultiClickMaxX();
    }

    @Override
    public final int getMultiClickMaxY() {
        return View.getMultiClickMaxY();
    }

    @Override
    public final String getThemeName() {
        return Application.GetApplication().getHighContrastTheme();
    }

    @Override
    public final GlassRobot createRobot() {
        return Application.GetApplication().createRobot();
    }
}

