/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.tk.quantum.SwipeGestureRecognizer;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer$CenterComputer;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer$SwipeRecognitionState;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer$TouchPointTracker;
import java.util.HashMap;
import java.util.Map;
import javafx.event.EventType;
import javafx.scene.input.SwipeEvent;

class SwipeGestureRecognizer$MultiTouchTracker {
    SwipeGestureRecognizer$SwipeRecognitionState state = SwipeGestureRecognizer$SwipeRecognitionState.IDLE;
    Map<Long, SwipeGestureRecognizer$TouchPointTracker> trackers = new HashMap<Long, SwipeGestureRecognizer$TouchPointTracker>();
    SwipeGestureRecognizer$CenterComputer cc = new SwipeGestureRecognizer$CenterComputer();
    int modifiers;
    boolean direct;
    private int touchCount;
    private int currentTouchCount;
    private EventType<SwipeEvent> type;
    final /* synthetic */ SwipeGestureRecognizer this$0;

    private SwipeGestureRecognizer$MultiTouchTracker(SwipeGestureRecognizer swipeGestureRecognizer) {
        this.this$0 = swipeGestureRecognizer;
    }

    public void params(int n2, boolean bl2) {
        this.modifiers = n2;
        this.direct = bl2;
    }

    public void pressed(long l2, long l3, int n2, int n3, int n4, int n5) {
        ++this.currentTouchCount;
        switch (this.state) {
            case IDLE: {
                this.currentTouchCount = 1;
                this.state = SwipeGestureRecognizer$SwipeRecognitionState.ADDING;
            }
            case ADDING: {
                SwipeGestureRecognizer$TouchPointTracker swipeGestureRecognizer$TouchPointTracker = new SwipeGestureRecognizer$TouchPointTracker();
                swipeGestureRecognizer$TouchPointTracker.start(l3, n2, n3, n4, n5);
                this.trackers.put(l2, swipeGestureRecognizer$TouchPointTracker);
                return;
            }
            case REMOVING: {
                this.state = SwipeGestureRecognizer$SwipeRecognitionState.FAILURE;
            }
        }
    }

    public void released(long l2, long l3, int n2, int n3, int n4, int n5) {
        if (this.state != SwipeGestureRecognizer$SwipeRecognitionState.FAILURE) {
            SwipeGestureRecognizer$TouchPointTracker swipeGestureRecognizer$TouchPointTracker = this.trackers.get(l2);
            if (swipeGestureRecognizer$TouchPointTracker == null) {
                this.state = SwipeGestureRecognizer$SwipeRecognitionState.FAILURE;
                throw new RuntimeException("Error in swipe gesture recognition: released unknown touch point");
            }
            swipeGestureRecognizer$TouchPointTracker.end(l3, n2, n3, n4, n5);
            this.cc.add(swipeGestureRecognizer$TouchPointTracker.beginX, swipeGestureRecognizer$TouchPointTracker.beginY, swipeGestureRecognizer$TouchPointTracker.beginAbsX, swipeGestureRecognizer$TouchPointTracker.beginAbsY);
            this.cc.add(swipeGestureRecognizer$TouchPointTracker.endX, swipeGestureRecognizer$TouchPointTracker.endY, swipeGestureRecognizer$TouchPointTracker.endAbsX, swipeGestureRecognizer$TouchPointTracker.endAbsY);
            EventType<SwipeEvent> eventType = this.this$0.calcSwipeType(swipeGestureRecognizer$TouchPointTracker);
            switch (this.state) {
                case IDLE: {
                    this.reset();
                    throw new RuntimeException("Error in swipe gesture recognition: released touch point outside of gesture");
                }
                case ADDING: {
                    this.state = SwipeGestureRecognizer$SwipeRecognitionState.REMOVING;
                    this.touchCount = this.currentTouchCount;
                    this.type = eventType;
                    break;
                }
                case REMOVING: {
                    if (this.type == eventType) break;
                    this.state = SwipeGestureRecognizer$SwipeRecognitionState.FAILURE;
                }
            }
            this.trackers.remove(l2);
        }
        --this.currentTouchCount;
        if (this.currentTouchCount == 0) {
            if (this.state == SwipeGestureRecognizer$SwipeRecognitionState.REMOVING) {
                this.this$0.handleSwipeType(this.type, this.cc, this.touchCount, this.modifiers, this.direct);
            }
            this.state = SwipeGestureRecognizer$SwipeRecognitionState.IDLE;
            this.reset();
        }
    }

    public void progress(long l2, long l3, int n2, int n3) {
        if (this.state == SwipeGestureRecognizer$SwipeRecognitionState.FAILURE) {
            return;
        }
        SwipeGestureRecognizer$TouchPointTracker swipeGestureRecognizer$TouchPointTracker = this.trackers.get(l2);
        if (swipeGestureRecognizer$TouchPointTracker == null) {
            this.state = SwipeGestureRecognizer$SwipeRecognitionState.FAILURE;
            throw new RuntimeException("Error in swipe gesture recognition: reported unknown touch point");
        }
        swipeGestureRecognizer$TouchPointTracker.progress(l3, n2, n3);
    }

    void reset() {
        this.trackers.clear();
        this.cc.reset();
        this.state = SwipeGestureRecognizer$SwipeRecognitionState.IDLE;
    }
}

