/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.javafx.FXPermissions;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.iio.common.PushbroomScaler;
import com.sun.javafx.iio.common.ScalerFactory;
import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.GlassSystemMenu;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler;
import com.sun.javafx.tk.quantum.OverlayWarning;
import com.sun.javafx.tk.quantum.PixelUtils;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.scene.input.KeyCombination;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class WindowStage
extends GlassStage {
    protected com.sun.glass.ui.Window platformWindow;
    protected Stage fxStage;
    private StageStyle style;
    private GlassStage owner = null;
    private Modality modality = Modality.NONE;
    private final boolean securityDialog;
    private OverlayWarning warning = null;
    private boolean rtl = false;
    private boolean transparent = false;
    private boolean isPrimaryStage = false;
    private boolean isPopupStage = false;
    private boolean isInFullScreen = false;
    private boolean isAlwaysOnTop = false;
    private boolean inAllowedEventHandler = false;
    private static List<WindowStage> activeWindows = new LinkedList<WindowStage>();
    private static Map<com.sun.glass.ui.Window, WindowStage> platformWindows = new HashMap<com.sun.glass.ui.Window, WindowStage>();
    private static final Locale LOCALE = Locale.getDefault();
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle(WindowStage.class.getPackage().getName() + ".QuantumMessagesBundle", LOCALE);
    private boolean fullScreenFromUserEvent = false;
    private KeyCombination savedFullScreenExitKey = null;
    private boolean isClosePostponed = false;
    private com.sun.glass.ui.Window deadWindow = null;

    public WindowStage(Window window, boolean bl2, StageStyle stageStyle, Modality modality, TKStage tKStage) {
        this.style = stageStyle;
        this.owner = (GlassStage)tKStage;
        this.modality = modality;
        this.securityDialog = bl2;
        this.fxStage = window instanceof Stage ? (Stage)window : null;
        boolean bl3 = this.transparent = stageStyle == StageStyle.TRANSPARENT;
        if (tKStage == null && this.modality == Modality.WINDOW_MODAL) {
            this.modality = Modality.NONE;
        }
    }

    final void setIsPrimary() {
        this.isPrimaryStage = true;
    }

    final void setIsPopup() {
        this.isPopupStage = true;
    }

    final boolean isSecurityDialog() {
        return this.securityDialog;
    }

    public final WindowStage init(GlassSystemMenu glassSystemMenu) {
        this.initPlatformWindow();
        this.platformWindow.setEventHandler(new GlassWindowEventHandler(this));
        if (glassSystemMenu.isSupported()) {
            glassSystemMenu.createMenuBar();
            this.platformWindow.setMenuBar(glassSystemMenu.getMenuBar());
        }
        return this;
    }

    private void initPlatformWindow() {
        if (this.platformWindow == null) {
            int n2;
            Object object = Application.GetApplication();
            com.sun.glass.ui.Window window = null;
            if (this.owner instanceof WindowStage) {
                window = ((WindowStage)this.owner).platformWindow;
            }
            boolean bl2 = false;
            boolean bl3 = true;
            int n3 = n2 = this.rtl ? 128 : 0;
            if (this.isPopupStage) {
                n2 |= 8;
                if (this.style == StageStyle.TRANSPARENT) {
                    n2 |= 2;
                }
                bl3 = false;
            } else {
                switch (this.style) {
                    case UNIFIED: {
                        if (((Application)object).supportsUnifiedWindows()) {
                            n2 |= 0x100;
                        }
                    }
                    case DECORATED: {
                        n2 |= 0x71;
                        if (window != null || this.modality != Modality.NONE) {
                            n2 &= 0xFFFFFF9F;
                        }
                        bl2 = true;
                        break;
                    }
                    case UTILITY: {
                        n2 |= 0x15;
                        break;
                    }
                    default: {
                        n2 |= (this.transparent ? 2 : 0) | 0x10;
                    }
                }
            }
            if (this.modality != Modality.NONE) {
                n2 |= 0x200;
            }
            this.platformWindow = ((Application)object).createWindow(window, Screen.getMainScreen(), n2);
            this.platformWindow.setResizable(bl2);
            this.platformWindow.setFocusable(bl3);
            if (this.securityDialog) {
                this.platformWindow.setLevel(2);
            }
            if (this.fxStage != null && this.fxStage.getScene() != null) {
                object = this.fxStage.getScene().getFill();
                if (object instanceof Color) {
                    object = (Color)object;
                    this.platformWindow.setBackground((float)((Color)object).getRed(), (float)((Color)object).getGreen(), (float)((Color)object).getBlue());
                } else if (object instanceof LinearGradient) {
                    object = (LinearGradient)object;
                    this.computeAndSetBackground(((LinearGradient)object).getStops());
                } else if (object instanceof RadialGradient) {
                    object = (RadialGradient)object;
                    this.computeAndSetBackground(((RadialGradient)object).getStops());
                }
            }
        }
        platformWindows.put(this.platformWindow, this);
    }

    private void computeAndSetBackground(List<Stop> object) {
        if (object.size() == 1) {
            Color color = object.get(0).getColor();
            this.platformWindow.setBackground((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue());
            return;
        }
        if (object.size() > 1) {
            Color color = object.get(0).getColor();
            List<Stop> list = object;
            object = list.get(list.size() - 1).getColor();
            this.platformWindow.setBackground((float)((color.getRed() + ((Color)object).getRed()) / 2.0), (float)((color.getGreen() + ((Color)object).getGreen()) / 2.0), (float)((color.getBlue() + ((Color)object).getBlue()) / 2.0));
        }
    }

    public final com.sun.glass.ui.Window getPlatformWindow() {
        return this.platformWindow;
    }

    static WindowStage findWindowStage(com.sun.glass.ui.Window window) {
        return platformWindows.get(window);
    }

    protected GlassStage getOwner() {
        return this.owner;
    }

    protected ViewScene getViewScene() {
        return (ViewScene)this.getScene();
    }

    StageStyle getStyle() {
        return this.style;
    }

    @Override
    public TKScene createTKScene(boolean bl2, boolean bl3, AccessControlContext accessControlContext) {
        ViewScene viewScene = new ViewScene(bl2, bl3);
        viewScene.setSecurityContext(accessControlContext);
        return viewScene;
    }

    @Override
    public void setScene(TKScene object) {
        GlassScene glassScene = this.getScene();
        if (glassScene == object) {
            return;
        }
        this.exitFullScreen();
        super.setScene((TKScene)object);
        if (object != null) {
            object = this.getViewScene();
            View view = ((GlassScene)object).getPlatformView();
            QuantumToolkit.runWithRenderLock(() -> this.lambda$setScene$0(view, glassScene, (GlassScene)object));
            if (PlatformUtil.isAndroid()) {
                this.requestFocus();
            }
        } else {
            QuantumToolkit.runWithRenderLock(() -> {
                if (this.platformWindow != null) {
                    this.platformWindow.setView(null);
                }
                if (glassScene != null) {
                    glassScene.updateSceneState();
                }
                return null;
            });
        }
        if (glassScene != null) {
            object = ((ViewScene)glassScene).getPainter();
            QuantumRenderer.getInstance().disposePresentable(((ViewPainter)object).presentable);
        }
    }

    @Override
    public void setBounds(float f2, float f3, boolean bl2, boolean bl3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        if ((double)f10 > 0.0 || (double)f11 > 0.0) {
            ViewScene viewScene;
            if ((double)f10 > 0.0) {
                this.platformWindow.setRenderScaleX(f10);
            }
            if ((double)f11 > 0.0) {
                this.platformWindow.setRenderScaleY(f11);
            }
            if ((viewScene = this.getViewScene()) != null) {
                viewScene.updateSceneState();
                viewScene.entireSceneNeedsRepaint();
            }
        }
        if (bl2 || bl3 || f4 > 0.0f || f5 > 0.0f || f6 > 0.0f || f7 > 0.0f) {
            this.platformWindow.setBounds(f2, f3, bl2, bl3, f4, f5, f6, f7, f8, f9);
        }
    }

    @Override
    public float getPlatformScaleX() {
        return this.platformWindow.getPlatformScaleX();
    }

    @Override
    public float getPlatformScaleY() {
        return this.platformWindow.getPlatformScaleY();
    }

    @Override
    public float getOutputScaleX() {
        return this.platformWindow.getOutputScaleX();
    }

    @Override
    public float getOutputScaleY() {
        return this.platformWindow.getOutputScaleY();
    }

    @Override
    public void setMinimumSize(int n2, int n3) {
        n2 = (int)Math.ceil((float)n2 * this.getPlatformScaleX());
        n3 = (int)Math.ceil((float)n3 * this.getPlatformScaleY());
        this.platformWindow.setMinimumSize(n2, n3);
    }

    @Override
    public void setMaximumSize(int n2, int n3) {
        n2 = (int)Math.ceil((float)n2 * this.getPlatformScaleX());
        n3 = (int)Math.ceil((float)n3 * this.getPlatformScaleY());
        this.platformWindow.setMaximumSize(n2, n3);
    }

    static Image findBestImage(List object, int n2, int n3) {
        Object object2 = null;
        double d2 = 3.0;
        object = object.iterator();
        while (object.hasNext()) {
            double d3;
            double d4;
            double d5;
            double d6;
            Object object3 = object.next();
            if ((object3 = (Image)object3) == null || ((Image)object3).getPixelFormat() != PixelFormat.BYTE_RGB && ((Image)object3).getPixelFormat() != PixelFormat.BYTE_BGRA_PRE && ((Image)object3).getPixelFormat() != PixelFormat.BYTE_GRAY) continue;
            int n4 = ((Image)object3).getWidth();
            int n5 = ((Image)object3).getHeight();
            if (n4 <= 0 || n5 <= 0) continue;
            double d7 = Math.min((double)n2 / (double)n4, (double)n3 / (double)n5);
            if (d6 >= 2.0) {
                d7 = Math.floor(d7);
                n4 *= (int)d7;
                n5 *= (int)d7;
                d5 = 1.0 - 0.5 / d7;
            } else if (d7 >= 1.0) {
                d5 = 0.0;
            } else if (d7 >= 0.75) {
                n4 = n4 * 3 / 4;
                n5 = n5 * 3 / 4;
                d5 = 0.3;
            } else if (d7 >= 0.6666) {
                n4 = (n4 << 1) / 3;
                n5 = (n5 << 1) / 3;
                d5 = 0.33;
            } else {
                d4 = Math.ceil(1.0 / d7);
                double cfr_ignored_0 = 1.0 / d4;
                n4 = (int)Math.round((double)n4 / d4);
                n5 = (int)Math.round((double)n5 / d4);
                d5 = 1.0 - 1.0 / d4;
            }
            d4 = ((double)n2 - (double)n4) / (double)n2 + ((double)n3 - (double)n5) / (double)n3 + d5;
            if (d3 < d2) {
                d2 = d4;
                object2 = object3;
            }
            if (d4 != 0.0) continue;
        }
        return object2;
    }

    @Override
    public void setIcons(List object) {
        int n2 = 32;
        int n3 = 32;
        if (PlatformUtil.isMac()) {
            n2 = 128;
            n3 = 128;
        } else if (PlatformUtil.isWindows()) {
            n2 = 32;
            n3 = 32;
        } else if (PlatformUtil.isLinux()) {
            n2 = 128;
            n3 = 128;
        }
        if (object == null || object.size() <= 0) {
            this.platformWindow.setIcon(null);
            return;
        }
        if ((object = WindowStage.findBestImage((List)object, n3, n2)) == null) {
            return;
        }
        PushbroomScaler pushbroomScaler = ScalerFactory.createScaler(((Image)object).getWidth(), ((Image)object).getHeight(), ((Image)object).getBytesPerPixelUnit(), n3, n2, true);
        ByteBuffer byteBuffer = (ByteBuffer)((Image)object).getPixelBuffer();
        byte[] byArray = new byte[byteBuffer.limit()];
        int n4 = ((Image)object).getHeight();
        for (int i2 = 0; i2 < n4; ++i2) {
            byteBuffer.position(i2 * ((Image)object).getScanlineStride());
            byteBuffer.get(byArray, 0, ((Image)object).getScanlineStride());
            pushbroomScaler.putSourceScanline(byArray, 0);
        }
        byteBuffer.rewind();
        Image image = ((Image)object).iconify(pushbroomScaler.getDestination(), n3, n2);
        this.platformWindow.setIcon(PixelUtils.imageToPixels(image));
    }

    @Override
    public void setTitle(String string) {
        this.platformWindow.setTitle(string);
    }

    @Override
    public void setVisible(boolean bl2) {
        if (!bl2) {
            WindowStage.removeActiveWindow(this);
            if (this.modality == Modality.WINDOW_MODAL) {
                if (this.owner != null && this.owner instanceof WindowStage) {
                    ((WindowStage)this.owner).setEnabled(true);
                }
            } else if (this.modality == Modality.APPLICATION_MODAL) {
                this.windowsSetEnabled(true);
            }
            if (!this.isPopupStage && this.owner != null && this.owner instanceof WindowStage) {
                WindowStage windowStage = (WindowStage)this.owner;
                windowStage.requestToFront();
            }
        }
        QuantumToolkit.runWithRenderLock(() -> {
            if (this.platformWindow != null) {
                this.platformWindow.setVisible(bl2);
            }
            super.setVisible(bl2);
            return null;
        });
        if (bl2) {
            if (this.modality == Modality.WINDOW_MODAL) {
                if (this.owner != null && this.owner instanceof WindowStage) {
                    ((WindowStage)this.owner).setEnabled(false);
                }
            } else if (this.modality == Modality.APPLICATION_MODAL) {
                this.windowsSetEnabled(false);
            }
        }
        this.applyFullScreen();
    }

    @Override
    boolean isVisible() {
        return this.platformWindow.isVisible();
    }

    @Override
    public void setOpacity(float f2) {
        this.platformWindow.setAlpha(f2);
        GlassScene glassScene = this.getScene();
        if (glassScene != null) {
            glassScene.entireSceneNeedsRepaint();
        }
    }

    public boolean needsUpdateWindow() {
        return this.transparent && Application.GetApplication().shouldUpdateWindow();
    }

    @Override
    public void setIconified(boolean bl2) {
        if (this.platformWindow.isMinimized() == bl2) {
            return;
        }
        this.platformWindow.minimize(bl2);
    }

    @Override
    public void setMaximized(boolean bl2) {
        if (this.platformWindow.isMaximized() == bl2) {
            return;
        }
        this.platformWindow.maximize(bl2);
    }

    @Override
    public void setAlwaysOnTop(boolean bl2) {
        if (this.securityDialog) {
            return;
        }
        if (this.isAlwaysOnTop == bl2) {
            return;
        }
        if (bl2) {
            if (this.hasPermission(FXPermissions.SET_WINDOW_ALWAYS_ON_TOP_PERMISSION)) {
                this.platformWindow.setLevel(2);
            } else {
                bl2 = false;
                if (this.stageListener != null) {
                    this.stageListener.changedAlwaysOnTop(false);
                }
            }
        } else {
            this.platformWindow.setLevel(1);
        }
        this.isAlwaysOnTop = bl2;
    }

    @Override
    public void setResizable(boolean bl2) {
        this.platformWindow.setResizable(bl2);
    }

    boolean isTrustedFullScreen() {
        return this.hasPermission(FXPermissions.UNRESTRICTED_FULL_SCREEN_PERMISSION);
    }

    void exitFullScreen() {
        this.setFullScreen(false);
    }

    private boolean hasPermission(Permission permission) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(permission, this.getAccessControlContext());
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public final KeyCombination getSavedFullScreenExitKey() {
        return this.savedFullScreenExitKey;
    }

    private void applyFullScreen() {
        if (this.platformWindow == null) {
            return;
        }
        View view = this.platformWindow.getView();
        if (this.isVisible() && view != null && view.isInFullscreen() != this.isInFullScreen) {
            if (this.isInFullScreen) {
                boolean bl2 = this.isTrustedFullScreen();
                if (!bl2 && !this.fullScreenFromUserEvent) {
                    this.exitFullScreen();
                    this.fullscreenChanged(false);
                } else {
                    view.enterFullscreen(false, false, false);
                    if (this.warning != null && this.warning.inWarningTransition()) {
                        this.warning.setView(this.getViewScene());
                    } else {
                        boolean bl3 = true;
                        KeyCombination keyCombination = null;
                        String string = null;
                        if (bl2 && this.fxStage != null) {
                            keyCombination = this.fxStage.getFullScreenExitKeyCombination();
                            string = this.fxStage.getFullScreenExitHint();
                        }
                        KeyCombination keyCombination2 = this.savedFullScreenExitKey = keyCombination == null ? defaultFullScreenExitKeycombo : keyCombination;
                        if ("".equals(string) || this.savedFullScreenExitKey.equals(KeyCombination.NO_MATCH)) {
                            bl3 = false;
                        }
                        if (bl3 && string == null) {
                            if (keyCombination == null) {
                                string = RESOURCES.getString("OverlayWarningESC");
                            } else {
                                String string2 = RESOURCES.getString("OverlayWarningKey");
                                string = String.format(string2, this.savedFullScreenExitKey.toString());
                            }
                        }
                        if (bl3 && this.warning == null) {
                            this.setWarning(new OverlayWarning(this.getViewScene()));
                        }
                        if (bl3 && this.warning != null) {
                            this.warning.warn(string);
                        }
                    }
                }
            } else {
                if (this.warning != null) {
                    this.warning.cancel();
                    this.setWarning(null);
                }
                view.exitFullscreen(false);
            }
            this.fullScreenFromUserEvent = false;
            return;
        }
        if (!this.isVisible() && this.warning != null) {
            this.warning.cancel();
            this.setWarning(null);
        }
    }

    void setWarning(OverlayWarning overlayWarning) {
        this.warning = overlayWarning;
        this.getViewScene().synchroniseOverlayWarning();
    }

    OverlayWarning getWarning() {
        return this.warning;
    }

    @Override
    public void setFullScreen(boolean bl2) {
        if (this.isInFullScreen == bl2) {
            return;
        }
        if (this.isInAllowedEventHandler()) {
            this.fullScreenFromUserEvent = true;
        }
        GlassStage glassStage = (GlassStage)activeFSWindow.get();
        if (bl2 && glassStage != null) {
            glassStage.setFullScreen(false);
        }
        this.isInFullScreen = bl2;
        this.applyFullScreen();
        if (bl2) {
            activeFSWindow.set(this);
        }
    }

    void fullscreenChanged(boolean bl2) {
        if (!bl2) {
            if (activeFSWindow.compareAndSet(this, null)) {
                this.isInFullScreen = false;
            }
        } else {
            this.isInFullScreen = true;
            activeFSWindow.set(this);
        }
        AccessController.doPrivileged(() -> {
            if (this.stageListener != null) {
                this.stageListener.changedFullscreen(bl2);
            }
            return null;
        }, this.getAccessControlContext());
    }

    @Override
    public void toBack() {
        this.platformWindow.toBack();
    }

    @Override
    public void toFront() {
        this.platformWindow.requestFocus();
        this.platformWindow.toFront();
    }

    @Override
    public void postponeClose() {
        this.isClosePostponed = true;
    }

    @Override
    public void closePostponed() {
        if (this.deadWindow != null) {
            this.deadWindow.close();
            this.deadWindow = null;
        }
    }

    @Override
    public void close() {
        super.close();
        QuantumToolkit.runWithRenderLock(() -> {
            ViewScene viewScene;
            if (this.platformWindow != null) {
                platformWindows.remove(this.platformWindow);
                if (this.isClosePostponed) {
                    this.deadWindow = this.platformWindow;
                } else {
                    this.platformWindow.close();
                }
                this.platformWindow = null;
            }
            if ((viewScene = this.getViewScene()) != null) {
                viewScene.updateSceneState();
            }
            return null;
        });
    }

    void setPlatformWindowClosed() {
        if (this.platformWindow != null) {
            platformWindows.remove(this.platformWindow);
            this.platformWindow = null;
        }
    }

    static void addActiveWindow(WindowStage windowStage) {
        activeWindows.remove(windowStage);
        activeWindows.add(windowStage);
    }

    static void removeActiveWindow(WindowStage windowStage) {
        activeWindows.remove(windowStage);
    }

    final void handleFocusDisabled() {
        if (activeWindows.isEmpty()) {
            return;
        }
        List<WindowStage> list = activeWindows;
        WindowStage windowStage = list.get(list.size() - 1);
        windowStage.setIconified(false);
        windowStage.requestToFront();
        windowStage.requestFocus();
    }

    @Override
    public boolean grabFocus() {
        return this.platformWindow.grabFocus();
    }

    @Override
    public void ungrabFocus() {
        this.platformWindow.ungrabFocus();
    }

    @Override
    public void requestFocus() {
        this.platformWindow.requestFocus();
    }

    @Override
    public void requestFocus(FocusCause focusCause) {
        switch (focusCause) {
            case TRAVERSED_FORWARD: {
                this.platformWindow.requestFocus(543);
                return;
            }
            case TRAVERSED_BACKWARD: {
                this.platformWindow.requestFocus(544);
                return;
            }
            case ACTIVATED: {
                this.platformWindow.requestFocus(542);
                return;
            }
            case DEACTIVATED: {
                this.platformWindow.requestFocus(541);
            }
        }
    }

    @Override
    protected void setPlatformEnabled(boolean bl2) {
        super.setPlatformEnabled(bl2);
        if (this.platformWindow != null) {
            this.platformWindow.setEnabled(bl2);
        }
        if (bl2) {
            if (this.platformWindow != null && this.platformWindow.isEnabled() && this.modality == Modality.APPLICATION_MODAL) {
                this.requestToFront();
                return;
            }
        } else {
            WindowStage.removeActiveWindow(this);
        }
    }

    @Override
    public void setEnabled(boolean bl2) {
        if (this.owner != null && this.owner instanceof WindowStage) {
            ((WindowStage)this.owner).setEnabled(bl2);
        }
        if (bl2 && (this.platformWindow == null || this.platformWindow.isClosed())) {
            return;
        }
        this.setPlatformEnabled(bl2);
    }

    @Override
    public long getRawHandle() {
        return this.platformWindow.getRawHandle();
    }

    protected void requestToFront() {
        if (this.platformWindow != null) {
            this.platformWindow.toFront();
            this.platformWindow.requestFocus();
        }
    }

    public void setInAllowedEventHandler(boolean bl2) {
        this.inAllowedEventHandler = bl2;
    }

    private boolean isInAllowedEventHandler() {
        return this.inAllowedEventHandler;
    }

    @Override
    public void requestInput(String string, int n2, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15) {
        this.platformWindow.requestInput(string, n2, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15);
    }

    @Override
    public void releaseInput() {
        this.platformWindow.releaseInput();
    }

    @Override
    public void setRTL(boolean bl2) {
        this.rtl = bl2;
    }

    private /* synthetic */ Object lambda$setScene$0(View view, GlassScene glassScene, GlassScene glassScene2) {
        this.platformWindow.setView(view);
        if (glassScene != null) {
            glassScene.updateSceneState();
        }
        glassScene2.updateSceneState();
        return null;
    }
}

