/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheByte;
import com.sun.marlin.ArrayCacheConst$BucketStats;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class ArrayCacheByte$Bucket {
    private int tail = 0;
    private final int arraySize;
    private final byte[][] arrays;
    private final ArrayCacheConst$BucketStats stats;

    ArrayCacheByte$Bucket(int n2, int n3, ArrayCacheConst$BucketStats bucketStats) {
        this.arraySize = n2;
        this.stats = bucketStats;
        this.arrays = new byte[n3][];
    }

    final byte[] getArray() {
        if (MarlinConst.DO_STATS) {
            ++this.stats.getOp;
        }
        if (this.tail != 0) {
            byte[] byArray = this.arrays[--this.tail];
            this.arrays[this.tail] = null;
            return byArray;
        }
        if (MarlinConst.DO_STATS) {
            ++this.stats.createOp;
        }
        return ArrayCacheByte.createArray(this.arraySize);
    }

    final void putArray(byte[] byArray) {
        if (MarlinConst.DO_CHECKS && byArray.length != this.arraySize) {
            MarlinUtils.logInfo("ArrayCacheByte(Dirty): bad length = " + byArray.length);
            return;
        }
        if (MarlinConst.DO_STATS) {
            ++this.stats.returnOp;
        }
        if (this.arrays.length > this.tail) {
            this.arrays[this.tail++] = byArray;
            if (MarlinConst.DO_STATS) {
                this.stats.updateMaxSize(this.tail);
                return;
            }
        } else if (MarlinConst.DO_CHECKS) {
            MarlinUtils.logInfo("ArrayCacheByte(Dirty): array capacity exceeded !");
        }
    }
}

