/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheByte;
import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class ArrayCacheByte$Reference {
    final byte[] initial;
    private final ArrayCacheByte cache;

    ArrayCacheByte$Reference(ArrayCacheByte arrayCacheByte, int n2) {
        this.cache = arrayCacheByte;
        this.initial = ArrayCacheByte.createArray(n2);
        if (MarlinConst.DO_STATS) {
            arrayCacheByte.stats.totalInitial += (long)n2;
        }
    }

    final byte[] getArray(int n2) {
        if (n2 <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            return this.cache.getCacheBucket(n2).getArray();
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.oversize;
        }
        if (MarlinConst.DO_LOG_OVERSIZE) {
            MarlinUtils.logInfo("ArrayCacheByte(Dirty): getArray[oversize]: length=\t" + n2);
        }
        return ArrayCacheByte.createArray(n2);
    }

    final byte[] widenArray(byte[] byArray, int n2, int n3) {
        int n4 = byArray.length;
        if (MarlinConst.DO_CHECKS && n4 >= n3) {
            return byArray;
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.resize;
        }
        byte[] byArray2 = this.getArray(ArrayCacheConst.getNewSize(n2, n3));
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        this.putArray(byArray, 0, n2);
        if (MarlinConst.DO_LOG_WIDEN_ARRAY) {
            MarlinUtils.logInfo("ArrayCacheByte(Dirty): widenArray[" + byArray2.length + "]: usedSize=\t" + n2 + "\tlength=\t" + n4 + "\tneeded length=\t" + n3);
        }
        return byArray2;
    }

    final boolean doCleanRef(byte[] byArray) {
        return byArray != this.initial;
    }

    final byte[] putArray(byte[] byArray) {
        return this.putArray(byArray, 0, byArray.length);
    }

    final byte[] putArray(byte[] byArray, int n2, int n3) {
        if (byArray.length <= ArrayCacheConst.MAX_ARRAY_SIZE && byArray != this.initial) {
            this.cache.getCacheBucket(byArray.length).putArray(byArray);
        }
        return this.initial;
    }
}

