/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheByte$Bucket;
import com.sun.marlin.ArrayCacheByte$Reference;
import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.ArrayCacheConst$CacheStats;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public final class ArrayCacheByte {
    private final int bucketCapacity;
    private WeakReference<ArrayCacheByte$Bucket[]> refBuckets = null;
    final ArrayCacheConst$CacheStats stats;

    ArrayCacheByte(int n2) {
        this.bucketCapacity = n2;
        this.stats = MarlinConst.DO_STATS ? new ArrayCacheConst$CacheStats("ArrayCacheByte(Dirty)") : null;
    }

    final ArrayCacheByte$Bucket getCacheBucket(int n2) {
        n2 = ArrayCacheConst.getBucket(n2);
        return this.getBuckets()[n2];
    }

    private ArrayCacheByte$Bucket[] getBuckets() {
        ArrayCacheByte$Bucket[] arrayCacheByte$BucketArray = this.refBuckets != null ? (ArrayCacheByte$Bucket[])this.refBuckets.get() : null;
        if (arrayCacheByte$BucketArray == null) {
            arrayCacheByte$BucketArray = new ArrayCacheByte$Bucket[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                arrayCacheByte$BucketArray[i2] = new ArrayCacheByte$Bucket(ArrayCacheConst.ARRAY_SIZES[i2], this.bucketCapacity, MarlinConst.DO_STATS ? this.stats.bucketStats[i2] : null);
            }
            this.refBuckets = new WeakReference<ArrayCacheByte$Bucket[]>(arrayCacheByte$BucketArray);
        }
        return arrayCacheByte$BucketArray;
    }

    final ArrayCacheByte$Reference createRef(int n2) {
        return new ArrayCacheByte$Reference(this, n2);
    }

    static byte[] createArray(int n2) {
        return new byte[n2];
    }

    static void fill(byte[] byArray, int n2, int n3, byte by2) {
        Arrays.fill(byArray, n2, n3, by2);
        if (MarlinConst.DO_CHECKS) {
            ArrayCacheByte.check(byArray, n2, n3, by2);
        }
    }

    static void check(byte[] byArray, int n2, int n3, byte by2) {
        if (MarlinConst.DO_CHECKS) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] == by2) continue;
                MarlinUtils.logException("Invalid value at: " + i2 + " = " + byArray[i2] + " from: " + n2 + " to: " + n3 + "\n" + Arrays.toString(byArray), new Throwable());
                Arrays.fill(byArray, by2);
                return;
            }
        }
    }
}

