/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.ArrayCacheConst$CacheStats;
import com.sun.marlin.ArrayCacheDouble$Bucket;
import com.sun.marlin.ArrayCacheDouble$Reference;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public final class ArrayCacheDouble {
    private final int bucketCapacity;
    private WeakReference<ArrayCacheDouble$Bucket[]> refBuckets = null;
    final ArrayCacheConst$CacheStats stats;

    ArrayCacheDouble(int n2) {
        this.bucketCapacity = n2;
        this.stats = MarlinConst.DO_STATS ? new ArrayCacheConst$CacheStats("ArrayCacheDouble(Dirty)") : null;
    }

    final ArrayCacheDouble$Bucket getCacheBucket(int n2) {
        n2 = ArrayCacheConst.getBucket(n2);
        return this.getBuckets()[n2];
    }

    private ArrayCacheDouble$Bucket[] getBuckets() {
        ArrayCacheDouble$Bucket[] arrayCacheDouble$BucketArray = this.refBuckets != null ? (ArrayCacheDouble$Bucket[])this.refBuckets.get() : null;
        if (arrayCacheDouble$BucketArray == null) {
            arrayCacheDouble$BucketArray = new ArrayCacheDouble$Bucket[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                arrayCacheDouble$BucketArray[i2] = new ArrayCacheDouble$Bucket(ArrayCacheConst.ARRAY_SIZES[i2], this.bucketCapacity, MarlinConst.DO_STATS ? this.stats.bucketStats[i2] : null);
            }
            this.refBuckets = new WeakReference<ArrayCacheDouble$Bucket[]>(arrayCacheDouble$BucketArray);
        }
        return arrayCacheDouble$BucketArray;
    }

    final ArrayCacheDouble$Reference createRef(int n2) {
        return new ArrayCacheDouble$Reference(this, n2);
    }

    static double[] createArray(int n2) {
        return new double[n2];
    }

    static void fill(double[] dArray, int n2, int n3, double d2) {
        Arrays.fill(dArray, n2, n3, d2);
        if (MarlinConst.DO_CHECKS) {
            ArrayCacheDouble.check(dArray, n2, n3, d2);
        }
    }

    static void check(double[] dArray, int n2, int n3, double d2) {
        if (MarlinConst.DO_CHECKS) {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                if (dArray[i2] == d2) continue;
                MarlinUtils.logException("Invalid value at: " + i2 + " = " + dArray[i2] + " from: " + n2 + " to: " + n3 + "\n" + Arrays.toString(dArray), new Throwable());
                Arrays.fill(dArray, d2);
                return;
            }
        }
    }
}

