/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.ArrayCacheIntClean;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;

final class ArrayCacheIntClean$Reference {
    final int[] initial;
    private final ArrayCacheIntClean cache;

    ArrayCacheIntClean$Reference(ArrayCacheIntClean arrayCacheIntClean, int n2) {
        this.cache = arrayCacheIntClean;
        this.initial = ArrayCacheIntClean.createArray(n2);
        if (MarlinConst.DO_STATS) {
            arrayCacheIntClean.stats.totalInitial += (long)n2;
        }
    }

    final int[] getArray(int n2) {
        if (n2 <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            return this.cache.getCacheBucket(n2).getArray();
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.oversize;
        }
        if (MarlinConst.DO_LOG_OVERSIZE) {
            MarlinUtils.logInfo("ArrayCacheInt(Clean): getArray[oversize]: length=\t" + n2);
        }
        return ArrayCacheIntClean.createArray(n2);
    }

    final int[] widenArray(int[] nArray, int n2, int n3) {
        int n4 = nArray.length;
        if (MarlinConst.DO_CHECKS && n4 >= n3) {
            return nArray;
        }
        if (MarlinConst.DO_STATS) {
            ++this.cache.stats.resize;
        }
        int[] nArray2 = this.getArray(ArrayCacheConst.getNewSize(n2, n3));
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        this.putArray(nArray, 0, n2);
        if (MarlinConst.DO_LOG_WIDEN_ARRAY) {
            MarlinUtils.logInfo("ArrayCacheInt(Clean): widenArray[" + nArray2.length + "]: usedSize=\t" + n2 + "\tlength=\t" + n4 + "\tneeded length=\t" + n3);
        }
        return nArray2;
    }

    final boolean doSetRef(int[] nArray) {
        return nArray != this.initial;
    }

    final int[] putArrayClean(int[] nArray) {
        if (nArray.length <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            this.cache.getCacheBucket(nArray.length).putArray(nArray);
        }
        return this.initial;
    }

    final int[] putArray(int[] nArray, int n2, int n3) {
        if (nArray.length <= ArrayCacheConst.MAX_ARRAY_SIZE) {
            if (n3 != 0) {
                ArrayCacheIntClean.fill(nArray, n2, n3, 0);
            }
            if (nArray != this.initial) {
                this.cache.getCacheBucket(nArray.length).putArray(nArray);
            }
        }
        return this.initial;
    }
}

