/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.Helpers;

final class Curve {
    double ax;
    double ay;
    double bx;
    double by;
    double cx;
    double cy;
    double dx;
    double dy;
    double dax;
    double day;
    double dbx;
    double dby;

    Curve() {
    }

    final void set(double[] dArray, int n2) {
        if (n2 == 8) {
            this.set(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], dArray[6], dArray[7]);
            return;
        }
        if (n2 == 4) {
            this.set(dArray[0], dArray[1], dArray[2], dArray[3]);
            return;
        }
        this.set(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
    }

    final void set(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = 3.0 * (d6 - d4);
        double d11 = 3.0 * (d7 - d5);
        double d12 = 3.0 * (d4 - d2);
        double d13 = 3.0 * (d5 - d3);
        this.ax = d8 - d2 - d10;
        this.ay = d9 - d3 - d11;
        this.bx = d10 - d12;
        this.by = d11 - d13;
        this.cx = d12;
        this.cy = d13;
        this.dx = d2;
        this.dy = d3;
        this.dax = 3.0 * this.ax;
        this.day = 3.0 * this.ay;
        this.dbx = 2.0 * this.bx;
        this.dby = 2.0 * this.by;
    }

    final void set(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d4 - d2;
        double d9 = d5 - d3;
        this.ax = 0.0;
        this.ay = 0.0;
        this.bx = d6 - d4 - d8;
        this.by = d7 - d5 - d9;
        this.cx = d8 * 2.0;
        this.cy = d9 * 2.0;
        this.dx = d2;
        this.dy = d3;
        this.dax = 0.0;
        this.day = 0.0;
        this.dbx = 2.0 * this.bx;
        this.dby = 2.0 * this.by;
    }

    final void set(double d2, double d3, double d4, double d5) {
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        this.ax = 0.0;
        this.ay = 0.0;
        this.bx = 0.0;
        this.by = 0.0;
        this.cx = d6;
        this.cy = d7;
        this.dx = d2;
        this.dy = d3;
        this.dax = 0.0;
        this.day = 0.0;
        this.dbx = 0.0;
        this.dby = 0.0;
    }

    final int dxRoots(double[] dArray, int n2) {
        return Helpers.quadraticRoots(this.dax, this.dbx, this.cx, dArray, n2);
    }

    final int dyRoots(double[] dArray, int n2) {
        return Helpers.quadraticRoots(this.day, this.dby, this.cy, dArray, n2);
    }

    final int infPoints(double[] dArray, int n2) {
        double d2 = this.dax * this.dby - this.dbx * this.day;
        double d3 = 2.0 * (this.cy * this.dax - this.day * this.cx);
        double d4 = this.cy * this.dbx - this.cx * this.dby;
        return Helpers.quadraticRoots(d2, d3, d4, dArray, n2);
    }

    final int xPoints(double[] dArray, int n2, double d2) {
        return Helpers.cubicRootsInAB(this.ax, this.bx, this.cx, this.dx - d2, dArray, n2, 0.0, 1.0);
    }

    final int yPoints(double[] dArray, int n2, double d2) {
        return Helpers.cubicRootsInAB(this.ay, this.by, this.cy, this.dy - d2, dArray, n2, 0.0, 1.0);
    }

    private int perpendiculardfddf(double[] dArray, int n2) {
        assert (dArray.length >= n2 + 4);
        double d2 = 2.0 * (this.dax * this.dax + this.day * this.day);
        double d3 = 3.0 * (this.dax * this.dbx + this.day * this.dby);
        double d4 = 2.0 * (this.dax * this.cx + this.day * this.cy) + this.dbx * this.dbx + this.dby * this.dby;
        double d5 = this.dbx * this.cx + this.dby * this.cy;
        return Helpers.cubicRootsInAB(d2, d3, d4, d5, dArray, n2, 0.0, 1.0);
    }

    final int rootsOfROCMinusW(double[] dArray, int n2, double d2, double d3) {
        assert (n2 <= 6 && dArray.length >= 10);
        int n3 = n2;
        int n4 = n2 + this.perpendiculardfddf(dArray, n2);
        dArray[n4] = 1.0;
        double d4 = 0.0;
        double d5 = this.ROCsq(0.0) - d2;
        for (int i2 = n2; i2 <= n4; ++i2) {
            double d6 = dArray[i2];
            double d7 = this.ROCsq(d6) - d2;
            if (d5 == 0.0) {
                dArray[n3++] = d4;
            } else if (d7 * d5 < 0.0) {
                dArray[n3++] = this.falsePositionROCsqMinusX(d4, d6, d2, d3);
            }
            d4 = d6;
            d5 = d7;
        }
        return n3 - n2;
    }

    private static double eliminateInf(double d2) {
        if (d2 == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return Double.MIN_VALUE;
        }
        return d2;
    }

    private double falsePositionROCsqMinusX(double d2, double d3, double d4, double d5) {
        int n2 = 0;
        double d6 = d3;
        double d7 = Curve.eliminateInf(this.ROCsq(d6) - d4);
        double d8 = d2;
        double d9 = Curve.eliminateInf(this.ROCsq(d8) - d4);
        double d10 = d8;
        for (int i2 = 0; i2 < 100 && Math.abs(d6 - d8) > d5 * Math.abs(d6 + d8); ++i2) {
            d10 = (d9 * d6 - d7 * d8) / (d9 - d7);
            double d11 = this.ROCsq(d10) - d4;
            if (Curve.sameSign(d11, d7)) {
                d7 = d11;
                d6 = d10;
                if (n2 < 0) {
                    d9 /= (double)(1 << -n2);
                    --n2;
                    continue;
                }
                n2 = -1;
                continue;
            }
            if (!(d11 * d9 > 0.0)) break;
            d9 = d11;
            d8 = d10;
            if (n2 > 0) {
                d7 /= (double)(1 << n2);
                ++n2;
                continue;
            }
            n2 = 1;
        }
        return d10;
    }

    private static boolean sameSign(double d2, double d3) {
        return d2 < 0.0 && d3 < 0.0 || d2 > 0.0 && d3 > 0.0;
    }

    private double ROCsq(double d2) {
        double d3 = d2;
        double d4 = d3 * (d3 * this.dax + this.dbx) + this.cx;
        double d5 = d2;
        double d6 = d5 * (d5 * this.day + this.dby) + this.cy;
        double d7 = 2.0 * this.dax * d2 + this.dbx;
        double d8 = 2.0 * this.day * d2 + this.dby;
        double d9 = d4;
        double d10 = d6;
        double d11 = d9 * d9 + d10 * d10;
        double d12 = d7;
        double d13 = d8;
        double d14 = d12 * d12 + d13 * d13;
        double d15 = d7 * d4 + d8 * d6;
        double d16 = d11;
        double d17 = d15;
        return d16 * (d16 * d11 / (d11 * d14 - d17 * d17));
    }
}

