/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.Dasher;
import com.sun.marlin.Helpers;

final class Dasher$LengthIterator {
    private final double[][] recCurveStack;
    private final boolean[] sidesRight;
    private int curveType;
    private double nextT;
    private double lenAtNextT;
    private double lastT;
    private double lenAtLastT;
    private double lenAtLastSplit;
    private double lastSegLen;
    private int recLevel;
    private boolean done = true;
    private final double[] curLeafCtrlPolyLengths = new double[3];
    private int cachedHaveLowAcceleration = -1;
    private final double[] nextRoots = new double[4];
    private final double[] flatLeafCoefCache = new double[]{0.0, 0.0, -1.0, 0.0};

    Dasher$LengthIterator() {
        this.recCurveStack = new double[17][8];
        this.sidesRight = new boolean[16];
        this.nextT = Double.MAX_VALUE;
        this.lenAtNextT = Double.MAX_VALUE;
        this.lenAtLastSplit = Double.MIN_VALUE;
        this.recLevel = Integer.MIN_VALUE;
        this.lastSegLen = Double.MAX_VALUE;
    }

    final void reset() {
    }

    final void initializeIterationOnCurve(double[] dArray, int n2) {
        System.arraycopy(dArray, 0, this.recCurveStack[0], 0, 8);
        this.curveType = n2;
        this.recLevel = 0;
        this.lastT = 0.0;
        this.lenAtLastT = 0.0;
        this.nextT = 0.0;
        this.lenAtNextT = 0.0;
        this.goLeft();
        this.lenAtLastSplit = 0.0;
        if (this.recLevel > 0) {
            this.sidesRight[0] = false;
            this.done = false;
        } else {
            this.sidesRight[0] = true;
            this.done = true;
        }
        this.lastSegLen = 0.0;
    }

    private boolean haveLowAcceleration(double d2) {
        if (this.cachedHaveLowAcceleration == -1) {
            double d3;
            double d4;
            double d5 = this.curLeafCtrlPolyLengths[0];
            double d6 = this.curLeafCtrlPolyLengths[1];
            if (!Helpers.within(d5, d6, d2 * d6)) {
                this.cachedHaveLowAcceleration = 0;
                return false;
            }
            if (!(this.curveType != 8 || Helpers.within(d6, d4 = this.curLeafCtrlPolyLengths[2], d3 = d2 * d4) && Helpers.within(d5, d4, d3))) {
                this.cachedHaveLowAcceleration = 0;
                return false;
            }
            this.cachedHaveLowAcceleration = 1;
            return true;
        }
        return this.cachedHaveLowAcceleration == 1;
    }

    final double next(double d2) {
        double d3;
        double d4 = this.lenAtLastSplit + d2;
        while (this.lenAtNextT < d4) {
            if (this.done) {
                this.lastSegLen = this.lenAtNextT - this.lenAtLastSplit;
                return 1.0;
            }
            this.goToNextLeaf();
        }
        this.lenAtLastSplit = d4;
        double d5 = this.lenAtNextT - this.lenAtLastT;
        double d6 = (d4 - this.lenAtLastT) / d5;
        if (!this.haveLowAcceleration(0.05)) {
            double d7;
            int n2;
            double d8;
            double d9;
            double d10;
            double[] dArray = this.flatLeafCoefCache;
            if (this.flatLeafCoefCache[2] < 0.0) {
                d10 = this.curLeafCtrlPolyLengths[0];
                d9 = d10 + this.curLeafCtrlPolyLengths[1];
                if (this.curveType == 8) {
                    d8 = d9 + this.curLeafCtrlPolyLengths[2];
                    dArray[0] = 3.0 * (d10 - d9) + d8;
                    dArray[1] = 3.0 * (d9 - 2.0 * d10);
                    dArray[2] = d10 * 3.0;
                    dArray[3] = -d8;
                } else if (this.curveType == 6) {
                    dArray[0] = 0.0;
                    dArray[1] = d9 - d10 * 2.0;
                    dArray[2] = d10 * 2.0;
                    dArray[3] = -d9;
                }
            }
            if ((n2 = Helpers.cubicRootsInAB(d10 = dArray[0], d9 = dArray[1], d8 = dArray[2], d7 = d6 * dArray[3], this.nextRoots, 0, 0.0, 1.0)) == 1) {
                d6 = this.nextRoots[0];
            }
        }
        d6 = d6 * (this.nextT - this.lastT) + this.lastT;
        if (d3 >= 1.0) {
            d6 = 1.0;
            this.done = true;
        }
        this.lastSegLen = d2;
        return d6;
    }

    final double totalLength() {
        while (!this.done) {
            this.goToNextLeaf();
        }
        this.reset();
        return this.lenAtNextT;
    }

    final double lastSegLen() {
        return this.lastSegLen;
    }

    private void goToNextLeaf() {
        boolean[] blArray = this.sidesRight;
        int n2 = this.recLevel;
        --n2;
        while (blArray[n2]) {
            if (n2 == 0) {
                this.recLevel = 0;
                this.done = true;
                return;
            }
            --n2;
        }
        blArray[n2] = true;
        System.arraycopy(this.recCurveStack[n2++], 0, this.recCurveStack[n2], 0, 8);
        this.recLevel = n2;
        this.goLeft();
    }

    private void goLeft() {
        while (true) {
            double d2;
            double d3 = this.onLeaf();
            if (d2 >= 0.0) {
                this.lastT = this.nextT;
                this.lenAtLastT = this.lenAtNextT;
                this.nextT += (double)(1 << 16 - this.recLevel) * 1.52587890625E-5;
                this.lenAtNextT += d3;
                this.flatLeafCoefCache[2] = -1.0;
                this.cachedHaveLowAcceleration = -1;
                return;
            }
            Helpers.subdivide(this.recCurveStack[this.recLevel], this.recCurveStack[this.recLevel + 1], this.recCurveStack[this.recLevel], this.curveType);
            this.sidesRight[this.recLevel] = false;
            ++this.recLevel;
        }
    }

    private double onLeaf() {
        double[] dArray = this.recCurveStack[this.recLevel];
        int n2 = this.curveType;
        double d2 = 0.0;
        double d3 = dArray[0];
        double d4 = dArray[1];
        for (int i2 = 2; i2 < n2; i2 += 2) {
            double d5 = dArray[i2];
            double d6 = dArray[i2 + 1];
            double d7 = Helpers.linelen(d3, d4, d5, d6);
            d2 += d7;
            this.curLeafCtrlPolyLengths[(i2 >> 1) - 1] = d7;
            d3 = d5;
            d4 = d6;
        }
        double d8 = Helpers.linelen(dArray[0], dArray[1], d3, d4);
        if (d2 - d8 < Dasher.CURVE_LEN_ERR || this.recLevel == 16) {
            return (d2 + d8) / 2.0;
        }
        return -1.0;
    }
}

