/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheDouble$Reference;
import com.sun.marlin.DPathConsumer2D;
import com.sun.marlin.Dasher$LengthIterator;
import com.sun.marlin.FloatMath;
import com.sun.marlin.Helpers;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinProperties;
import com.sun.marlin.RendererContext;
import com.sun.marlin.TransformingPathConsumer2D$CurveBasicMonotonizer;
import com.sun.marlin.TransformingPathConsumer2D$CurveClipSplitter;
import com.sun.marlin.TransformingPathConsumer2D$StartFlagPathConsumer2D;

public final class Dasher
implements MarlinConst,
TransformingPathConsumer2D$StartFlagPathConsumer2D {
    static final int REC_LIMIT = 16;
    static final double CURVE_LEN_ERR = MarlinProperties.getCurveLengthError();
    static final double MIN_T_INC = 1.52587890625E-5;
    static final double EPS = 1.0E-6;
    static final double MAX_CYCLES = 1.6E7;
    private DPathConsumer2D out;
    private double[] dash;
    private int dashLen;
    private double startPhase;
    private boolean startDashOn;
    private int startIdx;
    private boolean starting;
    private boolean needsMoveTo;
    private int idx;
    private boolean dashOn;
    private double phase;
    private double sx0;
    private double sy0;
    private double cx0;
    private double cy0;
    private final double[] curCurvepts;
    final RendererContext rdrCtx;
    boolean recycleDashes;
    private double[] firstSegmentsBuffer;
    private int firstSegidx;
    final ArrayCacheDouble$Reference dashes_ref;
    final ArrayCacheDouble$Reference firstSegmentsBuffer_ref;
    private double[] clipRect;
    private int cOutCode = 0;
    private boolean subdivide = DO_CLIP_SUBDIVIDER;
    private final Dasher$LengthIterator li = new Dasher$LengthIterator();
    private final TransformingPathConsumer2D$CurveClipSplitter curveSplitter;
    private double cycleLen;
    private boolean outside;
    private double totalSkipLen;

    Dasher(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.dashes_ref = rendererContext.newDirtyDoubleArrayRef(256);
        this.firstSegmentsBuffer_ref = rendererContext.newDirtyDoubleArrayRef(256);
        this.firstSegmentsBuffer = this.firstSegmentsBuffer_ref.initial;
        this.curCurvepts = new double[16];
        this.curveSplitter = rendererContext.curveClipSplitter;
    }

    public final Dasher init(DPathConsumer2D dPathConsumer2D, double[] dArray, int n2, double d2, boolean bl2) {
        this.out = dPathConsumer2D;
        int n3 = 0;
        this.dashOn = true;
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            d3 += dArray[i2];
        }
        this.cycleLen = d3;
        double d4 = d2 / d3;
        if (d2 < 0.0) {
            if (-d4 >= 1.6E7) {
                d2 = 0.0;
            } else {
                int n4 = FloatMath.floor_int(-d4);
                if ((n4 & n2 & 1) != 0) {
                    this.dashOn = !this.dashOn;
                }
                d2 += (double)n4 * d3;
                while (d2 < 0.0) {
                    if (--n3 < 0) {
                        n3 = n2 - 1;
                    }
                    d2 += dArray[n3];
                    this.dashOn = !this.dashOn;
                }
            }
        } else if (d2 > 0.0) {
            if (d4 >= 1.6E7) {
                d2 = 0.0;
            } else {
                int n5 = FloatMath.floor_int(d4);
                if ((n5 & n2 & 1) != 0) {
                    this.dashOn = !this.dashOn;
                }
                d2 -= (double)n5 * d3;
                while (true) {
                    double d5;
                    double d6 = dArray[n3];
                    if (!(d2 >= d5)) break;
                    d2 -= d6;
                    n3 = (n3 + 1) % n2;
                    this.dashOn = !this.dashOn;
                }
            }
        }
        this.dash = dArray;
        this.dashLen = n2;
        this.phase = d2;
        this.startPhase = d2;
        this.startDashOn = this.dashOn;
        this.startIdx = n3;
        this.starting = true;
        this.needsMoveTo = false;
        this.firstSegidx = 0;
        this.recycleDashes = bl2;
        if (this.rdrCtx.doClip) {
            this.clipRect = this.rdrCtx.clipRect;
        } else {
            this.clipRect = null;
            this.cOutCode = 0;
        }
        return this;
    }

    final void dispose() {
        if (this.recycleDashes && this.dashes_ref.doCleanRef(this.dash)) {
            this.dash = this.dashes_ref.putArray(this.dash);
        }
        if (this.firstSegmentsBuffer_ref.doCleanRef(this.firstSegmentsBuffer)) {
            this.firstSegmentsBuffer = this.firstSegmentsBuffer_ref.putArray(this.firstSegmentsBuffer);
        }
    }

    public final double[] copyDashArray(float[] fArray) {
        double[] dArray;
        int n2 = fArray.length;
        if (n2 <= 256) {
            dArray = this.dashes_ref.initial;
        } else {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_dasher_dasher.add(n2);
            }
            dArray = this.dashes_ref.getArray(n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = fArray[i2];
        }
        return dArray;
    }

    @Override
    public final void moveTo(double d2, double d3) {
        if (this.firstSegidx != 0) {
            this.out.moveTo(this.sx0, this.sy0);
            this.emitFirstSegments();
        }
        this.needsMoveTo = true;
        this.idx = this.startIdx;
        this.dashOn = this.startDashOn;
        this.phase = this.startPhase;
        this.cx0 = d2;
        this.cy0 = d3;
        this.sx0 = d2;
        this.sy0 = d3;
        this.starting = true;
        if (this.clipRect != null) {
            int n2;
            this.cOutCode = n2 = Helpers.outcode(d2, d3, this.clipRect);
            this.outside = false;
            this.totalSkipLen = 0.0;
        }
    }

    private void emitSeg(double[] dArray, int n2, int n3) {
        switch (n3) {
            case 4: {
                this.out.lineTo(dArray[n2], dArray[n2 + 1]);
                return;
            }
            case 8: {
                this.out.curveTo(dArray[n2], dArray[n2 + 1], dArray[n2 + 2], dArray[n2 + 3], dArray[n2 + 4], dArray[n2 + 5]);
                return;
            }
            case 6: {
                this.out.quadTo(dArray[n2], dArray[n2 + 1], dArray[n2 + 2], dArray[n2 + 3]);
                return;
            }
        }
    }

    private void emitFirstSegments() {
        int n2;
        double[] dArray = this.firstSegmentsBuffer;
        int n3 = this.firstSegidx;
        for (int i2 = 0; i2 < n3; i2 += n2 - 1) {
            n2 = (int)dArray[i2];
            this.emitSeg(dArray, i2 + 1, n2);
        }
        this.firstSegidx = 0;
    }

    private void goTo(double[] dArray, int n2, int n3, boolean bl2) {
        int n4 = n2 + n3;
        double d2 = dArray[n4 - 4];
        double d3 = dArray[n4 - 3];
        if (bl2) {
            if (this.starting) {
                this.goTo_starting(dArray, n2, n3);
            } else {
                if (this.needsMoveTo) {
                    this.needsMoveTo = false;
                    this.out.moveTo(this.cx0, this.cy0);
                }
                this.emitSeg(dArray, n2, n3);
            }
        } else {
            if (this.starting) {
                this.starting = false;
            }
            this.needsMoveTo = true;
        }
        this.cx0 = d2;
        this.cy0 = d3;
    }

    private void goTo_starting(double[] dArray, int n2, int n3) {
        int n4 = this.firstSegidx;
        int n5 = n3 - 1;
        double[] dArray2 = this.firstSegmentsBuffer;
        if (n4 + n5 > dArray2.length) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_dasher_firstSegmentsBuffer.add(n4 + n5);
            }
            int n6 = n4;
            this.firstSegmentsBuffer = dArray2 = this.firstSegmentsBuffer_ref.widenArray(dArray2, n6, n6 + n5);
        }
        dArray2[n4++] = n3;
        System.arraycopy(dArray, n2, dArray2, n4, --n5);
        this.firstSegidx = n4 + n5;
    }

    @Override
    public final void setStartFlag(boolean bl2) {
        if (bl2) {
            this.rdrCtx.firstFlags &= 3;
            return;
        }
        this.rdrCtx.firstFlags |= 4;
    }

    public final void setMonotonizerStartFlag(boolean bl2) {
        if (bl2) {
            this.rdrCtx.firstFlags &= 5;
            return;
        }
        this.rdrCtx.firstFlags |= 2;
    }

    @Override
    public final void lineTo(double d2, double d3) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3 = Helpers.outcode(d2, d3, this.clipRect);
            int n4 = n2 | n3;
            if (n4 != 0) {
                if ((n2 &= n3) == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        n2 = this.curveSplitter.splitLine(this.cx0, this.cy0, d2, d3, n4, this) ? 1 : 0;
                        this.subdivide = true;
                        if (n2 != 0) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this.skipLineTo(d2, d3);
                    return;
                }
            }
            this.cOutCode = n3;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._lineTo(d2, d3);
    }

    private void _lineTo(double d2, double d3) {
        double d4 = d2 - this.cx0;
        double d5 = d3 - this.cy0;
        double d6 = d4;
        double d7 = d5;
        double d8 = d6 * d6 + d7 * d7;
        if (d8 == 0.0) {
            return;
        }
        d8 = Math.sqrt(d8);
        double d9 = d4 / d8;
        double d10 = d5 / d8;
        double[] dArray = this.curCurvepts;
        double[] dArray2 = this.dash;
        int n2 = this.dashLen;
        int n3 = this.idx;
        boolean bl2 = this.dashOn;
        double d11 = this.phase;
        while (true) {
            double d12;
            double d13 = dArray2[n3] - d11;
            double d14 = d8 - d13;
            if (d12 <= 1.0E-6) {
                dArray[0] = d2;
                dArray[1] = d3;
                this.goTo(dArray, 0, 4, bl2);
                d11 += d8;
                if (!(Math.abs(d14) <= 1.0E-6)) break;
                d11 = 0.0;
                n3 = (n3 + 1) % n2;
                bl2 = !bl2;
                break;
            }
            dArray[0] = this.cx0 + d13 * d9;
            dArray[1] = this.cy0 + d13 * d10;
            this.goTo(dArray, 0, 4, bl2);
            d8 = d14;
            n3 = (n3 + 1) % n2;
            bl2 = !bl2;
            d11 = 0.0;
        }
        this.idx = n3;
        this.dashOn = bl2;
        this.phase = d11;
    }

    private void skipLineTo(double d2, double d3) {
        double d4 = d2 - this.cx0;
        double d5 = d3 - this.cy0;
        double d6 = d4;
        double d7 = d5;
        double d8 = d6 * d6 + d7 * d7;
        if (d8 != 0.0) {
            d8 = Math.sqrt(d8);
        }
        this.outside = true;
        this.totalSkipLen += d8;
        this.needsMoveTo = true;
        this.starting = false;
        this.cx0 = d2;
        this.cy0 = d3;
    }

    public final void skipLen() {
        double d2 = this.totalSkipLen;
        this.totalSkipLen = 0.0;
        double[] dArray = this.dash;
        int n2 = this.dashLen;
        int n3 = this.idx;
        boolean bl2 = this.dashOn;
        double d3 = this.phase;
        long l2 = (long)Math.floor(d2 / this.cycleLen) - 2L;
        if (l2 > 0L) {
            d2 -= this.cycleLen * (double)l2;
            long l3 = l2 * (long)n2;
            n3 = (int)(l3 + (long)n3) % n2;
            bl2 = (l3 + (bl2 ? 1L : 0L) & 1L) == 1L;
        }
        while (true) {
            double d4;
            double d5 = dArray[n3] - d3;
            double d6 = d2 - d5;
            if (d4 <= 1.0E-6) {
                d3 += d2;
                if (!(Math.abs(d6) <= 1.0E-6)) break;
                d3 = 0.0;
                n3 = (n3 + 1) % n2;
                bl2 = !bl2;
                break;
            }
            d2 = d6;
            n3 = (n3 + 1) % n2;
            bl2 = !bl2;
            d3 = 0.0;
        }
        this.idx = n3;
        this.dashOn = bl2;
        this.phase = d3;
    }

    private void somethingTo(int n2) {
        double d2;
        double[] dArray = this.curCurvepts;
        if (Helpers.isPointCurve(this.curCurvepts, n2)) {
            return;
        }
        Dasher$LengthIterator dasher$LengthIterator = this.li;
        double[] dArray2 = this.dash;
        int n3 = this.dashLen;
        dasher$LengthIterator.initializeIterationOnCurve(dArray, n2);
        int n4 = this.idx;
        boolean bl2 = this.dashOn;
        double d3 = this.phase;
        int n5 = 0;
        double d4 = 0.0;
        double d5 = dArray2[n4] - d3;
        while (true) {
            double d6;
            double d7 = dasher$LengthIterator.next(d5);
            if (!(d6 < 1.0)) break;
            if (d7 != 0.0) {
                Helpers.subdivideAt((d7 - d4) / (1.0 - d4), dArray, n5, dArray, 0, n2);
                d4 = d7;
                this.goTo(dArray, 2, n2, bl2);
                n5 = n2;
            }
            n4 = (n4 + 1) % n3;
            bl2 = !bl2;
            d3 = 0.0;
            d5 = dArray2[n4];
        }
        this.goTo(dArray, n5 + 2, n2, bl2);
        d3 += dasher$LengthIterator.lastSegLen();
        if (d2 + 1.0E-6 >= dArray2[n4]) {
            d3 = 0.0;
            n4 = (n4 + 1) % n3;
            bl2 = !bl2;
        }
        this.idx = n4;
        this.dashOn = bl2;
        this.phase = d3;
        dasher$LengthIterator.reset();
    }

    private void skipSomethingTo(int n2) {
        double[] dArray = this.curCurvepts;
        if (Helpers.isPointCurve(this.curCurvepts, n2)) {
            return;
        }
        Dasher$LengthIterator dasher$LengthIterator = this.li;
        dasher$LengthIterator.initializeIterationOnCurve(dArray, n2);
        double d2 = dasher$LengthIterator.totalLength();
        this.outside = true;
        this.totalSkipLen += d2;
        this.needsMoveTo = true;
        this.starting = false;
    }

    @Override
    public final void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3;
            int n4;
            int n5 = Helpers.outcode(d2, d3, this.clipRect);
            int n6 = n2 | n5 | (n4 = Helpers.outcode(d4, d5, this.clipRect)) | (n3 = Helpers.outcode(d6, d7, this.clipRect));
            if (n6 != 0) {
                if ((n2 = n2 & n5 & n4 & n3) == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        n2 = this.curveSplitter.splitCurve(this.cx0, this.cy0, d2, d3, d4, d5, d6, d7, n6, this) ? 1 : 0;
                        this.subdivide = true;
                        if (n2 != 0) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this.skipCurveTo(d2, d3, d4, d5, d6, d7);
                    return;
                }
            }
            this.cOutCode = n3;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._curveTo(d2, d3, d4, d5, d6, d7);
    }

    private void _curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        double[] dArray = this.curCurvepts;
        Object object = this.rdrCtx.monotonizer.curve(this.cx0, this.cy0, d2, d3, d4, d5, d6, d7);
        int n2 = ((TransformingPathConsumer2D$CurveBasicMonotonizer)object).nbSplits;
        object = ((TransformingPathConsumer2D$CurveBasicMonotonizer)object).middle;
        int n3 = 0;
        int n4 = 0;
        while (n3 <= n2) {
            System.arraycopy(object, n4, dArray, 0, 8);
            this.somethingTo(8);
            if (n3 == 0) {
                this.setMonotonizerStartFlag(false);
            }
            ++n3;
            n4 += 6;
        }
        this.setMonotonizerStartFlag(true);
    }

    private void skipCurveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        double[] dArray = this.curCurvepts;
        this.curCurvepts[0] = this.cx0;
        dArray[1] = this.cy0;
        dArray[2] = d2;
        dArray[3] = d3;
        dArray[4] = d4;
        dArray[5] = d5;
        dArray[6] = d6;
        dArray[7] = d7;
        this.skipSomethingTo(8);
        this.cx0 = d6;
        this.cy0 = d7;
    }

    @Override
    public final void quadTo(double d2, double d3, double d4, double d5) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3;
            int n4 = Helpers.outcode(d2, d3, this.clipRect);
            int n5 = n2 | n4 | (n3 = Helpers.outcode(d4, d5, this.clipRect));
            if (n5 != 0) {
                if ((n2 = n2 & n4 & n3) == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        n2 = this.curveSplitter.splitQuad(this.cx0, this.cy0, d2, d3, d4, d5, n5, this) ? 1 : 0;
                        this.subdivide = true;
                        if (n2 != 0) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this.skipQuadTo(d2, d3, d4, d5);
                    return;
                }
            }
            this.cOutCode = n3;
            if (this.outside) {
                this.outside = false;
                this.skipLen();
            }
        }
        this._quadTo(d2, d3, d4, d5);
    }

    private void _quadTo(double d2, double d3, double d4, double d5) {
        double[] dArray = this.curCurvepts;
        Object object = this.rdrCtx.monotonizer.quad(this.cx0, this.cy0, d2, d3, d4, d5);
        int n2 = ((TransformingPathConsumer2D$CurveBasicMonotonizer)object).nbSplits;
        object = ((TransformingPathConsumer2D$CurveBasicMonotonizer)object).middle;
        int n3 = 0;
        int n4 = 0;
        while (n3 <= n2) {
            System.arraycopy(object, n4, dArray, 0, 8);
            this.somethingTo(6);
            if (n3 == 0) {
                this.setMonotonizerStartFlag(false);
            }
            ++n3;
            n4 += 4;
        }
        this.setMonotonizerStartFlag(true);
    }

    private void skipQuadTo(double d2, double d3, double d4, double d5) {
        double[] dArray = this.curCurvepts;
        this.curCurvepts[0] = this.cx0;
        dArray[1] = this.cy0;
        dArray[2] = d2;
        dArray[3] = d3;
        dArray[4] = d4;
        dArray[5] = d5;
        this.skipSomethingTo(6);
        this.cx0 = d4;
        this.cy0 = d5;
    }

    @Override
    public final void closePath() {
        if (this.cx0 != this.sx0 || this.cy0 != this.sy0) {
            Dasher dasher = this;
            dasher.lineTo(dasher.sx0, this.sy0);
        }
        if (this.firstSegidx != 0) {
            if (!this.dashOn || this.needsMoveTo) {
                this.out.moveTo(this.sx0, this.sy0);
            }
            this.emitFirstSegments();
        }
        Dasher dasher = this;
        dasher.moveTo(dasher.sx0, this.sy0);
    }

    @Override
    public final void pathDone() {
        if (this.firstSegidx != 0) {
            this.out.moveTo(this.sx0, this.sy0);
            this.emitFirstSegments();
        }
        this.out.pathDone();
        this.dispose();
    }
}

