/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.DPathConsumer2D;
import com.sun.marlin.MarlinProperties;

public final class PathSimplifier
implements DPathConsumer2D {
    private static final double PIX_THRESHOLD = MarlinProperties.getPathSimplifierPixelTolerance();
    private static final double SQUARE_TOLERANCE = PIX_THRESHOLD * PIX_THRESHOLD;
    private DPathConsumer2D delegate;
    private double cx;
    private double cy;
    private boolean skipped;
    private double sx;
    private double sy;

    PathSimplifier() {
    }

    public final PathSimplifier init(DPathConsumer2D dPathConsumer2D) {
        this.delegate = dPathConsumer2D;
        this.skipped = false;
        return this;
    }

    private void finishPath() {
        if (this.skipped) {
            PathSimplifier pathSimplifier = this;
            pathSimplifier._lineTo(pathSimplifier.sx, this.sy);
        }
    }

    @Override
    public final void pathDone() {
        this.finishPath();
        this.delegate.pathDone();
    }

    @Override
    public final void closePath() {
        this.finishPath();
        this.delegate.closePath();
    }

    @Override
    public final void moveTo(double d2, double d3) {
        this.finishPath();
        this.delegate.moveTo(d2, d3);
        this.cx = d2;
        this.cy = d3;
    }

    @Override
    public final void lineTo(double d2, double d3) {
        double d4 = d2 - this.cx;
        double d5 = d3 - this.cy;
        double d6 = d4;
        double d7 = d5;
        if (d6 * d6 + d7 * d7 <= SQUARE_TOLERANCE) {
            this.skipped = true;
            this.sx = d2;
            this.sy = d3;
            return;
        }
        this._lineTo(d2, d3);
    }

    private void _lineTo(double d2, double d3) {
        this.delegate.lineTo(d2, d3);
        this.cx = d2;
        this.cy = d3;
        this.skipped = false;
    }

    @Override
    public final void quadTo(double d2, double d3, double d4, double d5) {
        double d6 = d4 - this.cx;
        double d7 = d5 - this.cy;
        double d8 = d6;
        double d9 = d7;
        if (d8 * d8 + d9 * d9 <= SQUARE_TOLERANCE) {
            d6 = d2 - this.cx;
            d7 = d3 - this.cy;
            double d10 = d6;
            double d11 = d7;
            if (d10 * d10 + d11 * d11 <= SQUARE_TOLERANCE) {
                this.skipped = true;
                this.sx = d4;
                this.sy = d5;
                return;
            }
        }
        this.delegate.quadTo(d2, d3, d4, d5);
        this.cx = d4;
        this.cy = d5;
        this.skipped = false;
    }

    @Override
    public final void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d6 - this.cx;
        double d9 = d7 - this.cy;
        double d10 = d8;
        double d11 = d9;
        if (d10 * d10 + d11 * d11 <= SQUARE_TOLERANCE) {
            d8 = d2 - this.cx;
            d9 = d3 - this.cy;
            double d12 = d8;
            double d13 = d9;
            if (d12 * d12 + d13 * d13 <= SQUARE_TOLERANCE) {
                d8 = d4 - this.cx;
                d9 = d5 - this.cy;
                double d14 = d8;
                double d15 = d9;
                if (d14 * d14 + d15 * d15 <= SQUARE_TOLERANCE) {
                    this.skipped = true;
                    this.sx = d6;
                    this.sy = d7;
                    return;
                }
            }
        }
        this.delegate.curveTo(d2, d3, d4, d5, d6, d7);
        this.cx = d6;
        this.cy = d7;
        this.skipped = false;
    }
}

