/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.ArrayCacheConst;
import com.sun.marlin.ArrayCacheInt$Reference;
import com.sun.marlin.ArrayCacheIntClean$Reference;
import com.sun.marlin.Curve;
import com.sun.marlin.DPQSSorterContext;
import com.sun.marlin.FloatMath;
import com.sun.marlin.MarlinAlphaConsumer;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinProperties;
import com.sun.marlin.MarlinRenderer;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.MergeSort;
import com.sun.marlin.OffHeapArray;
import com.sun.marlin.RendererContext;
import com.sun.marlin.stats.StatLong;
import sun.misc.Unsafe;

public final class Renderer
implements MarlinConst,
MarlinRenderer {
    static final boolean DISABLE_RENDER = MarlinProperties.isSkipRenderer();
    private static final int ALL_BUT_LSB = -2;
    private static final int ERR_STEP_MAX = Integer.MAX_VALUE;
    private static final double POWER_2_TO_32 = 4.294967296E9;
    static final double SUBPIXEL_SCALE_X = SUBPIXEL_POSITIONS_X;
    static final double SUBPIXEL_SCALE_Y = SUBPIXEL_POSITIONS_Y;
    static final int SUBPIXEL_MASK_X = SUBPIXEL_POSITIONS_X - 1;
    static final int SUBPIXEL_MASK_Y = SUBPIXEL_POSITIONS_Y - 1;
    private static final double RDR_OFFSET_X = 0.5 / SUBPIXEL_SCALE_X;
    private static final double RDR_OFFSET_Y = 0.5 / SUBPIXEL_SCALE_Y;
    public static final long OFF_CURX_OR = 0L;
    public static final long OFF_ERROR = 0L + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_BUMP_X = OFF_ERROR + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_BUMP_ERR = OFF_BUMP_X + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_NEXT = OFF_BUMP_ERR + (long)OffHeapArray.SIZE_INT;
    public static final long OFF_YMAX = OFF_NEXT + (long)OffHeapArray.SIZE_INT;
    public static final int SIZEOF_EDGE_BYTES = (int)(OFF_YMAX + (long)OffHeapArray.SIZE_INT);
    private static final double CUB_DEC_ERR_SUBPIX = (double)MarlinProperties.getCubicDecD2() * ((double)SUBPIXEL_POSITIONS_X / 8.0);
    private static final double CUB_INC_ERR_SUBPIX = (double)MarlinProperties.getCubicIncD1() * ((double)SUBPIXEL_POSITIONS_X / 8.0);
    public static final double SCALE_DY = (double)SUBPIXEL_POSITIONS_X / (double)SUBPIXEL_POSITIONS_Y;
    public static final double CUB_DEC_BND = 8.0 * CUB_DEC_ERR_SUBPIX;
    public static final double CUB_INC_BND = 8.0 * CUB_INC_ERR_SUBPIX;
    public static final int CUB_COUNT_LG = 2;
    private static final int CUB_COUNT = 4;
    private static final int CUB_COUNT_2 = 16;
    private static final int CUB_COUNT_3 = 64;
    private static final double CUB_INV_COUNT = 0.25;
    private static final double CUB_INV_COUNT_2 = 0.0625;
    private static final double CUB_INV_COUNT_3 = 0.015625;
    private static final double QUAD_DEC_ERR_SUBPIX = (double)MarlinProperties.getQuadDecD2() * ((double)SUBPIXEL_POSITIONS_X / 8.0);
    public static final double QUAD_DEC_BND = 8.0 * QUAD_DEC_ERR_SUBPIX;
    private int[] crossings;
    private int[] aux_crossings;
    private int edgeCount;
    private int[] edgePtrs;
    private int[] aux_edgePtrs;
    private int activeEdgeMaxUsed;
    private final ArrayCacheInt$Reference crossings_ref;
    private final ArrayCacheInt$Reference edgePtrs_ref;
    private final ArrayCacheInt$Reference aux_crossings_ref;
    private final ArrayCacheInt$Reference aux_edgePtrs_ref;
    private int edgeMinY = Integer.MAX_VALUE;
    private int edgeMaxY = Integer.MIN_VALUE;
    private double edgeMinX = Double.POSITIVE_INFINITY;
    private double edgeMaxX = Double.NEGATIVE_INFINITY;
    private final OffHeapArray edges;
    private int[] edgeBuckets;
    private int[] edgeBucketCounts;
    private int buckets_minY;
    private int buckets_maxY;
    private final ArrayCacheIntClean$Reference edgeBuckets_ref;
    private final ArrayCacheIntClean$Reference edgeBucketCounts_ref;
    boolean useRLE = false;
    private int boundsMinX;
    private int boundsMinY;
    private int boundsMaxX;
    private int boundsMaxY;
    private int windingRule;
    private double x0;
    private double y0;
    private double sx0;
    private double sy0;
    final RendererContext rdrCtx;
    private final Curve curve;
    private int[] alphaLine;
    private final ArrayCacheIntClean$Reference alphaLine_ref;
    private boolean enableBlkFlags = false;
    private boolean prevUseBlkFlags = false;
    private int[] blkFlags;
    private final ArrayCacheIntClean$Reference blkFlags_ref;
    private int bbox_spminX;
    private int bbox_spmaxX;
    private int bbox_spminY;
    private int bbox_spmaxY;
    int bboxX0;
    int bboxX1;
    int bboxY0;
    int bboxY1;

    private void quadBreakIntoLinesAndAdd(double d2, double d3, Curve curve, double d4, double d5) {
        int n2 = 1;
        double d6 = Math.abs(curve.dbx) + Math.abs(curve.dby) * SCALE_DY;
        double d7 = QUAD_DEC_BND;
        while (d6 >= d7) {
            d6 /= 4.0;
            n2 <<= 1;
            if (!DO_STATS) continue;
            this.rdrCtx.stats.stat_rdr_quadBreak_dec.add(n2);
        }
        int n3 = n2;
        if (n2 > 1) {
            double d8 = 1.0 / (double)n2;
            double d9 = d8 * d8;
            double d10 = curve.dbx * d9;
            double d11 = curve.dby * d9;
            double d12 = curve.bx * d9 + curve.cx * d8;
            double d13 = curve.by * d9 + curve.cy * d8;
            double d14 = d2;
            double d15 = d3;
            while (--n2 > 0) {
                this.addLine(d2, d3, d14 += d12, d15 += d13);
                d2 = d14;
                d3 = d15;
                d12 += d10;
                d13 += d11;
            }
        }
        this.addLine(d2, d3, d4, d5);
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_quadBreak.add(n3);
        }
    }

    private void curveBreakIntoLinesAndAdd(double d2, double d3, Curve curve, double d4, double d5) {
        int n2 = 4;
        double d6 = 2.0 * curve.dax * 0.015625;
        double d7 = 2.0 * curve.day * 0.015625;
        double d8 = d6 + curve.dbx * 0.0625;
        double d9 = d7 + curve.dby * 0.0625;
        double d10 = curve.ax * 0.015625 + curve.bx * 0.0625 + curve.cx * 0.25;
        double d11 = curve.ay * 0.015625 + curve.by * 0.0625 + curve.cy * 0.25;
        double d12 = CUB_DEC_BND;
        double d13 = CUB_INC_BND;
        double d14 = SCALE_DY;
        double d15 = d2;
        double d16 = d3;
        while (n2 > 0) {
            while (n2 % 2 == 0 && Math.abs(d8) + Math.abs(d9) * d14 <= d13) {
                d10 = d10 * 2.0 + d8;
                d11 = d11 * 2.0 + d9;
                d8 = 4.0 * (d8 + d6);
                d9 = 4.0 * (d9 + d7);
                d6 *= 8.0;
                d7 *= 8.0;
                n2 >>= 1;
                if (!DO_STATS) continue;
                this.rdrCtx.stats.stat_rdr_curveBreak_inc.add(n2);
            }
            while (Math.abs(d8) + Math.abs(d9) * d14 >= d12) {
                d8 = d8 / 4.0 - (d6 /= 8.0);
                d9 = d9 / 4.0 - (d7 /= 8.0);
                d10 = (d10 - d8) / 2.0;
                d11 = (d11 - d9) / 2.0;
                n2 <<= 1;
                if (!DO_STATS) continue;
                this.rdrCtx.stats.stat_rdr_curveBreak_dec.add(n2);
            }
            if (--n2 == 0) break;
            d8 += d6;
            this.addLine(d2, d3, d15 += (d10 += d8), d16 += (d11 += (d9 += d7)));
            d2 = d15;
            d3 = d16;
        }
        this.addLine(d2, d3, d4, d5);
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_curveBreak.add(1);
        }
    }

    private void addLine(double d2, double d3, double d4, double d5) {
        double d6;
        int n2;
        int n3;
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_addLine.add(1);
        }
        int n4 = 1;
        if (d5 < d3) {
            n4 = 0;
            double d7 = d5;
            d5 = d3;
            d3 = d7;
            d7 = d4;
            d4 = d2;
            d2 = d7;
        }
        if ((n3 = FloatMath.max(FloatMath.ceil_int(d3), this.boundsMinY)) >= (n2 = FloatMath.min(FloatMath.ceil_int(d5), this.boundsMaxY))) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_rdr_addLine_skip.add(1);
            }
            return;
        }
        if (n3 < this.edgeMinY) {
            this.edgeMinY = n3;
        }
        if (n2 > this.edgeMaxY) {
            this.edgeMaxY = n2;
        }
        double d8 = (d2 - d4) / (d3 - d5);
        if (d6 >= 0.0) {
            if (d2 < this.edgeMinX) {
                this.edgeMinX = d2;
            }
            if (d4 > this.edgeMaxX) {
                this.edgeMaxX = d4;
            }
        } else {
            if (d4 < this.edgeMinX) {
                this.edgeMinX = d4;
            }
            if (d2 > this.edgeMaxX) {
                this.edgeMaxX = d2;
            }
        }
        int n5 = SIZEOF_EDGE_BYTES;
        OffHeapArray offHeapArray = this.edges;
        int n6 = offHeapArray.used;
        if (offHeapArray.length - (long)n6 < (long)n5) {
            long l2 = ArrayCacheConst.getNewLargeSize(offHeapArray.length, n6 + n5);
            if (DO_STATS) {
                this.rdrCtx.stats.stat_rdr_edges_resizes.add(l2);
            }
            offHeapArray.resize(l2);
        }
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l3 = offHeapArray.address + (long)n6;
        double d9 = d2 + ((double)n3 - d3) * d8;
        long l4 = (long)(d9 * 4.294967296E9) + Integer.MAX_VALUE;
        unsafe.putInt(l3, (int)(l4 >> 31) & 0xFFFFFFFE | n4);
        unsafe.putInt(l3 += 4L, (int)l4 >>> 1);
        long l5 = (long)(d8 * 4.294967296E9);
        unsafe.putInt(l3 += 4L, (int)(l5 >> 31) & 0xFFFFFFFE);
        unsafe.putInt(l3 += 4L, (int)l5 >>> 1);
        int[] nArray = this.edgeBuckets;
        int[] nArray2 = this.edgeBucketCounts;
        int n7 = this.boundsMinY;
        int n8 = n3 - n7;
        unsafe.putInt(l3 += 4L, nArray[n8]);
        unsafe.putInt(l3 += 4L, n2);
        nArray[n8] = n6;
        int n9 = n8;
        nArray2[n9] = nArray2[n9] + 2;
        int n10 = n2 - n7;
        nArray2[n10] = nArray2[n10] | 1;
        offHeapArray.used += n5;
    }

    Renderer(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.curve = rendererContext.curve;
        this.edges = rendererContext.rdrMem.edges;
        this.edgeBuckets_ref = rendererContext.rdrMem.edgeBuckets_ref;
        this.edgeBucketCounts_ref = rendererContext.rdrMem.edgeBucketCounts_ref;
        this.edgeBuckets = this.edgeBuckets_ref.initial;
        this.edgeBucketCounts = this.edgeBucketCounts_ref.initial;
        this.alphaLine_ref = rendererContext.rdrMem.alphaLine_ref;
        this.alphaLine = this.alphaLine_ref.initial;
        this.crossings_ref = rendererContext.rdrMem.crossings_ref;
        this.aux_crossings_ref = rendererContext.rdrMem.aux_crossings_ref;
        this.edgePtrs_ref = rendererContext.rdrMem.edgePtrs_ref;
        this.aux_edgePtrs_ref = rendererContext.rdrMem.aux_edgePtrs_ref;
        this.crossings = this.crossings_ref.initial;
        this.aux_crossings = this.aux_crossings_ref.initial;
        this.edgePtrs = this.edgePtrs_ref.initial;
        this.aux_edgePtrs = this.aux_edgePtrs_ref.initial;
        this.blkFlags_ref = rendererContext.rdrMem.blkFlags_ref;
        this.blkFlags = this.blkFlags_ref.initial;
    }

    @Override
    public final Renderer init(int n2, int n3, int n4, int n5, int n6) {
        this.windingRule = n6;
        this.boundsMinX = n2 << SUBPIXEL_LG_POSITIONS_X;
        this.boundsMaxX = n2 + n4 << SUBPIXEL_LG_POSITIONS_X;
        this.boundsMinY = n3 << SUBPIXEL_LG_POSITIONS_Y;
        this.boundsMaxY = n3 + n5 << SUBPIXEL_LG_POSITIONS_Y;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("boundsXY = [" + this.boundsMinX + " ... " + this.boundsMaxX + "[ [" + this.boundsMinY + " ... " + this.boundsMaxY + "[");
        }
        if ((n2 = this.boundsMaxY - this.boundsMinY + 1) > INITIAL_BUCKET_ARRAY) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_renderer_edgeBuckets.add(n2);
                this.rdrCtx.stats.stat_array_renderer_edgeBucketCounts.add(n2);
            }
            this.edgeBuckets = this.edgeBuckets_ref.getArray(n2);
            this.edgeBucketCounts = this.edgeBucketCounts_ref.getArray(n2);
        }
        this.edgeMinY = Integer.MAX_VALUE;
        this.edgeMaxY = Integer.MIN_VALUE;
        this.edgeMinX = Double.POSITIVE_INFINITY;
        this.edgeMaxX = Double.NEGATIVE_INFINITY;
        this.edgeCount = 0;
        this.activeEdgeMaxUsed = 0;
        this.edges.used = 0;
        this.bboxX0 = 0;
        this.bboxX1 = 0;
        return this;
    }

    @Override
    public final void dispose() {
        if (DO_STATS) {
            this.rdrCtx.stats.stat_rdr_activeEdges.add(this.activeEdgeMaxUsed);
            this.rdrCtx.stats.stat_rdr_edges.add(this.edges.used);
            this.rdrCtx.stats.stat_rdr_edges_count.add(this.edges.used / SIZEOF_EDGE_BYTES);
            ((StatLong)this.rdrCtx.stats.hist_rdr_edges_count).add(this.edges.used / SIZEOF_EDGE_BYTES);
            this.rdrCtx.stats.totalOffHeap += this.edges.length;
        }
        if (this.crossings_ref.doCleanRef(this.crossings)) {
            this.crossings = this.crossings_ref.putArray(this.crossings);
        }
        if (this.aux_crossings_ref.doCleanRef(this.aux_crossings)) {
            this.aux_crossings = this.aux_crossings_ref.putArray(this.aux_crossings);
        }
        if (this.edgePtrs_ref.doCleanRef(this.edgePtrs)) {
            this.edgePtrs = this.edgePtrs_ref.putArray(this.edgePtrs);
        }
        if (this.aux_edgePtrs_ref.doCleanRef(this.aux_edgePtrs)) {
            this.aux_edgePtrs = this.aux_edgePtrs_ref.putArray(this.aux_edgePtrs);
        }
        if (this.alphaLine_ref.doSetRef(this.alphaLine)) {
            this.alphaLine = this.alphaLine_ref.putArrayClean(this.alphaLine);
        }
        if (this.blkFlags_ref.doSetRef(this.blkFlags)) {
            this.blkFlags = this.blkFlags_ref.putArrayClean(this.blkFlags);
        }
        if (this.edgeMinY != Integer.MAX_VALUE) {
            if (this.rdrCtx.dirty) {
                this.buckets_minY = 0;
                this.buckets_maxY = this.boundsMaxY - this.boundsMinY;
            }
            this.edgeBuckets = this.edgeBuckets_ref.putArray(this.edgeBuckets, this.buckets_minY, this.buckets_maxY);
            this.edgeBucketCounts = this.edgeBucketCounts_ref.putArray(this.edgeBucketCounts, this.buckets_minY, this.buckets_maxY + 1);
        } else {
            if (this.edgeBuckets_ref.doSetRef(this.edgeBuckets)) {
                this.edgeBuckets = this.edgeBuckets_ref.putArrayClean(this.edgeBuckets);
            }
            if (this.edgeBucketCounts_ref.doSetRef(this.edgeBucketCounts)) {
                this.edgeBucketCounts = this.edgeBucketCounts_ref.putArrayClean(this.edgeBucketCounts);
            }
        }
        if (this.edges.length != (long)INITIAL_EDGES_CAPACITY) {
            this.edges.resize(INITIAL_EDGES_CAPACITY);
        }
    }

    private static double tosubpixx(double d2) {
        return SUBPIXEL_SCALE_X * d2;
    }

    private static double tosubpixy(double d2) {
        return SUBPIXEL_SCALE_Y * d2 - 0.5;
    }

    @Override
    public final void moveTo(double d2, double d3) {
        this.closePath();
        double d4 = Renderer.tosubpixx(d2);
        double d5 = Renderer.tosubpixy(d3);
        this.sx0 = d4;
        this.sy0 = d5;
        this.x0 = d4;
        this.y0 = d5;
    }

    @Override
    public final void lineTo(double d2, double d3) {
        double d4 = Renderer.tosubpixx(d2);
        double d5 = Renderer.tosubpixy(d3);
        Renderer renderer = this;
        renderer.addLine(renderer.x0, this.y0, d4, d5);
        this.x0 = d4;
        this.y0 = d5;
    }

    @Override
    public final void curveTo(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Renderer.tosubpixx(d6);
        double d9 = Renderer.tosubpixy(d7);
        this.curve.set(this.x0, this.y0, Renderer.tosubpixx(d2), Renderer.tosubpixy(d3), Renderer.tosubpixx(d4), Renderer.tosubpixy(d5), d8, d9);
        Renderer renderer = this;
        renderer.curveBreakIntoLinesAndAdd(renderer.x0, this.y0, this.curve, d8, d9);
        this.x0 = d8;
        this.y0 = d9;
    }

    @Override
    public final void quadTo(double d2, double d3, double d4, double d5) {
        double d6 = Renderer.tosubpixx(d4);
        double d7 = Renderer.tosubpixy(d5);
        this.curve.set(this.x0, this.y0, Renderer.tosubpixx(d2), Renderer.tosubpixy(d3), d6, d7);
        Renderer renderer = this;
        renderer.quadBreakIntoLinesAndAdd(renderer.x0, this.y0, this.curve, d6, d7);
        this.x0 = d6;
        this.y0 = d7;
    }

    @Override
    public final void closePath() {
        if (this.x0 != this.sx0 || this.y0 != this.sy0) {
            Renderer renderer = this;
            renderer.addLine(renderer.x0, this.y0, this.sx0, this.sy0);
            this.x0 = this.sx0;
            this.y0 = this.sy0;
        }
    }

    @Override
    public final void pathDone() {
        this.closePath();
        this.endRendering();
    }

    private void _endRendering(int n2, int n3, MarlinAlphaConsumer marlinAlphaConsumer) {
        if (DISABLE_RENDER) {
            return;
        }
        int n4 = this.bbox_spminX;
        int n5 = this.bbox_spmaxX;
        boolean bl2 = this.windingRule == 0;
        int[] nArray = this.alphaLine;
        OffHeapArray offHeapArray = this.edges;
        int[] nArray2 = this.edgeBuckets;
        int[] nArray3 = this.edgeBucketCounts;
        int[] nArray4 = this.crossings;
        int[] nArray5 = this.edgePtrs;
        int[] nArray6 = this.aux_crossings;
        int[] nArray7 = this.aux_edgePtrs;
        long l2 = OFF_ERROR;
        long l3 = OFF_BUMP_X;
        long l4 = OFF_BUMP_ERR;
        long l5 = OFF_NEXT;
        long l6 = OFF_YMAX;
        Unsafe unsafe = OffHeapArray.UNSAFE;
        long l7 = offHeapArray.address;
        int n6 = SUBPIXEL_LG_POSITIONS_X;
        int n7 = SUBPIXEL_LG_POSITIONS_Y;
        int n8 = SUBPIXEL_MASK_X;
        int n9 = SUBPIXEL_MASK_Y;
        int n10 = SUBPIXEL_POSITIONS_X;
        int n11 = Integer.MAX_VALUE;
        int n12 = Integer.MIN_VALUE;
        int n13 = n2 - this.boundsMinY;
        int n14 = this.edgeCount;
        int n15 = nArray5.length;
        int n16 = nArray4.length;
        int n17 = this.activeEdgeMaxUsed;
        int n18 = 0;
        int[] nArray8 = this.blkFlags;
        int n19 = BLOCK_SIZE_LG;
        int n20 = BLOCK_SIZE;
        boolean bl3 = ENABLE_BLOCK_FLAGS_HEURISTICS && this.enableBlkFlags;
        boolean bl4 = this.prevUseBlkFlags;
        int n21 = this.rdrCtx.stroking;
        int n22 = -1;
        DPQSSorterContext dPQSSorterContext = this.rdrCtx.sorterCtx;
        while (n2 < n3) {
            int n23;
            int n24;
            long l8;
            int n25 = nArray3[n13];
            int n26 = n14;
            if (n25 != 0) {
                if (DO_STATS) {
                    this.rdrCtx.stats.stat_rdr_activeEdges_updates.add(n26);
                }
                if ((n25 & 1) != 0) {
                    l8 = l7 + l6;
                    n14 = 0;
                    for (n24 = 0; n24 < n26; ++n24) {
                        n23 = nArray5[n24];
                        if (unsafe.getInt(l8 + (long)n23) <= n2) continue;
                        nArray5[n14++] = n23;
                    }
                    n26 = n14;
                }
                if ((n18 = n25 >> 1) != 0) {
                    if (DO_STATS) {
                        this.rdrCtx.stats.stat_rdr_activeEdges_adds.add(n18);
                        if (n18 > 10) {
                            this.rdrCtx.stats.stat_rdr_activeEdges_adds_high.add(n18);
                        }
                    }
                    if (n15 < (n25 = n14 + n18)) {
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_edgePtrs.add(n25);
                        }
                        this.edgePtrs = nArray5 = this.edgePtrs_ref.widenArray(nArray5, n15, n25);
                        n15 = nArray5.length;
                        this.aux_edgePtrs_ref.putArray(nArray7);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_aux_edgePtrs.add(n25);
                        }
                        this.aux_edgePtrs = nArray7 = this.aux_edgePtrs_ref.getArray(ArrayCacheConst.getNewSize(n14, n25));
                    }
                    l8 = l7 + l5;
                    n23 = nArray2[n13];
                    while (n14 < n25) {
                        nArray5[n14] = n23;
                        n23 = unsafe.getInt(l8 + (long)n23);
                        ++n14;
                    }
                    if (n16 < n14) {
                        this.crossings_ref.putArray(nArray4);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_crossings.add(n14);
                        }
                        this.crossings = nArray4 = this.crossings_ref.getArray(n14);
                        this.aux_crossings_ref.putArray(nArray6);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_array_renderer_aux_crossings.add(n14);
                        }
                        this.aux_crossings = nArray6 = this.aux_crossings_ref.getArray(n14);
                        n16 = nArray4.length;
                    }
                    if (DO_STATS && n14 > n17) {
                        n17 = n14;
                    }
                }
            }
            if (n14 != 0) {
                int n27;
                int n28;
                int n29;
                if (n14 <= 40 || n18 <= 10 && n14 <= 1000) {
                    if (DO_STATS) {
                        ((StatLong)this.rdrCtx.stats.hist_rdr_crossings).add(n14);
                        ((StatLong)this.rdrCtx.stats.hist_rdr_crossings_adds).add(n18);
                    }
                    boolean bl5 = n14 >= 20;
                    n25 = Integer.MIN_VALUE;
                    for (n24 = 0; n24 < n14; ++n24) {
                        n23 = nArray5[n24];
                        l8 = l7 + (long)n23;
                        n18 = n29 = unsafe.getInt(l8);
                        n28 = unsafe.getInt(l8 + l2) + unsafe.getInt(l8 + l4);
                        unsafe.putInt(l8, (n29 += unsafe.getInt(l8 + l3)) - (n28 >> 30 & 0xFFFFFFFE));
                        unsafe.putInt(l8 + l2, n28 & Integer.MAX_VALUE);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_rdr_crossings_updates.add(n14);
                        }
                        if (n18 < n25) {
                            if (DO_STATS) {
                                this.rdrCtx.stats.stat_rdr_crossings_sorts.add(n24);
                            }
                            if (bl5 && n24 >= n26) {
                                if (DO_STATS) {
                                    this.rdrCtx.stats.stat_rdr_crossings_bsearch.add(n24);
                                }
                                int n30 = 0;
                                int n31 = n24 - 1;
                                do {
                                    int n32;
                                    if (nArray4[n32 = n30 + n31 >> 1] < n18) {
                                        n30 = n32 + 1;
                                        continue;
                                    }
                                    n31 = n32 - 1;
                                } while (n30 <= n31);
                                for (int i2 = n24 - 1; i2 >= n30; --i2) {
                                    nArray4[i2 + 1] = nArray4[i2];
                                    nArray5[i2 + 1] = nArray5[i2];
                                }
                                nArray4[n30] = n18;
                                nArray5[n30] = n23;
                                continue;
                            }
                            int n33 = n24 - 1;
                            nArray4[n24] = nArray4[n33];
                            nArray5[n24] = nArray5[n33];
                            while (--n33 >= 0 && nArray4[n33] > n18) {
                                nArray4[n33 + 1] = nArray4[n33];
                                nArray5[n33 + 1] = nArray5[n33];
                            }
                            nArray4[n33 + 1] = n18;
                            nArray5[n33 + 1] = n23;
                            continue;
                        }
                        nArray4[n24] = n25 = n18;
                    }
                } else {
                    boolean bl6;
                    if (DO_STATS) {
                        this.rdrCtx.stats.stat_rdr_crossings_msorts.add(n14);
                        ((StatLong)this.rdrCtx.stats.hist_rdr_crossings_ratio).add(n18 * 1000 / n14);
                        ((StatLong)this.rdrCtx.stats.hist_rdr_crossings_msorts).add(n14);
                        ((StatLong)this.rdrCtx.stats.hist_rdr_crossings_msorts_adds).add(n18);
                    }
                    boolean bl7 = n26 >= 1000;
                    boolean bl8 = bl6 = MergeSort.USE_DPQS && (bl7 || n18 >= 256);
                    if (DO_STATS && bl6) {
                        this.rdrCtx.stats.stat_rdr_crossings_dpqs.add(bl7 ? n14 : n18);
                    }
                    n25 = Integer.MIN_VALUE;
                    for (n24 = 0; n24 < n14; ++n24) {
                        n23 = nArray5[n24];
                        l8 = l7 + (long)n23;
                        n18 = n29 = unsafe.getInt(l8);
                        n28 = unsafe.getInt(l8 + l2) + unsafe.getInt(l8 + l4);
                        unsafe.putInt(l8, (n29 += unsafe.getInt(l8 + l3)) - (n28 >> 30 & 0xFFFFFFFE));
                        unsafe.putInt(l8 + l2, n28 & Integer.MAX_VALUE);
                        if (DO_STATS) {
                            this.rdrCtx.stats.stat_rdr_crossings_updates.add(n14);
                        }
                        if (bl7) {
                            if (bl6) {
                                nArray4[n24] = n18;
                                continue;
                            }
                            nArray6[n24] = n18;
                            nArray7[n24] = n23;
                            continue;
                        }
                        if (n24 >= n26) {
                            if (bl6) {
                                nArray6[n24] = n18;
                                nArray7[n24] = n23;
                                continue;
                            }
                            nArray4[n24] = n18;
                            continue;
                        }
                        if (n18 < n25) {
                            if (DO_STATS) {
                                this.rdrCtx.stats.stat_rdr_crossings_sorts.add(n24);
                            }
                            int n34 = n24 - 1;
                            nArray6[n24] = nArray6[n34];
                            nArray7[n24] = nArray7[n34];
                            while (--n34 >= 0 && nArray6[n34] > n18) {
                                nArray6[n34 + 1] = nArray6[n34];
                                nArray7[n34 + 1] = nArray7[n34];
                            }
                            nArray6[n34 + 1] = n18;
                            nArray7[n34 + 1] = n23;
                            continue;
                        }
                        nArray6[n24] = n25 = n18;
                        nArray7[n24] = n23;
                    }
                    MergeSort.mergeSortNoCopy(nArray4, nArray5, nArray6, nArray7, n14, n26, bl7, dPQSSorterContext, bl6);
                }
                n18 = 0;
                n23 = nArray4[0];
                int n35 = n23 >> 1;
                if (n35 < n11) {
                    n11 = n35;
                }
                if ((n27 = nArray4[n14 - 1] >> 1) > n12) {
                    n12 = n27;
                }
                n35 = n29 = n35;
                n23 = ((n23 & 1) << 1) - 1;
                if (bl2) {
                    n25 = n23;
                    for (n24 = 1; n24 < n14; ++n24) {
                        n23 = nArray4[n24];
                        n29 = n23 >> 1;
                        n23 = ((n23 & 1) << 1) - 1;
                        if ((n25 & 1) != 0) {
                            int n36 = n35 = n35 > n4 ? n35 : n4;
                            if (n29 < n5) {
                                n27 = n29;
                            } else {
                                n27 = n5;
                                n24 = n14;
                            }
                            if (n35 < n27) {
                                n28 = (n35 -= n4) >> n6;
                                var47_55 = (n27 -= n4) - 1 >> n6;
                                if (n28 == var47_55) {
                                    n35 = n27 - n35;
                                    int n37 = n28;
                                    nArray[n37] = nArray[n37] + n35;
                                    int n38 = n28 + 1;
                                    nArray[n38] = nArray[n38] - n35;
                                    if (bl4) {
                                        nArray8[n28 >> n19] = 1;
                                    }
                                } else {
                                    int n39 = n28;
                                    nArray[n39] = nArray[n39] + (n10 - (n35 &= n8));
                                    int n40 = n28 + 1;
                                    nArray[n40] = nArray[n40] + n35;
                                    var47_55 = n27 >> n6;
                                    n35 = n27 & n8;
                                    int n41 = var47_55;
                                    nArray[n41] = nArray[n41] - (n10 - n35);
                                    int n42 = var47_55 + 1;
                                    nArray[n42] = nArray[n42] - n35;
                                    if (bl4) {
                                        nArray8[n28 >> n19] = 1;
                                        nArray8[var47_55 >> n19] = 1;
                                    }
                                }
                            }
                        }
                        n25 += n23;
                        n35 = n29;
                    }
                } else {
                    n24 = 1;
                    n25 = 0;
                    while (true) {
                        if ((n25 += n23) != 0) {
                            if (n35 > n29) {
                                n35 = n29;
                            }
                        } else {
                            int n43 = n35 = n35 > n4 ? n35 : n4;
                            if (n29 < n5) {
                                n27 = n29;
                            } else {
                                n27 = n5;
                                n24 = n14;
                            }
                            if (n35 < n27) {
                                n28 = (n35 -= n4) >> n6;
                                var47_55 = (n27 -= n4) - 1 >> n6;
                                if (n28 == var47_55) {
                                    n35 = n27 - n35;
                                    int n44 = n28;
                                    nArray[n44] = nArray[n44] + n35;
                                    int n45 = n28 + 1;
                                    nArray[n45] = nArray[n45] - n35;
                                    if (bl4) {
                                        nArray8[n28 >> n19] = 1;
                                    }
                                } else {
                                    int n46 = n28;
                                    nArray[n46] = nArray[n46] + (n10 - (n35 &= n8));
                                    int n47 = n28 + 1;
                                    nArray[n47] = nArray[n47] + n35;
                                    var47_55 = n27 >> n6;
                                    n35 = n27 & n8;
                                    int n48 = var47_55;
                                    nArray[n48] = nArray[n48] - (n10 - n35);
                                    int n49 = var47_55 + 1;
                                    nArray[n49] = nArray[n49] - n35;
                                    if (bl4) {
                                        nArray8[n28 >> n19] = 1;
                                        nArray8[var47_55 >> n19] = 1;
                                    }
                                }
                            }
                            n35 = Integer.MAX_VALUE;
                        }
                        if (n24 == n14) break;
                        n23 = nArray4[n24];
                        n29 = n23 >> 1;
                        n23 = ((n23 & 1) << 1) - 1;
                        ++n24;
                    }
                }
            }
            if ((n2 & n9) == n9) {
                n22 = n2 >> n7;
                n11 = FloatMath.max(n11, n4) >> n6;
                if ((n12 = FloatMath.min(n12, n5) >> n6) >= n11) {
                    this.copyAARow(nArray, n22, n11, n12 + 1, bl4, marlinAlphaConsumer);
                    if (bl3) {
                        boolean bl9 = bl4 = (n12 -= n11) > n20 && n12 > (n14 >> n21) - 1 << n19;
                        if (DO_STATS) {
                            int n50 = FloatMath.max(1, (n14 >> n21) - 1);
                            ((StatLong)this.rdrCtx.stats.hist_tile_generator_encoding_dist).add(n12 / n50);
                        }
                    }
                } else {
                    marlinAlphaConsumer.clearAlphas(n22);
                }
                n11 = Integer.MAX_VALUE;
                n12 = Integer.MIN_VALUE;
            }
            ++n2;
            ++n13;
        }
        --n2;
        n2 >>= n7;
        n11 = FloatMath.max(n11, n4) >> n6;
        if ((n12 = FloatMath.min(n12, n5) >> n6) >= n11) {
            this.copyAARow(nArray, n2, n11, n12 + 1, bl4, marlinAlphaConsumer);
        } else if (n2 != n22) {
            marlinAlphaConsumer.clearAlphas(n2);
        }
        this.edgeCount = n14;
        this.prevUseBlkFlags = bl4;
        if (DO_STATS) {
            this.activeEdgeMaxUsed = n17;
        }
    }

    final void endRendering() {
        int n2;
        if (this.edgeMinY == Integer.MAX_VALUE) {
            return;
        }
        int n3 = FloatMath.max(FloatMath.ceil_int(this.edgeMinX - 0.5), this.boundsMinX);
        int n4 = FloatMath.min(FloatMath.ceil_int(this.edgeMaxX - 0.5), this.boundsMaxX);
        int n5 = this.edgeMinY;
        int n6 = this.edgeMaxY;
        this.buckets_minY = n5 - this.boundsMinY;
        this.buckets_maxY = n6 - this.boundsMinY;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("edgesXY = [" + this.edgeMinX + " ... " + this.edgeMaxX + "[ [" + this.edgeMinY + " ... " + this.edgeMaxY + "[");
            MarlinUtils.logInfo("spXY    = [" + n3 + " ... " + n4 + "[ [" + n5 + " ... " + n6 + "[");
        }
        if (n3 >= n4 || n5 >= n6) {
            return;
        }
        n4 = n4 + SUBPIXEL_MASK_X >> SUBPIXEL_LG_POSITIONS_X;
        int n7 = n5 >> SUBPIXEL_LG_POSITIONS_Y;
        int n8 = n6 + SUBPIXEL_MASK_Y >> SUBPIXEL_LG_POSITIONS_Y;
        this.initConsumer(n3 >>= SUBPIXEL_LG_POSITIONS_X, n7, n4, n8);
        if (ENABLE_BLOCK_FLAGS) {
            this.enableBlkFlags = this.useRLE;
            boolean bl2 = this.prevUseBlkFlags = this.enableBlkFlags && !ENABLE_BLOCK_FLAGS_HEURISTICS;
            if (this.enableBlkFlags && (n2 = (n4 - n3 >> BLOCK_SIZE_LG) + 2) > 256) {
                this.blkFlags = this.blkFlags_ref.getArray(n2);
            }
        }
        this.bbox_spminX = n3 << SUBPIXEL_LG_POSITIONS_X;
        this.bbox_spmaxX = n4 << SUBPIXEL_LG_POSITIONS_X;
        this.bbox_spminY = n5;
        this.bbox_spmaxY = n6;
        if (DO_LOG_BOUNDS) {
            MarlinUtils.logInfo("pXY       = [" + n3 + " ... " + n4 + "[ [" + n7 + " ... " + n8 + "[");
            MarlinUtils.logInfo("bbox_spXY = [" + this.bbox_spminX + " ... " + this.bbox_spmaxX + "[ [" + this.bbox_spminY + " ... " + this.bbox_spmaxY + "[");
        }
        if ((n2 = n4 - n3 + 2) > INITIAL_AA_ARRAY) {
            if (DO_STATS) {
                this.rdrCtx.stats.stat_array_renderer_alphaline.add(n2);
            }
            this.alphaLine = this.alphaLine_ref.getArray(n2);
        }
    }

    /*
     * Unable to fully structure code
     */
    final void initConsumer(int var1_1, int var2_2, int var3_3, int var4_4) {
        block4: {
            this.bboxX0 = var1_1;
            this.bboxX1 = var3_3;
            this.bboxY0 = var2_2;
            this.bboxY1 = var4_4;
            var1_1 = var3_3 - var1_1;
            if (!Renderer.FORCE_NO_RLE) break block4;
            v0 = this;
            ** GOTO lbl-1000
        }
        if (Renderer.FORCE_RLE) {
            v0 = this;
            v1 = true;
        } else {
            v0 = this;
            if (var1_1 > Renderer.RLE_MIN_WIDTH) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
        }
        v0.useRLE = v1;
    }

    @Override
    public final void produceAlphas(MarlinAlphaConsumer marlinAlphaConsumer) {
        marlinAlphaConsumer.setMaxAlpha(MAX_AA_ALPHA);
        if (this.enableBlkFlags && !marlinAlphaConsumer.supportBlockFlags()) {
            this.enableBlkFlags = false;
            this.prevUseBlkFlags = false;
        }
        Renderer renderer = this;
        renderer._endRendering(renderer.bbox_spminY, this.bbox_spmaxY, marlinAlphaConsumer);
    }

    final void copyAARow(int[] nArray, int n2, int n3, int n4, boolean bl2, MarlinAlphaConsumer marlinAlphaConsumer) {
        if (DO_STATS) {
            this.rdrCtx.stats.stat_cache_rowAA.add(n4 - n3);
        }
        if (bl2) {
            if (DO_STATS) {
                ((StatLong)this.rdrCtx.stats.hist_tile_generator_encoding).add(1);
            }
            marlinAlphaConsumer.setAndClearRelativeAlphas(this.blkFlags, nArray, n2, n3, n4);
            return;
        }
        if (DO_STATS) {
            ((StatLong)this.rdrCtx.stats.hist_tile_generator_encoding).add(0);
        }
        marlinAlphaConsumer.setAndClearRelativeAlphas(nArray, n2, n3, n4);
    }

    @Override
    public final int getOutpixMinX() {
        return this.bboxX0;
    }

    @Override
    public final int getOutpixMaxX() {
        return this.bboxX1;
    }

    @Override
    public final int getOutpixMinY() {
        return this.bboxY0;
    }

    @Override
    public final int getOutpixMaxY() {
        return this.bboxY1;
    }

    @Override
    public final double getOffsetX() {
        return RDR_OFFSET_X;
    }

    @Override
    public final double getOffsetY() {
        return RDR_OFFSET_Y;
    }
}

