/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.prism.Image;
import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.Texture$WrapMode;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class MultiTexture
implements Texture {
    private int width;
    private int height;
    private PixelFormat format;
    private Texture$WrapMode wrapMode;
    private boolean linearFiltering = true;
    private final ArrayList<Texture> textures;
    private int lastImageSerial;

    public MultiTexture(PixelFormat pixelFormat, Texture$WrapMode texture$WrapMode, int n2, int n3) {
        this.width = n2;
        this.height = n3;
        this.format = pixelFormat;
        this.wrapMode = texture$WrapMode;
        this.textures = new ArrayList(4);
    }

    private MultiTexture(MultiTexture multiTexture, Texture$WrapMode texture$WrapMode) {
        this(multiTexture.format, texture$WrapMode, multiTexture.width, multiTexture.height);
        for (int i2 = 0; i2 < multiTexture.textureCount(); ++i2) {
            Texture texture = multiTexture.getTexture(i2);
            this.setTexture(texture.getSharedTexture(texture$WrapMode), i2);
        }
        this.linearFiltering = multiTexture.linearFiltering;
        this.lastImageSerial = multiTexture.lastImageSerial;
    }

    @Override
    public final Texture getSharedTexture(Texture$WrapMode object) {
        this.assertLocked();
        if (this.wrapMode == object) {
            this.lock();
            return this;
        }
        switch (object) {
            case REPEAT: {
                if (this.wrapMode == Texture$WrapMode.CLAMP_TO_EDGE) break;
                return null;
            }
            case CLAMP_TO_EDGE: {
                if (this.wrapMode == Texture$WrapMode.REPEAT) break;
                return null;
            }
            default: {
                return null;
            }
        }
        object = new MultiTexture(this, (Texture$WrapMode)((Object)object));
        object.lock();
        return object;
    }

    public final int textureCount() {
        return this.textures.size();
    }

    public final void setTexture(Texture texture, int n2) {
        if (!texture.getWrapMode().isCompatibleWith(this.wrapMode)) {
            throw new IllegalArgumentException("texture wrap mode must match multi-texture mode");
        }
        if (this.textures.size() < n2 + 1) {
            for (int i2 = this.textures.size(); i2 < n2; ++i2) {
                this.textures.add(null);
            }
            this.textures.add(texture);
        } else {
            this.textures.set(n2, texture);
        }
        texture.setLinearFiltering(this.linearFiltering);
    }

    public final Texture getTexture(int n2) {
        return this.textures.get(n2);
    }

    public final Texture[] getTextures() {
        return this.textures.toArray(new Texture[this.textures.size()]);
    }

    public final void removeTexture(Texture texture) {
        this.textures.remove(texture);
    }

    public final void removeTexture(int n2) {
        this.textures.remove(n2);
    }

    @Override
    public final PixelFormat getPixelFormat() {
        return this.format;
    }

    @Override
    public final int getPhysicalWidth() {
        return this.width;
    }

    @Override
    public final int getPhysicalHeight() {
        return this.height;
    }

    @Override
    public final int getContentX() {
        return 0;
    }

    @Override
    public final int getContentY() {
        return 0;
    }

    @Override
    public final int getContentWidth() {
        return this.width;
    }

    @Override
    public final int getContentHeight() {
        return this.height;
    }

    @Override
    public final int getLastImageSerial() {
        return this.lastImageSerial;
    }

    @Override
    public final void setLastImageSerial(int n2) {
        this.lastImageSerial = n2;
    }

    @Override
    public final void update(Image image) {
        throw new UnsupportedOperationException("Update from Image not supported");
    }

    @Override
    public final void update(Image image, int n2, int n3) {
        throw new UnsupportedOperationException("Update from Image not supported");
    }

    @Override
    public final void update(Image image, int n2, int n3, int n4, int n5) {
        throw new UnsupportedOperationException("Update from Image not supported");
    }

    @Override
    public final void update(Image image, int n2, int n3, int n4, int n5, boolean bl2) {
        throw new UnsupportedOperationException("Update from Image not supported");
    }

    @Override
    public final void update(Buffer buffer, PixelFormat pixelFormat, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        throw new UnsupportedOperationException("Update from generic Buffer not supported");
    }

    @Override
    public final void update(MediaFrame mediaFrame, boolean bl2) {
        if (mediaFrame.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            int n2 = mediaFrame.getEncodedWidth();
            int n3 = mediaFrame.getEncodedHeight();
            for (int i2 = 0; i2 < mediaFrame.planeCount(); ++i2) {
                Texture texture = this.textures.get(i2);
                if (texture == null) continue;
                int n4 = n2;
                int n5 = n3;
                if (i2 == 2 || i2 == 1) {
                    n4 /= 2;
                    n5 /= 2;
                }
                ByteBuffer byteBuffer = mediaFrame.getBufferForPlane(i2);
                texture.update(byteBuffer, PixelFormat.BYTE_ALPHA, 0, 0, 0, 0, n4, n5, mediaFrame.strideForPlane(i2), bl2);
            }
            return;
        }
        throw new IllegalArgumentException("Invalid pixel format in MediaFrame");
    }

    @Override
    public final Texture$WrapMode getWrapMode() {
        return this.wrapMode;
    }

    @Override
    public final boolean getUseMipmap() {
        return false;
    }

    @Override
    public final boolean getLinearFiltering() {
        return this.linearFiltering;
    }

    @Override
    public final void setLinearFiltering(boolean bl2) {
        this.linearFiltering = bl2;
        for (Texture texture : this.textures) {
            texture.setLinearFiltering(bl2);
        }
    }

    @Override
    public final void lock() {
        for (Texture texture : this.textures) {
            texture.lock();
        }
    }

    @Override
    public final void unlock() {
        for (Texture texture : this.textures) {
            texture.unlock();
        }
    }

    @Override
    public final boolean isLocked() {
        for (Texture texture : this.textures) {
            if (!texture.isLocked()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int getLockCount() {
        int n2 = 0;
        for (Texture texture : this.textures) {
            n2 = Math.max(n2, texture.getLockCount());
        }
        return n2;
    }

    @Override
    public final void assertLocked() {
        for (Texture texture : this.textures) {
            texture.assertLocked();
        }
    }

    @Override
    public final void makePermanent() {
        for (Texture texture : this.textures) {
            texture.makePermanent();
        }
    }

    @Override
    public final void contentsUseful() {
        for (Texture texture : this.textures) {
            texture.contentsUseful();
        }
    }

    @Override
    public final void contentsNotUseful() {
        for (Texture texture : this.textures) {
            texture.contentsNotUseful();
        }
    }

    @Override
    public final boolean isSurfaceLost() {
        for (Texture texture : this.textures) {
            if (!texture.isSurfaceLost()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void dispose() {
        for (Texture texture : this.textures) {
            texture.dispose();
        }
        this.textures.clear();
    }

    @Override
    public final int getMaxContentWidth() {
        return this.getPhysicalWidth();
    }

    @Override
    public final int getMaxContentHeight() {
        return this.getPhysicalHeight();
    }

    @Override
    public final void setContentWidth(int n2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public final void setContentHeight(int n2) {
        throw new UnsupportedOperationException("Not supported.");
    }
}

