/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.prism.PixelSource;

public abstract class PresentableState {
    protected Window window;
    protected View view;
    protected int nativeFrameBuffer;
    protected int windowX;
    protected int windowY;
    protected float windowAlpha;
    protected long nativeWindowHandle;
    protected long nativeView;
    protected int viewWidth;
    protected int viewHeight;
    protected float renderScaleX;
    protected float renderScaleY;
    protected int renderWidth;
    protected int renderHeight;
    protected float outputScaleX;
    protected float outputScaleY;
    protected int outputWidth;
    protected int outputHeight;
    protected int screenHeight;
    protected int screenWidth;
    protected boolean isWindowVisible;
    protected boolean isWindowMinimized;
    protected static final boolean hasWindowManager = Application.GetApplication().hasWindowManager();
    protected boolean isClosed;
    protected final int pixelFormat = Pixels.getNativeFormat();

    public int getWindowX() {
        return this.windowX;
    }

    public int getWindowY() {
        return this.windowY;
    }

    public int getWidth() {
        return this.viewWidth;
    }

    public int getHeight() {
        return this.viewHeight;
    }

    public int getRenderWidth() {
        return this.renderWidth;
    }

    public int getRenderHeight() {
        return this.renderHeight;
    }

    public int getOutputWidth() {
        return this.outputWidth;
    }

    public int getOutputHeight() {
        return this.outputHeight;
    }

    public float getRenderScaleX() {
        return this.renderScaleX;
    }

    public float getRenderScaleY() {
        return this.renderScaleY;
    }

    public float getOutputScaleX() {
        return this.outputScaleX;
    }

    public float getOutputScaleY() {
        return this.outputScaleY;
    }

    public float getAlpha() {
        return this.windowAlpha;
    }

    public long getNativeWindow() {
        return this.nativeWindowHandle;
    }

    public long getNativeView() {
        return this.nativeView;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public boolean isViewClosed() {
        return this.isClosed;
    }

    public boolean isWindowMinimized() {
        return this.isWindowMinimized;
    }

    public boolean isWindowVisible() {
        return this.isWindowVisible;
    }

    public boolean hasWindowManager() {
        return hasWindowManager;
    }

    public Window getWindow() {
        return this.window;
    }

    public boolean isMSAA() {
        return false;
    }

    public View getView() {
        return this.view;
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public int getNativeFrameBuffer() {
        return this.nativeFrameBuffer;
    }

    public void lock() {
        if (this.view != null) {
            this.view.lock();
            this.nativeFrameBuffer = this.view.getNativeFrameBuffer();
        }
    }

    public void unlock() {
        if (this.view != null) {
            this.view.unlock();
        }
    }

    public void uploadPixels(PixelSource pixelSource) {
        Pixels pixels = pixelSource.getLatestPixels();
        if (pixels != null) {
            try {
                this.view.uploadPixels(pixels);
                return;
            }
            finally {
                pixelSource.doneWithPixels(pixels);
            }
        }
    }

    private int scale(int n2, float f2, float f3) {
        if (f2 == f3) {
            return n2;
        }
        return (int)Math.ceil((float)n2 * f3 / f2);
    }

    protected void update(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.renderScaleX = f4;
        this.renderScaleY = f5;
        this.outputScaleX = f6;
        this.outputScaleY = f7;
        if (f4 == f2 && f5 == f3) {
            this.renderWidth = this.viewWidth;
            this.renderHeight = this.viewHeight;
        } else {
            this.renderWidth = this.scale(this.viewWidth, f2, f4);
            this.renderHeight = this.scale(this.viewHeight, f3, f5);
        }
        if (f6 == f2 && f7 == f3) {
            this.outputWidth = this.viewWidth;
            this.outputHeight = this.viewHeight;
            return;
        }
        if (f6 == f4 && f7 == f5) {
            this.outputWidth = this.renderWidth;
            this.outputHeight = this.renderHeight;
            return;
        }
        this.outputWidth = this.scale(this.viewWidth, f2, f6);
        this.outputHeight = this.scale(this.viewHeight, f3, f7);
    }

    public void update() {
        if (this.view != null) {
            this.viewWidth = this.view.getWidth();
            this.viewHeight = this.view.getHeight();
            this.window = this.view.getWindow();
        } else {
            PresentableState presentableState = this;
            presentableState.viewHeight = -1;
            presentableState.viewWidth = -1;
            this.window = null;
        }
        if (this.window != null) {
            this.windowX = this.window.getX();
            this.windowY = this.window.getY();
            this.windowAlpha = this.window.getAlpha();
            this.nativeView = this.view.getNativeView();
            this.nativeWindowHandle = this.window.getNativeWindow();
            this.isClosed = this.view.isClosed();
            this.isWindowVisible = this.window.isVisible();
            this.isWindowMinimized = this.window.isMinimized();
            PresentableState presentableState = this;
            presentableState.update(presentableState.window.getPlatformScaleX(), this.window.getPlatformScaleY(), this.window.getRenderScaleX(), this.window.getRenderScaleY(), this.window.getOutputScaleX(), this.window.getOutputScaleY());
            Screen screen = this.window.getScreen();
            if (screen != null) {
                this.screenHeight = screen.getHeight();
                this.screenWidth = screen.getWidth();
            }
            return;
        }
        this.nativeView = -1L;
        this.nativeWindowHandle = -1L;
        this.isClosed = true;
    }
}

