/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Light;
import com.sun.prism.es2.ES2MeshView;
import com.sun.prism.es2.ES2PhongMaterial;
import com.sun.prism.es2.ES2PhongShader$BumpMapState;
import com.sun.prism.es2.ES2PhongShader$DiffuseState;
import com.sun.prism.es2.ES2PhongShader$SelfIllumState;
import com.sun.prism.es2.ES2PhongShader$SpecularState;
import com.sun.prism.es2.ES2ResourceFactory;
import com.sun.prism.es2.ES2Shader;
import java.util.HashMap;
import java.util.Map;

class ES2PhongShader {
    static ES2Shader[][][][][] shaders = null;
    static String vertexShaderSource;
    static String mainFragShaderSource;
    static final int lightStateCount = 4;
    private static String[] diffuseShaderParts;
    private static String[] specularShaderParts;
    private static String[] selfIllumShaderParts;
    private static String[] normalMapShaderParts;
    private static String[] lightingShaderParts;

    ES2PhongShader() {
    }

    static ES2PhongShader$SpecularState getSpecularState(ES2PhongMaterial eS2PhongMaterial) {
        if (eS2PhongMaterial.maps[ES2PhongMaterial.SPECULAR].getTexture() != null) {
            if (eS2PhongMaterial.specularColorSet) {
                return ES2PhongShader$SpecularState.MIX;
            }
            return ES2PhongShader$SpecularState.TEXTURE;
        }
        if (eS2PhongMaterial.specularColorSet) {
            return ES2PhongShader$SpecularState.COLOR;
        }
        return ES2PhongShader$SpecularState.NONE;
    }

    static ES2Shader getShader(ES2MeshView object, ES2Context eS2Context) {
        ES2PhongMaterial eS2PhongMaterial = ((ES2MeshView)object).getMaterial();
        ES2PhongShader$DiffuseState eS2PhongShader$DiffuseState = ES2PhongShader$DiffuseState.DIFFUSECOLOR;
        if (eS2PhongMaterial.maps[ES2PhongMaterial.DIFFUSE].getTexture() != null) {
            eS2PhongShader$DiffuseState = ES2PhongShader$DiffuseState.TEXTURE;
        }
        ES2PhongShader$SpecularState eS2PhongShader$SpecularState = ES2PhongShader.getSpecularState(eS2PhongMaterial);
        ES2PhongShader$BumpMapState eS2PhongShader$BumpMapState = ES2PhongShader$BumpMapState.NONE;
        if (eS2PhongMaterial.maps[ES2PhongMaterial.BUMP].getTexture() != null) {
            eS2PhongShader$BumpMapState = ES2PhongShader$BumpMapState.TEXTURE;
        }
        ES2PhongShader$SelfIllumState eS2PhongShader$SelfIllumState = ES2PhongShader$SelfIllumState.NONE;
        if (eS2PhongMaterial.maps[ES2PhongMaterial.SELF_ILLUM].getTexture() != null) {
            eS2PhongShader$SelfIllumState = ES2PhongShader$SelfIllumState.TEXTURE;
        }
        int n2 = 0;
        for (ES2Light object2 : ((ES2MeshView)object).getLights()) {
            if (object2 == null || !(object2.w > 0.0f)) continue;
            ++n2;
        }
        object = shaders[eS2PhongShader$DiffuseState.ordinal()][eS2PhongShader$SpecularState.ordinal()][eS2PhongShader$SelfIllumState.ordinal()][eS2PhongShader$BumpMapState.ordinal()][n2];
        if (object == null) {
            String string = lightingShaderParts[n2].replace("vec4 apply_diffuse();", diffuseShaderParts[eS2PhongShader$DiffuseState.ordinal()]);
            string = string.replace("vec4 apply_specular();", specularShaderParts[eS2PhongShader$SpecularState.ordinal()]);
            string = string.replace("vec3 apply_normal();", normalMapShaderParts[eS2PhongShader$BumpMapState.ordinal()]);
            string = string.replace("vec4 apply_selfIllum();", selfIllumShaderParts[eS2PhongShader$SelfIllumState.ordinal()]);
            String[] stringArray = new String[]{string};
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("pos", 0);
            hashMap.put("texCoords", 1);
            hashMap.put("tangent", 2);
            object = new HashMap<String, Integer>();
            object.put("diffuseTexture", 0);
            object.put("specularMap", 1);
            object.put("normalMap", 2);
            object.put("selfIllumTexture", 3);
            ES2PhongShader.shaders[eS2PhongShader$DiffuseState.ordinal()][eS2PhongShader$SpecularState.ordinal()][eS2PhongShader$SelfIllumState.ordinal()][eS2PhongShader$BumpMapState.ordinal()][n2] = object = ES2Shader.createFromSource(eS2Context, vertexShaderSource, stringArray, (Map<String, Integer>)object, hashMap, 1, false);
        }
        return object;
    }

    static void setShaderParamaters(ES2Shader eS2Shader, ES2MeshView eS2MeshView, ES2Context eS2Context) {
        Object object = eS2MeshView.getMaterial();
        eS2Shader.setConstant("diffuseColor", ((ES2PhongMaterial)object).diffuseColor.getRed(), ((ES2PhongMaterial)object).diffuseColor.getGreen(), ((ES2PhongMaterial)object).diffuseColor.getBlue(), ((ES2PhongMaterial)object).diffuseColor.getAlpha());
        eS2Shader.setConstant("specularColor", ((ES2PhongMaterial)object).specularColor.getRed(), ((ES2PhongMaterial)object).specularColor.getGreen(), ((ES2PhongMaterial)object).specularColor.getBlue(), ((ES2PhongMaterial)object).specularColor.getAlpha());
        eS2Context.updateTexture(0, ((ES2PhongMaterial)object).maps[ES2PhongMaterial.DIFFUSE].getTexture());
        eS2Context.updateTexture(1, ((ES2PhongMaterial)object).maps[ES2PhongMaterial.SPECULAR].getTexture());
        eS2Context.updateTexture(2, ((ES2PhongMaterial)object).maps[ES2PhongMaterial.BUMP].getTexture());
        eS2Context.updateTexture(3, ((ES2PhongMaterial)object).maps[ES2PhongMaterial.SELF_ILLUM].getTexture());
        eS2Shader.setConstant("ambientColor", eS2MeshView.getAmbientLightRed(), eS2MeshView.getAmbientLightGreen(), eS2MeshView.getAmbientLightBlue());
        for (int i2 = 0; i2 < eS2MeshView.getLights().length; ++i2) {
            object = eS2MeshView.getLights()[i2];
            if (object == null || !(((ES2Light)object).w > 0.0f)) continue;
            ES2PhongShader.setLightConstants(i2, eS2Shader, (ES2Light)object);
        }
    }

    private static void setLightConstants(int n2, ES2Shader eS2Shader, ES2Light eS2Light) {
        float f2;
        float f3;
        eS2Shader.setConstant("lights[" + n2 + "].pos", eS2Light.x, eS2Light.y, eS2Light.z, eS2Light.w);
        eS2Shader.setConstant("lights[" + n2 + "].color", eS2Light.r, eS2Light.g, eS2Light.b);
        eS2Shader.setConstant("lights[" + n2 + "].attn", eS2Light.ca, eS2Light.la, eS2Light.qa, eS2Light.isAttenuated);
        eS2Shader.setConstant("lights[" + n2 + "].range", eS2Light.maxRange);
        if (eS2Light.isPointLight()) {
            eS2Shader.setConstant("lights[" + n2 + "].dir", 0.0f, 0.0f, 1.0f);
        } else {
            f3 = eS2Light.dirX;
            f2 = eS2Light.dirY;
            float f4 = eS2Light.dirZ;
            float f5 = f3;
            float f6 = f2;
            float f7 = f4;
            float f8 = (float)Math.sqrt(f5 * f5 + f6 * f6 + f7 * f7);
            eS2Shader.setConstant("lights[" + n2 + "].dir", f3 / f8, f2 / f8, f4 / f8);
        }
        if (eS2Light.isPointLight() || eS2Light.isDirectionalLight()) {
            eS2Shader.setConstant("lights[" + n2 + "].cosOuter", -1.0f);
            eS2Shader.setConstant("lights[" + n2 + "].denom", 2.0f);
            eS2Shader.setConstant("lights[" + n2 + "].falloff", 0.0f);
            return;
        }
        f3 = (float)Math.cos(Math.toRadians(eS2Light.outerAngle));
        f2 = (float)Math.cos(Math.toRadians(eS2Light.innerAngle));
        eS2Shader.setConstant("lights[" + n2 + "].cosOuter", f3);
        eS2Shader.setConstant("lights[" + n2 + "].denom", f2 - f3);
        eS2Shader.setConstant("lights[" + n2 + "].falloff", eS2Light.falloff);
    }

    static {
        diffuseShaderParts = new String[ES2PhongShader$DiffuseState.values().length];
        specularShaderParts = new String[ES2PhongShader$SpecularState.values().length];
        selfIllumShaderParts = new String[ES2PhongShader$SelfIllumState.values().length];
        normalMapShaderParts = new String[ES2PhongShader$BumpMapState.values().length];
        lightingShaderParts = new String[4];
        shaders = new ES2Shader[ES2PhongShader$DiffuseState.values().length][ES2PhongShader$SpecularState.values().length][ES2PhongShader$SelfIllumState.values().length][ES2PhongShader$BumpMapState.values().length][4];
        ES2PhongShader.diffuseShaderParts[ES2PhongShader$DiffuseState.NONE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/diffuse_none.frag"));
        ES2PhongShader.diffuseShaderParts[ES2PhongShader$DiffuseState.DIFFUSECOLOR.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/diffuse_color.frag"));
        ES2PhongShader.diffuseShaderParts[ES2PhongShader$DiffuseState.TEXTURE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/diffuse_texture.frag"));
        ES2PhongShader.specularShaderParts[ES2PhongShader$SpecularState.NONE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/specular_none.frag"));
        ES2PhongShader.specularShaderParts[ES2PhongShader$SpecularState.TEXTURE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/specular_texture.frag"));
        ES2PhongShader.specularShaderParts[ES2PhongShader$SpecularState.COLOR.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/specular_color.frag"));
        ES2PhongShader.specularShaderParts[ES2PhongShader$SpecularState.MIX.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/specular_mix.frag"));
        ES2PhongShader.selfIllumShaderParts[ES2PhongShader$SelfIllumState.NONE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/selfIllum_none.frag"));
        ES2PhongShader.selfIllumShaderParts[ES2PhongShader$SelfIllumState.TEXTURE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/selfIllum_texture.frag"));
        ES2PhongShader.normalMapShaderParts[ES2PhongShader$BumpMapState.NONE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/normalMap_none.frag"));
        ES2PhongShader.normalMapShaderParts[ES2PhongShader$BumpMapState.TEXTURE.ordinal()] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/normalMap_texture.frag"));
        ES2PhongShader.lightingShaderParts[0] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/main0Lights.frag"));
        ES2PhongShader.lightingShaderParts[1] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/main1Light.frag"));
        ES2PhongShader.lightingShaderParts[2] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/main2Lights.frag"));
        ES2PhongShader.lightingShaderParts[3] = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/main3Lights.frag"));
        vertexShaderSource = ES2Shader.readStreamIntoString(ES2ResourceFactory.class.getResourceAsStream("glsl/main.vert"));
    }
}

