/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2;

import com.sun.javafx.PlatformUtil;
import com.sun.prism.Image;
import com.sun.prism.MediaFrame;
import com.sun.prism.MultiTexture;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.es2.ES2Context;
import com.sun.prism.es2.ES2Pipeline;
import com.sun.prism.es2.ES2TextureData;
import com.sun.prism.es2.ES2TextureResource;
import com.sun.prism.es2.ES2VramPool;
import com.sun.prism.es2.GLContext;
import com.sun.prism.impl.BaseTexture;
import com.sun.prism.impl.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

class ES2Texture<T extends ES2TextureData>
extends BaseTexture<ES2TextureResource<T>> {
    final ES2Context context;

    ES2Texture(ES2Context eS2Context, ES2TextureResource<T> eS2TextureResource, PixelFormat pixelFormat, Texture$WrapMode texture$WrapMode, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        super(eS2TextureResource, pixelFormat, texture$WrapMode, n2, n3, n4, n5, n6, n7, bl2);
        this.context = eS2Context;
    }

    ES2Texture(ES2Context eS2Context, ES2TextureResource<T> eS2TextureResource, PixelFormat pixelFormat, Texture$WrapMode texture$WrapMode, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2) {
        super(eS2TextureResource, pixelFormat, texture$WrapMode, n2, n3, n4, n5, n6, n7, n8, n9, bl2);
        this.context = eS2Context;
    }

    private ES2Texture(ES2Texture eS2Texture, Texture$WrapMode texture$WrapMode) {
        super(eS2Texture, texture$WrapMode, false);
        this.context = eS2Texture.context;
    }

    @Override
    protected Texture createSharedTexture(Texture$WrapMode texture$WrapMode) {
        return new ES2Texture<T>(this, texture$WrapMode);
    }

    static int nextPowerOfTwo(int n2, int n3) {
        if (n2 > n3) {
            return 0;
        }
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        return n3;
    }

    static ES2Texture create(ES2Context eS2Context, PixelFormat pixelFormat, Texture$WrapMode texture$WrapMode, int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (!eS2Context.getResourceFactory().isFormatSupported(pixelFormat)) {
            throw new UnsupportedOperationException("Pixel format " + String.valueOf((Object)pixelFormat) + " not supported on this device");
        }
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new IllegalArgumentException("Format requires multitexturing: " + String.valueOf((Object)pixelFormat));
        }
        GLContext gLContext = eS2Context.getGLContext();
        switch (texture$WrapMode) {
            case CLAMP_TO_ZERO: {
                if (gLContext.canClampToZero()) break;
                texture$WrapMode = texture$WrapMode.simulatedVersion();
                break;
            }
            case CLAMP_TO_EDGE: 
            case REPEAT: {
                if (gLContext.canCreateNonPowTwoTextures()) break;
                int n8 = n2;
                if ((n8 & n8 - 1) == 0) {
                    int n9 = n3;
                    if ((n9 & n9 - 1) == 0) break;
                }
                texture$WrapMode = texture$WrapMode.simulatedVersion();
                break;
            }
            case CLAMP_NOT_NEEDED: {
                break;
            }
            case CLAMP_TO_EDGE_SIMULATED: 
            case CLAMP_TO_ZERO_SIMULATED: 
            case REPEAT_SIMULATED: {
                throw new IllegalArgumentException("Cannot request simulated wrap mode: " + String.valueOf((Object)texture$WrapMode));
            }
        }
        int n10 = gLContext.getMaxTextureSize();
        int n11 = n2;
        int n12 = n3;
        switch (texture$WrapMode) {
            case CLAMP_TO_ZERO_SIMULATED: {
                n7 = 1;
                n6 = 1;
                n5 = n11 + 2;
                n4 = n12 + 2;
                break;
            }
            case CLAMP_TO_EDGE_SIMULATED: 
            case REPEAT_SIMULATED: {
                n7 = 0;
                n6 = 0;
                n5 = n11;
                n4 = n12;
                int n13 = n2;
                if ((n13 & n13 - 1) != 0) {
                    ++n5;
                }
                int n14 = n3;
                if ((n14 & n14 - 1) == 0) break;
                ++n4;
                break;
            }
            default: {
                n7 = 0;
                n6 = 0;
                n5 = n11;
                n4 = n12;
            }
        }
        if (n5 > n10 || n4 > n10) {
            throw new RuntimeException("Requested texture dimensions (" + n2 + "x" + n3 + ") require dimensions (" + n5 + "x" + n4 + ") that exceed maximum texture size (" + n10 + ")");
        }
        if (!gLContext.canCreateNonPowTwoTextures()) {
            n5 = ES2Texture.nextPowerOfTwo(n5, n10);
            n4 = ES2Texture.nextPowerOfTwo(n4, n10);
        }
        if (n5 <= 0 || n4 <= 0) {
            throw new RuntimeException("Illegal texture dimensions (" + n5 + "x" + n4 + ")");
        }
        n2 = pixelFormat.getBytesPerPixelUnit();
        if (n5 >= Integer.MAX_VALUE / n4 / n2) {
            throw new RuntimeException("Illegal texture dimensions (" + n5 + "x" + n4 + ")");
        }
        ES2VramPool eS2VramPool = ES2VramPool.instance;
        long l2 = eS2VramPool.estimateTextureSize(n5, n4, pixelFormat);
        if (!eS2VramPool.prepareForAllocation(l2)) {
            return null;
        }
        int n15 = gLContext.getBoundTexture();
        Object object = new ES2TextureData(eS2Context, gLContext.genAndBindTexture(), n5, n4, l2);
        object = new ES2TextureResource<ES2TextureData>((ES2TextureData)object);
        n10 = ES2Texture.uploadPixels(gLContext, 50, null, pixelFormat, n5, n4, n7, n6, 0, 0, n11, n12, 0, true, bl2) ? 1 : 0;
        gLContext.texParamsMinMax(53, bl2);
        gLContext.setBoundTexture(n15);
        if (n10 == 0) {
            return null;
        }
        return new ES2Texture(eS2Context, object, pixelFormat, texture$WrapMode, n5, n4, n7, n6, n11, n12, bl2);
    }

    public static Texture create(ES2Context eS2Context, MediaFrame mediaFrame) {
        mediaFrame.holdFrame();
        PixelFormat pixelFormat = mediaFrame.getPixelFormat();
        if (mediaFrame.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            int n2 = mediaFrame.getEncodedWidth();
            int n3 = mediaFrame.getEncodedHeight();
            int n4 = mediaFrame.planeCount();
            MultiTexture multiTexture = new MultiTexture(pixelFormat, Texture$WrapMode.CLAMP_TO_EDGE, mediaFrame.getWidth(), mediaFrame.getHeight());
            for (int i2 = 0; i2 < n4; ++i2) {
                ES2Texture eS2Texture;
                int n5 = n2;
                int n6 = n3;
                if (i2 == 2 || i2 == 1) {
                    n5 /= 2;
                    n6 /= 2;
                }
                if ((eS2Texture = ES2Texture.create(eS2Context, PixelFormat.BYTE_ALPHA, Texture$WrapMode.CLAMP_TO_EDGE, n5, n6, false)) == null) continue;
                multiTexture.setTexture(eS2Texture, i2);
            }
            mediaFrame.releaseFrame();
            return multiTexture;
        }
        Object object = eS2Context.getGLContext();
        int n7 = ((GLContext)object).getMaxTextureSize();
        int n8 = mediaFrame.getEncodedHeight();
        int n9 = mediaFrame.getEncodedWidth();
        pixelFormat = mediaFrame.getPixelFormat();
        if (!((GLContext)object).canCreateNonPowTwoTextures()) {
            n9 = ES2Texture.nextPowerOfTwo(n9, n7);
            n8 = ES2Texture.nextPowerOfTwo(n8, n7);
        }
        if (n9 <= 0 || n8 <= 0) {
            mediaFrame.releaseFrame();
            throw new RuntimeException("Illegal texture dimensions (" + n9 + "x" + n8 + ")");
        }
        int n10 = pixelFormat.getBytesPerPixelUnit();
        if (n9 >= Integer.MAX_VALUE / n8 / n10) {
            mediaFrame.releaseFrame();
            throw new RuntimeException("Illegal texture dimensions (" + n9 + "x" + n8 + ")");
        }
        ES2VramPool eS2VramPool = ES2VramPool.instance;
        long l2 = eS2VramPool.estimateTextureSize(n9, n8, pixelFormat);
        if (!eS2VramPool.prepareForAllocation(l2)) {
            return null;
        }
        int n11 = ((GLContext)object).getBoundTexture();
        Object object2 = new ES2TextureData(eS2Context, ((GLContext)object).genAndBindTexture(), n9, n8, l2);
        object2 = new ES2TextureResource<ES2TextureData>((ES2TextureData)object2);
        n10 = ES2Texture.uploadPixels(eS2Context.getGLContext(), 50, mediaFrame, n9, n8, true) ? 1 : 0;
        ((GLContext)object).texParamsMinMax(53, false);
        ((GLContext)object).setBoundTexture(n11);
        object = null;
        if (n10 != 0) {
            object = new ES2Texture(eS2Context, object2, pixelFormat, Texture$WrapMode.CLAMP_TO_EDGE, n9, n8, 0, 0, mediaFrame.getWidth(), mediaFrame.getHeight(), false);
        }
        mediaFrame.releaseFrame();
        return object;
    }

    private static boolean uploadPixels(GLContext gLContext, int n2, Buffer buffer, PixelFormat pixelFormat, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, boolean n12, boolean bl2) {
        int n13;
        int n14;
        int n15;
        int n16;
        int n17 = 1;
        boolean bl3 = ES2Pipeline.glFactory.isGL2();
        int n18 = switch (pixelFormat) {
            case PixelFormat.BYTE_BGRA_PRE, PixelFormat.INT_ARGB_PRE -> {
                n17 = 4;
                n16 = 40;
                n15 = 41;
                if (!bl3) {
                    if (!PlatformUtil.isIOS()) {
                        if (ES2Pipeline.glFactory.isGLExtensionSupported("GL_EXT_texture_format_BGRA8888")) {
                            n15 = 41;
                            n16 = 41;
                        } else {
                            n15 = 40;
                        }
                    }
                    yield 21;
                }
                yield 22;
            }
            case PixelFormat.BYTE_RGB -> {
                n16 = bl3 ? 40 : 42;
                n15 = 42;
                yield 21;
            }
            case PixelFormat.BYTE_GRAY -> {
                n16 = 43;
                n15 = 43;
                yield 21;
            }
            case PixelFormat.BYTE_ALPHA -> {
                n16 = 44;
                n15 = 44;
                yield 21;
            }
            case PixelFormat.FLOAT_XYZW -> {
                n17 = 4;
                n16 = bl3 ? 45 : 40;
                n15 = 40;
                yield 20;
            }
            case PixelFormat.BYTE_APPLE_422 -> {
                n17 = 2;
                n16 = 42;
                n15 = 46;
                yield 24;
            }
            default -> throw new InternalError("Image format not supported: " + String.valueOf((Object)pixelFormat));
        };
        if (!bl3 && n16 != n15 && !PlatformUtil.isIOS()) {
            throw new InternalError("On ES 2.0 device, internalFormat must match pixelFormat");
        }
        int n19 = 1;
        if (n12 != 0) {
            gLContext.pixelStorei(60, 1);
            if (pixelFormat == PixelFormat.FLOAT_XYZW && n16 == 40) {
                n19 = gLContext.texImage2D(n2, 0, 40, n3, n4, 0, n15, n18, null, bl2);
            } else {
                if (bl3) {
                    n12 = 44;
                    n14 = 21;
                    n13 = 1;
                } else {
                    n12 = n15;
                    n14 = n18;
                    n13 = pixelFormat.getBytesPerPixelUnit();
                }
                ByteBuffer byteBuffer = null;
                if (n9 != n3 || n10 != n4) {
                    n19 = n3 * n4 * n13;
                    byteBuffer = BufferUtil.newByteBuffer(n19);
                }
                if (bl3) {
                    gLContext.pixelStorei(61, 0);
                    gLContext.pixelStorei(62, 0);
                    gLContext.pixelStorei(63, 0);
                    gLContext.pixelStorei(60, n17);
                }
                n19 = gLContext.texImage2D(n2, 0, n16, n3, n4, 0, n12, n14, byteBuffer, bl2) ? 1 : 0;
            }
        }
        if (buffer != null) {
            n12 = n11 / pixelFormat.getBytesPerPixelUnit();
            if (!(bl3 || n7 == 0 && n8 == 0 && n9 == n12)) {
                buffer = Image.createPackedBuffer(buffer, pixelFormat, n7, n8, n9, n10, n11);
                n8 = 0;
                n7 = 0;
                n11 = n9;
                n12 = n11 / pixelFormat.getBytesPerPixelUnit();
            }
            gLContext.pixelStorei(60, n17);
            if (bl3) {
                if (n9 == n12) {
                    gLContext.pixelStorei(61, 0);
                } else {
                    gLContext.pixelStorei(61, n12);
                }
            }
            n14 = buffer.position();
            n13 = ES2Texture.getBufferElementSizeLog(buffer);
            int n20 = pixelFormat.getBytesPerPixelUnit() >> n13;
            buffer.position(n7 * n20 + n8 * (n11 >> n13));
            gLContext.texSubImage2D(n2, 0, n5, n6, n9, n10, n15, n18, buffer);
            buffer.position(n14);
        }
        return n19 != 0;
    }

    private static boolean uploadPixels(GLContext gLContext, int n2, MediaFrame mediaFrame, int n3, int n4, boolean bl2) {
        int n5;
        int n6;
        int n7;
        mediaFrame.holdFrame();
        int n8 = mediaFrame.getEncodedWidth();
        int n9 = n7 = mediaFrame.getEncodedHeight();
        ByteBuffer byteBuffer = mediaFrame.getBufferForPlane(0);
        int n10 = switch (mediaFrame.getPixelFormat()) {
            case PixelFormat.INT_ARGB_PRE -> {
                n7 = 4;
                n6 = 40;
                n5 = 41;
                if (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
                    yield 22;
                }
                yield 23;
            }
            case PixelFormat.BYTE_APPLE_422 -> {
                n7 = 2;
                n6 = 42;
                n5 = 46;
                yield 24;
            }
            default -> {
                mediaFrame.releaseFrame();
                throw new InternalError("Invalid video image format " + String.valueOf((Object)mediaFrame.getPixelFormat()));
            }
        };
        boolean bl3 = true;
        if (bl2) {
            gLContext.pixelStorei(60, 1);
            ByteBuffer byteBuffer2 = null;
            if (n8 != n3 || n9 != n4) {
                int n11 = n3 * n4;
                byteBuffer2 = BufferUtil.newByteBuffer(n11);
            }
            bl3 = gLContext.texImage2D(n2, 0, n6, n3, n4, 0, 44, 21, byteBuffer2, false);
        }
        if (byteBuffer != null) {
            gLContext.pixelStorei(60, n7);
            gLContext.pixelStorei(61, mediaFrame.strideForPlane(0) / n7);
            gLContext.texSubImage2D(n2, 0, 0, 0, n8, mediaFrame.getHeight(), n5, n10, byteBuffer);
        }
        mediaFrame.releaseFrame();
        return bl3;
    }

    public static int getBufferElementSizeLog(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return 0;
        }
        if (buffer instanceof IntBuffer || buffer instanceof FloatBuffer) {
            return 2;
        }
        throw new InternalError("Unsupported Buffer type: " + String.valueOf(buffer.getClass()));
    }

    void updateWrapState() {
        Texture$WrapMode texture$WrapMode = this.getWrapMode();
        ES2TextureData eS2TextureData = (ES2TextureData)((ES2TextureResource)this.resource).getResource();
        if (eS2TextureData.getWrapMode() != texture$WrapMode) {
            int n2;
            GLContext gLContext = this.context.getGLContext();
            int n3 = gLContext.getBoundTexture();
            if (n3 != (n2 = eS2TextureData.getTexID())) {
                gLContext.setBoundTexture(n2);
            }
            gLContext.updateWrapState(n2, texture$WrapMode);
            if (n3 != n2) {
                gLContext.setBoundTexture(n3);
            }
            eS2TextureData.setWrapMode(texture$WrapMode);
        }
    }

    void updateFilterState() {
        boolean bl2 = this.getLinearFiltering();
        ES2TextureData eS2TextureData = (ES2TextureData)((ES2TextureResource)this.resource).getResource();
        if (eS2TextureData.isFiltered() != bl2) {
            int n2;
            GLContext gLContext = this.context.getGLContext();
            int n3 = gLContext.getBoundTexture();
            if (n3 != (n2 = eS2TextureData.getTexID())) {
                gLContext.setBoundTexture(n2);
            }
            gLContext.updateFilterState(n2, bl2);
            if (n3 != n2) {
                gLContext.setBoundTexture(n3);
            }
            eS2TextureData.setFiltered(bl2);
        }
    }

    public int getNativeSourceHandle() {
        return ((ES2TextureData)((ES2TextureResource)this.resource).getResource()).getTexID();
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean n9) {
        this.checkUpdateParams(buffer, pixelFormat, n2, n3, n4, n5, n6, n7, n8);
        if (n9 == 0) {
            this.context.flushVertexBuffer();
        }
        if ((n9 = this.getNativeSourceHandle()) != 0) {
            int n10;
            GLContext gLContext = this.context.getGLContext();
            int n11 = gLContext.getActiveTextureUnit();
            int n12 = gLContext.getBoundTexture();
            int n13 = 0;
            for (n10 = 0; n10 < 2; ++n10) {
                if (gLContext.getBoundTexture(n10) != n9) continue;
                n13 = 1;
                if (n11 == n10) break;
                gLContext.setActiveTextureUnit(n10);
                break;
            }
            if (n13 == 0) {
                gLContext.setBoundTexture(n9);
            }
            n10 = this.getContentX();
            n9 = this.getContentY();
            n13 = this.getContentWidth();
            int n14 = this.getContentHeight();
            int n15 = this.getPhysicalWidth();
            int n16 = this.getPhysicalHeight();
            boolean bl2 = this.getUseMipmap();
            ES2Texture.uploadPixels(gLContext, 50, buffer, pixelFormat, n15, n16, n10 + n2, n9 + n3, n4, n5, n6, n7, n8, false, bl2);
            switch (this.getWrapMode()) {
                case CLAMP_TO_EDGE: {
                    break;
                }
                case CLAMP_TO_EDGE_SIMULATED: {
                    boolean bl3;
                    boolean bl4 = n13 < n15 && n2 + n6 == n13;
                    boolean bl5 = bl3 = n14 < n16 && n3 + n7 == n14;
                    if (bl4) {
                        ES2Texture.uploadPixels(gLContext, 50, buffer, pixelFormat, n15, n16, n10 + n13, n9 + n3, n4 + n6 - 1, n5, 1, n7, n8, false, bl2);
                    }
                    if (!bl3) break;
                    ES2Texture.uploadPixels(gLContext, 50, buffer, pixelFormat, n15, n16, n10 + n2, n9 + n14, n4, n5 + n7 - 1, n6, 1, n8, false, bl2);
                    if (!bl4) break;
                    ES2Texture.uploadPixels(gLContext, 50, buffer, pixelFormat, n15, n16, n10 + n13, n9 + n14, n4 + n6 - 1, n5 + n7 - 1, 1, 1, n8, false, bl2);
                    break;
                }
                case REPEAT: {
                    break;
                }
                case REPEAT_SIMULATED: {
                    boolean bl6;
                    boolean bl7 = n13 < n15 && n2 == 0;
                    boolean bl8 = bl6 = n14 < n16 && n3 == 0;
                    if (bl7) {
                        ES2Texture.uploadPixels(gLContext, 50, buffer, pixelFormat, n15, n16, n10 + n13, n9 + n3, n4, n5, 1, n7, n8, false, bl2);
                    }
                    if (!bl6) break;
                    ES2Texture.uploadPixels(gLContext, 50, buffer, pixelFormat, n15, n16, n10 + n2, n9 + n14, n4, n5, n6, 1, n8, false, bl2);
                    if (!bl7) break;
                    ES2Texture.uploadPixels(gLContext, 50, buffer, pixelFormat, n15, n16, n10 + n13, n9 + n14, n4, n5, 1, 1, n8, false, bl2);
                }
            }
            if (n11 != gLContext.getActiveTextureUnit()) {
                gLContext.setActiveTextureUnit(n11);
            }
            if (n12 != gLContext.getBoundTexture()) {
                gLContext.setBoundTexture(n12);
            }
        }
    }

    @Override
    public void update(MediaFrame mediaFrame, boolean n2) {
        if (n2 == 0) {
            this.context.flushVertexBuffer();
        }
        if ((n2 = this.getNativeSourceHandle()) != 0) {
            GLContext gLContext = this.context.getGLContext();
            int n3 = gLContext.getActiveTextureUnit();
            int n4 = gLContext.getBoundTexture();
            boolean bl2 = false;
            for (int i2 = 0; i2 < 2; ++i2) {
                if (gLContext.getBoundTexture(i2) != n2) continue;
                bl2 = true;
                if (n3 == i2) break;
                gLContext.setActiveTextureUnit(i2);
                break;
            }
            if (!bl2) {
                gLContext.setBoundTexture(n2);
            }
            ES2Texture.uploadPixels(gLContext, 50, mediaFrame, this.getPhysicalWidth(), this.getPhysicalHeight(), false);
            if (n3 != gLContext.getActiveTextureUnit()) {
                gLContext.setActiveTextureUnit(n3);
            }
            if (n4 != gLContext.getBoundTexture()) {
                gLContext.setBoundTexture(n4);
            }
        }
    }
}

