/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.image;

import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.image.CompoundCoords;
import com.sun.prism.image.Coords;

public abstract class CompoundImage {
    public static final int BORDER_SIZE_DEFAULT = 1;
    protected final int[] uSubdivision;
    protected final int[] u0;
    protected final int[] u1;
    protected final int[] vSubdivision;
    protected final int[] v0;
    protected final int[] v1;
    protected final int uSections;
    protected final int vSections;
    protected final int uBorderSize;
    protected final int vBorderSize;
    protected Image[] tiles;

    public CompoundImage(Image image, int n2) {
        this(image, n2, 1);
    }

    public CompoundImage(Image image, int n2, int n3) {
        if (4 * n3 >= n2) {
            n3 = n2 / 4;
        }
        int n4 = image.getWidth();
        int n5 = image.getHeight();
        this.uBorderSize = n4 <= n2 ? 0 : n3;
        this.vBorderSize = n5 <= n2 ? 0 : n3;
        this.uSubdivision = CompoundImage.subdivideUVs(n4, n2, this.uBorderSize);
        this.vSubdivision = CompoundImage.subdivideUVs(n5, n2, this.vBorderSize);
        this.uSections = this.uSubdivision.length - 1;
        this.vSections = this.vSubdivision.length - 1;
        this.u0 = new int[this.uSections];
        this.u1 = new int[this.uSections];
        this.v0 = new int[this.vSections];
        this.v1 = new int[this.vSections];
        this.tiles = new Image[this.uSections * this.vSections];
        for (n2 = 0; n2 != this.vSections; ++n2) {
            this.v0[n2] = this.vSubdivision[n2] - this.uBorder(n2);
            this.v1[n2] = this.vSubdivision[n2 + 1] + this.dBorder(n2);
        }
        for (n2 = 0; n2 != this.uSections; ++n2) {
            this.u0[n2] = this.uSubdivision[n2] - this.lBorder(n2);
            this.u1[n2] = this.uSubdivision[n2 + 1] + this.rBorder(n2);
        }
        for (n2 = 0; n2 != this.vSections; ++n2) {
            for (n3 = 0; n3 != this.uSections; ++n3) {
                this.tiles[n2 * this.uSections + n3] = image.createSubImage(this.u0[n3], this.v0[n2], this.u1[n3] - this.u0[n3], this.v1[n2] - this.v0[n2]);
            }
        }
    }

    private int lBorder(int n2) {
        if (n2 > 0) {
            return this.uBorderSize;
        }
        return 0;
    }

    private int rBorder(int n2) {
        if (n2 < this.uSections - 1) {
            return this.uBorderSize;
        }
        return 0;
    }

    private int uBorder(int n2) {
        if (n2 > 0) {
            return this.vBorderSize;
        }
        return 0;
    }

    private int dBorder(int n2) {
        if (n2 < this.vSections - 1) {
            return this.vBorderSize;
        }
        return 0;
    }

    private static int[] subdivideUVs(int n2, int n3, int n4) {
        int n5 = (n2 - (n4 << 1) + (n3 -= n4 << 1) - 1) / n3;
        int[] nArray = new int[n5 + 1];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        nArray2[n5] = n2;
        for (n2 = 1; n2 < n5; ++n2) {
            nArray2[n2] = n4 + n3 * n2;
        }
        return nArray2;
    }

    protected abstract Texture getTile(int var1, int var2, ResourceFactory var3);

    public void drawLazy(Graphics graphics, Coords coords, float f2, float f3) {
        new CompoundCoords(this, coords).draw(graphics, this, f2, f3);
    }
}

