/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.glass.ui.Screen;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.impl.ByteGray;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderTarget;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.Texture$Usage;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.BaseGraphics;
import com.sun.prism.impl.GlyphCache;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.paint.PaintUtil;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.paint.Gradient;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class BaseContext {
    private final Screen screen;
    private final ResourceFactory factory;
    private final VertexBuffer vertexBuffer;
    private boolean disposed = false;
    private static final int MIN_MASK_DIM = 1024;
    private Texture maskTex;
    private ByteBuffer maskBuffer;
    private ByteBuffer clearBuffer;
    private int curMaskRow;
    private int nextMaskRow;
    private int curMaskCol;
    private int highMaskCol;
    private Texture paintTex;
    private int[] paintPixels;
    private ByteBuffer paintBuffer;
    private Texture rectTex;
    private int rectTexMax;
    private Texture wrapRectTex;
    private Texture ovalTex;
    private final GeneralTransform3D perspectiveTransform = new GeneralTransform3D();
    private final Map<FontStrike, GlyphCache> greyGlyphCaches = new HashMap<FontStrike, GlyphCache>();
    private final Map<FontStrike, GlyphCache> lcdGlyphCaches = new HashMap<FontStrike, GlyphCache>();

    protected BaseContext(Screen screen, ResourceFactory resourceFactory, int n2) {
        this.screen = screen;
        this.factory = resourceFactory;
        this.vertexBuffer = new VertexBuffer(this, n2);
    }

    protected void setDeviceParametersFor2D() {
    }

    protected void setDeviceParametersFor3D() {
    }

    public Screen getAssociatedScreen() {
        return this.screen;
    }

    public ResourceFactory getResourceFactory() {
        return this.factory;
    }

    public VertexBuffer getVertexBuffer() {
        return this.vertexBuffer;
    }

    public void flushVertexBuffer() {
        if (this.checkDisposed()) {
            return;
        }
        this.vertexBuffer.flush();
    }

    protected final void flushMask() {
        if (this.curMaskRow > 0 || this.curMaskCol > 0) {
            this.maskTex.lock();
            this.maskTex.update(this.maskBuffer, this.maskTex.getPixelFormat(), 0, 0, 0, 0, this.highMaskCol, this.nextMaskRow, this.maskTex.getContentWidth(), true);
            this.maskTex.unlock();
            BaseContext baseContext = this;
            BaseContext baseContext2 = this;
            baseContext2.highMaskCol = 0;
            baseContext2.nextMaskRow = 0;
            baseContext.curMaskCol = 0;
            baseContext.curMaskRow = 0;
        }
    }

    public void drawQuads(float[] fArray, byte[] byArray, int n2) {
        this.flushMask();
        this.renderQuads(fArray, byArray, n2);
    }

    protected GeneralTransform3D getPerspectiveTransformNoClone() {
        return this.perspectiveTransform;
    }

    protected void setPerspectiveTransform(GeneralTransform3D generalTransform3D) {
        if (generalTransform3D == null) {
            this.perspectiveTransform.setIdentity();
            return;
        }
        this.perspectiveTransform.set(generalTransform3D);
    }

    protected abstract void renderQuads(float[] var1, byte[] var2, int var3);

    public void setRenderTarget(BaseGraphics baseGraphics) {
        if (baseGraphics != null) {
            this.setRenderTarget(baseGraphics.getRenderTarget(), baseGraphics.getCameraNoClone(), baseGraphics.isDepthTest() && baseGraphics.isDepthBuffer(), baseGraphics.isState3D());
            return;
        }
        this.releaseRenderTarget();
    }

    protected void releaseRenderTarget() {
    }

    protected abstract void setRenderTarget(RenderTarget var1, NGCamera var2, boolean var3, boolean var4);

    public abstract void validateClearOp(BaseGraphics var1);

    public abstract void validatePaintOp(BaseGraphics var1, BaseTransform var2, Texture var3, float var4, float var5, float var6, float var7);

    public abstract void validateTextureOp(BaseGraphics var1, BaseTransform var2, Texture var3, PixelFormat var4);

    public void clearGlyphCaches() {
        BaseContext baseContext = this;
        baseContext.clearCaches(baseContext.greyGlyphCaches);
        BaseContext baseContext2 = this;
        baseContext2.clearCaches(baseContext2.lcdGlyphCaches);
    }

    private void clearCaches(Map<FontStrike, GlyphCache> map) {
        Iterator<Object> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().clearDesc();
        }
        for (GlyphCache glyphCache : map.values()) {
            if (glyphCache == null) continue;
            glyphCache.clear();
        }
        map.clear();
    }

    public abstract RTTexture getLCDBuffer();

    public GlyphCache getGlyphCache(FontStrike fontStrike) {
        Map<FontStrike, GlyphCache> map = fontStrike.getAAMode() == 1 ? this.lcdGlyphCaches : this.greyGlyphCaches;
        return this.getGlyphCache(fontStrike, map);
    }

    public boolean isSuperShaderEnabled() {
        return false;
    }

    private GlyphCache getGlyphCache(FontStrike fontStrike, Map<FontStrike, GlyphCache> map) {
        if (this.checkDisposed()) {
            return null;
        }
        GlyphCache glyphCache = map.get(fontStrike);
        if (glyphCache == null) {
            glyphCache = new GlyphCache(this, fontStrike);
            map.put(fontStrike, glyphCache);
        }
        return glyphCache;
    }

    public Texture validateMaskTexture(MaskData maskData, boolean n2) {
        if (this.checkDisposed()) {
            return null;
        }
        n2 = n2 != 0 ? 1 : 0;
        int n3 = maskData.getWidth() + n2 + n2;
        int n4 = maskData.getHeight() + n2 + n2;
        n2 = 0;
        int n5 = 0;
        if (this.maskTex != null) {
            this.maskTex.lock();
            if (this.maskTex.isSurfaceLost()) {
                this.maskTex = null;
            } else {
                n2 = this.maskTex.getContentWidth();
                n5 = this.maskTex.getContentHeight();
            }
        }
        if (this.maskTex == null || n2 < n3 || n5 < n4) {
            if (this.maskTex != null) {
                this.flushVertexBuffer();
                this.maskTex.dispose();
                this.maskTex = null;
            }
            this.maskBuffer = null;
            n2 = Math.max(1024, Math.max(n3, n2));
            n4 = Math.max(1024, Math.max(n4, n5));
            this.maskTex = this.getResourceFactory().createMaskTexture(n2, n4, Texture$WrapMode.CLAMP_NOT_NEEDED);
            this.maskBuffer = ByteBuffer.allocate(n2 * n4);
            if (this.clearBuffer == null || this.clearBuffer.capacity() < n2) {
                this.clearBuffer = null;
                this.clearBuffer = ByteBuffer.allocate(n2);
            }
            BaseContext baseContext = this;
            BaseContext baseContext2 = this;
            baseContext2.highMaskCol = 0;
            baseContext2.nextMaskRow = 0;
            baseContext.curMaskCol = 0;
            baseContext.curMaskRow = 0;
        }
        return this.maskTex;
    }

    public void updateMaskTexture(MaskData maskData, RectBounds rectBounds, boolean bl2) {
        if (this.checkDisposed()) {
            return;
        }
        this.maskTex.assertLocked();
        int n2 = maskData.getWidth();
        int n3 = maskData.getHeight();
        int n4 = this.maskTex.getContentWidth();
        int n5 = this.maskTex.getContentHeight();
        int n6 = bl2 ? 1 : 0;
        int n7 = n2 + n6 + n6;
        int n8 = n3 + n6 + n6;
        if (this.curMaskCol + n7 > n4) {
            this.curMaskCol = 0;
            this.curMaskRow = this.nextMaskRow;
        }
        if (this.curMaskRow + n8 > n5) {
            this.flushVertexBuffer();
        }
        n5 = this.curMaskRow * n4 + this.curMaskCol;
        ByteToBytePixelConverter byteToBytePixelConverter = ByteGray.ToByteGrayConverter();
        if (bl2) {
            int f2 = n5;
            byteToBytePixelConverter.convert(this.clearBuffer, 0, 0, this.maskBuffer, f2, n4, n2 + 1, 1);
            int n9 = n5 + n2 + 1;
            byteToBytePixelConverter.convert(this.clearBuffer, 0, 0, this.maskBuffer, n9, n4, 1, n3 + 1);
            int n10 = n5 + n4;
            byteToBytePixelConverter.convert(this.clearBuffer, 0, 0, this.maskBuffer, n10, n4, 1, n3 + 1);
            int n11 = n5 + (n3 + 1) * n4 + 1;
            byteToBytePixelConverter.convert(this.clearBuffer, 0, 0, this.maskBuffer, n11, n4, n2 + 1, 1);
            n5 += n4 + 1;
        }
        byteToBytePixelConverter.convert(maskData.getMaskBuffer(), 0, n2, this.maskBuffer, n5, n4, n2, n3);
        float f2 = this.maskTex.getPhysicalWidth();
        float f3 = this.maskTex.getPhysicalHeight();
        rectBounds.setMinX((float)(this.curMaskCol + n6) / f2);
        rectBounds.setMinY((float)(this.curMaskRow + n6) / f3);
        rectBounds.setMaxX((float)(this.curMaskCol + n6 + n2) / f2);
        rectBounds.setMaxY((float)(this.curMaskRow + n6 + n3) / f3);
        this.curMaskCol += n7;
        if (this.highMaskCol < this.curMaskCol) {
            this.highMaskCol = this.curMaskCol;
        }
        if (this.nextMaskRow < this.curMaskRow + n8) {
            this.nextMaskRow = this.curMaskRow + n8;
        }
    }

    public int getRectTextureMaxSize() {
        if (this.checkDisposed()) {
            return 0;
        }
        if (this.rectTex == null) {
            this.createRectTexture();
        }
        return this.rectTexMax;
    }

    public Texture getRectTexture() {
        if (this.checkDisposed()) {
            return null;
        }
        if (this.rectTex == null) {
            this.createRectTexture();
        }
        this.rectTex.lock();
        return this.rectTex;
    }

    private void createRectTexture() {
        int n2;
        if (this.checkDisposed()) {
            return;
        }
        int n3 = PrismSettings.primTextureSize;
        if (n3 < 0) {
            n3 = this.getResourceFactory().getMaximumTextureSize();
        }
        int n4 = 3;
        int n5 = 2;
        while (n4 + n5 + 1 <= n3) {
            this.rectTexMax = n5++;
            n4 += n5;
        }
        int n6 = n4;
        byte[] byArray = new byte[n6 * n6];
        n5 = 1;
        for (int i2 = 1; i2 <= this.rectTexMax; ++i2) {
            int n7 = 1;
            for (n2 = 1; n2 <= this.rectTexMax; ++n2) {
                int n8 = n5 * n4 + n7;
                for (int i3 = 0; i3 < i2; ++i3) {
                    for (int i4 = 0; i4 < n2; ++i4) {
                        byArray[n8 + i4] = -1;
                    }
                    n8 += n4;
                }
                n7 += n2 + 1;
            }
            n5 += i2 + 1;
        }
        if (PrismSettings.verbose) {
            System.out.println("max rectangle texture cell size = " + this.rectTexMax);
        }
        int n9 = n4;
        Texture texture = this.getResourceFactory().createMaskTexture(n9, n9, Texture$WrapMode.CLAMP_NOT_NEEDED);
        texture.contentsUseful();
        texture.makePermanent();
        PixelFormat pixelFormat = texture.getPixelFormat();
        n2 = n4 * pixelFormat.getBytesPerPixelUnit();
        int n10 = n4;
        texture.update(ByteBuffer.wrap(byArray), pixelFormat, 0, 0, 0, 0, n10, n10, n2, false);
        this.rectTex = texture;
    }

    public Texture getWrapRectTexture() {
        if (this.checkDisposed()) {
            return null;
        }
        if (this.wrapRectTex == null) {
            int n2;
            Texture texture = this.getResourceFactory().createMaskTexture(2, 2, Texture$WrapMode.CLAMP_TO_EDGE);
            texture.contentsUseful();
            texture.makePermanent();
            int n3 = texture.getPhysicalWidth();
            int n4 = texture.getPhysicalHeight();
            if (PrismSettings.verbose) {
                System.out.println("wrap rectangle texture = " + n3 + " x " + n4);
            }
            byte[] byArray = new byte[n3 * n4];
            int n5 = n3;
            for (int i2 = 1; i2 < n4; ++i2) {
                for (n2 = 1; n2 < n4; ++n2) {
                    byArray[n5 + n2] = -1;
                }
                n5 += n3;
            }
            PixelFormat pixelFormat = texture.getPixelFormat();
            n2 = n3 * pixelFormat.getBytesPerPixelUnit();
            texture.update(ByteBuffer.wrap(byArray), pixelFormat, 0, 0, 0, 0, n3, n4, n2, false);
            this.wrapRectTex = texture;
        }
        this.wrapRectTex.lock();
        return this.wrapRectTex;
    }

    public Texture getOvalTexture() {
        if (this.checkDisposed()) {
            return null;
        }
        if (this.ovalTex == null) {
            int n2;
            int n3 = this.getRectTextureMaxSize();
            int n4 = n3 * (n3 + 1) / 2;
            byte[] byArray = new byte[(n4 += n3 + 1) * n4];
            int n5 = 1;
            for (int i2 = 1; i2 <= n3; ++i2) {
                int n6 = 1;
                for (n2 = 1; n2 <= n3; ++n2) {
                    int n7 = n5 * n4 + n6;
                    for (int i3 = 0; i3 < i2; ++i3) {
                        if (i3 << 1 >= i2) {
                            int n8 = i2 - 1 - i3;
                            var11_14 = n7 + (n8 - i3) * n4;
                            for (var12_15 = 0; var12_15 < n2; ++var12_15) {
                                byArray[n7 + var12_15] = byArray[var11_14 + var12_15];
                            }
                        } else {
                            float f2 = (float)i3 + 0.0625f;
                            for (var11_14 = 0; var11_14 < 8; ++var11_14) {
                                float f3;
                                float f4 = f3 = f2 / (float)i2 - 0.5f;
                                f3 = (float)Math.sqrt(0.25f - f4 * f4);
                                var12_15 = Math.round((float)n2 * 4.0f * (1.0f - f3 * 2.0f));
                                int n9 = var12_15 >> 3;
                                int n10 = n7 + n9;
                                byArray[n10] = (byte)(byArray[n10] + (8 - (var12_15 &= 7)));
                                int n11 = n7 + n9 + 1;
                                byArray[n11] = (byte)(byArray[n11] + var12_15);
                                f2 += 0.125f;
                            }
                            var11_14 = 0;
                            for (var12_15 = 0; var12_15 < n2; ++var12_15) {
                                byArray[n7 + var12_15] = var12_15 << 1 >= n2 ? byArray[n7 + n2 - 1 - var12_15] : (byte)(((var11_14 += byArray[n7 + var12_15]) * 255 + 32) / 64);
                            }
                            byArray[n7 + n2] = 0;
                        }
                        n7 += n4;
                    }
                    n6 += n2 + 1;
                }
                n5 += i2 + 1;
            }
            int n12 = n4;
            Texture texture = this.getResourceFactory().createMaskTexture(n12, n12, Texture$WrapMode.CLAMP_NOT_NEEDED);
            texture.contentsUseful();
            texture.makePermanent();
            PixelFormat pixelFormat = texture.getPixelFormat();
            n2 = n4 * pixelFormat.getBytesPerPixelUnit();
            int n13 = n4;
            texture.update(ByteBuffer.wrap(byArray), pixelFormat, 0, 0, 0, 0, n13, n13, n2, false);
            this.ovalTex = texture;
        }
        this.ovalTex.lock();
        return this.ovalTex;
    }

    public Texture getGradientTexture(Gradient gradient, BaseTransform baseTransform, int n2, int n3, MaskData maskData, float f2, float f3, float f4, float f5) {
        int n4;
        if (this.checkDisposed()) {
            return null;
        }
        int n5 = n2 * n3;
        int n6 = n5 << 2;
        if (this.paintBuffer == null || this.paintBuffer.capacity() < n6) {
            this.paintPixels = new int[n5];
            this.paintBuffer = ByteBuffer.wrap(new byte[n6]);
        }
        if (this.paintTex != null) {
            this.paintTex.lock();
            if (this.paintTex.isSurfaceLost()) {
                this.paintTex = null;
            }
        }
        if (this.paintTex == null || this.paintTex.getContentWidth() < n2 || this.paintTex.getContentHeight() < n3) {
            n6 = n2;
            n4 = n3;
            if (this.paintTex != null) {
                n6 = Math.max(n2, this.paintTex.getContentWidth());
                n4 = Math.max(n3, this.paintTex.getContentHeight());
                this.paintTex.dispose();
            }
            this.paintTex = this.getResourceFactory().createTexture(PixelFormat.BYTE_BGRA_PRE, Texture$Usage.DEFAULT, Texture$WrapMode.CLAMP_NOT_NEEDED, n6, n4);
        }
        PaintUtil.fillImageWithGradient(this.paintPixels, gradient, baseTransform, 0, 0, n2, n3, f2, f3, f4, f5);
        byte[] byArray = this.paintBuffer.array();
        if (maskData != null) {
            byte[] byArray2 = maskData.getMaskBuffer().array();
            int n7 = 0;
            for (int i2 = 0; i2 < n5; ++i2) {
                int n8 = this.paintPixels[i2];
                int n9 = byArray2[i2] & 0xFF;
                byArray[n7++] = (byte)((n8 & 0xFF) * n9 / 255);
                byArray[n7++] = (byte)((n8 >> 8 & 0xFF) * n9 / 255);
                byArray[n7++] = (byte)((n8 >> 16 & 0xFF) * n9 / 255);
                byArray[n7++] = (byte)((n8 >>> 24) * n9 / 255);
            }
        } else {
            n4 = 0;
            for (int i3 = 0; i3 < n5; ++i3) {
                int n10 = this.paintPixels[i3];
                byArray[n4++] = (byte)n10;
                byArray[n4++] = (byte)(n10 >> 8);
                byArray[n4++] = (byte)(n10 >> 16);
                byArray[n4++] = (byte)(n10 >>> 24);
            }
        }
        this.paintTex.update(this.paintBuffer, PixelFormat.BYTE_BGRA_PRE, 0, 0, 0, 0, n2, n3, n2 << 2, false);
        return this.paintTex;
    }

    public void dispose() {
        this.clearGlyphCaches();
        GlyphCache.disposeForContext(this);
        if (this.maskTex != null) {
            this.maskTex.dispose();
            this.maskTex = null;
        }
        if (this.paintTex != null) {
            this.paintTex.dispose();
            this.paintTex = null;
        }
        if (this.rectTex != null) {
            this.rectTex.dispose();
            this.rectTex = null;
        }
        if (this.wrapRectTex != null) {
            this.wrapRectTex.dispose();
            this.wrapRectTex = null;
        }
        if (this.ovalTex != null) {
            this.ovalTex.dispose();
            this.ovalTex = null;
        }
        this.disposed = true;
    }

    public final boolean isDisposed() {
        return this.disposed;
    }

    protected boolean checkDisposed() {
        if (PrismSettings.verbose && this.isDisposed()) {
            try {
                throw new IllegalStateException("attempt to use resource after context is disposed");
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2 = runtimeException;
                runtimeException.printStackTrace();
            }
        }
        return this.isDisposed();
    }
}

