/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.geom.Quat4f;
import com.sun.javafx.geom.Vec2f;
import com.sun.javafx.geom.Vec3f;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.logging.PlatformLogger$Level;
import com.sun.prism.Mesh;
import com.sun.prism.impl.BaseGraphicsResource;
import com.sun.prism.impl.BaseMesh$FaceMembers;
import com.sun.prism.impl.BaseMesh$MeshGeomComp2VB;
import com.sun.prism.impl.Disposer$Record;
import com.sun.prism.impl.MeshTempState;
import com.sun.prism.impl.MeshUtil;
import com.sun.prism.impl.MeshVertex;
import java.util.Arrays;
import java.util.HashMap;
import javafx.scene.shape.VertexFormat;

public abstract class BaseMesh
extends BaseGraphicsResource
implements Mesh {
    private int nVerts;
    private int nTVerts;
    private int nFaces;
    private float[] pos;
    private float[] uv;
    private int[] faces;
    private int[] smoothing;
    private boolean allSameSmoothing;
    private boolean allHardEdges;
    protected static final int POINT_SIZE = 3;
    protected static final int NORMAL_SIZE = 3;
    protected static final int TEXCOORD_SIZE = 2;
    protected static final int POINT_SIZE_VB = 3;
    protected static final int TEXCOORD_SIZE_VB = 2;
    protected static final int NORMAL_SIZE_VB = 4;
    protected static final int VERTEX_SIZE_VB = 9;
    public static final int FACE_MEMBERS_SIZE = 7;
    private boolean[] dirtyVertices;
    private float[] cachedNormals;
    private float[] cachedTangents;
    private float[] cachedBitangents;
    private float[] vertexBuffer;
    private int[] indexBuffer;
    private short[] indexBufferShort;
    private int indexBufferSize;
    private int numberOfVertices;
    private HashMap<Integer, BaseMesh$MeshGeomComp2VB> point2vbMap;
    private HashMap<Integer, BaseMesh$MeshGeomComp2VB> normal2vbMap;
    private HashMap<Integer, BaseMesh$MeshGeomComp2VB> texCoord2vbMap;

    protected BaseMesh(Disposer$Record disposer$Record) {
        super(disposer$Record);
    }

    public abstract boolean buildNativeGeometry(float[] var1, int var2, int[] var3, int var4);

    public abstract boolean buildNativeGeometry(float[] var1, int var2, short[] var3, int var4);

    private void convertNormalsToQuats(MeshTempState meshTempState, int n2, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, boolean[] blArray) {
        Vec3f vec3f = meshTempState.vec3f1;
        Vec3f vec3f2 = meshTempState.vec3f2;
        Vec3f vec3f3 = meshTempState.vec3f3;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            if (blArray == null || blArray[n3]) {
                int n5 = n3 * 3;
                vec3f.x = fArray[n5];
                vec3f.y = fArray[n5 + 1];
                vec3f.z = fArray[n5 + 2];
                vec3f.normalize();
                vec3f2.x = fArray2[n5];
                vec3f2.y = fArray2[n5 + 1];
                vec3f2.z = fArray2[n5 + 2];
                vec3f3.x = fArray3[n5];
                vec3f3.y = fArray3[n5 + 1];
                vec3f3.z = fArray3[n5 + 2];
                meshTempState.triNormals[0].set(vec3f);
                meshTempState.triNormals[1].set(vec3f2);
                meshTempState.triNormals[2].set(vec3f3);
                MeshUtil.fixTSpace(meshTempState.triNormals);
                this.buildVSQuat(meshTempState.triNormals, meshTempState.quat);
                fArray4[n4 + 5] = meshTempState.quat.x;
                fArray4[n4 + 6] = meshTempState.quat.y;
                fArray4[n4 + 7] = meshTempState.quat.z;
                fArray4[n4 + 8] = meshTempState.quat.w;
            }
            ++n3;
            n4 += 9;
        }
    }

    private boolean doBuildPNTGeometry(float[] fArray, float[] fArray2, float[] fArray3, int[] nArray) {
        int n2;
        int n3;
        if (this.point2vbMap == null) {
            this.point2vbMap = new HashMap();
        } else {
            this.point2vbMap.clear();
        }
        if (this.normal2vbMap == null) {
            this.normal2vbMap = new HashMap();
        } else {
            this.normal2vbMap.clear();
        }
        if (this.texCoord2vbMap == null) {
            this.texCoord2vbMap = new HashMap();
        } else {
            this.texCoord2vbMap.clear();
        }
        int n4 = VertexFormat.POINT_NORMAL_TEXCOORD.getVertexIndexSize();
        int n5 = n4 * 3;
        int n6 = VertexFormat.POINT_NORMAL_TEXCOORD.getPointIndexOffset();
        int n7 = VertexFormat.POINT_NORMAL_TEXCOORD.getNormalIndexOffset();
        int n8 = VertexFormat.POINT_NORMAL_TEXCOORD.getTexCoordIndexOffset();
        int n9 = fArray.length / 3;
        int n10 = fArray2.length / 3;
        int n11 = fArray3.length / 2;
        int n12 = nArray.length / n5;
        assert (n9 > 0 && n10 > 0 && n11 > 0 && n12 > 0);
        this.cachedNormals = new float[n9 * 3];
        this.cachedTangents = new float[n9 * 3];
        this.cachedBitangents = new float[n9 * 3];
        this.vertexBuffer = new float[n9 * 9];
        this.indexBuffer = new int[n12 * 3];
        n11 = 0;
        int n13 = 0;
        MeshTempState meshTempState = MeshTempState.getInstance();
        for (n3 = 0; n3 < 3; ++n3) {
            if (meshTempState.triPoints[n3] == null) {
                meshTempState.triPoints[n3] = new Vec3f();
            }
            if (meshTempState.triTexCoords[n3] != null) continue;
            meshTempState.triTexCoords[n3] = new Vec2f();
        }
        for (n3 = 0; n3 < n12; ++n3) {
            int n14;
            n2 = n3 * n5;
            for (n14 = 0; n14 < 3; ++n14) {
                int n15;
                int n16;
                n9 = n2 + n14 * n4;
                n10 = n9 + n6;
                int n17 = n9 + n7;
                int n18 = n9 + n8;
                Integer n19 = n13 / 9;
                if (this.vertexBuffer.length <= n13) {
                    n16 = n13 / 9;
                    n15 = n16 + Math.max(n16 >> 3, 6);
                    float[] fArray4 = new float[n15 * 9];
                    System.arraycopy(this.vertexBuffer, 0, fArray4, 0, this.vertexBuffer.length);
                    this.vertexBuffer = fArray4;
                    fArray4 = new float[n15 * 3];
                    System.arraycopy(this.cachedNormals, 0, fArray4, 0, this.cachedNormals.length);
                    this.cachedNormals = fArray4;
                    fArray4 = new float[n15 * 3];
                    System.arraycopy(this.cachedTangents, 0, fArray4, 0, this.cachedTangents.length);
                    this.cachedTangents = fArray4;
                    fArray4 = new float[n15 * 3];
                    System.arraycopy(this.cachedBitangents, 0, fArray4, 0, this.cachedBitangents.length);
                    this.cachedBitangents = fArray4;
                }
                n16 = nArray[n10] * 3;
                n15 = nArray[n17] * 3;
                int n20 = nArray[n18] << 1;
                meshTempState.triPointIndex[n14] = n16;
                meshTempState.triTexCoordIndex[n14] = n20;
                meshTempState.triVerts[n14] = n13 / 9;
                this.vertexBuffer[n13] = fArray[n16];
                this.vertexBuffer[n13 + 1] = fArray[n16 + 1];
                this.vertexBuffer[n13 + 2] = fArray[n16 + 2];
                this.vertexBuffer[n13 + 3] = fArray3[n20];
                this.vertexBuffer[n13 + 4] = fArray3[n20 + 1];
                n10 = meshTempState.triVerts[n14] * 3;
                this.cachedNormals[n10] = fArray2[n15];
                this.cachedNormals[n10 + 1] = fArray2[n15 + 1];
                this.cachedNormals[n10 + 2] = fArray2[n15 + 2];
                n13 += 9;
                BaseMesh$MeshGeomComp2VB baseMesh$MeshGeomComp2VB = this.point2vbMap.get(n16);
                if (baseMesh$MeshGeomComp2VB == null) {
                    baseMesh$MeshGeomComp2VB = new BaseMesh$MeshGeomComp2VB(this, n16, n19);
                    this.point2vbMap.put(n16, baseMesh$MeshGeomComp2VB);
                } else {
                    baseMesh$MeshGeomComp2VB.addLoc(n19);
                }
                baseMesh$MeshGeomComp2VB = this.normal2vbMap.get(n15);
                if (baseMesh$MeshGeomComp2VB == null) {
                    baseMesh$MeshGeomComp2VB = new BaseMesh$MeshGeomComp2VB(this, n15, n19);
                    this.normal2vbMap.put(n15, baseMesh$MeshGeomComp2VB);
                } else {
                    baseMesh$MeshGeomComp2VB.addLoc(n19);
                }
                baseMesh$MeshGeomComp2VB = this.texCoord2vbMap.get(n20);
                if (baseMesh$MeshGeomComp2VB == null) {
                    baseMesh$MeshGeomComp2VB = new BaseMesh$MeshGeomComp2VB(this, n20, n19);
                    this.texCoord2vbMap.put(n20, baseMesh$MeshGeomComp2VB);
                } else {
                    baseMesh$MeshGeomComp2VB.addLoc(n19);
                }
                this.indexBuffer[n11++] = n19;
            }
            for (n14 = 0; n14 < 3; ++n14) {
                meshTempState.triPoints[n14].x = fArray[meshTempState.triPointIndex[n14]];
                meshTempState.triPoints[n14].y = fArray[meshTempState.triPointIndex[n14] + 1];
                meshTempState.triPoints[n14].z = fArray[meshTempState.triPointIndex[n14] + 2];
                meshTempState.triTexCoords[n14].x = fArray3[meshTempState.triTexCoordIndex[n14]];
                meshTempState.triTexCoords[n14].y = fArray3[meshTempState.triTexCoordIndex[n14] + 1];
            }
            MeshUtil.computeTBNNormalized(meshTempState.triPoints[0], meshTempState.triPoints[1], meshTempState.triPoints[2], meshTempState.triTexCoords[0], meshTempState.triTexCoords[1], meshTempState.triTexCoords[2], meshTempState.triNormals);
            for (n14 = 0; n14 < 3; ++n14) {
                n9 = meshTempState.triVerts[n14] * 3;
                this.cachedTangents[n9] = meshTempState.triNormals[1].x;
                this.cachedTangents[n9 + 1] = meshTempState.triNormals[1].y;
                this.cachedTangents[n9 + 2] = meshTempState.triNormals[1].z;
                this.cachedBitangents[n9] = meshTempState.triNormals[2].x;
                this.cachedBitangents[n9 + 1] = meshTempState.triNormals[2].y;
                this.cachedBitangents[n9 + 2] = meshTempState.triNormals[2].z;
            }
        }
        this.numberOfVertices = n13 / 9;
        this.convertNormalsToQuats(meshTempState, this.numberOfVertices, this.cachedNormals, this.cachedTangents, this.cachedBitangents, this.vertexBuffer, null);
        this.indexBufferSize = n12 * 3;
        if (this.numberOfVertices > 65536) {
            BaseMesh baseMesh = this;
            return baseMesh.buildNativeGeometry(baseMesh.vertexBuffer, this.numberOfVertices * 9, this.indexBuffer, this.indexBufferSize);
        }
        if (this.indexBufferShort == null || this.indexBufferShort.length < this.indexBufferSize) {
            this.indexBufferShort = new short[this.indexBufferSize];
        }
        n3 = 0;
        for (n2 = 0; n2 < n12; ++n2) {
            this.indexBufferShort[n3] = (short)this.indexBuffer[n3++];
            this.indexBufferShort[n3] = (short)this.indexBuffer[n3++];
            this.indexBufferShort[n3] = (short)this.indexBuffer[n3++];
        }
        this.indexBuffer = null;
        BaseMesh baseMesh = this;
        return baseMesh.buildNativeGeometry(baseMesh.vertexBuffer, this.numberOfVertices * 9, this.indexBufferShort, this.indexBufferSize);
    }

    private boolean updatePNTGeometry(float[] object, int[] nArray, float[] fArray, int[] nArray2, float[] fArray2, int[] nArray3) {
        int n2;
        int n3;
        int n4;
        if (this.dirtyVertices == null) {
            this.dirtyVertices = new boolean[this.numberOfVertices];
        }
        Arrays.fill(this.dirtyVertices, false);
        int n5 = nArray[0] / 3;
        int n6 = nArray[1] / 3;
        if (nArray[1] % 3 > 0) {
            ++n6;
        }
        if (n6 > 0) {
            for (int i2 = 0; i2 < n6; ++i2) {
                int n7;
                n4 = (n5 + i2) * 3;
                BaseMesh$MeshGeomComp2VB baseMesh$MeshGeomComp2VB = this.point2vbMap.get(n4);
                assert (baseMesh$MeshGeomComp2VB != null);
                if (baseMesh$MeshGeomComp2VB == null) continue;
                int[] nArray4 = baseMesh$MeshGeomComp2VB.getLocs();
                int n8 = baseMesh$MeshGeomComp2VB.getValidLocs();
                if (nArray4 != null) {
                    for (n7 = 0; n7 < n8; ++n7) {
                        n3 = nArray4[n7] * 9;
                        this.vertexBuffer[n3] = object[n4];
                        this.vertexBuffer[n3 + 1] = object[n4 + 1];
                        this.vertexBuffer[n3 + 2] = (float)object[n4 + 2];
                        this.dirtyVertices[nArray4[n7]] = true;
                    }
                    continue;
                }
                n7 = baseMesh$MeshGeomComp2VB.getLoc();
                n3 = n7 * 9;
                this.vertexBuffer[n3] = object[n4];
                this.vertexBuffer[n3 + 1] = object[n4 + 1];
                this.vertexBuffer[n3 + 2] = object[n4 + 2];
                this.dirtyVertices[n7] = true;
            }
        }
        int n9 = nArray3[0] / 2;
        n4 = nArray3[1] / 2;
        if (nArray3[1] % 2 > 0) {
            ++n4;
        }
        if (n4 > 0) {
            for (int i3 = 0; i3 < n4; ++i3) {
                int n10 = n9 + i3 << 1;
                BaseMesh$MeshGeomComp2VB baseMesh$MeshGeomComp2VB = this.texCoord2vbMap.get(n10);
                assert (baseMesh$MeshGeomComp2VB != null);
                if (baseMesh$MeshGeomComp2VB == null) continue;
                int[] nArray5 = baseMesh$MeshGeomComp2VB.getLocs();
                n3 = baseMesh$MeshGeomComp2VB.getValidLocs();
                if (nArray5 != null) {
                    for (int i4 = 0; i4 < n3; ++i4) {
                        int n11 = nArray5[i4] * 9 + 3;
                        this.vertexBuffer[n11] = fArray2[n10];
                        this.vertexBuffer[n11 + 1] = fArray2[n10 + 1];
                        this.dirtyVertices[nArray5[i4]] = true;
                    }
                    continue;
                }
                int n12 = baseMesh$MeshGeomComp2VB.getLoc();
                int n13 = n12 * 9 + 3;
                this.vertexBuffer[n13] = fArray2[n10];
                this.vertexBuffer[n13 + 1] = fArray2[n10 + 1];
                this.dirtyVertices[n12] = true;
            }
        }
        int n14 = nArray2[0] / 3;
        int n15 = nArray2[1] / 3;
        if (nArray2[1] % 3 > 0) {
            ++n15;
        }
        if (n15 > 0) {
            MeshTempState.getInstance();
            for (int i5 = 0; i5 < n15; ++i5) {
                n3 = (n14 + i5) * 3;
                object = this.normal2vbMap.get(n3);
                assert (object != null);
                if (object == null) continue;
                nArray3 = ((BaseMesh$MeshGeomComp2VB)object).getLocs();
                n9 = ((BaseMesh$MeshGeomComp2VB)object).getValidLocs();
                if (nArray3 != null) {
                    for (int i6 = 0; i6 < n9; ++i6) {
                        int n16 = nArray3[i6] * 3;
                        this.cachedNormals[n16] = fArray[n3];
                        this.cachedNormals[n16 + 1] = fArray[n3 + 1];
                        this.cachedNormals[n16 + 2] = fArray[n3 + 2];
                        this.dirtyVertices[nArray3[i6]] = true;
                    }
                    continue;
                }
                int n17 = ((BaseMesh$MeshGeomComp2VB)object).getLoc();
                int n18 = n17 * 3;
                this.cachedNormals[n18] = fArray[n3];
                this.cachedNormals[n18 + 1] = fArray[n3 + 1];
                this.cachedNormals[n18 + 2] = fArray[n3 + 2];
                this.dirtyVertices[n17] = true;
            }
        }
        MeshTempState meshTempState = MeshTempState.getInstance();
        for (n2 = 0; n2 < 3; ++n2) {
            if (meshTempState.triPoints[n2] == null) {
                meshTempState.triPoints[n2] = new Vec3f();
            }
            if (meshTempState.triTexCoords[n2] != null) continue;
            meshTempState.triTexCoords[n2] = new Vec2f();
        }
        for (n2 = 0; n2 < this.numberOfVertices; n2 += 3) {
            int n19;
            if (!this.dirtyVertices[n2] && !this.dirtyVertices[n2 + 1] && !this.dirtyVertices[n2 + 2]) continue;
            n3 = n2 * 9;
            for (n19 = 0; n19 < 3; ++n19) {
                meshTempState.triPoints[n19].x = this.vertexBuffer[n3];
                meshTempState.triPoints[n19].y = this.vertexBuffer[n3 + 1];
                meshTempState.triPoints[n19].z = this.vertexBuffer[n3 + 2];
                meshTempState.triTexCoords[n19].x = this.vertexBuffer[n3 + 3];
                meshTempState.triTexCoords[n19].y = this.vertexBuffer[n3 + 3 + 1];
                n3 += 9;
            }
            MeshUtil.computeTBNNormalized(meshTempState.triPoints[0], meshTempState.triPoints[1], meshTempState.triPoints[2], meshTempState.triTexCoords[0], meshTempState.triTexCoords[1], meshTempState.triTexCoords[2], meshTempState.triNormals);
            n19 = n2 * 3;
            for (int i7 = 0; i7 < 3; ++i7) {
                this.cachedTangents[n19] = meshTempState.triNormals[1].x;
                this.cachedTangents[n19 + 1] = meshTempState.triNormals[1].y;
                this.cachedTangents[n19 + 2] = meshTempState.triNormals[1].z;
                this.cachedBitangents[n19] = meshTempState.triNormals[2].x;
                this.cachedBitangents[n19 + 1] = meshTempState.triNormals[2].y;
                this.cachedBitangents[n19 + 2] = meshTempState.triNormals[2].z;
                n19 += 3;
            }
        }
        this.convertNormalsToQuats(meshTempState, this.numberOfVertices, this.cachedNormals, this.cachedTangents, this.cachedBitangents, this.vertexBuffer, this.dirtyVertices);
        if (this.indexBuffer != null) {
            BaseMesh baseMesh = this;
            return baseMesh.buildNativeGeometry(baseMesh.vertexBuffer, this.numberOfVertices * 9, this.indexBuffer, this.indexBufferSize);
        }
        BaseMesh baseMesh = this;
        return baseMesh.buildNativeGeometry(baseMesh.vertexBuffer, this.numberOfVertices * 9, this.indexBufferShort, this.indexBufferSize);
    }

    @Override
    public boolean buildGeometry(boolean bl2, float[] fArray, int[] nArray, float[] fArray2, int[] nArray2, float[] fArray3, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7) {
        if (bl2) {
            return this.buildPNTGeometry(fArray, nArray, fArray2, nArray2, fArray3, nArray3, nArray4, nArray5);
        }
        return this.buildPTGeometry(fArray, fArray3, nArray4, nArray6);
    }

    private boolean buildPNTGeometry(float[] fArray, int[] nArray, float[] fArray2, int[] nArray2, float[] fArray3, int[] nArray3, int[] nArray4, int[] nArray5) {
        boolean bl2 = nArray[1] > 0;
        boolean bl3 = nArray2[1] > 0;
        boolean bl4 = nArray3[1] > 0;
        boolean bl5 = nArray5[1] > 0;
        boolean bl6 = bl2 = !bl2 && !bl3 && !bl4 && !bl5;
        if (bl5) {
            bl2 = true;
        }
        if (!(bl2 || this.vertexBuffer == null || this.indexBuffer == null && this.indexBufferShort == null)) {
            return this.updatePNTGeometry(fArray, nArray, fArray2, nArray2, fArray3, nArray3);
        }
        return this.doBuildPNTGeometry(fArray, fArray2, fArray3, nArray4);
    }

    private boolean buildPTGeometry(float[] object, float[] fArray, int[] nArray, int[] nArray2) {
        this.nVerts = ((float[])object).length / 3;
        this.nTVerts = fArray.length / 2;
        this.nFaces = nArray.length / (VertexFormat.POINT_TEXCOORD.getVertexIndexSize() * 3);
        assert (this.nVerts > 0 && this.nFaces > 0 && this.nTVerts > 0);
        this.pos = object;
        this.uv = fArray;
        this.faces = nArray;
        this.smoothing = (int[])(nArray2.length == this.nFaces ? nArray2 : null);
        MeshTempState meshTempState = MeshTempState.getInstance();
        object = meshTempState;
        if (meshTempState.pool == null || object.pool.length < this.nFaces * 3) {
            object.pool = new MeshVertex[this.nFaces * 3];
        }
        if (object.indexBuffer == null || object.indexBuffer.length < this.nFaces * 3) {
            object.indexBuffer = new int[this.nFaces * 3];
        }
        if (object.pVertex == null || object.pVertex.length < this.nVerts) {
            object.pVertex = new MeshVertex[this.nVerts];
        } else {
            Arrays.fill(object.pVertex, 0, object.pVertex.length, null);
        }
        this.checkSmoothingGroup();
        this.computeTBNormal(object.pool, object.pVertex, object.indexBuffer);
        int n2 = MeshVertex.processVertices(object.pVertex, this.nVerts, this.allHardEdges, this.allSameSmoothing);
        if (object.vertexBuffer == null || object.vertexBuffer.length < n2 * 9) {
            object.vertexBuffer = new float[n2 * 9];
        }
        this.buildVertexBuffer(object.pVertex, object.vertexBuffer);
        if (n2 > 65536) {
            this.buildIndexBuffer(object.pool, object.indexBuffer, null);
            return this.buildNativeGeometry(object.vertexBuffer, n2 * 9, object.indexBuffer, this.nFaces * 3);
        }
        if (object.indexBufferShort == null || object.indexBufferShort.length < this.nFaces * 3) {
            object.indexBufferShort = new short[this.nFaces * 3];
        }
        this.buildIndexBuffer(object.pool, object.indexBuffer, object.indexBufferShort);
        return this.buildNativeGeometry(object.vertexBuffer, n2 * 9, object.indexBufferShort, this.nFaces * 3);
    }

    private void computeTBNormal(MeshVertex[] meshVertexArray, MeshVertex[] meshVertexArray2, int[] nArray) {
        Vec3f[] vec3fArray = MeshTempState.getInstance();
        int[] nArray2 = vec3fArray.smFace;
        int[] nArray3 = vec3fArray.triVerts;
        Vec3f[] vec3fArray2 = vec3fArray.triPoints;
        Vec2f[] vec2fArray = vec3fArray.triTexCoords;
        vec3fArray = vec3fArray.triNormals;
        String string = BaseMesh.class.getName();
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.nFaces; ++i2) {
            int n4;
            int n5 = i2 * 3;
            nArray2 = this.getFace(i2, nArray2);
            nArray3[0] = nArray2[BaseMesh$FaceMembers.POINT0.ordinal()];
            nArray3[1] = nArray2[BaseMesh$FaceMembers.POINT1.ordinal()];
            nArray3[2] = nArray2[BaseMesh$FaceMembers.POINT2.ordinal()];
            if (MeshUtil.isDeadFace(nArray3) && PlatformLogger.getLogger(string).isLoggable(PlatformLogger$Level.FINE)) {
                PlatformLogger.getLogger(string).fine("Dead face [" + nArray3[0] + ", " + nArray3[1] + ", " + nArray3[2] + "] @ face group " + i2 + "; nEmptyFaces = " + ++n2);
            }
            for (n4 = 0; n4 < 3; ++n4) {
                vec3fArray2[n4] = this.getVertex(nArray3[n4], vec3fArray2[n4]);
            }
            nArray3[0] = nArray2[BaseMesh$FaceMembers.TEXCOORD0.ordinal()];
            nArray3[1] = nArray2[BaseMesh$FaceMembers.TEXCOORD1.ordinal()];
            nArray3[2] = nArray2[BaseMesh$FaceMembers.TEXCOORD2.ordinal()];
            for (n4 = 0; n4 < 3; ++n4) {
                vec2fArray[n4] = this.getTVertex(nArray3[n4], vec2fArray[n4]);
            }
            MeshUtil.computeTBNNormalized(vec3fArray2[0], vec3fArray2[1], vec3fArray2[2], vec2fArray[0], vec2fArray[1], vec2fArray[2], vec3fArray);
            for (n4 = 0; n4 < 3; ++n4) {
                int n6;
                meshVertexArray[n3] = meshVertexArray[n3] == null ? new MeshVertex() : meshVertexArray[n3];
                for (n6 = 0; n6 < 3; ++n6) {
                    meshVertexArray[n3].norm[n6].set(vec3fArray[n6]);
                }
                meshVertexArray[n3].smGroup = nArray2[BaseMesh$FaceMembers.SMOOTHING_GROUP.ordinal()];
                meshVertexArray[n3].fIdx = i2;
                meshVertexArray[n3].tVert = nArray3[n4];
                meshVertexArray[n3].index = -1;
                n6 = n4 == 0 ? BaseMesh$FaceMembers.POINT0.ordinal() : (n4 == 1 ? BaseMesh$FaceMembers.POINT1.ordinal() : BaseMesh$FaceMembers.POINT2.ordinal());
                meshVertexArray[n3].pVert = n6 = nArray2[n6];
                nArray[n5 + n4] = n6;
                meshVertexArray[n3].next = meshVertexArray2[n6];
                meshVertexArray2[n6] = meshVertexArray[n3];
                ++n3;
            }
        }
    }

    private void buildVSQuat(Vec3f[] vec3fArray, Quat4f quat4f) {
        float f2;
        Vec3f vec3f = MeshTempState.getInstance().vec3f1;
        vec3f.cross(vec3fArray[1], vec3fArray[2]);
        float f3 = vec3fArray[0].dot(vec3f);
        if (f2 < 0.0f) {
            vec3fArray[2].mul(-1.0f);
        }
        MeshUtil.buildQuat(vec3fArray, quat4f);
        if (f3 < 0.0f) {
            if (quat4f.w == 0.0f) {
                quat4f.w = 1.0E-10f;
            }
            quat4f.scale(-1.0f);
        }
    }

    private void buildVertexBuffer(MeshVertex[] meshVertexArray, float[] fArray) {
        Quat4f quat4f = MeshTempState.getInstance().quat;
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.nVerts; ++i2) {
            MeshVertex meshVertex = meshVertexArray[i2];
            while (meshVertex != null) {
                if (meshVertex.index == n2) {
                    int n4 = meshVertex.pVert * 3;
                    fArray[n3++] = this.pos[n4];
                    fArray[n3++] = this.pos[n4 + 1];
                    fArray[n3++] = this.pos[n4 + 2];
                    n4 = meshVertex.tVert << 1;
                    fArray[n3++] = this.uv[n4];
                    fArray[n3++] = this.uv[n4 + 1];
                    this.buildVSQuat(meshVertex.norm, quat4f);
                    fArray[n3++] = quat4f.x;
                    fArray[n3++] = quat4f.y;
                    fArray[n3++] = quat4f.z;
                    fArray[n3++] = quat4f.w;
                    ++n2;
                }
                meshVertex = meshVertex.next;
            }
        }
    }

    private void buildIndexBuffer(MeshVertex[] meshVertexArray, int[] nArray, short[] sArray) {
        for (int i2 = 0; i2 < this.nFaces; ++i2) {
            int n2;
            int n3 = i2 * 3;
            if (nArray[n3] != -1) {
                for (n2 = 0; n2 < 3; ++n2) {
                    assert (meshVertexArray[n3].fIdx == i2);
                    if (sArray != null) {
                        sArray[n3 + n2] = (short)meshVertexArray[n3 + n2].index;
                    } else {
                        nArray[n3 + n2] = meshVertexArray[n3 + n2].index;
                    }
                    meshVertexArray[n3 + n2].next = null;
                }
                continue;
            }
            for (n2 = 0; n2 < 3; ++n2) {
                if (sArray != null) {
                    sArray[n3 + n2] = 0;
                    continue;
                }
                nArray[n3 + n2] = 0;
            }
        }
    }

    public int getNumVerts() {
        return this.nVerts;
    }

    public int getNumTVerts() {
        return this.nTVerts;
    }

    public int getNumFaces() {
        return this.nFaces;
    }

    public Vec3f getVertex(int n2, Vec3f vec3f) {
        if (vec3f == null) {
            vec3f = new Vec3f();
        }
        vec3f.set(this.pos[n2 *= 3], this.pos[n2 + 1], this.pos[n2 + 2]);
        return vec3f;
    }

    public Vec2f getTVertex(int n2, Vec2f vec2f) {
        if (vec2f == null) {
            vec2f = new Vec2f();
        }
        vec2f.set(this.uv[n2 <<= 1], this.uv[n2 + 1]);
        return vec2f;
    }

    private void checkSmoothingGroup() {
        if (this.smoothing == null || this.smoothing.length == 0) {
            this.allSameSmoothing = true;
            this.allHardEdges = false;
            return;
        }
        int n2 = 0;
        while (n2 + 1 < this.smoothing.length) {
            if (this.smoothing[n2] != this.smoothing[n2 + 1]) {
                this.allSameSmoothing = false;
                this.allHardEdges = false;
                return;
            }
            ++n2;
        }
        if (this.smoothing[0] == 0) {
            this.allSameSmoothing = false;
            this.allHardEdges = true;
            return;
        }
        this.allSameSmoothing = true;
        this.allHardEdges = false;
    }

    public int[] getFace(int n2, int[] nArray) {
        int n3 = n2 * 6;
        if (nArray == null || nArray.length < 7) {
            nArray = new int[7];
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            nArray[i2] = this.faces[n3 + i2];
        }
        nArray[6] = this.smoothing != null ? this.smoothing[n2] : 1;
        return nArray;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    boolean test_isVertexBufferNull() {
        return this.vertexBuffer == null;
    }

    int test_getVertexBufferLength() {
        return this.vertexBuffer.length;
    }

    int test_getNumberOfVertices() {
        return this.numberOfVertices;
    }
}

