/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.geom.Rectangle;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.prism.Texture$Usage;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.util.Pair;

public abstract class BaseResourceFactory
implements ResourceFactory {
    private final Map<Image, Texture> clampTexCache;
    private final Map<Image, Texture> repeatTexCache;
    private final Map<Image, Texture> mipmapTexCache;
    private final WeakHashMap<ResourceFactoryListener, Boolean> listenerMap = new WeakHashMap();
    private boolean disposed = false;
    private Texture regionTexture;
    private Texture glyphTexture;
    private boolean superShaderAllowed;

    public BaseResourceFactory() {
        this(new WeakHashMap<Image, Texture>(), new WeakHashMap<Image, Texture>(), new WeakHashMap<Image, Texture>());
    }

    public BaseResourceFactory(Map<Image, Texture> map, Map<Image, Texture> map2, Map<Image, Texture> map3) {
        this.clampTexCache = map;
        this.repeatTexCache = map2;
        this.mipmapTexCache = map3;
    }

    @Override
    public void addFactoryListener(ResourceFactoryListener resourceFactoryListener) {
        this.listenerMap.put(resourceFactoryListener, Boolean.TRUE);
    }

    @Override
    public void removeFactoryListener(ResourceFactoryListener resourceFactoryListener) {
        this.listenerMap.remove(resourceFactoryListener);
    }

    @Override
    public boolean isDeviceReady() {
        return !this.isDisposed();
    }

    protected void clearTextureCache() {
        BaseResourceFactory baseResourceFactory = this;
        baseResourceFactory.clearTextureCache(baseResourceFactory.clampTexCache);
        BaseResourceFactory baseResourceFactory2 = this;
        baseResourceFactory2.clearTextureCache(baseResourceFactory2.repeatTexCache);
        BaseResourceFactory baseResourceFactory3 = this;
        baseResourceFactory3.clearTextureCache(baseResourceFactory3.mipmapTexCache);
    }

    protected void clearTextureCache(Map<Image, Texture> map) {
        Object object = map.values();
        object = object.iterator();
        while (object.hasNext()) {
            Texture texture = (Texture)object.next();
            texture.dispose();
        }
        map.clear();
    }

    protected ResourceFactoryListener[] getFactoryListeners() {
        return this.listenerMap.keySet().toArray(new ResourceFactoryListener[0]);
    }

    private void disposeResources() {
        this.clampTexCache.clear();
        this.repeatTexCache.clear();
        this.mipmapTexCache.clear();
        if (this.regionTexture != null) {
            this.regionTexture.dispose();
            this.regionTexture = null;
        }
        if (this.glyphTexture != null) {
            this.glyphTexture.dispose();
            this.glyphTexture = null;
        }
    }

    protected void notifyReset() {
        this.disposeResources();
        ResourceFactoryListener[] resourceFactoryListenerArray = this.getFactoryListeners();
        ResourceFactoryListener[] resourceFactoryListenerArray2 = resourceFactoryListenerArray;
        resourceFactoryListenerArray2 = resourceFactoryListenerArray;
        int n2 = resourceFactoryListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ResourceFactoryListener resourceFactoryListener = resourceFactoryListenerArray2[i2];
            if (resourceFactoryListener == null) continue;
            resourceFactoryListener.factoryReset();
        }
    }

    @Override
    public void dispose() {
        this.disposeResources();
        this.disposed = true;
        ResourceFactoryListener[] resourceFactoryListenerArray = this.getFactoryListeners();
        ResourceFactoryListener[] resourceFactoryListenerArray2 = resourceFactoryListenerArray;
        resourceFactoryListenerArray2 = resourceFactoryListenerArray;
        int n2 = resourceFactoryListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ResourceFactoryListener resourceFactoryListener = resourceFactoryListenerArray2[i2];
            if (resourceFactoryListener == null) continue;
            resourceFactoryListener.factoryReleased();
        }
    }

    static long sizeWithMipMap(int n2, int n3, PixelFormat pixelFormat) {
        long l2 = 0L;
        int n4 = pixelFormat.getBytesPerPixelUnit();
        while (n2 > 1 && n3 > 1) {
            l2 += (long)n2 * (long)n3;
            n2 = n2 + 1 >> 1;
            n3 = n3 + 1 >> 1;
        }
        return ++l2 * (long)n4;
    }

    @Override
    public Texture getCachedTexture(Image image, Texture$WrapMode texture$WrapMode) {
        if (this.checkDisposed()) {
            return null;
        }
        return this.getCachedTexture(image, texture$WrapMode, false);
    }

    @Override
    public Texture getCachedTexture(Image image, Texture$WrapMode texture$WrapMode, boolean bl2) {
        Object object;
        Map<Image, Texture> map;
        if (this.checkDisposed()) {
            return null;
        }
        if (image == null) {
            throw new IllegalArgumentException("Image must be non-null");
        }
        if (texture$WrapMode == Texture$WrapMode.CLAMP_TO_EDGE) {
            if (bl2) {
                throw new IllegalArgumentException("Mipmap not supported with CLAMP mode: useMipmap = " + bl2 + ", wrapMode = " + String.valueOf((Object)texture$WrapMode));
            }
            map = this.clampTexCache;
        } else if (texture$WrapMode == Texture$WrapMode.REPEAT) {
            map = bl2 ? this.mipmapTexCache : this.repeatTexCache;
        } else {
            throw new IllegalArgumentException("no caching for " + String.valueOf((Object)texture$WrapMode));
        }
        Texture texture = map.get(image);
        if (texture != null) {
            texture.lock();
            if (texture.isSurfaceLost()) {
                map.remove(image);
                texture = null;
            }
        }
        if (!bl2 && texture == null && (object = (texture$WrapMode == Texture$WrapMode.REPEAT ? this.clampTexCache : this.repeatTexCache).get(image)) != null) {
            object.lock();
            if (!object.isSurfaceLost() && (texture = object.getSharedTexture(texture$WrapMode)) != null) {
                texture.contentsUseful();
                map.put(image, texture);
            }
            object.unlock();
        }
        object = image.getSerial().getIdRect();
        if (texture == null) {
            long l2;
            int n2 = image.getWidth();
            int n3 = image.getHeight();
            TextureResourcePool textureResourcePool = this.getTextureResourcePool();
            long l3 = l2 = bl2 ? BaseResourceFactory.sizeWithMipMap(n2, n3, image.getPixelFormat()) : textureResourcePool.estimateTextureSize(n2, n3, image.getPixelFormat());
            if (!textureResourcePool.prepareForAllocation(l2)) {
                return null;
            }
            texture = this.createTexture(image, Texture$Usage.DEFAULT, texture$WrapMode, bl2);
            if (texture != null) {
                texture.setLastImageSerial((Integer)((Pair)object).getKey());
                map.put(image, texture);
            }
        } else if (texture.getLastImageSerial() != ((Pair)object).getKey().intValue()) {
            if ((Integer)((Pair)object).getKey() - texture.getLastImageSerial() == 1 && ((Pair)object).getValue() != null) {
                Rectangle rectangle = (Rectangle)((Pair)object).getValue();
                texture.update(image.getPixelBuffer(), image.getPixelFormat(), rectangle.x, rectangle.y, rectangle.x, rectangle.y, rectangle.width, rectangle.height, image.getScanlineStride(), false);
            } else {
                texture.update(image, 0, 0, image.getWidth(), image.getHeight(), false);
            }
            texture.setLastImageSerial((Integer)((Pair)object).getKey());
        }
        return texture;
    }

    @Override
    public Texture createTexture(Image image, Texture$Usage texture$Usage, Texture$WrapMode texture$WrapMode) {
        if (this.checkDisposed()) {
            return null;
        }
        return this.createTexture(image, texture$Usage, texture$WrapMode, false);
    }

    @Override
    public Texture createTexture(Image image, Texture$Usage object, Texture$WrapMode texture$WrapMode, boolean bl2) {
        int n2;
        int n3;
        if (this.checkDisposed()) {
            return null;
        }
        PixelFormat pixelFormat = image.getPixelFormat();
        object = this.createTexture(pixelFormat, (Texture$Usage)((Object)object), texture$WrapMode, n3 = image.getWidth(), n2 = image.getHeight(), bl2);
        if (object != null) {
            object.update(image, 0, 0, n3, n2, true);
            object.contentsUseful();
        }
        return object;
    }

    @Override
    public Texture createMaskTexture(int n2, int n3, Texture$WrapMode texture$WrapMode) {
        return this.createTexture(PixelFormat.BYTE_ALPHA, Texture$Usage.DEFAULT, texture$WrapMode, n2, n3);
    }

    @Override
    public Texture createFloatTexture(int n2, int n3) {
        return this.createTexture(PixelFormat.FLOAT_XYZW, Texture$Usage.DEFAULT, Texture$WrapMode.CLAMP_TO_ZERO, n2, n3);
    }

    @Override
    public void setRegionTexture(Texture texture) {
        if (this.checkDisposed()) {
            return;
        }
        this.regionTexture = texture;
        this.superShaderAllowed = PrismSettings.superShader && this.regionTexture != null && this.glyphTexture != null;
    }

    @Override
    public Texture getRegionTexture() {
        return this.regionTexture;
    }

    @Override
    public void setGlyphTexture(Texture texture) {
        if (this.checkDisposed()) {
            return;
        }
        this.glyphTexture = texture;
        this.superShaderAllowed = PrismSettings.superShader && this.regionTexture != null && this.glyphTexture != null;
    }

    @Override
    public Texture getGlyphTexture() {
        return this.glyphTexture;
    }

    @Override
    public boolean isSuperShaderAllowed() {
        return this.superShaderAllowed;
    }

    protected boolean canClampToZero() {
        return true;
    }

    protected boolean canClampToEdge() {
        return true;
    }

    protected boolean canRepeat() {
        return true;
    }

    @Override
    public boolean isWrapModeSupported(Texture$WrapMode texture$WrapMode) {
        switch (texture$WrapMode) {
            case CLAMP_NOT_NEEDED: {
                return true;
            }
            case CLAMP_TO_EDGE: {
                return this.canClampToEdge();
            }
            case REPEAT: {
                return this.canRepeat();
            }
            case CLAMP_TO_ZERO: {
                return this.canClampToZero();
            }
            case CLAMP_TO_EDGE_SIMULATED: 
            case CLAMP_TO_ZERO_SIMULATED: 
            case REPEAT_SIMULATED: {
                throw new InternalError("Cannot test support for simulated wrap modes");
            }
        }
        throw new InternalError("Unrecognized wrap mode: " + String.valueOf((Object)texture$WrapMode));
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    protected boolean checkDisposed() {
        if (PrismSettings.verbose && this.isDisposed()) {
            try {
                throw new IllegalStateException("attempt to use resource after factory is disposed");
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2 = runtimeException;
                runtimeException.printStackTrace();
            }
        }
        return this.isDisposed();
    }
}

