/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.font.FontStrike;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.impl.GlyphCache$GlyphData;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.packrect.RectanglePacker;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.paint.Color;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.WeakHashMap;

public class GlyphCache {
    private static final int WIDTH = PrismSettings.glyphCacheWidth;
    private static final int HEIGHT = PrismSettings.glyphCacheHeight;
    private static ByteBuffer emptyMask;
    private final BaseContext context;
    private final FontStrike strike;
    private static final int SEGSHIFT = 5;
    private static final int SEGSIZE = 32;
    private static final int SEGMASK = 31;
    HashMap<Integer, GlyphCache$GlyphData[]> glyphDataMap = new HashMap();
    private static final int SUBPIXEL_SHIFT = 27;
    private RectanglePacker packer;
    private boolean isLCDCache;
    static WeakHashMap<BaseContext, RectanglePacker> greyPackerMap;
    static WeakHashMap<BaseContext, RectanglePacker> lcdPackerMap;

    public GlyphCache(BaseContext baseContext, FontStrike object) {
        this.context = baseContext;
        this.strike = object;
        this.isLCDCache = object.getAAMode() == 1;
        object = this.isLCDCache ? lcdPackerMap : greyPackerMap;
        this.packer = (RectanglePacker)((WeakHashMap)object).get(baseContext);
        if (this.packer == null) {
            ResourceFactory resourceFactory = baseContext.getResourceFactory();
            Texture texture = resourceFactory.createMaskTexture(WIDTH, HEIGHT, Texture$WrapMode.CLAMP_NOT_NEEDED);
            texture.contentsUseful();
            texture.makePermanent();
            if (!this.isLCDCache) {
                resourceFactory.setGlyphTexture(texture);
            }
            texture.setLinearFiltering(false);
            this.packer = new RectanglePacker(texture, WIDTH, HEIGHT);
            ((WeakHashMap)object).put(baseContext, this.packer);
        }
    }

    public void render(BaseContext object, GlyphList glyphList, float f2, float f3, int n2, int n3, Color color, Color color2, BaseTransform baseTransform, BaseBounds baseBounds) {
        int n4;
        int n5;
        if (this.isLCDCache) {
            n5 = ((BaseContext)object).getLCDBuffer().getPhysicalWidth();
            n4 = ((BaseContext)object).getLCDBuffer().getPhysicalHeight();
        } else {
            n5 = 1;
            n4 = 1;
        }
        Texture texture = this.getBackingStore();
        object = ((BaseContext)object).getVertexBuffer();
        int n6 = glyphList.getGlyphCount();
        Color color3 = null;
        Point2D point2D = new Point2D();
        for (int i2 = 0; i2 < n6; ++i2) {
            int n7 = glyphList.getGlyphCode(i2);
            if ((n7 & 0xFFFFFF) == 65535) continue;
            point2D.setLocation(f2 + glyphList.getPosX(i2), f3 + glyphList.getPosY(i2));
            Point2D point2D2 = point2D;
            baseTransform.transform(point2D2, point2D2);
            int n8 = this.strike.getQuantizedPosition(point2D);
            GlyphCache$GlyphData glyphCache$GlyphData = this.getCachedGlyph(n7, n8);
            if (glyphCache$GlyphData == null) continue;
            if (baseBounds != null) {
                if (f2 + glyphList.getPosX(i2) > baseBounds.getMaxX()) break;
                if (f2 + glyphList.getPosX(i2 + 1) < baseBounds.getMinX()) continue;
            }
            if (color != null && color2 != null) {
                n8 = glyphList.getCharOffset(i2);
                if (n2 <= n8 && n8 < n3) {
                    if (color != color3) {
                        ((VertexBuffer)object).setPerVertexColor(color, 1.0f);
                        color3 = color;
                    }
                } else if (color2 != color3) {
                    ((VertexBuffer)object).setPerVertexColor(color2, 1.0f);
                    color3 = color2;
                }
            }
            this.addDataToQuad(glyphCache$GlyphData, (VertexBuffer)object, texture, point2D.x, point2D.y, n5, n4);
        }
    }

    private void addDataToQuad(GlyphCache$GlyphData glyphCache$GlyphData, VertexBuffer vertexBuffer, Texture texture, float f2, float f3, float f4, float f5) {
        f3 = Math.round(f3);
        Rectangle rectangle = glyphCache$GlyphData.getRect();
        if (rectangle == null) {
            return;
        }
        int n2 = glyphCache$GlyphData.getBlankBoundary();
        float f6 = rectangle.width - (n2 << 1);
        float f7 = rectangle.height - (n2 << 1);
        f2 = (float)glyphCache$GlyphData.getOriginX() + f2;
        float f8 = (float)glyphCache$GlyphData.getOriginY() + f3;
        f3 = f8 + f7;
        float f9 = texture.getPhysicalWidth();
        float f10 = texture.getPhysicalHeight();
        float f11 = (float)(rectangle.x + n2) / f9;
        float f12 = (float)(rectangle.y + n2) / f10;
        float f13 = f11 + f6 / f9;
        f7 = f12 + f7 / f10;
        if (this.isLCDCache) {
            f2 = (float)Math.round(f2 * 3.0f) / 3.0f;
            f10 = f2 + f6 / 3.0f;
            f6 = f2 / f4;
            f4 = f10 / f4;
            f9 = f8 / f5;
            f5 = f3 / f5;
            vertexBuffer.addQuad(f2, f8, f10, f3, f11, f12, f13, f7, f6, f9, f4, f5);
            return;
        }
        f2 = Math.round(f2);
        f10 = f2 + f6;
        if (this.context.isSuperShaderEnabled()) {
            vertexBuffer.addSuperQuad(f2, f8, f10, f3, f11, f12, f13, f7, true);
            return;
        }
        vertexBuffer.addQuad(f2, f8, f10, f3, f11, f12, f13, f7);
    }

    public Texture getBackingStore() {
        return this.packer.getBackingStore();
    }

    public void clear() {
        this.glyphDataMap.clear();
    }

    private void clearAll() {
        this.context.flushVertexBuffer();
        this.context.clearGlyphCaches();
        this.packer.clear();
    }

    private GlyphCache$GlyphData getCachedGlyph(int n2, int n3) {
        int n4 = n2 >>> 5;
        int n5 = n2 & 0x1F;
        GlyphCache$GlyphData[] glyphCache$GlyphDataArray = this.glyphDataMap.get(n4 |= n3 << 27);
        if (glyphCache$GlyphDataArray != null) {
            if (glyphCache$GlyphDataArray[n5] != null) {
                return glyphCache$GlyphDataArray[n5];
            }
        } else {
            glyphCache$GlyphDataArray = new GlyphCache$GlyphData[32];
            this.glyphDataMap.put(n4, glyphCache$GlyphDataArray);
        }
        GlyphCache$GlyphData glyphCache$GlyphData = null;
        Object object = this.strike.getGlyph(n2);
        if (object != null) {
            Object object2 = object.getPixelData(n3);
            if (object2 == null || ((byte[])object2).length == 0) {
                glyphCache$GlyphData = new GlyphCache$GlyphData(0, 0, 0, object.getPixelXAdvance(), object.getPixelYAdvance(), null);
            } else {
                MaskData maskData = MaskData.create(object2, object.getOriginX(), object.getOriginY(), object.getWidth(), object.getHeight());
                object2 = maskData;
                int n6 = maskData.getWidth() + 2;
                int n7 = object2.getHeight() + 2;
                int n8 = object2.getOriginX();
                int n9 = object2.getOriginY();
                Rectangle rectangle = new Rectangle(0, 0, n6, n7);
                glyphCache$GlyphData = new GlyphCache$GlyphData(n8, n9, 1, object.getPixelXAdvance(), object.getPixelYAdvance(), rectangle);
                if (!this.packer.add(rectangle)) {
                    if (PulseLogger.PULSE_LOGGING_ENABLED) {
                        PulseLogger.incrementCounter("Font Glyph Cache Cleared");
                    }
                    this.clearAll();
                    if (!this.packer.add(rectangle)) {
                        if (PrismSettings.verbose) {
                            System.out.println(String.valueOf(rectangle) + " won't fit in GlyphCache");
                        }
                        return null;
                    }
                }
                object = this.getBackingStore();
                n8 = rectangle.width;
                n9 = rectangle.height;
                int n10 = object.getPixelFormat().getBytesPerPixelUnit();
                n10 = n8 * n10;
                int n11 = n10 * n9;
                if (emptyMask == null || n11 > emptyMask.capacity()) {
                    emptyMask = BufferUtil.newByteBuffer(n11);
                }
                try {
                    object.update(emptyMask, object.getPixelFormat(), rectangle.x, rectangle.y, 0, 0, n8, n9, n10, true);
                }
                catch (Exception exception) {
                    if (PrismSettings.verbose) {
                        exception.printStackTrace();
                    }
                    return null;
                }
                object2.uploadToTexture((Texture)object, 1 + rectangle.x, 1 + rectangle.y, true);
            }
            glyphCache$GlyphDataArray[n5] = glyphCache$GlyphData;
        }
        return glyphCache$GlyphData;
    }

    private static void disposePackerForContext(BaseContext object, WeakHashMap<BaseContext, RectanglePacker> weakHashMap) {
        if ((object = weakHashMap.remove(object)) != null) {
            ((RectanglePacker)object).dispose();
        }
    }

    public static void disposeForContext(BaseContext baseContext) {
        GlyphCache.disposePackerForContext(baseContext, greyPackerMap);
        GlyphCache.disposePackerForContext(baseContext, lcdPackerMap);
    }

    static {
        greyPackerMap = new WeakHashMap();
        lcdPackerMap = new WeakHashMap();
    }
}

