/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.RectangularShape;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.AffineBase;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.prism.BasicStroke;
import com.sun.prism.CompositeMode;
import com.sun.prism.MaskTextureGraphics;
import com.sun.prism.MultiTexture;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ReadbackGraphics;
import com.sun.prism.ReadbackRenderTarget;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.BaseGraphics;
import com.sun.prism.impl.GlyphCache;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.impl.ps.BaseShaderContext$MaskType;
import com.sun.prism.impl.ps.PaintHelper;
import com.sun.prism.impl.shape.MaskData;
import com.sun.prism.impl.shape.ShapeUtil;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.Paint$Type;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderGraphics;
import java.security.AccessController;

public abstract class BaseShaderGraphics
extends BaseGraphics
implements MaskTextureGraphics,
ReadbackGraphics,
ShaderGraphics {
    private static Affine2D TEMP_TX2D = new Affine2D();
    private static Affine3D TEMP_TX3D = new Affine3D();
    private final BaseShaderContext context;
    private Shader externalShader;
    private boolean isComplexPaint;
    private NGLightBase[] lights = null;
    private static RectBounds TMP_BOUNDS = new RectBounds();
    private static final float FRINGE_FACTOR;
    private static final double SQRT_2;
    private boolean lcdSampleInvalid = false;

    protected BaseShaderGraphics(BaseShaderContext baseShaderContext, RenderTarget renderTarget) {
        super(baseShaderContext, renderTarget);
        this.context = baseShaderContext;
    }

    BaseShaderContext getContext() {
        return this.context;
    }

    boolean isComplexPaint() {
        return this.isComplexPaint;
    }

    @Override
    public void getPaintShaderTransform(Affine3D affine3D) {
        ((BaseTransform)affine3D).setTransform(this.getTransformNoClone());
    }

    public Shader getExternalShader() {
        return this.externalShader;
    }

    @Override
    public void setExternalShader(Shader shader) {
        this.externalShader = shader;
        this.context.setExternalShader(this, shader);
    }

    @Override
    public void setPaint(Paint paint) {
        Gradient gradient;
        this.isComplexPaint = paint.getType().isGradient() ? (gradient = (Gradient)paint).getNumStops() > 12 : false;
        super.setPaint(paint);
    }

    @Override
    public void setLights(NGLightBase[] nGLightBaseArray) {
        this.lights = nGLightBaseArray;
    }

    @Override
    public final NGLightBase[] getLights() {
        return this.lights;
    }

    @Override
    public void clearQuad(float f2, float f3, float f4, float f5) {
        this.context.setRenderTarget(this);
        this.context.flushVertexBuffer();
        CompositeMode compositeMode = this.getCompositeMode();
        this.setCompositeMode(CompositeMode.CLEAR);
        Paint paint = this.getPaint();
        ((BaseGraphics)this).setPaint(Color.BLACK);
        this.fillQuad(f2, f3, f4, f5);
        this.context.flushVertexBuffer();
        ((BaseGraphics)this).setPaint(paint);
        this.setCompositeMode(compositeMode);
    }

    @Override
    public void drawTexture(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (texture instanceof MultiTexture) {
            this.drawMultiTexture((MultiTexture)texture, f2, f3, f4, f5, f6, f7, f8, f9);
            return;
        }
        super.drawTexture(texture, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    @Override
    public void drawTexture3SliceH(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        if (!(texture instanceof MultiTexture)) {
            super.drawTexture3SliceH(texture, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13);
            return;
        }
        texture = (MultiTexture)texture;
        this.drawMultiTexture((MultiTexture)texture, f2, f3, f10, f5, f6, f7, f12, f9);
        this.drawMultiTexture((MultiTexture)texture, f10, f3, f11, f5, f12, f7, f13, f9);
        this.drawMultiTexture((MultiTexture)texture, f11, f3, f4, f5, f13, f7, f8, f9);
    }

    @Override
    public void drawTexture3SliceV(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        if (!(texture instanceof MultiTexture)) {
            super.drawTexture3SliceV(texture, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13);
            return;
        }
        texture = (MultiTexture)texture;
        this.drawMultiTexture((MultiTexture)texture, f2, f3, f4, f10, f6, f7, f8, f12);
        this.drawMultiTexture((MultiTexture)texture, f2, f10, f4, f11, f6, f12, f8, f13);
        this.drawMultiTexture((MultiTexture)texture, f2, f11, f4, f5, f6, f13, f8, f9);
    }

    @Override
    public void drawTexture9Slice(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17) {
        if (!(texture instanceof MultiTexture)) {
            super.drawTexture9Slice(texture, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17);
            return;
        }
        texture = (MultiTexture)texture;
        this.drawMultiTexture((MultiTexture)texture, f2, f3, f10, f11, f6, f7, f14, f15);
        this.drawMultiTexture((MultiTexture)texture, f10, f3, f12, f11, f14, f7, f16, f15);
        this.drawMultiTexture((MultiTexture)texture, f12, f3, f4, f11, f16, f7, f8, f15);
        this.drawMultiTexture((MultiTexture)texture, f2, f11, f10, f13, f6, f15, f14, f17);
        this.drawMultiTexture((MultiTexture)texture, f10, f11, f12, f13, f14, f15, f16, f17);
        this.drawMultiTexture((MultiTexture)texture, f12, f11, f4, f13, f16, f15, f8, f17);
        this.drawMultiTexture((MultiTexture)texture, f2, f13, f10, f5, f6, f17, f14, f9);
        this.drawMultiTexture((MultiTexture)texture, f10, f13, f12, f5, f14, f17, f16, f9);
        this.drawMultiTexture((MultiTexture)texture, f12, f13, f4, f5, f16, f17, f8, f9);
    }

    private static float calculateScaleFactor(float f2, float f3) {
        if (f2 == f3) {
            return 1.0f;
        }
        return (f2 - 1.0f) / f3;
    }

    protected void drawMultiTexture(MultiTexture multiTexture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        Texture[] textureArray;
        Object object = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            object = IDENT;
            f2 += this.transX;
            f3 += this.transY;
            f4 += this.transX;
            f5 += this.transY;
        }
        if ((object = this.context.validateTextureOp(this, (BaseTransform)object, textureArray = multiTexture.getTextures(), multiTexture.getPixelFormat())) == null) {
            return;
        }
        if (multiTexture.getPixelFormat() == PixelFormat.MULTI_YCbCr_420) {
            float f10;
            float f11;
            Texture texture = textureArray[0];
            Texture texture2 = textureArray[2];
            Texture texture3 = textureArray[1];
            float f12 = multiTexture.getContentWidth();
            float f13 = multiTexture.getContentHeight();
            float f14 = BaseShaderGraphics.calculateScaleFactor(f12, texture.getPhysicalWidth());
            float f15 = BaseShaderGraphics.calculateScaleFactor(f13, texture.getPhysicalHeight());
            if (textureArray.length > 3) {
                Texture texture4 = textureArray[3];
                f11 = BaseShaderGraphics.calculateScaleFactor(f12, texture4.getPhysicalWidth());
                f10 = BaseShaderGraphics.calculateScaleFactor(f13, texture4.getPhysicalHeight());
            } else {
                f10 = 0.0f;
                f11 = 0.0f;
            }
            float f16 = (float)Math.floor((double)f12 / 2.0);
            float f17 = (float)Math.floor((double)f13 / 2.0);
            float f18 = BaseShaderGraphics.calculateScaleFactor(f16, texture2.getPhysicalWidth());
            float f19 = BaseShaderGraphics.calculateScaleFactor(f17, texture2.getPhysicalHeight());
            f16 = BaseShaderGraphics.calculateScaleFactor(f16, texture3.getPhysicalWidth());
            float f20 = BaseShaderGraphics.calculateScaleFactor(f17, texture3.getPhysicalHeight());
            object.setConstant("lumaAlphaScale", f14, f15, f11, f10);
            object.setConstant("cbCrScale", f18, f19, f16, f20);
            f7 /= f13;
            f13 = f9 / f13;
            VertexBuffer vertexBuffer = this.context.getVertexBuffer();
            vertexBuffer.addQuad(f2, f3, f4, f5, f6 /= f12, f7, f8 /= f12, f13);
            return;
        }
        throw new UnsupportedOperationException("Unsupported multitexture format " + String.valueOf((Object)multiTexture.getPixelFormat()));
    }

    @Override
    public void drawTextureRaw2(Texture object, Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        BaseTransform baseTransform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            baseTransform = IDENT;
            f2 += this.transX;
            f3 += this.transY;
            f4 += this.transX;
            f5 += this.transY;
        }
        this.context.validateTextureOp(this, baseTransform, (Texture)object, texture, PixelFormat.INT_ARGB_PRE);
        object = this.context.getVertexBuffer();
        ((VertexBuffer)object).addQuad(f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13);
    }

    @Override
    public void drawMappedTextureRaw2(Texture object, Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21) {
        BaseTransform baseTransform = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            baseTransform = IDENT;
            f2 += this.transX;
            f3 += this.transY;
            f4 += this.transX;
            f5 += this.transY;
        }
        this.context.validateTextureOp(this, baseTransform, (Texture)object, texture, PixelFormat.INT_ARGB_PRE);
        object = this.context.getVertexBuffer();
        ((VertexBuffer)object).addMappedQuad(f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, f21);
    }

    @Override
    public void drawPixelsMasked(RTTexture object, RTTexture rTTexture, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        float f2 = object.getPhysicalWidth();
        float f3 = object.getPhysicalHeight();
        float f4 = rTTexture.getPhysicalWidth();
        float f5 = rTTexture.getPhysicalHeight();
        float f6 = n2;
        float f7 = n3;
        float f8 = n2 + n4;
        float f9 = n3 + n5;
        float f10 = (float)n6 / f2;
        float f11 = (float)n7 / f3;
        float f12 = (float)(n6 + n4) / f2;
        float f13 = (float)(n7 + n5) / f3;
        f2 = (float)n8 / f4;
        f3 = (float)n9 / f5;
        float f14 = (float)(n8 + n4) / f4;
        float f15 = (float)(n9 + n5) / f5;
        this.context.validateMaskTextureOp(this, IDENT, (Texture)object, rTTexture, PixelFormat.INT_ARGB_PRE);
        object = this.context.getVertexBuffer();
        ((VertexBuffer)object).addQuad(f6, f7, f8, f9, f10, f11, f12, f13, f2, f3, f14, f15);
    }

    @Override
    public void maskInterpolatePixels(RTTexture rTTexture, RTTexture rTTexture2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        float f2 = rTTexture.getPhysicalWidth();
        float f3 = rTTexture.getPhysicalHeight();
        float f4 = rTTexture2.getPhysicalWidth();
        float f5 = rTTexture2.getPhysicalHeight();
        float f6 = n2;
        float f7 = n3;
        float f8 = n2 + n4;
        float f9 = n3 + n5;
        float f10 = (float)n6 / f2;
        float f11 = (float)n7 / f3;
        float f12 = (float)(n6 + n4) / f2;
        float f13 = (float)(n7 + n5) / f3;
        f2 = (float)n8 / f4;
        f3 = (float)n9 / f5;
        float f14 = (float)(n8 + n4) / f4;
        float f15 = (float)(n9 + n5) / f5;
        CompositeMode compositeMode = this.getCompositeMode();
        this.setCompositeMode(CompositeMode.DST_OUT);
        ((BaseContext)this.context).validateTextureOp(this, IDENT, rTTexture2, PixelFormat.INT_ARGB_PRE);
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        vertexBuffer.addQuad(f6, f7, f8, f9, f2, f3, f14, f15);
        this.setCompositeMode(CompositeMode.ADD);
        this.context.validateMaskTextureOp(this, IDENT, rTTexture, rTTexture2, PixelFormat.INT_ARGB_PRE);
        vertexBuffer.addQuad(f6, f7, f8, f9, f10, f11, f12, f13, f2, f3, f14, f15);
        this.setCompositeMode(compositeMode);
    }

    private void renderWithComplexPaint(Shape object, BasicStroke basicStroke, float f2, float f3, float f4, float f5) {
        this.context.flushVertexBuffer();
        BaseTransform baseTransform = this.getTransformNoClone();
        object = ShapeUtil.rasterizeShape((Shape)object, basicStroke, this.getFinalClipNoClone(), baseTransform, true, this.isAntialiasedShape());
        int n2 = ((MaskData)object).getWidth();
        int n3 = ((MaskData)object).getHeight();
        float f6 = ((MaskData)object).getOriginX();
        float f7 = ((MaskData)object).getOriginY();
        float f8 = f6 + (float)n2;
        float f9 = f7 + (float)n3;
        Gradient gradient = (Gradient)this.paint;
        TEMP_TX2D.setToTranslation(-f6, -f7);
        TEMP_TX2D.concatenate(baseTransform);
        object = this.context.getGradientTexture(gradient, TEMP_TX2D, n2, n3, (MaskData)object, f2, f3, f4, f5);
        float f10 = 0.0f + (float)n2 / (float)object.getPhysicalWidth();
        f2 = 0.0f + (float)n3 / (float)object.getPhysicalHeight();
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        this.context.validateTextureOp(this, IDENT, (Texture)object, null, object.getPixelFormat());
        vertexBuffer.addQuad(f6, f7, f8, f9, 0.0f, 0.0f, f10, f2);
        object.unlock();
    }

    @Override
    protected void renderShape(Shape object, BasicStroke object2, float f2, float f3, float f4, float f5) {
        AffineBase affineBase;
        if (this.isComplexPaint) {
            this.renderWithComplexPaint((Shape)object, (BasicStroke)object2, f2, f3, f4, f5);
            return;
        }
        BaseTransform baseTransform = this.getTransformNoClone();
        object = ShapeUtil.rasterizeShape((Shape)object, (BasicStroke)object2, this.getFinalClipNoClone(), baseTransform, true, this.isAntialiasedShape());
        object2 = this.context.validateMaskTexture((MaskData)object, false);
        if (PrismSettings.primTextureSize != 0) {
            Shader shader = this.context.validatePaintOp(this, IDENT, BaseShaderContext$MaskType.ALPHA_TEXTURE, (Texture)object2, f2, f3, f4, f5);
            affineBase = this.getPaintTextureTx(baseTransform, shader, f2, f3, f4, f5);
        } else {
            this.context.validatePaintOp(this, IDENT, (Texture)object2, f2, f3, f4, f5);
            affineBase = null;
        }
        this.context.updateMaskTexture((MaskData)object, TMP_BOUNDS, false);
        float f6 = ((MaskData)object).getOriginX();
        f3 = ((MaskData)object).getOriginY();
        f4 = f6 + (float)((MaskData)object).getWidth();
        float f7 = f3 + (float)((MaskData)object).getHeight();
        f5 = ((BaseBounds)TMP_BOUNDS).getMinX();
        float f8 = ((BaseBounds)TMP_BOUNDS).getMinY();
        float f9 = ((BaseBounds)TMP_BOUNDS).getMaxX();
        float f10 = ((BaseBounds)TMP_BOUNDS).getMaxY();
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        vertexBuffer.addQuad(f6, f3, f4, f7, f5, f8, f9, f10, affineBase);
        object2.unlock();
    }

    private static float getStrokeExpansionFactor(BasicStroke basicStroke) {
        if (basicStroke.getType() == 2) {
            return 1.0f;
        }
        if (basicStroke.getType() == 0) {
            return 0.5f;
        }
        return 0.0f;
    }

    private BaseTransform extract3Dremainder(BaseTransform baseTransform) {
        if (baseTransform.is2D()) {
            return IDENT;
        }
        ((BaseTransform)TEMP_TX3D).setTransform(baseTransform);
        TEMP_TX2D.setTransform(baseTransform.getMxx(), baseTransform.getMyx(), baseTransform.getMxy(), baseTransform.getMyy(), baseTransform.getMxt(), baseTransform.getMyt());
        try {
            ((BaseTransform)TEMP_TX2D).invert();
            ((AffineBase)TEMP_TX3D).concatenate(TEMP_TX2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {}
        return TEMP_TX3D;
    }

    private void renderGeneralRoundedRect(float f2, float f3, float f4, float f5, float f6, float f7, BaseShaderContext$MaskType baseShaderContext$MaskType, BasicStroke basicStroke) {
        BaseTransform baseTransform;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        if (basicStroke == null) {
            f14 = f2;
            f13 = f3;
            f12 = f4;
            f11 = f5;
            f10 = 0.0f;
            f9 = 0.0f;
        } else {
            float f15 = basicStroke.getLineWidth();
            float f16 = BaseShaderGraphics.getStrokeExpansionFactor(basicStroke) * f15;
            f14 = f2 - f16;
            f13 = f3 - f16;
            f12 = f4 + (f16 *= 2.0f);
            f11 = f5 + f16;
            if (f6 > 0.0f && f7 > 0.0f) {
                f6 += f16;
                f7 += f16;
            } else if (basicStroke.getLineJoin() == 1) {
                f6 = f7 = f16;
                baseShaderContext$MaskType = BaseShaderContext$MaskType.DRAW_ROUNDRECT;
            } else {
                f7 = 0.0f;
                f6 = 0.0f;
            }
            f9 = (f12 - f15 * 2.0f) / f12;
            f10 = (f11 - f15 * 2.0f) / f11;
            if (f9 <= 0.0f || f10 <= 0.0f) {
                baseShaderContext$MaskType = baseShaderContext$MaskType.getFillType();
            }
        }
        BaseTransform baseTransform2 = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            var18_19 = 1.0f;
            var15_20 = 1.0f;
            var17_21 = 0.0f;
            var16_22 = 0.0f;
            f8 = f14 + this.transX;
            f14 = f13 + this.transY;
            baseTransform = IDENT;
        } else {
            baseTransform = this.extract3Dremainder(baseTransform2);
            var15_20 = (float)baseTransform2.getMxx();
            var17_21 = (float)baseTransform2.getMxy();
            var16_22 = (float)baseTransform2.getMyx();
            var18_19 = (float)baseTransform2.getMyy();
            f8 = f14 * var15_20 + f13 * var17_21 + (float)baseTransform2.getMxt();
            f14 = f14 * var16_22 + f13 * var18_19 + (float)baseTransform2.getMyt();
        }
        this.renderGeneralRoundedPgram(f8, f14, var15_20 *= f12, var16_22 *= f12, var17_21 *= f11, var18_19 *= f11, f6 /= f12, f7 /= f11, f9, f10, baseTransform, baseShaderContext$MaskType, f2, f3, f4, f5);
    }

    private void renderGeneralRoundedPgram(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, BaseTransform baseTransform, BaseShaderContext$MaskType baseShaderContext$MaskType, float f12, float f13, float f14, float f15) {
        float f16 = BaseShaderGraphics.len(f4, f5);
        float f17 = BaseShaderGraphics.len(f6, f7);
        if (f16 == 0.0f || f17 == 0.0f) {
            return;
        }
        float f18 = f2;
        float f19 = f3;
        float f20 = f2 + f4;
        float f21 = f3 + f5;
        f2 += f6;
        f3 += f7;
        float f22 = f20 + f6;
        float f23 = f21 + f7;
        float f24 = (f4 * f7 - f5 * f6) * 0.5f;
        float f25 = f24 / f17;
        f24 /= f16;
        if (f25 < 0.0f) {
            f25 = -f25;
        }
        if (f24 < 0.0f) {
            f24 = -f24;
        }
        float f26 = f4 / f16;
        f16 = f5 / f16;
        float f27 = f6 / f17;
        f17 = f7 / f17;
        float f28 = -f6 * (f26 + f27) - f7 * (f16 + f17);
        float f29 = f7 * f4 - f6 * f5;
        float f30 = FRINGE_FACTOR * Math.signum(f28 /= f29);
        float f31 = (f28 * f4 + f16) * f30;
        f28 = (f28 * f5 - f26) * f30;
        f18 += f31;
        f19 += f28;
        f22 -= f31;
        f23 -= f28;
        f28 = f5 * (f17 - f16) - f4 * (f26 - f27);
        f30 = FRINGE_FACTOR * Math.signum(f28 /= f29);
        f31 = (f28 * f6 + f17) * f30;
        f28 = (f28 * f7 - f27) * f30;
        f20 += f31;
        f21 += f28;
        f2 -= f31;
        f3 -= f28;
        f4 = (f18 + f22) * 0.5f;
        f5 = (f19 + f23) * 0.5f;
        f6 = f4 * f17 - f5 * f27;
        f4 = f4 * f16 - f5 * f26;
        f5 = f18 * f17 - f19 * f27 - f6;
        f7 = f18 * f16 - f19 * f26 - f4;
        f28 = f20 * f17 - f21 * f27 - f6;
        f29 = f20 * f16 - f21 * f26 - f4;
        f30 = f2 * f17 - f3 * f27 - f6;
        f31 = f2 * f16 - f3 * f26 - f4;
        f6 = f22 * f17 - f23 * f27 - f6;
        f4 = f22 * f16 - f23 * f26 - f4;
        if (baseShaderContext$MaskType == BaseShaderContext$MaskType.DRAW_ROUNDRECT || baseShaderContext$MaskType == BaseShaderContext$MaskType.FILL_ROUNDRECT) {
            f8 = f25 * f8;
            f9 = f24 * f9;
            if ((double)f8 < 0.5 || (double)f9 < 0.5) {
                baseShaderContext$MaskType = baseShaderContext$MaskType == BaseShaderContext$MaskType.DRAW_ROUNDRECT ? BaseShaderContext$MaskType.DRAW_PGRAM : BaseShaderContext$MaskType.FILL_PGRAM;
            } else {
                f16 = f25 - f8;
                f17 = f24 - f9;
                if (baseShaderContext$MaskType == BaseShaderContext$MaskType.DRAW_ROUNDRECT) {
                    f26 = f25 * f10;
                    f27 = f24 * f11;
                    f24 = f26 - f16;
                    f25 = f27 - f17;
                    if (f24 < 0.5f || f25 < 0.5f) {
                        f24 = f26;
                        f25 = f27;
                        baseShaderContext$MaskType = BaseShaderContext$MaskType.DRAW_SEMIROUNDRECT;
                    } else {
                        f24 = 1.0f / f24;
                        f25 = 1.0f / f25;
                    }
                } else {
                    f25 = 0.0f;
                    f24 = 0.0f;
                }
                f8 = 1.0f / f8;
                f9 = 1.0f / f9;
                Shader shader = this.context.validatePaintOp(this, baseTransform, baseShaderContext$MaskType, f12, f13, f14, f15, f8, f9, f24, f25, 0.0f, 0.0f);
                shader.setConstant("oinvarcradii", f8, f9);
                if (baseShaderContext$MaskType == BaseShaderContext$MaskType.DRAW_ROUNDRECT) {
                    shader.setConstant("iinvarcradii", f24, f25);
                } else if (baseShaderContext$MaskType == BaseShaderContext$MaskType.DRAW_SEMIROUNDRECT) {
                    shader.setConstant("idim", f24, f25);
                }
                f25 = f16;
                f24 = f17;
            }
        }
        if (baseShaderContext$MaskType == BaseShaderContext$MaskType.DRAW_PGRAM || baseShaderContext$MaskType == BaseShaderContext$MaskType.DRAW_ELLIPSE) {
            f8 = f25 * f10;
            f9 = f24 * f11;
            if (baseShaderContext$MaskType == BaseShaderContext$MaskType.DRAW_ELLIPSE) {
                if ((double)Math.abs(f25 - f24) < 0.01) {
                    baseShaderContext$MaskType = BaseShaderContext$MaskType.DRAW_CIRCLE;
                    float f32 = f24;
                    f24 = (float)Math.min(1.0, (double)(f32 * f32) * Math.PI);
                    float f33 = f9;
                    f9 = (float)Math.min(1.0, (double)(f33 * f33) * Math.PI);
                } else {
                    f25 = 1.0f / f25;
                    f24 = 1.0f / f24;
                    f8 = 1.0f / f8;
                    f9 = 1.0f / f9;
                }
            }
            Shader shader = this.context.validatePaintOp(this, baseTransform, baseShaderContext$MaskType, f12, f13, f14, f15, f8, f9, 0.0f, 0.0f, 0.0f, 0.0f);
            shader.setConstant("idim", f8, f9);
        } else if (baseShaderContext$MaskType == BaseShaderContext$MaskType.FILL_ELLIPSE) {
            if ((double)Math.abs(f25 - f24) < 0.01) {
                baseShaderContext$MaskType = BaseShaderContext$MaskType.FILL_CIRCLE;
                float f34 = f24;
                f24 = (float)Math.min(1.0, (double)(f34 * f34) * Math.PI);
            } else {
                f25 = 1.0f / f25;
                f24 = 1.0f / f24;
                f5 *= f25;
                f7 *= f24;
                f28 *= f25;
                f29 *= f24;
                f30 *= f25;
                f31 *= f24;
                f6 *= f25;
                f4 *= f24;
            }
            this.context.validatePaintOp(this, baseTransform, baseShaderContext$MaskType, f12, f13, f14, f15);
        } else if (baseShaderContext$MaskType == BaseShaderContext$MaskType.FILL_PGRAM) {
            this.context.validatePaintOp(this, baseTransform, baseShaderContext$MaskType, f12, f13, f14, f15);
        }
        this.context.getVertexBuffer().addMappedPgram(f18, f19, f20, f21, f2, f3, f22, f23, f5, f7, f28, f29, f30, f31, f6, f4, f25, f24);
    }

    AffineBase getPaintTextureTx(BaseTransform baseTransform, Shader shader, float f2, float f3, float f4, float f5) {
        switch (this.paint.getType()) {
            case COLOR: {
                return null;
            }
            case LINEAR_GRADIENT: {
                return PaintHelper.getLinearGradientTx((LinearGradient)this.paint, shader, baseTransform, f2, f3, f4, f5);
            }
            case RADIAL_GRADIENT: {
                return PaintHelper.getRadialGradientTx((RadialGradient)this.paint, shader, baseTransform, f2, f3, f4, f5);
            }
            case IMAGE_PATTERN: {
                BaseShaderGraphics baseShaderGraphics = this;
                return PaintHelper.getImagePatternTx(baseShaderGraphics, (ImagePattern)baseShaderGraphics.paint, shader, baseTransform, f2, f3, f4, f5);
            }
        }
        throw new InternalError("Unrecogized paint type: " + String.valueOf(this.paint));
    }

    boolean fillPrimRect(float f2, float f3, float f4, float f5, Texture texture, Texture texture2, float f6, float f7, float f8, float f9) {
        BaseTransform baseTransform = this.getTransformNoClone();
        float f10 = (float)baseTransform.getMxx();
        float f11 = (float)baseTransform.getMxy();
        float f12 = (float)baseTransform.getMxt();
        float f13 = (float)baseTransform.getMyx();
        float f14 = (float)baseTransform.getMyy();
        float f15 = (float)baseTransform.getMyt();
        float f16 = BaseShaderGraphics.len(f10, f13);
        float f17 = BaseShaderGraphics.len(f11, f14);
        if (f16 == 0.0f || f17 == 0.0f) {
            return true;
        }
        float f18 = 1.0f / f16;
        float f19 = 1.0f / f17;
        float f20 = f2 - f18 * 0.5f;
        float f21 = f3 - f19 * 0.5f;
        f18 = f2 + f4 + f18 * 0.5f;
        f19 = f3 + f5 + f19 * 0.5f;
        int n2 = (int)Math.ceil(f4 * f16 - 0.001953125f);
        int n3 = (int)Math.ceil(f5 * f17 - 0.001953125f);
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        int n4 = this.context.getRectTextureMaxSize();
        if (n2 <= n4 && n3 <= n4) {
            int n5 = n2;
            float f22 = (float)(n5 * (n5 + 1) / 2) - 0.5f;
            int n6 = n3;
            float f23 = (float)(n6 * (n6 + 1) / 2) - 0.5f;
            float f24 = f22 + (float)n2 + 1.0f;
            float f25 = f23 + (float)n3 + 1.0f;
            f22 /= (float)texture.getPhysicalWidth();
            f23 /= (float)texture.getPhysicalHeight();
            f24 /= (float)texture.getPhysicalWidth();
            f25 /= (float)texture.getPhysicalHeight();
            if (baseTransform.isTranslateOrIdentity()) {
                f20 += f12;
                f21 += f15;
                f18 += f12;
                f19 += f15;
                baseTransform = IDENT;
            } else {
                if (baseTransform.is2D()) {
                    Shader shader = this.context.validatePaintOp(this, IDENT, BaseShaderContext$MaskType.ALPHA_TEXTURE, texture, f6, f7, f8, f9);
                    AffineBase affineBase = this.getPaintTextureTx(IDENT, shader, f6, f7, f8, f9);
                    if (affineBase == null) {
                        vertexBuffer.addMappedPgram(f20 * f10 + f21 * f11 + f12, f20 * f13 + f21 * f14 + f15, f18 * f10 + f21 * f11 + f12, f18 * f13 + f21 * f14 + f15, f20 * f10 + f19 * f11 + f12, f20 * f13 + f19 * f14 + f15, f18 * f10 + f19 * f11 + f12, f18 * f13 + f19 * f14 + f15, f22, f23, f24, f23, f22, f25, f24, f25, 0.0f, 0.0f);
                    } else {
                        vertexBuffer.addMappedPgram(f20 * f10 + f21 * f11 + f12, f20 * f13 + f21 * f14 + f15, f18 * f10 + f21 * f11 + f12, f18 * f13 + f21 * f14 + f15, f20 * f10 + f19 * f11 + f12, f20 * f13 + f19 * f14 + f15, f18 * f10 + f19 * f11 + f12, f18 * f13 + f19 * f14 + f15, f22, f23, f24, f23, f22, f25, f24, f25, f20, f21, f18, f19, affineBase);
                    }
                    return true;
                }
                System.out.println("Not a 2d transform!");
                f15 = 0.0f;
                f12 = 0.0f;
            }
            Shader shader = this.context.validatePaintOp(this, baseTransform, BaseShaderContext$MaskType.ALPHA_TEXTURE, texture, f6, f7, f8, f9);
            AffineBase affineBase = this.getPaintTextureTx(IDENT, shader, f6, f7, f8, f9);
            if (affineBase == null) {
                vertexBuffer.addQuad(f20, f21, f18, f19, f22, f23, f24, f25);
            } else {
                affineBase.translate(-f12, -f15);
                vertexBuffer.addQuad(f20, f21, f18, f19, f22, f23, f24, f25, affineBase);
            }
            return true;
        }
        if (texture2 == null) {
            return false;
        }
        float f26 = 0.5f / (float)texture2.getPhysicalWidth();
        float f27 = 0.5f / (float)texture2.getPhysicalHeight();
        float f28 = ((float)n2 * 0.5f + 1.0f) / (float)texture2.getPhysicalWidth();
        float f29 = ((float)n3 * 0.5f + 1.0f) / (float)texture2.getPhysicalHeight();
        f2 += f4 * 0.5f;
        f3 += f5 * 0.5f;
        if (baseTransform.isTranslateOrIdentity()) {
            f20 += f12;
            f21 += f15;
            f2 += f12;
            f3 += f15;
            f18 += f12;
            f19 += f15;
            baseTransform = IDENT;
        } else {
            if (baseTransform.is2D()) {
                Object object = this.context.validatePaintOp(this, IDENT, BaseShaderContext$MaskType.ALPHA_TEXTURE, texture2, f6, f7, f8, f9);
                object = this.getPaintTextureTx(IDENT, (Shader)object, f6, f7, f8, f9);
                f5 = f10 * f20;
                float f30 = f13 * f20;
                float f31 = f11 * f21;
                f6 = f14 * f21;
                f7 = f10 * f2;
                f8 = f13 * f2;
                f9 = f11 * f3;
                float f32 = f14 * f3;
                float f33 = f10 * f18;
                float f34 = f13 * f18;
                float f35 = f11 * f19;
                float f36 = f14 * f19;
                float f37 = f7 + f9 + f12;
                float f38 = f8 + f32 + f15;
                f31 = f7 + f31 + f12;
                f6 = f8 + f6 + f15;
                f5 = f5 + f9 + f12;
                f30 = f30 + f32 + f15;
                f7 = f7 + f35 + f12;
                f8 = f8 + f36 + f15;
                f9 = f33 + f9 + f12;
                f32 = f34 + f32 + f15;
                if (object == null) {
                    vertexBuffer.addMappedPgram(f20 * f10 + f21 * f11 + f12, f20 * f13 + f21 * f14 + f15, f31, f6, f5, f30, f37, f38, f26, f27, f28, f27, f26, f29, f28, f29, 0.0f, 0.0f);
                    vertexBuffer.addMappedPgram(f18 * f10 + f21 * f11 + f12, f18 * f13 + f21 * f14 + f15, f31, f6, f9, f32, f37, f38, f26, f27, f28, f27, f26, f29, f28, f29, 0.0f, 0.0f);
                    vertexBuffer.addMappedPgram(f20 * f10 + f19 * f11 + f12, f20 * f13 + f19 * f14 + f15, f7, f8, f5, f30, f37, f38, f26, f27, f28, f27, f26, f29, f28, f29, 0.0f, 0.0f);
                    vertexBuffer.addMappedPgram(f18 * f10 + f19 * f11 + f12, f18 * f13 + f19 * f14 + f15, f7, f8, f9, f32, f37, f38, f26, f27, f28, f27, f26, f29, f28, f29, 0.0f, 0.0f);
                } else {
                    vertexBuffer.addMappedPgram(f20 * f10 + f21 * f11 + f12, f20 * f13 + f21 * f14 + f15, f31, f6, f5, f30, f37, f38, f26, f27, f28, f27, f26, f29, f28, f29, f20, f21, f2, f3, (AffineBase)object);
                    vertexBuffer.addMappedPgram(f18 * f10 + f21 * f11 + f12, f18 * f13 + f21 * f14 + f15, f31, f6, f9, f32, f37, f38, f26, f27, f28, f27, f26, f29, f28, f29, f18, f21, f2, f3, (AffineBase)object);
                    vertexBuffer.addMappedPgram(f20 * f10 + f19 * f11 + f12, f20 * f13 + f19 * f14 + f15, f7, f8, f5, f30, f37, f38, f26, f27, f28, f27, f26, f29, f28, f29, f20, f19, f2, f3, (AffineBase)object);
                    vertexBuffer.addMappedPgram(f18 * f10 + f19 * f11 + f12, f18 * f13 + f19 * f14 + f15, f7, f8, f9, f32, f37, f38, f26, f27, f28, f27, f26, f29, f28, f29, f18, f19, f2, f3, (AffineBase)object);
                }
                return true;
            }
            System.out.println("Not a 2d transform!");
            f15 = 0.0f;
            f12 = 0.0f;
        }
        Object object = this.context.validatePaintOp(this, baseTransform, BaseShaderContext$MaskType.ALPHA_TEXTURE, texture2, f6, f7, f8, f9);
        object = this.getPaintTextureTx(IDENT, (Shader)object, f6, f7, f8, f9);
        if (object != null) {
            ((AffineBase)object).translate(-f12, -f15);
        }
        vertexBuffer.addQuad(f20, f21, f2, f3, f26, f27, f28, f29, (AffineBase)object);
        vertexBuffer.addQuad(f18, f21, f2, f3, f26, f27, f28, f29, (AffineBase)object);
        vertexBuffer.addQuad(f20, f19, f2, f3, f26, f27, f28, f29, (AffineBase)object);
        vertexBuffer.addQuad(f18, f19, f2, f3, f26, f27, f28, f29, (AffineBase)object);
        return true;
    }

    boolean drawPrimRect(float f2, float f3, float f4, float f5) {
        float f6 = this.stroke.getLineWidth();
        float f7 = BaseShaderGraphics.getStrokeExpansionFactor(this.stroke) * f6;
        Object object = this.getTransformNoClone();
        float f8 = (float)((BaseTransform)object).getMxx();
        float f9 = (float)((BaseTransform)object).getMxy();
        float f10 = (float)((BaseTransform)object).getMxt();
        float f11 = (float)((BaseTransform)object).getMyx();
        float f12 = (float)((BaseTransform)object).getMyy();
        float f13 = (float)((BaseTransform)object).getMyt();
        float f14 = BaseShaderGraphics.len(f8, f11);
        float f15 = BaseShaderGraphics.len(f9, f12);
        if (f14 == 0.0f || f15 == 0.0f) {
            return true;
        }
        float f16 = 1.0f / f14;
        float f17 = 1.0f / f15;
        float f18 = f2 - f7 - f16 * 0.5f;
        float f19 = f3 - f7 - f17 * 0.5f;
        float f20 = f2 + f4 * 0.5f;
        float f21 = f3 + f5 * 0.5f;
        f16 = f2 + f4 + f7 + f16 * 0.5f;
        f17 = f3 + f5 + f7 + f17 * 0.5f;
        Texture texture = this.context.getWrapRectTexture();
        float f22 = 1.0f / (float)texture.getPhysicalWidth();
        float f23 = 1.0f / (float)texture.getPhysicalHeight();
        float f24 = 0.5f * f22;
        float f25 = 0.5f * f23;
        float f26 = ((f4 * 0.5f + f7) * f14 + 1.0f) * f22;
        f7 = ((f5 * 0.5f + f7) * f15 + 1.0f) * f23;
        f14 = f6 * f14 * f22;
        f6 = f6 * f15 * f23;
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        if (((BaseTransform)object).isTranslateOrIdentity()) {
            f18 += f10;
            f19 += f13;
            f20 += f10;
            f21 += f13;
            f16 += f10;
            f17 += f13;
            object = IDENT;
        } else {
            if (((BaseTransform)object).is2D()) {
                object = this.context.validatePaintOp(this, IDENT, BaseShaderContext$MaskType.ALPHA_TEXTURE_DIFF, texture, f2, f3, f4, f5, f14, f6, 0.0f, 0.0f, 0.0f, 0.0f);
                object.setConstant("innerOffset", f14, f6);
                AffineBase affineBase = this.getPaintTextureTx(IDENT, (Shader)object, f2, f3, f4, f5);
                f3 = f8 * f18;
                f4 = f11 * f18;
                f5 = f9 * f19;
                f6 = f12 * f19;
                float f27 = f8 * f20;
                f14 = f11 * f20;
                f22 = f9 * f21;
                f23 = f12 * f21;
                f8 *= f16;
                f11 *= f16;
                f9 *= f17;
                f12 *= f17;
                float f28 = f27 + f22 + f10;
                float f29 = f14 + f23 + f13;
                float f30 = f27 + f5 + f10;
                float f31 = f14 + f6 + f13;
                float f32 = f3 + f22 + f10;
                float f33 = f4 + f23 + f13;
                f27 = f27 + f9 + f10;
                f14 = f14 + f12 + f13;
                f22 = f8 + f22 + f10;
                f23 = f11 + f23 + f13;
                if (affineBase == null) {
                    vertexBuffer.addMappedPgram(f3 + f5 + f10, f4 + f6 + f13, f30, f31, f32, f33, f28, f29, f24, f25, f26, f25, f24, f7, f26, f7, 0.0f, 0.0f);
                    vertexBuffer.addMappedPgram(f8 + f5 + f10, f11 + f6 + f13, f30, f31, f22, f23, f28, f29, f24, f25, f26, f25, f24, f7, f26, f7, 0.0f, 0.0f);
                    vertexBuffer.addMappedPgram(f3 + f9 + f10, f4 + f12 + f13, f27, f14, f32, f33, f28, f29, f24, f25, f26, f25, f24, f7, f26, f7, 0.0f, 0.0f);
                    vertexBuffer.addMappedPgram(f8 + f9 + f10, f11 + f12 + f13, f27, f14, f22, f23, f28, f29, f24, f25, f26, f25, f24, f7, f26, f7, 0.0f, 0.0f);
                } else {
                    vertexBuffer.addMappedPgram(f3 + f5 + f10, f4 + f6 + f13, f30, f31, f32, f33, f28, f29, f24, f25, f26, f25, f24, f7, f26, f7, f18, f19, f20, f21, affineBase);
                    vertexBuffer.addMappedPgram(f8 + f5 + f10, f11 + f6 + f13, f30, f31, f22, f23, f28, f29, f24, f25, f26, f25, f24, f7, f26, f7, f16, f19, f20, f21, affineBase);
                    vertexBuffer.addMappedPgram(f3 + f9 + f10, f4 + f12 + f13, f27, f14, f32, f33, f28, f29, f24, f25, f26, f25, f24, f7, f26, f7, f18, f17, f20, f21, affineBase);
                    vertexBuffer.addMappedPgram(f8 + f9 + f10, f11 + f12 + f13, f27, f14, f22, f23, f28, f29, f24, f25, f26, f25, f24, f7, f26, f7, f16, f17, f20, f21, affineBase);
                }
                texture.unlock();
                return true;
            }
            System.out.println("Not a 2d transform!");
            f13 = 0.0f;
            f10 = 0.0f;
        }
        object = this.context.validatePaintOp(this, (BaseTransform)object, BaseShaderContext$MaskType.ALPHA_TEXTURE_DIFF, texture, f2, f3, f4, f5, f14, f6, 0.0f, 0.0f, 0.0f, 0.0f);
        object.setConstant("innerOffset", f14, f6);
        AffineBase affineBase = this.getPaintTextureTx(IDENT, (Shader)object, f2, f3, f4, f5);
        if (affineBase != null) {
            affineBase.translate(-f10, -f13);
        }
        vertexBuffer.addQuad(f18, f19, f20, f21, f24, f25, f26, f7, affineBase);
        vertexBuffer.addQuad(f16, f19, f20, f21, f24, f25, f26, f7, affineBase);
        vertexBuffer.addQuad(f18, f17, f20, f21, f24, f25, f26, f7, affineBase);
        vertexBuffer.addQuad(f16, f17, f20, f21, f24, f25, f26, f7, affineBase);
        texture.unlock();
        return true;
    }

    boolean drawPrimDiagonal(float f2, float f3, float f4, float f5, float f6, int n2, float f7, float f8, float f9, float f10) {
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        int n3;
        int n4;
        float f16;
        if (this.stroke.getType() == 0) {
            f6 *= 0.5f;
        }
        float f17 = f4 - f2;
        float f18 = f5 - f3;
        float f19 = BaseShaderGraphics.len(f17, f18);
        f17 /= f19;
        f18 /= f19;
        f19 = f17 * f6;
        f6 = f18 * f6;
        float f20 = f2 + f6;
        float f21 = f3 - f19;
        float f22 = f4 + f6;
        float f23 = f5 - f19;
        f2 -= f6;
        f3 += f19;
        f4 -= f6;
        f5 += f19;
        if (n2 == 2) {
            f20 -= f19;
            f21 -= f6;
            f2 -= f19;
            f3 -= f6;
            f22 += f19;
            f23 += f6;
            f4 += f19;
            f5 += f6;
        }
        BaseTransform baseTransform = this.getTransformNoClone();
        float f24 = (float)baseTransform.getMxt();
        float f25 = (float)baseTransform.getMyt();
        if (baseTransform.isTranslateOrIdentity()) {
            f6 = f17;
            f16 = f18;
            f19 = f18;
            f17 = -f17;
            n4 = (int)Math.ceil(BaseShaderGraphics.len(f22 - f20, f23 - f21));
            n3 = (int)Math.ceil(BaseShaderGraphics.len(f2 - f20, f3 - f21));
            baseTransform = IDENT;
        } else if (baseTransform.is2D()) {
            f19 = (float)baseTransform.getMxx();
            float f26 = (float)baseTransform.getMxy();
            f15 = (float)baseTransform.getMyx();
            f14 = (float)baseTransform.getMyy();
            f13 = f19 * f20 + f26 * f21;
            f12 = f15 * f20 + f14 * f21;
            f20 = f13;
            f21 = f12;
            f13 = f19 * f22 + f26 * f23;
            f12 = f15 * f22 + f14 * f23;
            f22 = f13;
            f23 = f12;
            f13 = f19 * f2 + f26 * f3;
            f12 = f15 * f2 + f14 * f3;
            f2 = f13;
            f3 = f12;
            f13 = f19 * f4 + f26 * f5;
            f12 = f15 * f4 + f14 * f5;
            f4 = f13;
            f5 = f12;
            f6 = f19 * f17 + f26 * f18;
            f16 = f15 * f17 + f14 * f18;
            f11 = BaseShaderGraphics.len(f6, f16);
            if (f11 == 0.0f) {
                return true;
            }
            f6 /= f11;
            f16 /= f11;
            f11 = BaseShaderGraphics.len(f19 = f19 * f18 - f26 * f17, f17 = f15 * f18 - f14 * f17);
            if (f11 == 0.0f) {
                return true;
            }
            n4 = (int)Math.ceil(Math.abs((f22 - f20) * f6 + (f23 - f21) * f16));
            n3 = (int)Math.ceil(Math.abs((f2 - f20) * (f19 /= f11) + (f3 - f21) * (f17 /= f11)));
            baseTransform = IDENT;
        } else {
            System.out.println("Not a 2d transform!");
            return false;
        }
        f20 = f20 + f24 + (f19 *= 0.5f) - (f6 *= 0.5f);
        f21 = f21 + f25 + (f17 *= 0.5f) - (f16 *= 0.5f);
        f22 = f22 + f24 + f19 + f6;
        f23 = f23 + f25 + f17 + f16;
        f2 = f2 + f24 - f19 - f6;
        f3 = f3 + f25 - f17 - f16;
        f4 = f4 + f24 - f19 + f6;
        f5 = f5 + f25 - f17 + f16;
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        int n5 = this.context.getRectTextureMaxSize();
        if (n3 <= n5) {
            int n6 = n3;
            f15 = (float)(n6 * (n6 + 1) / 2) - 0.5f;
            f14 = f15 + (float)n3 + 1.0f;
            Texture texture = this.context.getRectTexture();
            f15 /= (float)texture.getPhysicalHeight();
            f14 /= (float)texture.getPhysicalHeight();
            if (n4 <= n5) {
                int n7 = n4;
                f12 = (float)(n7 * (n7 + 1) / 2) - 0.5f;
                f11 = f12 + (float)n4 + 1.0f;
                this.context.validatePaintOp(this, baseTransform, BaseShaderContext$MaskType.ALPHA_TEXTURE, texture, f7, f8, f9, f10);
                vertexBuffer.addMappedPgram(f20, f21, f22, f23, f2, f3, f4, f5, f12 /= (float)texture.getPhysicalWidth(), f15, f11 /= (float)texture.getPhysicalWidth(), f15, f12, f14, f11, f14, 0.0f, 0.0f);
                texture.unlock();
                return true;
            }
            if (n4 <= (n5 << 1) - 1) {
                f12 = (f20 + f22) * 0.5f;
                f11 = (f21 + f23) * 0.5f;
                f17 = (f2 + f4) * 0.5f;
                f24 = (f3 + f5) * 0.5f;
                int n8 = n5;
                f25 = (float)(n8 * (n8 + 1) / 2) - 0.5f;
                float f27 = f25 + 0.5f + (float)n4 * 0.5f;
                this.context.validatePaintOp(this, baseTransform, BaseShaderContext$MaskType.ALPHA_TEXTURE, texture, f7, f8, f9, f10);
                vertexBuffer.addMappedPgram(f20, f21, f12, f11, f2, f3, f17, f24, f25 /= (float)texture.getPhysicalWidth(), f15, f27 /= (float)texture.getPhysicalWidth(), f15, f25, f14, f27, f14, 0.0f, 0.0f);
                vertexBuffer.addMappedPgram(f22, f23, f12, f11, f4, f5, f17, f24, f25, f15, f27, f15, f25, f14, f27, f14, 0.0f, 0.0f);
                texture.unlock();
                return true;
            }
            f12 = 0.5f / (float)texture.getPhysicalWidth();
            f11 = 1.5f / (float)texture.getPhysicalWidth();
            f17 = f20 + (f6 *= 2.0f);
            f24 = f21 + (f16 *= 2.0f);
            f25 = f22 - f6;
            float f28 = f23 - f16;
            float f29 = f2 + f6;
            float f30 = f3 + f16;
            f6 = f4 - f6;
            f16 = f5 - f16;
            this.context.validatePaintOp(this, baseTransform, BaseShaderContext$MaskType.ALPHA_TEXTURE, texture, f7, f8, f9, f10);
            vertexBuffer.addMappedPgram(f20, f21, f17, f24, f2, f3, f29, f30, f12, f15, f11, f15, f12, f14, f11, f14, 0.0f, 0.0f);
            vertexBuffer.addMappedPgram(f17, f24, f25, f28, f29, f30, f6, f16, f11, f15, f11, f15, f11, f14, f11, f14, 0.0f, 0.0f);
            vertexBuffer.addMappedPgram(f25, f28, f22, f23, f6, f16, f4, f5, f11, f15, f12, f15, f11, f14, f12, f14, 0.0f, 0.0f);
            texture.unlock();
            return true;
        }
        f15 = (f20 + f22) * 0.5f;
        f14 = (f21 + f23) * 0.5f;
        f13 = (f2 + f4) * 0.5f;
        f12 = (f3 + f5) * 0.5f;
        f11 = (f20 + f2) * 0.5f;
        f17 = (f21 + f3) * 0.5f;
        f24 = (f22 + f4) * 0.5f;
        f25 = (f23 + f5) * 0.5f;
        float f31 = (f15 + f13) * 0.5f;
        float f32 = (f14 + f12) * 0.5f;
        Texture texture = this.context.getWrapRectTexture();
        f6 = 0.5f / (float)texture.getPhysicalWidth();
        f16 = 0.5f / (float)texture.getPhysicalHeight();
        float f33 = ((float)n4 * 0.5f + 1.0f) / (float)texture.getPhysicalWidth();
        float f34 = ((float)n3 * 0.5f + 1.0f) / (float)texture.getPhysicalHeight();
        this.context.validatePaintOp(this, baseTransform, BaseShaderContext$MaskType.ALPHA_TEXTURE, texture, f7, f8, f9, f10);
        vertexBuffer.addMappedPgram(f20, f21, f15, f14, f11, f17, f31, f32, f6, f16, f33, f16, f6, f34, f33, f34, 0.0f, 0.0f);
        vertexBuffer.addMappedPgram(f22, f23, f15, f14, f24, f25, f31, f32, f6, f16, f33, f16, f6, f34, f33, f34, 0.0f, 0.0f);
        vertexBuffer.addMappedPgram(f2, f3, f13, f12, f11, f17, f31, f32, f6, f16, f33, f16, f6, f34, f33, f34, 0.0f, 0.0f);
        vertexBuffer.addMappedPgram(f4, f5, f13, f12, f24, f25, f31, f32, f6, f16, f33, f16, f6, f34, f33, f34, 0.0f, 0.0f);
        texture.unlock();
        return true;
    }

    @Override
    public void fillRect(float f2, float f3, float f4, float f5) {
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return;
        }
        if (!this.isAntialiasedShape()) {
            this.fillQuad(f2, f3, f2 + f4, f3 + f5);
            return;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(f2, f3, f4, f5, 0.0f, 0.0f);
            this.renderWithComplexPaint(scratchRRect, null, f2, f3, f4, f5);
            return;
        }
        if (PrismSettings.primTextureSize != 0) {
            Texture texture = this.context.getRectTexture();
            Texture texture2 = this.context.getWrapRectTexture();
            boolean bl2 = this.fillPrimRect(f2, f3, f4, f5, texture, texture2, f2, f3, f4, f5);
            texture.unlock();
            texture2.unlock();
            if (bl2) {
                return;
            }
        }
        this.renderGeneralRoundedRect(f2, f3, f4, f5, 0.0f, 0.0f, BaseShaderContext$MaskType.FILL_PGRAM, null);
    }

    @Override
    public void fillEllipse(float f2, float f3, float f4, float f5) {
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return;
        }
        if (this.isComplexPaint) {
            ((RectangularShape)scratchEllipse).setFrame(f2, f3, f4, f5);
            this.renderWithComplexPaint(scratchEllipse, null, f2, f3, f4, f5);
            return;
        }
        if (!this.isAntialiasedShape()) {
            ((RectangularShape)scratchEllipse).setFrame(f2, f3, f4, f5);
            this.renderShape(scratchEllipse, null, f2, f3, f4, f5);
            return;
        }
        if (PrismSettings.primTextureSize != 0 && this.fillPrimRect(f2, f3, f4, f5, this.context.getOvalTexture(), null, f2, f3, f4, f5)) {
            return;
        }
        this.renderGeneralRoundedRect(f2, f3, f4, f5, f4, f5, BaseShaderContext$MaskType.FILL_ELLIPSE, null);
    }

    @Override
    public void fillRoundRect(float f2, float f3, float f4, float f5, float f6, float f7) {
        f6 = Math.min(Math.abs(f6), f4);
        f7 = Math.min(Math.abs(f7), f5);
        if (f4 <= 0.0f || f5 <= 0.0f) {
            return;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(f2, f3, f4, f5, f6, f7);
            this.renderWithComplexPaint(scratchRRect, null, f2, f3, f4, f5);
            return;
        }
        if (!this.isAntialiasedShape()) {
            scratchRRect.setRoundRect(f2, f3, f4, f5, f6, f7);
            this.renderShape(scratchRRect, null, f2, f3, f4, f5);
            return;
        }
        this.renderGeneralRoundedRect(f2, f3, f4, f5, f6, f7, BaseShaderContext$MaskType.FILL_ROUNDRECT, null);
    }

    @Override
    public void fillQuad(float f2, float f3, float f4, float f5) {
        float f6;
        float f7;
        float f8;
        float f9;
        if (f2 <= f4) {
            f9 = f2;
            f8 = f4 - f2;
        } else {
            f9 = f4;
            f8 = f2 - f4;
        }
        if (f3 <= f5) {
            f7 = f3;
            f6 = f5 - f3;
        } else {
            f7 = f5;
            f6 = f3 - f5;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(f9, f7, f8, f6, 0.0f, 0.0f);
            this.renderWithComplexPaint(scratchRRect, null, f9, f7, f8, f6);
            return;
        }
        Object object = this.getTransformNoClone();
        if (PrismSettings.primTextureSize != 0) {
            float f10;
            float f11;
            if (((BaseTransform)object).isTranslateOrIdentity()) {
                f11 = (float)((BaseTransform)object).getMxt();
                f10 = (float)((BaseTransform)object).getMyt();
                object = IDENT;
                f2 += f11;
                f3 += f10;
                f4 += f11;
                f5 += f10;
            } else {
                f10 = 0.0f;
                f11 = 0.0f;
            }
            object = this.context.validatePaintOp(this, (BaseTransform)object, BaseShaderContext$MaskType.ALPHA_ONE, null, f9, f7, f8, f6);
            AffineBase affineBase = this.getPaintTextureTx(IDENT, (Shader)object, f9, f7, f8, f6);
            if (affineBase != null) {
                affineBase.translate(-f11, -f10);
            }
            this.context.getVertexBuffer().addQuad(f2, f3, f4, f5, 0.0f, 0.0f, 0.0f, 0.0f, affineBase);
            return;
        }
        if (this.isSimpleTranslate) {
            object = IDENT;
            f9 += this.transX;
            f7 += this.transY;
        }
        this.context.validatePaintOp(this, (BaseTransform)object, BaseShaderContext$MaskType.SOLID, f9, f7, f8, f6);
        VertexBuffer vertexBuffer = this.context.getVertexBuffer();
        vertexBuffer.addQuad(f9, f7, f9 + f8, f7 + f6);
    }

    private static boolean canUseStrokeShader(BasicStroke basicStroke) {
        return !basicStroke.isDashed() && (basicStroke.getType() == 1 || basicStroke.getLineJoin() == 1 || basicStroke.getLineJoin() == 0 && (double)basicStroke.getMiterLimit() >= SQRT_2);
    }

    @Override
    public void blit(RTTexture rTTexture, RTTexture rTTexture2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (rTTexture2 == null) {
            this.context.setRenderTarget(this);
        } else {
            this.context.setRenderTarget((BaseGraphics)rTTexture2.createGraphics());
        }
        this.context.blit(rTTexture, rTTexture2, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    @Override
    public void drawRect(float f2, float f3, float f4, float f5) {
        if (f4 < 0.0f || f5 < 0.0f) {
            return;
        }
        if (f4 == 0.0f || f5 == 0.0f) {
            this.drawLine(f2, f3, f2 + f4, f3 + f5);
            return;
        }
        if (this.isComplexPaint) {
            scratchRRect.setRoundRect(f2, f3, f4, f5, 0.0f, 0.0f);
            this.renderWithComplexPaint(scratchRRect, this.stroke, f2, f3, f4, f5);
            return;
        }
        if (!this.isAntialiasedShape()) {
            scratchRRect.setRoundRect(f2, f3, f4, f5, 0.0f, 0.0f);
            this.renderShape(scratchRRect, this.stroke, f2, f3, f4, f5);
            return;
        }
        if (BaseShaderGraphics.canUseStrokeShader(this.stroke)) {
            if (PrismSettings.primTextureSize != 0 && this.stroke.getLineJoin() != 1 && this.drawPrimRect(f2, f3, f4, f5)) {
                return;
            }
            this.renderGeneralRoundedRect(f2, f3, f4, f5, 0.0f, 0.0f, BaseShaderContext$MaskType.DRAW_PGRAM, this.stroke);
            return;
        }
        scratchRRect.setRoundRect(f2, f3, f4, f5, 0.0f, 0.0f);
        this.renderShape(scratchRRect, this.stroke, f2, f3, f4, f5);
    }

    private boolean checkInnerCurvature(float f2, float f3) {
        float f4 = this.stroke.getLineWidth() * (1.0f - BaseShaderGraphics.getStrokeExpansionFactor(this.stroke));
        return (f2 -= f4) <= 0.0f || (f3 -= f4) <= 0.0f || f2 * 2.0f > f3 && f3 * 2.0f > f2;
    }

    @Override
    public void drawEllipse(float f2, float f3, float f4, float f5) {
        if (f4 < 0.0f || f5 < 0.0f) {
            return;
        }
        if (!this.isComplexPaint && !this.stroke.isDashed() && this.checkInnerCurvature(f4, f5) && this.isAntialiasedShape()) {
            this.renderGeneralRoundedRect(f2, f3, f4, f5, f4, f5, BaseShaderContext$MaskType.DRAW_ELLIPSE, this.stroke);
            return;
        }
        ((RectangularShape)scratchEllipse).setFrame(f2, f3, f4, f5);
        this.renderShape(scratchEllipse, this.stroke, f2, f3, f4, f5);
    }

    @Override
    public void drawRoundRect(float f2, float f3, float f4, float f5, float f6, float f7) {
        f6 = Math.min(Math.abs(f6), f4);
        f7 = Math.min(Math.abs(f7), f5);
        if (f4 < 0.0f || f5 < 0.0f) {
            return;
        }
        if (!this.isComplexPaint && !this.stroke.isDashed() && this.checkInnerCurvature(f6, f7) && this.isAntialiasedShape()) {
            this.renderGeneralRoundedRect(f2, f3, f4, f5, f6, f7, BaseShaderContext$MaskType.DRAW_ROUNDRECT, this.stroke);
            return;
        }
        scratchRRect.setRoundRect(f2, f3, f4, f5, f6, f7);
        this.renderShape(scratchRRect, this.stroke, f2, f3, f4, f5);
    }

    @Override
    public void drawLine(float f2, float f3, float f4, float f5) {
        BaseShaderContext$MaskType baseShaderContext$MaskType;
        float f6;
        float f7;
        BaseTransform baseTransform;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        if (f2 <= f4) {
            f16 = f2;
            f15 = f4 - f2;
        } else {
            f16 = f4;
            f15 = f2 - f4;
        }
        if (f3 <= f5) {
            f14 = f3;
            f13 = f5 - f3;
        } else {
            f14 = f5;
            f13 = f3 - f5;
        }
        if (this.stroke.getType() == 1) {
            return;
        }
        if (this.isComplexPaint) {
            scratchLine.setLine(f2, f3, f4, f5);
            this.renderWithComplexPaint(scratchLine, this.stroke, f16, f14, f15, f13);
            return;
        }
        if (!this.isAntialiasedShape()) {
            scratchLine.setLine(f2, f3, f4, f5);
            this.renderShape(scratchLine, this.stroke, f16, f14, f15, f13);
            return;
        }
        int n2 = this.stroke.getEndCap();
        if (this.stroke.isDashed()) {
            scratchLine.setLine(f2, f3, f4, f5);
            this.renderShape(scratchLine, this.stroke, f16, f14, f15, f13);
            return;
        }
        float f17 = this.stroke.getLineWidth();
        if (PrismSettings.primTextureSize != 0 && n2 != 1) {
            f12 = f17;
            if (this.stroke.getType() == 0) {
                f12 *= 0.5f;
            }
            if (f15 == 0.0f || f13 == 0.0f) {
                float f18;
                if (n2 == 2) {
                    f11 = f18 = f12;
                } else if (f15 != 0.0f) {
                    f11 = 0.0f;
                    f18 = f12;
                } else if (f13 != 0.0f) {
                    f11 = f12;
                    f18 = 0.0f;
                } else {
                    return;
                }
                Texture texture = this.context.getRectTexture();
                Texture texture2 = this.context.getWrapRectTexture();
                boolean bl2 = this.fillPrimRect(f16 - f11, f14 - f18, f15 + f11 + f11, f13 + f18 + f18, texture, texture2, f16, f14, f15, f13);
                texture.unlock();
                texture2.unlock();
                if (bl2) {
                    return;
                }
            } else if (this.drawPrimDiagonal(f2, f3, f4, f5, f17, n2, f16, f14, f15, f13)) {
                return;
            }
        }
        if (this.stroke.getType() == 2) {
            f17 *= 2.0f;
        }
        if ((f10 = BaseShaderGraphics.len(f12 = f4 - f2, f11 = f5 - f3)) == 0.0f) {
            if (n2 == 0) {
                return;
            }
            f9 = f17;
            f8 = 0.0f;
        } else {
            f9 = f17 * f12 / f10;
            f8 = f17 * f11 / f10;
        }
        BaseTransform baseTransform2 = this.getTransformNoClone();
        if (this.isSimpleTranslate) {
            double d2 = baseTransform2.getMxt();
            double d3 = baseTransform2.getMyt();
            f2 = (float)((double)f2 + d2);
            f3 = (float)((double)f3 + d3);
            f4 = f8;
            f5 = -f9;
            baseTransform = IDENT;
        } else {
            baseTransform = this.extract3Dremainder(baseTransform2);
            double[] dArray = new double[]{f2, f3, f4, f5};
            baseTransform2.transform(dArray, 0, dArray, 0, 2);
            f2 = (float)dArray[0];
            f3 = (float)dArray[1];
            f4 = (float)dArray[2];
            f5 = (float)dArray[3];
            f12 = f4 - f2;
            f11 = f5 - f3;
            dArray[0] = f9;
            dArray[1] = f8;
            dArray[2] = f8;
            dArray[3] = -f9;
            baseTransform2.deltaTransform(dArray, 0, dArray, 0, 2);
            f9 = (float)dArray[0];
            f8 = (float)dArray[1];
            f4 = (float)dArray[2];
            f5 = (float)dArray[3];
        }
        float f19 = f2 - f4 / 2.0f;
        float f20 = f3 - f5 / 2.0f;
        if (n2 != 0) {
            f19 -= f9 / 2.0f;
            f20 -= f8 / 2.0f;
            f12 += f9;
            f11 += f8;
            if (n2 == 1) {
                f7 = BaseShaderGraphics.len(f9, f8) / BaseShaderGraphics.len(f12, f11);
                f6 = 1.0f;
                baseShaderContext$MaskType = BaseShaderContext$MaskType.FILL_ROUNDRECT;
            } else {
                f6 = 0.0f;
                f7 = 0.0f;
                baseShaderContext$MaskType = BaseShaderContext$MaskType.FILL_PGRAM;
            }
        } else {
            f6 = 0.0f;
            f7 = 0.0f;
            baseShaderContext$MaskType = BaseShaderContext$MaskType.FILL_PGRAM;
        }
        this.renderGeneralRoundedPgram(f19, f20, f12, f11, f4, f5, f7, f6, 0.0f, 0.0f, baseTransform, baseShaderContext$MaskType, f16, f14, f15, f13);
    }

    private static float len(float f2, float f3) {
        if (f2 == 0.0f) {
            return Math.abs(f3);
        }
        if (f3 == 0.0f) {
            return Math.abs(f2);
        }
        float f4 = f2;
        float f5 = f3;
        return (float)Math.sqrt(f4 * f4 + f5 * f5);
    }

    @Override
    public void setNodeBounds(RectBounds rectBounds) {
        this.nodeBounds = rectBounds;
        this.lcdSampleInvalid = rectBounds != null;
    }

    private void initLCDSampleRT() {
        if (this.lcdSampleInvalid) {
            RectBounds rectBounds = new RectBounds();
            this.getTransformNoClone().transform(this.nodeBounds, rectBounds);
            Rectangle rectangle = this.getClipRectNoClone();
            if (rectangle != null && !rectangle.isEmpty()) {
                ((BaseBounds)rectBounds).intersectWith(rectangle);
            }
            float f2 = ((BaseBounds)rectBounds).getMinX() - 1.0f;
            float f3 = ((BaseBounds)rectBounds).getMinY() - 1.0f;
            float f4 = ((BaseBounds)rectBounds).getWidth() + 2.0f;
            float f5 = ((BaseBounds)rectBounds).getHeight() + 2.0f;
            this.context.validateLCDBuffer(this.getRenderTarget());
            BaseShaderGraphics baseShaderGraphics = (BaseShaderGraphics)((BaseContext)this.context).getLCDBuffer().createGraphics();
            baseShaderGraphics.setCompositeMode(CompositeMode.SRC);
            this.context.validateLCDOp(baseShaderGraphics, IDENT, (Texture)((Object)this.getRenderTarget()), null, true, null);
            int n2 = this.getRenderTarget().getPhysicalHeight();
            int n3 = this.getRenderTarget().getPhysicalWidth();
            float f6 = f2 / (float)n3;
            float f7 = f3 / (float)n2;
            float f8 = (f2 + f4) / (float)n3;
            float f9 = (f3 + f5) / (float)n2;
            baseShaderGraphics.drawLCDBuffer(f2, f3, f4, f5, f6, f7, f8, f9);
            this.context.setRenderTarget(this);
        }
        this.lcdSampleInvalid = false;
    }

    @Override
    public void drawString(GlyphList glyphList, FontStrike object, float f2, float f3, Color color, int n2, int n3) {
        Object object2;
        RectBounds rectBounds;
        float f4;
        boolean bl2;
        if (object.getFontResource().isColorGlyph(glyphList.getGlyphCode(0))) {
            this.drawColorGlyph(glyphList, (FontStrike)object, f2, f3, color, n2, n3);
            return;
        }
        if (this.isComplexPaint || this.paint.getType().isImagePattern() || object.drawAsShapes()) {
            BaseTransform baseTransform = BaseTransform.getTranslateInstance(f2, f3);
            Shape shape = object.getOutline(glyphList, baseTransform);
            this.fill(shape);
            return;
        }
        BaseTransform baseTransform = this.getTransformNoClone();
        Paint paint = this.getPaint();
        paint = paint.getType() == Paint$Type.COLOR ? (Color)paint : null;
        CompositeMode compositeMode = this.getCompositeMode();
        boolean bl3 = bl2 = compositeMode == CompositeMode.SRC_OVER && paint != null && baseTransform.is2D() && !this.getRenderTarget().isMSAA();
        if (object.getAAMode() == 1 && !bl2) {
            FontResource fontResource = object.getFontResource();
            f4 = object.getSize();
            BaseTransform baseTransform2 = object.getTransform();
            object = fontResource.getStrike(f4, baseTransform2, 0);
        }
        float f5 = 0.0f;
        f4 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (this.paint.getType().isGradient() && ((Gradient)this.paint).isProportional()) {
            rectBounds = this.nodeBounds;
            if (rectBounds == null) {
                object2 = object.getMetrics();
                float f8 = -object2.getAscent() * 0.4f;
                rectBounds = new RectBounds(-f8, object2.getAscent(), glyphList.getWidth() + f8 * 2.0f, object2.getDescent() + object2.getLineGap());
                f5 = f2;
                f4 = f3;
            }
            f5 += ((BaseBounds)rectBounds).getMinX();
            f4 += ((BaseBounds)rectBounds).getMinY();
            f6 = ((BaseBounds)rectBounds).getWidth();
            f7 = ((BaseBounds)rectBounds).getHeight();
        }
        rectBounds = null;
        object2 = new Point2D(f2, f3);
        if (this.isSimpleTranslate) {
            rectBounds = this.getFinalClipNoClone();
            baseTransform = IDENT;
            ((Point2D)object2).x += this.transX;
            ((Point2D)object2).y += this.transY;
        }
        GlyphCache glyphCache = this.context.getGlyphCache((FontStrike)object);
        Texture texture = glyphCache.getBackingStore();
        if (object.getAAMode() == 1) {
            if (this.nodeBounds == null) {
                object = object.getMetrics();
                RectBounds rectBounds2 = new RectBounds(f2 - 2.0f, f3 + object.getAscent(), f2 + 2.0f + glyphList.getWidth(), f3 + 1.0f + object.getDescent() + object.getLineGap());
                this.setNodeBounds(rectBounds2);
                this.initLCDSampleRT();
                this.setNodeBounds(null);
            } else {
                this.initLCDSampleRT();
            }
            float f9 = PrismFontFactory.getLCDContrast();
            float f10 = 1.0f / f9;
            paint = new Color((float)Math.pow(((Color)paint).getRed(), f9), (float)Math.pow(((Color)paint).getGreen(), f9), (float)Math.pow(((Color)paint).getBlue(), f9), (float)Math.pow(((Color)paint).getAlpha(), f9));
            if (color != null) {
                color = new Color((float)Math.pow(color.getRed(), f9), (float)Math.pow(color.getGreen(), f9), (float)Math.pow(color.getBlue(), f9), (float)Math.pow(color.getAlpha(), f9));
            }
            this.setCompositeMode(CompositeMode.SRC);
            Shader shader = this.context.validateLCDOp(this, IDENT, ((BaseContext)this.context).getLCDBuffer(), texture, false, paint);
            f5 = 1.0f / (float)texture.getPhysicalWidth();
            shader.setConstant("gamma", f10, f9, f5);
            this.setCompositeMode(compositeMode);
        } else {
            this.context.validatePaintOp(this, IDENT, texture, f5, f4, f6, f7);
        }
        if (this.isSimpleTranslate) {
            ((Point2D)object2).y = Math.round(((Point2D)object2).y);
            ((Point2D)object2).x = Math.round(((Point2D)object2).x);
        }
        glyphCache.render(this.context, glyphList, ((Point2D)object2).x, ((Point2D)object2).y, n2, n3, color, (Color)paint, baseTransform, rectBounds);
    }

    private void drawLCDBuffer(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.context.setRenderTarget(this);
        this.context.getVertexBuffer().addQuad(f2, f3, f2 + f4, f3 + f5, f6, f7, f8, f9);
    }

    @Override
    public boolean canReadBack() {
        RenderTarget renderTarget = this.getRenderTarget();
        return renderTarget instanceof ReadbackRenderTarget && ((ReadbackRenderTarget)renderTarget).getBackBuffer() != null;
    }

    @Override
    public RTTexture readBack(Rectangle rectangle) {
        Object object = this.getRenderTarget();
        this.context.flushVertexBuffer();
        this.context.validateLCDBuffer((RenderTarget)object);
        RTTexture rTTexture = ((BaseContext)this.context).getLCDBuffer();
        object = ((ReadbackRenderTarget)object).getBackBuffer();
        float f2 = rectangle.x;
        float f3 = rectangle.y;
        float f4 = f2 + (float)rectangle.width;
        float f5 = f3 + (float)rectangle.height;
        BaseShaderGraphics baseShaderGraphics = (BaseShaderGraphics)rTTexture.createGraphics();
        baseShaderGraphics.setCompositeMode(CompositeMode.SRC);
        Object object2 = object;
        ((BaseContext)this.context).validateTextureOp(baseShaderGraphics, IDENT, (Texture)object2, object2.getPixelFormat());
        ((BaseGraphics)baseShaderGraphics).drawTexture((Texture)object, 0.0f, 0.0f, rectangle.width, rectangle.height, f2, f3, f4, f5);
        this.context.flushVertexBuffer();
        this.context.setRenderTarget(this);
        return rTTexture;
    }

    @Override
    public void releaseReadBackBuffer(RTTexture rTTexture) {
    }

    @Override
    public void setup3DRendering() {
        this.context.setRenderTarget(this);
    }

    static {
        String string = (String)AccessController.doPrivileged(() -> System.getProperty("prism.primshaderpad"));
        if (string == null) {
            FRINGE_FACTOR = -0.5f;
        } else {
            FRINGE_FACTOR = -Float.valueOf(string).floatValue();
            System.out.println("Prism ShaderGraphics primitive shader pad = " + FRINGE_FACTOR);
        }
        SQRT_2 = Math.sqrt(2.0);
    }
}

