/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.javafx.image.IntPixelGetter;
import com.sun.javafx.image.PixelConverter;
import com.sun.javafx.image.PixelGetter;
import com.sun.javafx.image.PixelSetter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.ByteBgr;
import com.sun.javafx.image.impl.ByteBgraPre;
import com.sun.javafx.image.impl.ByteGray;
import com.sun.javafx.image.impl.ByteRgb;
import com.sun.javafx.image.impl.IntArgbPre;
import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.Texture$WrapMode;
import com.sun.prism.impl.BaseTexture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.j2d.J2DTexture$J2DTexResource;
import com.sun.prism.j2d.J2DTexturePool;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

class J2DTexture
extends BaseTexture<J2DTexture$J2DTexResource> {
    private final PixelSetter setter;

    static J2DTexture create(PixelFormat pixelFormat, Texture$WrapMode texture$WrapMode, int n2, int n3) {
        int n4;
        PixelSetter<ByteBuffer> pixelSetter = switch (pixelFormat) {
            case PixelFormat.BYTE_RGB -> {
                n4 = 5;
                yield ByteBgr.setter;
            }
            case PixelFormat.BYTE_GRAY -> {
                n4 = 10;
                yield ByteGray.setter;
            }
            case PixelFormat.INT_ARGB_PRE, PixelFormat.BYTE_BGRA_PRE -> {
                n4 = 3;
                yield IntArgbPre.setter;
            }
            default -> throw new InternalError("Unrecognized PixelFormat (" + String.valueOf((Object)pixelFormat) + ")!");
        };
        J2DTexturePool j2DTexturePool = J2DTexturePool.instance;
        long l2 = J2DTexturePool.size(n2, n3, n4);
        if (!j2DTexturePool.prepareForAllocation(l2)) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, n4);
        return new J2DTexture(bufferedImage, pixelFormat, pixelSetter, texture$WrapMode);
    }

    J2DTexture(BufferedImage bufferedImage, PixelFormat pixelFormat, PixelSetter pixelSetter, Texture$WrapMode texture$WrapMode) {
        super(new J2DTexture$J2DTexResource(bufferedImage), pixelFormat, texture$WrapMode, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.setter = pixelSetter;
    }

    J2DTexture(J2DTexture j2DTexture, Texture$WrapMode texture$WrapMode) {
        super(j2DTexture, texture$WrapMode, false);
        this.setter = j2DTexture.setter;
    }

    @Override
    protected Texture createSharedTexture(Texture$WrapMode texture$WrapMode) {
        return new J2DTexture(this, texture$WrapMode);
    }

    BufferedImage getBufferedImage() {
        return (BufferedImage)((J2DTexture$J2DTexResource)this.resource).getResource();
    }

    private static PixelGetter getGetter(PixelFormat pixelFormat) {
        switch (pixelFormat) {
            case BYTE_RGB: {
                return ByteRgb.getter;
            }
            case BYTE_GRAY: {
                return ByteGray.getter;
            }
            case INT_ARGB_PRE: {
                return IntArgbPre.getter;
            }
            case BYTE_BGRA_PRE: {
                return ByteBgraPre.getter;
            }
        }
        throw new InternalError("Unrecognized PixelFormat (" + String.valueOf((Object)pixelFormat) + ")!");
    }

    private static Buffer getDstBuffer(BufferedImage object) {
        if (((BufferedImage)object).getType() == 3) {
            int[] nArray = ((DataBufferInt)((BufferedImage)object).getRaster().getDataBuffer()).getData();
            object = nArray;
            return IntBuffer.wrap(nArray);
        }
        byte[] byArray = ((DataBufferByte)((BufferedImage)object).getRaster().getDataBuffer()).getData();
        object = byArray;
        return ByteBuffer.wrap(byArray);
    }

    void updateFromBuffer(BufferedImage bufferedImage, Buffer buffer, PixelFormat pixelFormat, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        PixelGetter pixelGetter = J2DTexture.getGetter(pixelFormat);
        PixelConverter<Buffer, Buffer> pixelConverter = PixelUtils.getConverter(pixelGetter, this.setter);
        if (PrismSettings.debug) {
            System.out.println("src = [" + n4 + ", " + n5 + "] x [" + n6 + ", " + n7 + "], dst = [" + n2 + ", " + n3 + "]");
            System.out.println("bimg = " + String.valueOf(bufferedImage));
            System.out.println("format = " + String.valueOf((Object)pixelFormat) + ", buffer = " + String.valueOf(buffer));
            System.out.println("getter = " + String.valueOf(pixelGetter) + ", setter = " + String.valueOf(this.setter));
            System.out.println("converter = " + String.valueOf(pixelConverter));
        }
        int n9 = bufferedImage.getWidth() * this.setter.getNumElements();
        n2 = n3 * n9 + n2 * this.setter.getNumElements();
        if (pixelGetter instanceof IntPixelGetter) {
            n8 /= 4;
        }
        n3 = buffer.position() + n5 * n8 + n4 * pixelGetter.getNumElements();
        pixelConverter.convert(buffer, n3, n8, J2DTexture.getDstBuffer(bufferedImage), n2, n9, n6, n7);
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        BufferedImage bufferedImage = this.getBufferedImage();
        buffer.position(0);
        this.updateFromBuffer(bufferedImage, buffer, pixelFormat, n2, n3, n4, n5, n6, n7, n8);
    }

    @Override
    public void update(MediaFrame mediaFrame, boolean bl2) {
        mediaFrame.holdFrame();
        if (mediaFrame.getPixelFormat() != PixelFormat.INT_ARGB_PRE) {
            MediaFrame mediaFrame2 = mediaFrame.convertToFormat(PixelFormat.INT_ARGB_PRE);
            mediaFrame.releaseFrame();
            mediaFrame = mediaFrame2;
            if (mediaFrame == null) {
                return;
            }
        }
        ByteBuffer byteBuffer = mediaFrame.getBufferForPlane(0);
        BufferedImage bufferedImage = this.getBufferedImage();
        this.updateFromBuffer(bufferedImage, byteBuffer.asIntBuffer(), PixelFormat.INT_ARGB_PRE, 0, 0, 0, 0, mediaFrame.getWidth(), mediaFrame.getHeight(), mediaFrame.strideForPlane(0));
        mediaFrame.releaseFrame();
    }
}

