/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.javafx.print.PrintHelper;
import com.sun.javafx.print.PrinterImpl;
import com.sun.javafx.print.PrinterJobImpl;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.PrintPipeline;
import com.sun.prism.j2d.PrismPrintGraphics;
import com.sun.prism.j2d.PrismPrintPipeline$NameComparator;
import com.sun.prism.j2d.print.J2DPrinter;
import com.sun.prism.j2d.print.J2DPrinterJob;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.print.Printer;
import javafx.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public final class PrismPrintPipeline
extends PrintPipeline {
    private static Printer defaultPrinter = null;
    private static final PrismPrintPipeline$NameComparator nameComparator = new PrismPrintPipeline$NameComparator();
    private static HashMap<PrintService, Printer> pMap = new HashMap();
    private static long lastTime = 0L;
    private static ObservableSet<Printer> printerSet = null;
    private static ObservableSet<Printer> returnedPrinterSet = null;

    public static PrintPipeline getInstance() {
        return new PrismPrintPipeline();
    }

    public final boolean printNode(NGNode nGNode, int n2, int n3, Graphics graphics) {
        PrismPrintGraphics prismPrintGraphics = new PrismPrintGraphics((Graphics2D)graphics, n2, n3);
        nGNode.render(prismPrintGraphics);
        return true;
    }

    @Override
    public final PrinterJobImpl createPrinterJob(PrinterJob printerJob) {
        return new J2DPrinterJob(printerJob);
    }

    @Override
    public final synchronized Printer getDefaultPrinter() {
        if (defaultPrinter == null) {
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            if (printService == null) {
                defaultPrinter = null;
            } else if (printerSet == null) {
                J2DPrinter j2DPrinter = new J2DPrinter(printService);
                defaultPrinter = PrintHelper.createPrinter(j2DPrinter);
            } else {
                for (Printer printer : printerSet) {
                    PrinterImpl printerImpl = PrintHelper.getPrinterImpl(printer);
                    if (!((J2DPrinter)(printerImpl = (J2DPrinter)printerImpl)).getService().equals(printService)) continue;
                    defaultPrinter = printer;
                    break;
                }
            }
        }
        return defaultPrinter;
    }

    @Override
    public final synchronized ObservableSet<Printer> getAllPrinters() {
        if (returnedPrinterSet == null) {
            Object object;
            TreeSet<Printer> treeSet = new TreeSet<Printer>(nameComparator);
            Printer printer = ((PrintPipeline)this).getDefaultPrinter();
            PrintService printService = null;
            if (printer != null) {
                object = (J2DPrinter)PrintHelper.getPrinterImpl(printer);
                printService = object.getService();
            }
            object = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i2 = 0; i2 < ((PrintService[])object).length; ++i2) {
                if (printService != null && printService.equals(object[i2])) {
                    treeSet.add(printer);
                    pMap.put(printService, printer);
                    continue;
                }
                this.addNew(object[i2], treeSet);
            }
            printerSet = FXCollections.observableSet(treeSet);
            returnedPrinterSet = FXCollections.unmodifiableObservableSet(printerSet);
            lastTime = System.currentTimeMillis();
        } else {
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
            if (printServiceArray.length != printerSet.size() || lastTime + 120000L < System.currentTimeMillis()) {
                this.updatePrinters(printServiceArray);
                lastTime = System.currentTimeMillis();
            }
        }
        return returnedPrinterSet;
    }

    private void addNew(PrintService printService, Set<Printer> set) {
        J2DPrinter j2DPrinter = new J2DPrinter(printService);
        Printer printer = PrintHelper.createPrinter(j2DPrinter);
        j2DPrinter.setPrinter(printer);
        set.add(printer);
        pMap.put(printService, printer);
    }

    private void updatePrinters(PrintService[] printServiceArray) {
        PrintService printService;
        int n2;
        PrintService[] printServiceArray2 = pMap.keySet();
        PrintService[] printServiceArray3 = printServiceArray2.toArray(new PrintService[0]);
        printServiceArray2 = printServiceArray3;
        printServiceArray2 = printServiceArray3;
        int n3 = printServiceArray3.length;
        for (n2 = 0; n2 < n3; ++n2) {
            printService = printServiceArray2[n2];
            boolean bl2 = false;
            Object object = printServiceArray;
            int n4 = printServiceArray.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                PrintService printService2 = object[i2];
                if (!printService.equals(printService2)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            object = pMap.get(printService);
            pMap.remove(printService);
            printerSet.remove(object);
        }
        printServiceArray2 = printServiceArray;
        n3 = printServiceArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            printService = printServiceArray2[n2];
            if (pMap.containsKey(printService)) continue;
            this.addNew(printService, printerSet);
        }
        printServiceArray2 = defaultPrinter == null ? null : ((J2DPrinter)PrintHelper.getPrinterImpl(defaultPrinter)).getService();
        PrintService printService3 = PrintServiceLookup.lookupDefaultPrintService();
        if (printService3 != null) {
            if (printServiceArray2 == null || !printServiceArray2.equals(printService3)) {
                defaultPrinter = PrismPrintPipeline.findDefaultPrinter(printerSet, printService3);
                return;
            }
        } else {
            defaultPrinter = null;
        }
    }

    private static Printer findDefaultPrinter(Set<Printer> object, PrintService printService) {
        object = object.iterator();
        while (object.hasNext()) {
            Printer printer = (Printer)object.next();
            PrintService printService2 = ((J2DPrinter)PrintHelper.getPrinterImpl(printer)).getService();
            if (!printService2.getName().equals(printService.getName())) continue;
            return printer;
        }
        return null;
    }
}

